/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import sanproject.common.RCobj_interface_CheckRet;
import sanproject.getmondat.RJMdGroupManager;
import sanproject.getmondat.RJMdHelp;
import sanproject.getmondat.RJMdSetCommand;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdDateFormat;
import sanproject.getmondat.com.RJMdExecParameter;
import sanproject.getmondat.com.RJMdMessage;
import sanproject.getmondat.com.RJMdRangeException;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.com.RJMdTimeShortRange;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.serverux.arg.monitor.ArgMonitoringInfo;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.MonMonitoringInfo;

public class RJMdCmdManager
extends RJMdCmdParser
implements Runnable {
    public static final RJMdDateFormat dateFormat = new RJMdDateFormat();
    public static final long OneDay = 86400000L;
    private static final Boolean TRACE_ON = new Boolean(true);
    private static final Boolean TRACE_OFF = new Boolean(false);
    private static final int MAX_DKCSN_LENGTH = 6;
    private static final String PATTERN_DECIMAL = "\\d+";
    public static final int MIN_PORT_NUM = 1;
    public static final int MAX_PORT_NUM = 65535;
    public static final int DEFAULT_PORT_NUM = 1099;
    private Object[][] commandTable = new Object[][]{{"ip", TRACE_ON, new RJMdCmdParser.CommandAction(){

        public void actionPerformed() throws ParseException {
            RJMdCmdManager.this.action_svpip();
        }
    }}, {"dkcsn", TRACE_ON, new RJMdCmdParser.CommandAction(){

        public void actionPerformed() throws ParseException {
            RJMdCmdManager.this.action_dkcsn();
        }
    }}, {"login", TRACE_OFF, new RJMdCmdParser.CommandAction(){

        public void actionPerformed() throws ParseException {
            RJMdCmdManager.this.action_login();
        }
    }}, {"show", TRACE_ON, new RJMdCmdParser.CommandAction(){

        public void actionPerformed() throws ParseException {
            RJMdCmdManager.this.action_show();
        }
    }}, {"group", TRACE_ON, new RJMdCmdParser.CommandAction(){

        public void actionPerformed() throws ParseException {
            RJMdCmdManager.this.action_group();
        }
    }}, {"range", TRACE_ON, new RJMdCmdParser.CommandAction(){

        public void actionPerformed() throws ParseException {
            RJMdCmdManager.this.action_shortrange();
        }
    }}, {"outpath", TRACE_ON, new RJMdCmdParser.CommandAction(){

        public void actionPerformed() throws ParseException {
            RJMdCmdManager.this.action_outpath();
        }
    }}, {"option", TRACE_ON, new RJMdCmdParser.CommandAction(){

        public void actionPerformed() throws ParseException {
            RJMdCmdManager.this.action_option();
        }
    }}, {"retry", TRACE_ON, new RJMdCmdParser.CommandAction(){

        public void actionPerformed() throws ParseException {
            RJMdCmdManager.this.action_retry();
        }
    }}, {"set", TRACE_ON, new RJMdCmdParser.CommandAction(){

        public void actionPerformed() throws ParseException {
            RJMdCmdManager.this.action_set();
        }
    }}, {"apply", TRACE_ON, new RJMdCmdParser.CommandAction(){

        public void actionPerformed() throws ParseException {
            RJMdCmdManager.this.action_apply();
        }
    }}, {"help", TRACE_ON, new RJMdCmdParser.CommandAction(){

        public void actionPerformed() throws ParseException {
            RJMdCmdManager.this.action_help();
        }
    }}};
    private RJMdDataControl controller;
    private RJMdExecParameter parameter;
    private RJMdGroupManager manager;
    private RJMdSetCommand setCommand;
    private Thread shutdownHook = new Thread(this);

    public RJMdCmdManager(RJMdDataControl rJMdDataControl) {
        this.controller = rJMdDataControl;
        this.parameter = rJMdDataControl.getExecParameter();
        dateFormat.setLenient(false);
        this.manager = new RJMdGroupManager(rJMdDataControl);
        this.setCommand = new RJMdSetCommand(rJMdDataControl);
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(this.shutdownHook);
    }

    protected Object[][] getCommandTable() {
        return this.commandTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyze(InputStream inputStream) {
        try {
            super.analyze(inputStream);
            this.setCommand.doit();
        }
        catch (IOException iOException) {
            this.controller.putMessage(iOException.getMessage());
            this.controller.putMessage(RJMdMessage.message("INF004"));
            this.parameter.setExitCode(2);
        }
        catch (ParseException parseException) {
            String string = parseException.getMessage();
            if (string != null) {
                this.controller.putMessage(string + " [line = " + this.getLineNumber() + "]");
            }
            this.controller.putMessage(RJMdMessage.message("INF004"));
            this.parameter.setExitCode(2);
        }
        finally {
            this.logout();
            Runtime runtime = Runtime.getRuntime();
            runtime.removeShutdownHook(this.shutdownHook);
        }
    }

    public void logout() {
        if (this.controller.isConnect()) {
            try {
                RJMdDataControl.trace("logout ");
                this.controller.logout();
                dateFormat.clear();
            }
            catch (RJMdRmiException rJMdRmiException) {
                // empty catch block
            }
        }
    }

    public void run() {
        RJMdDataControl.trace("ShutdownHook ");
        this.logout();
    }

    private void action_svpip() throws ParseException {
        String string = null;
        String string2 = null;
        String string3 = null;
        char c = this.nextToken(".[]:%");
        if (c == 'I' || c == 'L') {
            string = this.getToken();
            if (string.matches("\\[.*\\]") || string.matches("\\[.*\\]:\\d+")) {
                String[] stringArray = string.split("]");
                string2 = stringArray[0];
                string2 = string2 + "]";
                try {
                    if (stringArray.length > 1) {
                        string3 = stringArray[1];
                        string3 = string3.substring(1);
                    }
                    string3 = Integer.toString(1099);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw RJMdMessage.parseException("MSG001", this.getLine());
                }
            } else {
                String[] stringArray = string.split(":");
                string2 = stringArray[0];
                try {
                    string3 = stringArray.length > 1 ? stringArray[1] : Integer.toString(1099);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw RJMdMessage.parseException("MSG001", this.getLine());
                }
            }
            try {
                this.parameter.setInetAddress(string2);
            }
            catch (UnknownHostException unknownHostException) {
                throw RJMdMessage.parseException("MSG004", string2);
            }
            this.trace("\tipAddress = " + this.parameter.getInetAddress().getHostAddress());
            if (!string3.matches(PATTERN_DECIMAL)) {
                throw RJMdMessage.parseException("MSG001", this.getLine());
            }
            if (Integer.parseInt(string3) > 65535 || Integer.parseInt(string3) < 1) {
                throw RJMdMessage.parseException("MSG001", this.getLine());
            }
            try {
                this.parameter.setPortNum(string3);
            }
            catch (UnknownHostException unknownHostException) {
                throw RJMdMessage.parseException("MSG004", string3);
            }
        }
        throw RJMdMessage.parseException("MSG005");
        this.nextToken();
    }

    private void action_dkcsn() throws ParseException {
        String string = null;
        this.nextToken();
        string = this.getToken();
        if (string.length() != 6) {
            throw RJMdMessage.parseException("MSG001", this.getLine());
        }
        if (!string.matches(PATTERN_DECIMAL)) {
            throw RJMdMessage.parseException("MSG001", this.getLine());
        }
        try {
            this.parameter.setDkcSn(string);
        }
        catch (RJMdRmiException rJMdRmiException) {
            throw RJMdMessage.parseException("MSG030", string);
        }
        this.nextToken();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void action_login() throws ParseException {
        RCobj_interface_CheckRet rCobj_interface_CheckRet;
        InetAddress inetAddress = this.parameter.getInetAddress();
        String string = this.parameter.getPortNum();
        String string2 = this.parameter.getDkcSn();
        if (inetAddress == null) throw RJMdMessage.parseException("MSG029");
        if (string2 == null) throw RJMdMessage.parseException("MSG030");
        char c = this.nextToken();
        if (c != 'I' && c != 'L') throw RJMdMessage.parseException("MSG009");
        String string3 = this.getToken();
        this.parameter.setUserId(string3);
        c = this.nextToken();
        if (c != 'I' && c != 'L') throw RJMdMessage.parseException("MSG010");
        String string4 = this.getToken();
        this.parameter.setPassWord(string4);
        this.traceLine("login User = [" + string3 + "], Passwd = [****************]");
        try {
            rCobj_interface_CheckRet = this.controller.login(inetAddress.getHostName(), string, string2, string3, string4, 0, 0);
            this.manager.init();
            this.parameter.setCheckRet(rCobj_interface_CheckRet);
        }
        catch (RJMdRmiException rJMdRmiException) {
            throw RJMdMessage.parseException("MSG006");
        }
        try {
            rCobj_interface_CheckRet = this.controller.getSubsystemInfo();
            this.parameter.setSerialNumber(rCobj_interface_CheckRet.nDKCSerialNumber);
            String string5 = this.controller.getProductName();
            this.parameter.setProductName(string5);
        }
        catch (RJMdRmiException rJMdRmiException) {
            throw RJMdMessage.parseException("MSG023");
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            ArgMonitoringInfo argMonitoringInfo = new ArgMonitoringInfo();
            MonMonitoringInfo monMonitoringInfo = (MonMonitoringInfo)this.controller.getMonitorInfo((MonArg)argMonitoringInfo);
            RJMdDateFormat.initTimeZone(TimeZone.getTimeZone(monMonitoringInfo.getTimeZoneID()));
            bl = this.parameter.initShortRange(monMonitoringInfo);
            bl2 = this.parameter.initLongRange(monMonitoringInfo);
        }
        catch (RJMdRmiException rJMdRmiException) {
            // empty catch block
        }
        if (!bl || !bl2) {
            this.controller.putMessage(RJMdMessage.message("MSG007"));
        }
        c = this.nextToken();
    }

    private void action_show() throws ParseException {
        int n;
        String string;
        String string2;
        if (this.controller.isConnect()) {
            String string3 = "0000/00/00 00:00";
            int n2 = 0;
            string2 = string3;
            string = string3;
            n = n2;
            RJMdTimeRange rJMdTimeRange = this.parameter.getBasicShortRange();
            if (rJMdTimeRange != null) {
                string2 = rJMdTimeRange.toFromString();
                string = rJMdTimeRange.toToString();
                n = rJMdTimeRange.getIntervalTime();
            }
            String string4 = string3;
            String string5 = string3;
            int n3 = n2;
            RJMdTimeRange rJMdTimeRange2 = this.parameter.getBasicLongRange();
            if (rJMdTimeRange2 != null) {
                string4 = rJMdTimeRange2.toFromString();
                string5 = rJMdTimeRange2.toToString();
                n3 = rJMdTimeRange2.getIntervalTime();
            }
        } else {
            throw RJMdMessage.parseException("MSG011");
        }
        RJMdDataControl.putInfomation("Monitoring time range");
        RJMdDataControl.putInfomation("From : " + string2 + " - To : " + string + " Interval : " + n + "min.");
        this.nextToken();
    }

    private void action_group() throws ParseException {
        char c = this.nextToken();
        if (c == 'I') {
            this.manager.analyze(this);
        } else if (c == '\u0000') {
            throw RJMdMessage.parseException("MSG012");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void action_shortrange() throws ParseException {
        if (!this.controller.isConnect()) throw RJMdMessage.parseException("MSG011");
        RJMdTimeRange rJMdTimeRange = this.parameter.getBasicShortRange();
        if (rJMdTimeRange != null) {
            char c = this.nextToken();
            if (c == '\u0000') throw RJMdMessage.parseException("MSG016");
            this.analyzeTimeRange(rJMdTimeRange);
            try {
                this.parameter.adjustShortRange(rJMdTimeRange);
            }
            catch (RJMdRangeException rJMdRangeException) {
                throw RJMdMessage.parseException("MSG013", rJMdRangeException.getMessage());
            }
            rJMdTimeRange.adjustTime(this.parameter.getBasicShortRange());
            RJMdDataControl.putInfomation("\trange " + this.parameter.getShortRange() + ", count = " + this.parameter.getShortRange().getCount());
            c = this.getKind();
            if (c != ' ') return;
            this.nextToken();
            return;
        }
        this.controller.putMessage(RJMdMessage.message("MSG007"));
        this.skipOperand();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void action_longrange() throws ParseException {
        if (!this.controller.isConnect()) throw RJMdMessage.parseException("MSG011");
        RJMdTimeRange rJMdTimeRange = this.parameter.getBasicLongRange();
        if (rJMdTimeRange != null) {
            char c = this.nextToken();
            if (c == '\u0000') throw RJMdMessage.parseException("MSG016");
            this.analyzeTimeRange(rJMdTimeRange);
            try {
                this.parameter.adjustLongRange(rJMdTimeRange);
            }
            catch (RJMdRangeException rJMdRangeException) {
                throw RJMdMessage.parseException("MSG013", rJMdRangeException.getMessage());
            }
            rJMdTimeRange.adjustTime(this.parameter.getBasicLongRange());
            RJMdDataControl.putInfomation("\tlongrange " + this.parameter.getLongRange() + ", count = " + this.parameter.getLongRange().getCount());
            c = this.getKind();
            if (c != ' ') return;
            this.nextToken();
            return;
        }
        this.controller.putMessage(RJMdMessage.message("MSG007"));
        this.skipOperand();
    }

    private RJMdTimeRange analyzeTimeRange(RJMdTimeRange rJMdTimeRange) throws ParseException {
        long l;
        String string;
        String string2;
        String string3 = rJMdTimeRange instanceof RJMdTimeShortRange ? "HHmm" : "DDHHmm";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        long l2 = rJMdTimeRange instanceof RJMdTimeShortRange ? 0L : 86400000L;
        Date date = rJMdTimeRange.getFromTime();
        Date date2 = rJMdTimeRange.getToTime();
        Date date3 = rJMdTimeRange.getToTime();
        Date date4 = rJMdTimeRange.getFromTime();
        char c = this.getKind();
        if (c == 'I') {
            string2 = this.getToken();
            if (string2.length() == dateFormat.toPattern().length()) {
                date2 = date = new Date(dateFormat.parse(string2).getTime());
                c = this.nextTokenS();
            } else {
                throw RJMdMessage.parseException("MSG014", string2);
            }
        }
        if (c == '+' || c == '-') {
            char c2 = c;
            c = this.nextTokenS();
            if (c == 'I') {
                string = this.getToken();
                if (string.length() == simpleDateFormat.toPattern().length()) {
                    l = simpleDateFormat.parse(string).getTime() + l2;
                    date.setTime(c2 == '+' ? date.getTime() + l : date2.getTime() - l);
                    c = this.nextTokenS();
                } else {
                    throw RJMdMessage.parseException("MSG014", string);
                }
            }
        }
        if (c != ':') {
            throw RJMdMessage.parseException("MSG001", this.getLine());
        }
        c = this.nextTokenS();
        if (c == 'I') {
            string2 = this.getToken();
            if (string2.length() == dateFormat.toPattern().length()) {
                date4 = date3 = new Date(dateFormat.parse(string2).getTime());
                c = this.nextTokenS();
            } else {
                throw RJMdMessage.parseException("MSG014", string2);
            }
        }
        if (c == '+' || c == '-') {
            char c3 = c;
            c = this.nextTokenS();
            if (c == 'I') {
                string = this.getToken();
                if (string.length() == simpleDateFormat.toPattern().length()) {
                    l = simpleDateFormat.parse(string).getTime() + l2;
                    date3.setTime(c3 == '+' ? date4.getTime() + l : date3.getTime() - l);
                    c = this.nextTokenS();
                } else {
                    throw RJMdMessage.parseException("MSG014", string);
                }
            }
        }
        try {
            rJMdTimeRange.setValue(date, date3);
        }
        catch (RJMdRangeException rJMdRangeException) {
            throw RJMdMessage.parseException("MSG015", rJMdRangeException.getMessage());
        }
        return rJMdTimeRange;
    }

    private void action_outpath() throws ParseException {
        char c = this.nextToken(":\\");
        if (c == 'I' || c == 'L') {
            this.parameter.setDirectory(this.getToken());
            c = this.nextToken();
        } else if (c == '\u0000') {
            throw RJMdMessage.parseException("MSG017");
        }
    }

    private void action_option() throws ParseException {
        char c = this.nextToken();
        while (c == 'I') {
            String string = this.getToken();
            if (string.equals("compress")) {
                this.parameter.setCompless(true);
            } else if (string.equals("nocompress")) {
                this.parameter.setCompless(false);
            } else if (string.equals("ask")) {
                this.parameter.setClearMode(0);
            } else if (string.equals("clear")) {
                this.parameter.setClearMode(1);
            } else if (string.equals("noclear")) {
                this.parameter.setClearMode(2);
            } else {
                throw RJMdMessage.parseException("MSG018", string);
            }
            c = this.nextToken();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void action_retry() throws ParseException {
        if (this.controller.isConnect()) throw RJMdMessage.parseException("MSG025", this.getToken());
        char c = this.nextToken();
        while (c == 'I') {
            int n;
            String string = this.getToken();
            if (string.equals("time")) {
                c = this.nextTokenS();
                n = this.getValue(string);
                if (n < 1 || n > 59) throw RJMdMessage.parseException("MSG019", string + "=" + this.getToken());
                this.parameter.setRetryTime(n);
            } else {
                if (!string.equals("count")) throw RJMdMessage.parseException("MSG024", string);
                c = this.nextTokenS();
                n = this.getValue(string);
                if (n < 0) throw RJMdMessage.parseException("MSG019", string + "=" + this.getToken());
                if (n == 0) {
                    n = Integer.MAX_VALUE;
                }
                this.parameter.setRetryCount(n);
            }
            c = this.nextToken();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getValue(String string) throws ParseException {
        int n = -1;
        char c = this.getKind();
        if (c != '=') throw RJMdMessage.parseException("MSG001", this.getLine());
        c = this.nextTokenS();
        if (c != 'I') throw RJMdMessage.parseException("MSG001", this.getLine());
        try {
            return Integer.parseInt(this.getToken());
        }
        catch (NumberFormatException numberFormatException) {
            throw RJMdMessage.parseException("MSG019", string + "=" + this.getToken());
        }
    }

    private void action_set() throws ParseException {
        if (!this.controller.isConnect()) {
            throw RJMdMessage.parseException("MSG011");
        }
        this.setCommand.analyze(this);
    }

    private void action_apply() throws ParseException {
        if (!this.controller.isConnect()) {
            throw RJMdMessage.parseException("MSG011");
        }
        this.manager.apply();
        this.nextToken();
    }

    private void action_help() throws ParseException {
        RJMdHelp rJMdHelp = new RJMdHelp(this.controller);
        rJMdHelp.printHelp();
        this.nextToken();
    }

    protected void traceLine(String string) {
        String string2 = "[" + this.lineNumber() + "] " + string;
        RJMdDataControl.putInfomation(string2);
    }

    protected void trace(String string) {
        String string2 = string;
        RJMdDataControl.trace(string2);
    }

    private String lineNumber() {
        String string = String.valueOf(this.getLineNumber());
        if (string.length() < 3) {
            string = "   " + string;
            string = string.substring(string.length() - 3);
        }
        return string;
    }
}

