/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdRange;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataCU;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.data.RJMdDataLDEV;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupData;
import sanproject.getmondat.group.RJMdUnitEntry;
import sanproject.getmondat.group.RJMdUnitSerialStream;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serverux.arg.monitor.ArgHRCLDEVEx;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.MonitorInfoCollection;
import sanproject.serverux.dataimpl.RMCPgetUsageLDEVInfEx;

public class RJMdGroupRCLDEV
extends RJMdGroupData {
    private static final String groupID = "RCLDEV";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "RCLDEV_dat";
    private static final String groupInfo = "RCLDEV data";
    public static final int LIMIT_PARAMS_RCLDEV = 512;
    private HashMap unitStreams = null;
    private static final String UN_RCLDEV_All_RIO = "RCLDEV_All_RIO";
    private static final String UN_RCLDEV_All_Read = "RCLDEV_All_Read";
    private static final String UN_RCLDEV_All_Write = "RCLDEV_All_Write";
    private static final String UN_RCLDEV_RIO_Error = "RCLDEV_RIO_Error";
    private static final String UN_RCLDEV_Initial_Copy_RIO = "RCLDEV_Initial_Copy_RIO";
    private static final String UN_RCLDEV_Initial_Copy_Hit = "RCLDEV_Initial_Copy_Hit";
    private static final String UN_RCLDEV_Initial_Copy_Transfer = "RCLDEV_Initial_Copy_Transfer";
    private static final String UN_RCLDEV_Initial_Copy_Response = "RCLDEV_Initial_Copy_Response";
    private static final String UN_RCLDEV_Migration_Copy_RIO = "RCLDEV_Migration_Copy_RIO";
    private static final String UN_RCLDEV_Migration_Copy_Hit = "RCLDEV_Migration_Copy_Hit";
    private static final String UN_RCLDEV_Update_Copy_RIO = "RCLDEV_Update_Copy_RIO";
    private static final String UN_RCLDEV_Update_Copy_Hit = "RCLDEV_Update_Copy_Hit";
    private static final String UN_RCLDEV_Update_Copy_Transfer = "RCLDEV_Update_Copy_Transfer";
    private static final String UN_RCLDEV_Update_Copy_Response = "RCLDEV_Update_Copy_Response";
    private static final String UN_RCLDEV_Restore_Copy_RIO = "RCLDEV_Restore_Copy_RIO";
    private static final String UN_RCLDEV_Restore_Copy_Hit = "RCLDEV_Restore_Copy_Hit";
    private static final String UN_RCLDEV_Asynchronous_RIO = "RCLDEV_Asynchronous_RIO";
    private static final String UN_RCLDEV_Recordset = "RCLDEV_Recordset";
    private static final String UN_RCLDEV_Asynchronous_Copy_Transfer = "RCLDEV_Asynchronous_Copy_Transfer";
    private static final String UN_RCLDEV_Asynchronous_Copy_Response = "RCLDEV_Asynchronous_Copy_Response";
    private static final String UN_RCLDEV_Scheduling_Recordset = "RCLDEV_Scheduling_Recordset";
    private static final String UN_RCLDEV_Scheduling_Miss_Recordset = "RCLDEV_Scheduling_Miss_Recordset";
    private static final String UN_RCLDEV_Remained_Recordset = "RCLDEV_Remained_Recordset";
    private static final String UN_RCLDEV_Scheduling_Attempt = "RCLDEV_Scheduling_Attempt";
    private static final String UN_RCLDEV_Pair_Synchronized = "RCLDEV_Pair_Synchronized";
    private static final String UN_RCLDEV_Out_of_Tracks = "RCLDEV_Out_of_Tracks";
    private static final String[] unitNames = new String[]{"RCLDEV_All_RIO", "RCLDEV_All_Write", "RCLDEV_RIO_Error", "RCLDEV_Initial_Copy_RIO", "RCLDEV_Initial_Copy_Transfer", "RCLDEV_Initial_Copy_Response", "RCLDEV_Update_Copy_RIO", "RCLDEV_Update_Copy_Transfer", "RCLDEV_Update_Copy_Response", "RCLDEV_Pair_Synchronized", "RCLDEV_Out_of_Tracks"};

    public RJMdGroupRCLDEV(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
        this.allowPSA = false;
    }

    public void init() throws IOException {
        String string = this.parameter.getDirectory();
        File file = new File(string);
        File file2 = new File(file.getAbsolutePath(), groupName);
        this.unitStreams = new HashMap();
        for (int i = 0; i < unitNames.length; ++i) {
            RJMdUnitSerialStream rJMdUnitSerialStream = new RJMdUnitSerialStream(unitNames[i], file2);
            rJMdUnitSerialStream.setCompress(this.parameter.isCompless());
            this.unitStreams.put(unitNames[i], rJMdUnitSerialStream);
        }
    }

    protected boolean isGroupExists() {
        String string = this.parameter.getDirectory();
        File file = new File(string, groupName);
        boolean bl = file.exists() && file.isDirectory();
        return bl;
    }

    public void deleteGroup() {
        for (int i = 0; i < unitNames.length; ++i) {
            this.stream(unitNames[i]).deleteAll();
        }
        String string = this.parameter.getDirectory();
        File file = new File(string, groupName);
        this.stream(unitNames[0]).deletePath(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup() throws RJMdRmiException, IOException {
        try {
            this.createGroupRCLDEV();
        }
        finally {
            for (int i = 0; i < unitNames.length; ++i) {
                this.stream(unitNames[i]).closeEntry();
                this.stream(unitNames[i]).close();
            }
        }
    }

    private void createGroupRCLDEV() throws RJMdRmiException, IOException {
        this.putInfomation("INF006", this.getGroupInfo());
        String string = this.parameter.getDirectory();
        File file = new File(string, groupName);
        if (!file.exists()) {
            file.mkdirs();
        }
        RJMdTimeRange rJMdTimeRange = this.parameter.getShortRange();
        CollectParam collectParam = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
        ArrayList arrayList = this.controller.getCU();
        this.initProgress(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataCU rJMdDataCU = (RJMdDataCU)iterator.next();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataCU)) continue;
            ArrayList arrayList2 = this.controller.getCUToLDEV(rJMdDataCU.getLDKC(), rJMdDataCU.getCU());
            Iterator iterator2 = arrayList2.iterator();
            while (iterator2.hasNext()) {
                RJMdDataLDEV rJMdDataLDEV = (RJMdDataLDEV)iterator2.next();
                if (collectParam.size() >= 512) {
                    this.collect(this.unitStreams, collectParam);
                    this.addProgress(collectParam.size());
                    collectParam = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
                }
                collectParam.add(rJMdDataLDEV);
            }
        }
        this.collect(this.unitStreams, collectParam);
        this.addProgress(collectParam.size());
        this.closeProgress();
        this.putInfomation("INF007", this.getGroupInfo());
    }

    private void initProgress(ArrayList arrayList) throws RJMdRmiException {
        int n = 0;
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataCU rJMdDataCU = (RJMdDataCU)iterator.next();
            ArrayList arrayList2 = this.controller.getCUToLDEV(rJMdDataCU.getLDKC(), rJMdDataCU.getCU());
            n2 += arrayList2.size();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataCU)) continue;
            n += arrayList2.size();
        }
        super.initProgress(n, n2);
    }

    public void collect(HashMap hashMap, CollectParam collectParam) throws RJMdRmiException, IOException {
        if (collectParam.size() > 0) {
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)collectParam.getArgument());
            for (int i = 0; i < monitorInfoCollection.size(); ++i) {
                RMCPgetUsageLDEVInfEx rMCPgetUsageLDEVInfEx = (RMCPgetUsageLDEVInfEx)monitorInfoCollection.get(i);
                String string = collectParam.toColumnName(rMCPgetUsageLDEVInfEx.getLdkc(), rMCPgetUsageLDEVInfEx.getCu(), rMCPgetUsageLDEVInfEx.getLdev());
                String string2 = this.toHexString(rMCPgetUsageLDEVInfEx.getCu(), 2);
                for (int j = 0; j < unitNames.length; ++j) {
                    String string3 = this.stream(unitNames[j]).getName() + "_" + string2;
                    RJMdUnitEntry rJMdUnitEntry = this.stream(unitNames[j]).getCurrentEntry();
                    if (rJMdUnitEntry != null && rJMdUnitEntry.getName().equals(string3)) continue;
                    if (rJMdUnitEntry != null) {
                        this.stream(unitNames[j]).closeEntry();
                    }
                    this.stream(unitNames[j]).createEntry(string3, this.getTimeRange());
                }
                this.stream(UN_RCLDEV_All_RIO).write(new RJMdColumn(string, rMCPgetUsageLDEVInfEx.getAllRIO()));
                this.stream(UN_RCLDEV_All_Write).write(new RJMdColumn(string, rMCPgetUsageLDEVInfEx.getAllWrite()));
                this.stream(UN_RCLDEV_RIO_Error).write(new RJMdColumn(string, rMCPgetUsageLDEVInfEx.getRIOUCK()));
                this.stream(UN_RCLDEV_Initial_Copy_RIO).write(new RJMdColumn(string, rMCPgetUsageLDEVInfEx.getIniRIO()));
                this.stream(UN_RCLDEV_Initial_Copy_Transfer).write(new RJMdColumn(string, rMCPgetUsageLDEVInfEx.getIniLength()));
                this.stream(UN_RCLDEV_Initial_Copy_Response).write(new RJMdColumn(string, rMCPgetUsageLDEVInfEx.getIniTime()));
                this.stream(UN_RCLDEV_Update_Copy_RIO).write(new RJMdColumn(string, rMCPgetUsageLDEVInfEx.getRenewRIO()));
                this.stream(UN_RCLDEV_Update_Copy_Transfer).write(new RJMdColumn(string, rMCPgetUsageLDEVInfEx.getRenewLength()));
                this.stream(UN_RCLDEV_Update_Copy_Response).write(new RJMdColumn(string, rMCPgetUsageLDEVInfEx.getRenewTime()));
                this.stream(UN_RCLDEV_Pair_Synchronized).write(new RJMdColumn(string, rMCPgetUsageLDEVInfEx.getPairSync()));
                this.stream(UN_RCLDEV_Out_of_Tracks).write(new RJMdColumn(string, rMCPgetUsageLDEVInfEx.getOutOfSync()));
            }
        }
    }

    private RJMdUnitSerialStream stream(String string) {
        return (RJMdUnitSerialStream)this.unitStreams.get(string);
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public String getGroupID() {
        return groupID;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo() {
        return groupInfo;
    }

    public RJMdTimeRange getTimeRange() {
        return this.parameter.getShortRange();
    }

    public void analyzeOperand(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        char c = rJMdCmdParser.getKind();
        while ((rJMdRange = this.analyzeCURange(rJMdCmdParser)) != null) {
            RJMdDataControl.trace("\tCU =  " + rJMdRange);
            this.parameter.addGroupRange(this.getGroupID(), rJMdRange);
            if (rJMdCmdParser.getKind() != ' ') break;
            rJMdCmdParser.nextToken();
        }
    }

    class CollectParam {
        private ArrayList ldevList = new ArrayList();
        private HashMap ldevMap = new HashMap();
        private Date fromTime;
        private Date toTime;

        CollectParam(Date date, Date date2) {
            this.fromTime = date;
            this.toTime = date2;
        }

        public void add(RJMdDataLDEV rJMdDataLDEV) {
            String string = this.toKeyString(rJMdDataLDEV.getLDKC(), rJMdDataLDEV.getCU(), rJMdDataLDEV.getLDEV());
            this.ldevMap.put(string, rJMdDataLDEV);
            RJiLDEVIndex rJiLDEVIndex = new RJiLDEVIndex();
            rJiLDEVIndex.setLDEVIndex((short)rJMdDataLDEV.getLDKC(), (short)rJMdDataLDEV.getCU(), (short)rJMdDataLDEV.getLDEV());
            this.ldevList.add(rJiLDEVIndex);
        }

        public int size() {
            return this.ldevList.size();
        }

        private String toColumnName(int n, int n2, int n3) {
            String string = this.toKeyString(n, n2, n3);
            RJMdDataLDEV rJMdDataLDEV = (RJMdDataLDEV)this.ldevMap.get(string);
            if (rJMdDataLDEV.isExternal()) {
                string = string + " " + '#';
            }
            return string;
        }

        private String toKeyString(int n, int n2, int n3) {
            String string = RJMdGroupRCLDEV.this.toHexString(n, 2) + ":" + RJMdGroupRCLDEV.this.toHexString(n2, 2) + ":" + RJMdGroupRCLDEV.this.toHexString(n3, 2);
            return string;
        }

        public ArgHRCLDEVEx getArgument() {
            RJiLDEVIndex[] rJiLDEVIndexArray = this.ldevList.toArray(new RJiLDEVIndex[0]);
            ArgHRCLDEVEx argHRCLDEVEx = new ArgHRCLDEVEx(this.fromTime, this.toTime, (Robj_interface_RJiLDEVIndex[])rJiLDEVIndexArray);
            return argHRCLDEVEx;
        }
    }
}

