/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupData;
import sanproject.getmondat.group.RJMdUnitSerialStream;
import sanproject.serverux.arg.monitor.ArgHURSystem;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.HURgetUsageInf;
import sanproject.serverux.data.MonitorInfoCollection;

public class RJMdGroupUR
extends RJMdGroupData {
    private static final String groupID = "UniversalReplicator";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "UniversalReplicator_dat";
    private static final String groupInfo = "UniversalReplicator data";
    private RJMdUnitSerialStream stream = null;
    private static final String CM_WriteRecord = "Write Record";
    private static final String CM_WriteLength = "Write Transfer(KB/s)";
    private static final String CM_IniHit = "Initial Copy Hit(%)";
    private static final String CM_IniLength = "Initial Copy Transfer(KB/s)";
    private static final String CM_MJNLACopyRIO = "M-JNL Asynchronous RIO";
    private static final String CM_MJNLACopyJournal = "M-JNL Asynchronous Journal";
    private static final String CM_MJNLACopyLength = "M-JNL Asynchronous Copy Transfer(KB/s)";
    private static final String CM_MJNLACopyResponse = "M-JNL Asynchronous Copy Response(ms)";
    private static final String CM_RJNLACopyRIO = "R-JNL Asynchronous RIO";
    private static final String CM_RJNLACopyJournal = "R-JNL Asynchronous Journal";
    private static final String CM_RJNLACopyLength = "R-JNL Asynchronous Copy Transfer(KB/s)";
    private static final String CM_RJNLACopyResponse = "R-JNL Asynchronous Copy Response(ms)";
    private static final String UniversalReplicator = "UniversalReplicator";

    public RJMdGroupUR(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
        this.allowPSA = false;
    }

    public void init() throws IOException {
        String string = this.parameter.getDirectory();
        File file = new File(string);
        this.stream = new RJMdUnitSerialStream(groupName, file);
        this.stream.setCompress(this.parameter.isCompless());
    }

    protected boolean isGroupExists() {
        boolean bl = this.stream.exists();
        return bl;
    }

    public void deleteGroup() {
        this.stream.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup() throws RJMdRmiException, IOException {
        try {
            this.createGroupUR();
        }
        finally {
            this.stream.close();
        }
    }

    private void createGroupUR() throws RJMdRmiException, IOException {
        this.putInfomation("INF006", this.getGroupInfo());
        this.stream.createEntry("UniversalReplicator", this.getTimeRange());
        RJMdTimeRange rJMdTimeRange = this.parameter.getShortRange();
        ArgHURSystem argHURSystem = new ArgHURSystem(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
        this.initProgress(1, 1);
        MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)argHURSystem);
        if (monitorInfoCollection.size() > 0) {
            HURgetUsageInf hURgetUsageInf = (HURgetUsageInf)monitorInfoCollection.get(0);
            this.stream.write(new RJMdColumn(CM_WriteRecord, hURgetUsageInf.getwriteRecord()));
            this.stream.write(new RJMdColumn(CM_WriteLength, hURgetUsageInf.getwriteTransfer()));
            this.stream.write(new RJMdColumn(CM_IniHit, hURgetUsageInf.getinitHit()));
            this.stream.write(new RJMdColumn(CM_IniLength, hURgetUsageInf.getinitTransfer()));
            this.stream.write(new RJMdColumn(CM_MJNLACopyRIO, hURgetUsageInf.getmjnlAsyncRio()));
            this.stream.write(new RJMdColumn(CM_MJNLACopyJournal, hURgetUsageInf.getmjniAsyncJnl()));
            this.stream.write(new RJMdColumn(CM_MJNLACopyLength, hURgetUsageInf.getmjnlAsyncTransfer()));
            this.stream.write(new RJMdColumn(CM_MJNLACopyResponse, hURgetUsageInf.getmjnlAsyncResponse()));
            this.stream.write(new RJMdColumn(CM_RJNLACopyRIO, hURgetUsageInf.getrjnlAsyncRio()));
            this.stream.write(new RJMdColumn(CM_RJNLACopyJournal, hURgetUsageInf.getrjnlAsyncJnl()));
            this.stream.write(new RJMdColumn(CM_RJNLACopyLength, hURgetUsageInf.getrjnlAsyncTransfer()));
            this.stream.write(new RJMdColumn(CM_RJNLACopyResponse, hURgetUsageInf.getrjnlAsyncResponce()));
        }
        this.addProgress(1);
        this.closeProgress();
        this.stream.closeEntry();
        this.putInfomation("INF007", this.getGroupInfo());
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public String getGroupID() {
        return "UniversalReplicator";
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo() {
        return groupInfo;
    }

    public RJMdTimeRange getTimeRange() {
        return this.parameter.getShortRange();
    }
}

