/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdRange;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataCU;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.data.RJMdDataLDEV;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupData;
import sanproject.getmondat.group.RJMdUnitEntry;
import sanproject.getmondat.group.RJMdUnitSerialStream;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serverux.arg.monitor.ArgHURLDEV;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.HURgetUsageLDEVInf;
import sanproject.serverux.data.MonitorInfoCollection;

public class RJMdGroupURLDEV
extends RJMdGroupData {
    private static final String groupID = "URLDEV";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "URLDEV_dat";
    private static final String groupInfo = "URLDEV data";
    public static final int LIMIT_PARAMS_URLDEV = 512;
    private HashMap unitStreams = null;
    private static final String UN_URLDEV_Read_Record = "URLDEV_Read_Record";
    private static final String UN_URLDEV_Read_Hit = "URLDEV_Read_Hit";
    private static final String UN_URLDEV_Write_Record = "URLDEV_Write_Record";
    private static final String UN_URLDEV_Write_Hit = "URLDEV_Write_Hit";
    private static final String UN_URLDEV_Read_Transfer = "URLDEV_Read_Transfer";
    private static final String UN_URLDEV_Write_Transfer = "URLDEV_Write_Transfer";
    private static final String UN_URLDEV_Initial_Copy_Hit = "URLDEV_Initial_Copy_Hit";
    private static final String UN_URLDEV_Initial_Copy_Transfer = "URLDEV_Initial_Copy_Transfer";
    private static final String[] unitNames = new String[]{"URLDEV_Read_Record", "URLDEV_Read_Hit", "URLDEV_Write_Record", "URLDEV_Write_Hit", "URLDEV_Read_Transfer", "URLDEV_Write_Transfer", "URLDEV_Initial_Copy_Hit", "URLDEV_Initial_Copy_Transfer"};

    public RJMdGroupURLDEV(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
        this.allowPSA = false;
    }

    public void init() throws IOException {
        String string = this.parameter.getDirectory();
        File file = new File(string);
        File file2 = new File(file.getAbsolutePath(), groupName);
        this.unitStreams = new HashMap();
        for (int i = 0; i < unitNames.length; ++i) {
            RJMdUnitSerialStream rJMdUnitSerialStream = new RJMdUnitSerialStream(unitNames[i], file2);
            rJMdUnitSerialStream.setCompress(this.parameter.isCompless());
            this.unitStreams.put(unitNames[i], rJMdUnitSerialStream);
        }
    }

    protected boolean isGroupExists() {
        String string = this.parameter.getDirectory();
        File file = new File(string, groupName);
        boolean bl = file.exists() && file.isDirectory();
        return bl;
    }

    public void deleteGroup() {
        for (int i = 0; i < unitNames.length; ++i) {
            this.stream(unitNames[i]).deleteAll();
        }
        String string = this.parameter.getDirectory();
        File file = new File(string, groupName);
        this.stream(unitNames[0]).deletePath(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup() throws RJMdRmiException, IOException {
        try {
            this.createGroupURLDEV();
        }
        finally {
            for (int i = 0; i < unitNames.length; ++i) {
                this.stream(unitNames[i]).closeEntry();
                this.stream(unitNames[i]).close();
            }
        }
    }

    private void createGroupURLDEV() throws RJMdRmiException, IOException {
        this.putInfomation("INF006", this.getGroupInfo());
        String string = this.parameter.getDirectory();
        File file = new File(string, groupName);
        if (!file.exists()) {
            file.mkdirs();
        }
        RJMdTimeRange rJMdTimeRange = this.parameter.getShortRange();
        CollectParam collectParam = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
        ArrayList arrayList = this.controller.getCU();
        this.initProgress(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataCU rJMdDataCU = (RJMdDataCU)iterator.next();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataCU)) continue;
            ArrayList arrayList2 = this.controller.getCUToLDEV(rJMdDataCU.getLDKC(), rJMdDataCU.getCU());
            Iterator iterator2 = arrayList2.iterator();
            while (iterator2.hasNext()) {
                RJMdDataLDEV rJMdDataLDEV = (RJMdDataLDEV)iterator2.next();
                if (collectParam.size() >= 512) {
                    this.collect(this.unitStreams, collectParam);
                    this.addProgress(collectParam.size());
                    collectParam = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
                }
                collectParam.add(rJMdDataLDEV);
            }
        }
        this.collect(this.unitStreams, collectParam);
        this.addProgress(collectParam.size());
        this.closeProgress();
        this.putInfomation("INF007", this.getGroupInfo());
    }

    private void initProgress(ArrayList arrayList) throws RJMdRmiException {
        int n = 0;
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataCU rJMdDataCU = (RJMdDataCU)iterator.next();
            ArrayList arrayList2 = this.controller.getCUToLDEV(rJMdDataCU.getLDKC(), rJMdDataCU.getCU());
            n2 += arrayList2.size();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataCU)) continue;
            n += arrayList2.size();
        }
        super.initProgress(n, n2);
    }

    public void collect(HashMap hashMap, CollectParam collectParam) throws RJMdRmiException, IOException {
        if (collectParam.size() > 0) {
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)collectParam.getArgument());
            for (int i = 0; i < monitorInfoCollection.size(); ++i) {
                HURgetUsageLDEVInf hURgetUsageLDEVInf = (HURgetUsageLDEVInf)monitorInfoCollection.get(i);
                String string = collectParam.toColumnName(hURgetUsageLDEVInf.getLdkc(), hURgetUsageLDEVInf.getCu(), hURgetUsageLDEVInf.getLdev());
                String string2 = this.toHexString(hURgetUsageLDEVInf.getCu(), 2);
                for (int j = 0; j < unitNames.length; ++j) {
                    String string3 = this.stream(unitNames[j]).getName() + "_" + string2;
                    RJMdUnitEntry rJMdUnitEntry = this.stream(unitNames[j]).getCurrentEntry();
                    if (rJMdUnitEntry != null && rJMdUnitEntry.getName().equals(string3)) continue;
                    if (rJMdUnitEntry != null) {
                        this.stream(unitNames[j]).closeEntry();
                    }
                    this.stream(unitNames[j]).createEntry(string3, this.getTimeRange());
                }
                this.stream(UN_URLDEV_Read_Record).write(new RJMdColumn(string, hURgetUsageLDEVInf.getreadRecord()));
                this.stream(UN_URLDEV_Read_Hit).write(new RJMdColumn(string, hURgetUsageLDEVInf.getreadHit()));
                this.stream(UN_URLDEV_Write_Record).write(new RJMdColumn(string, hURgetUsageLDEVInf.getwriteRecord()));
                this.stream(UN_URLDEV_Write_Hit).write(new RJMdColumn(string, hURgetUsageLDEVInf.getwriteHit()));
                this.stream(UN_URLDEV_Read_Transfer).write(new RJMdColumn(string, hURgetUsageLDEVInf.getreadTransfer()));
                this.stream(UN_URLDEV_Write_Transfer).write(new RJMdColumn(string, hURgetUsageLDEVInf.getwriteTransfer()));
                this.stream(UN_URLDEV_Initial_Copy_Hit).write(new RJMdColumn(string, hURgetUsageLDEVInf.getinitHit()));
                this.stream(UN_URLDEV_Initial_Copy_Transfer).write(new RJMdColumn(string, hURgetUsageLDEVInf.getinitTransfer()));
            }
        }
    }

    private RJMdUnitSerialStream stream(String string) {
        return (RJMdUnitSerialStream)this.unitStreams.get(string);
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public String getGroupID() {
        return groupID;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo() {
        return groupInfo;
    }

    public RJMdTimeRange getTimeRange() {
        return this.parameter.getShortRange();
    }

    public void analyzeOperand(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        char c = rJMdCmdParser.getKind();
        while ((rJMdRange = this.analyzeCURange(rJMdCmdParser)) != null) {
            RJMdDataControl.trace("\tCU =  " + rJMdRange);
            this.parameter.addGroupRange(this.getGroupID(), rJMdRange);
            if (rJMdCmdParser.getKind() != ' ') break;
            rJMdCmdParser.nextToken();
        }
    }

    class CollectParam {
        private ArrayList ldevList = new ArrayList();
        private HashMap ldevMap = new HashMap();
        private Date fromTime;
        private Date toTime;

        CollectParam(Date date, Date date2) {
            this.fromTime = date;
            this.toTime = date2;
        }

        public void add(RJMdDataLDEV rJMdDataLDEV) {
            String string = this.toKeyString(rJMdDataLDEV.getLDKC(), rJMdDataLDEV.getCU(), rJMdDataLDEV.getLDEV());
            this.ldevMap.put(string, rJMdDataLDEV);
            RJiLDEVIndex rJiLDEVIndex = new RJiLDEVIndex();
            rJiLDEVIndex.setSLDKC((short)rJMdDataLDEV.getLDKC());
            rJiLDEVIndex.setSCU((short)rJMdDataLDEV.getCU());
            rJiLDEVIndex.setSLDEV((short)rJMdDataLDEV.getLDEV());
            this.ldevList.add(rJiLDEVIndex);
        }

        public int size() {
            return this.ldevList.size();
        }

        private String toColumnName(int n, int n2, int n3) {
            String string = this.toKeyString(n, n2, n3);
            RJMdDataLDEV rJMdDataLDEV = (RJMdDataLDEV)this.ldevMap.get(string);
            if (rJMdDataLDEV.isExternal()) {
                string = string + " " + '#';
            }
            return string;
        }

        private String toKeyString(int n, int n2, int n3) {
            String string = RJMdGroupURLDEV.this.toHexString(n, 2) + ":" + RJMdGroupURLDEV.this.toHexString(n2, 2) + ":" + RJMdGroupURLDEV.this.toHexString(n3, 2);
            return string;
        }

        public ArgHURLDEV getArgument() {
            RJiLDEVIndex[] rJiLDEVIndexArray = this.ldevList.toArray(new RJiLDEVIndex[0]);
            ArgHURLDEV argHURLDEV = new ArgHURLDEV(this.fromTime, this.toTime, (Robj_interface_RJiLDEVIndex[])rJiLDEVIndexArray);
            return argHURLDEV;
        }
    }
}

