/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public class JCNumberUtil {
    public static final double M_PI = Math.PI;
    public static final double M_PI_2 = 1.5707963267948966;
    public static final double M_2PI = Math.PI * 2;
    public static final double M_SQRT2 = 1.4142135623730951;
    public static final int DEGREES = 1;
    public static final int RADIANS = 2;
    public static final int GRADS = 3;
    public static final double DEFAULT_FLOAT = Double.MAX_VALUE;
    public static final double LOG_TEN_BASE_E = 2.302585092994;
    public static char DECIMAL = '\u0000';
    static final String[] tens_str = new String[]{"0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000", "0000000000", "00000000000", "000000000000"};
    static double[] tens_val = new double[]{1.0E-12, 1.0E-11, 1.0E-10, 1.0E-9, 1.0E-8, 1.0E-7, 1.0E-6, 1.0E-5, 1.0E-4, 0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12};
    public static final int XINSIDE = 1;
    public static final int XBYX1 = 2;
    public static final int XBYX2 = 3;
    public static final int YINSIDE = 10;
    public static final int YBYTOP = 11;
    public static final int YBYORIGIN = 12;
    private static final Color WHITE_BRIGHTER = new Color(200, 200, 200);
    private static final Color WHITE_DARKER = new Color(140, 140, 140);
    private static final Color BLACK_BRIGHTER = new Color(125, 125, 125);
    private static final Color BLACK_DARKER = new Color(75, 75, 75);
    private static final double FACTOR = 0.5;

    public static double abs(double d) {
        return d > 0.0 ? d : -d;
    }

    public static int abs(int n) {
        return n > 0 ? n : -n;
    }

    public static double boundAngle(int n, double d) {
        double d2;
        boolean bl = d < 0.0;
        switch (n) {
            case 1: {
                d2 = 360.0;
                break;
            }
            case 3: {
                d2 = 400.0;
                break;
            }
            default: {
                d2 = Math.PI * 2;
            }
        }
        double d3 = Math.IEEEremainder(Math.abs(d), d2);
        if (bl && d3 != 0.0) {
            d3 = d2 - d3;
        }
        return d3;
    }

    public static Color brighter(Color color) {
        if (color.equals(Color.white)) {
            return WHITE_BRIGHTER;
        }
        if (color.equals(Color.black)) {
            return BLACK_BRIGHTER;
        }
        int n = color.getRed();
        n += (int)((double)(255 - n) * 0.5);
        int n2 = color.getBlue();
        n2 += (int)((double)(255 - n2) * 0.5);
        int n3 = color.getGreen();
        n3 += (int)((double)(255 - n3) * 0.5);
        return new Color(Math.min(n, 255), Math.min(n3, 255), Math.min(n2, 255));
    }

    public static double calcError(int n) {
        return 0.5 * JCNumberUtil.pow10(-n - 1);
    }

    public static double clamp(double d, double d2, double d3) {
        return d > d3 ? d3 : (d < d2 ? d2 : d);
    }

    public static int clamp(int n, int n2, int n3) {
        return n > n3 ? n3 : (n < n2 ? n2 : n);
    }

    public static long clamp(long l, long l2, long l3) {
        return l > l3 ? l3 : (l < l2 ? l2 : l);
    }

    public static boolean colorsNear(Color color, Color color2) {
        if (color == null || color2 == null) {
            return false;
        }
        return Math.abs(color.getRed() - color2.getRed()) <= 15 && Math.abs(color.getGreen() - color2.getGreen()) <= 15 && Math.abs(color.getBlue() - color2.getBlue()) <= 15;
    }

    public static double convertAngle(int n, int n2, double d) {
        double d2;
        block0 : switch (n2) {
            case 1: {
                switch (n) {
                    case 2: {
                        d2 = d * 180.0 / Math.PI;
                        break block0;
                    }
                    case 3: {
                        d2 = d * 0.9;
                        break block0;
                    }
                }
                d2 = d;
                break;
            }
            case 3: {
                switch (n) {
                    case 2: {
                        d2 = d * 200.0 / Math.PI;
                        break block0;
                    }
                    case 1: {
                        d2 = d / 0.9;
                        break block0;
                    }
                }
                d2 = d;
                break;
            }
            default: {
                switch (n) {
                    case 1: {
                        d2 = d * Math.PI / 180.0;
                        break block0;
                    }
                    case 3: {
                        d2 = d * Math.PI / 200.0;
                        break block0;
                    }
                }
                d2 = d;
                break;
            }
        }
        return d2;
    }

    public static String convertFromSN(String string) {
        StringBuffer stringBuffer;
        block15: {
            String string2;
            int n;
            block14: {
                int n2 = string.indexOf(101);
                if (n2 < 0) {
                    n2 = string.indexOf(69);
                }
                if (n2 < 0) {
                    return string;
                }
                n = 0;
                if (n2 + 1 < string.length()) {
                    string2 = string.substring(n2 + 1);
                    n = string2.charAt(0) == '+' ? (string2.length() <= 1 ? 0 : Integer.valueOf(string2.substring(1))) : Integer.valueOf(string2);
                }
                string2 = string.substring(0, n2);
                if (n == 0) {
                    return string2;
                }
                stringBuffer = new StringBuffer();
                char c = string2.charAt(0);
                switch (c) {
                    case '-': {
                        stringBuffer.append('-');
                    }
                    case '+': {
                        string2 = string2.substring(1);
                    }
                }
                if (n >= 0) break block14;
                stringBuffer.append("0.");
                int n3 = -1;
                while (n3 > n) {
                    stringBuffer.append('0');
                    --n3;
                }
                stringBuffer.append(string2.charAt(0));
                int n4 = 2;
                while (n4 < string2.length()) {
                    stringBuffer.append(string2.charAt(n4));
                    ++n4;
                }
                break block15;
            }
            stringBuffer.append(string2.charAt(0));
            int n5 = 0;
            while (n5 < n) {
                if (n5 + 2 < string2.length()) {
                    stringBuffer.append(string2.charAt(2 + n5));
                } else {
                    stringBuffer.append('0');
                }
                ++n5;
            }
            if (n5 + 2 >= string2.length()) break block15;
            stringBuffer.append(JCNumberUtil.getDecimalPointChar());
            while (n5 + 2 < string2.length()) {
                stringBuffer.append(string2.charAt(2 + n5));
                ++n5;
            }
        }
        return new String(stringBuffer);
    }

    public static int countInString(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string2.indexOf(string, n2)) >= 0) {
            ++n;
            n2 = n3 + 1;
        }
        return n;
    }

    public static Color darker(Color color) {
        if (color.equals(Color.white)) {
            return WHITE_DARKER;
        }
        if (color.equals(Color.black)) {
            return BLACK_DARKER;
        }
        return color.darker();
    }

    public static final double degToRad(double d) {
        return d * (Math.PI / 180);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static long distTrap(int n, int n2, int n3, double d, double d2, double d3, double d4) {
        long l = d == d2 ? 32000L : (long)(d3 + ((double)n - d) * ((d3 - d4) / (d - d2)));
        long l2 = d <= (double)n && (double)n <= d2 || d2 <= (double)n && (double)n <= d ? 1L : ((double)n <= d && d <= d2 || (double)n >= d && d >= d2 ? 2L : 3L);
        long l3 = l <= (long)n2 && n2 <= n3 || n3 <= n2 && (long)n2 <= l ? 10L : (l <= (long)n3 && n3 <= n2 || n2 <= n3 && (long)n3 <= l ? 12L : 11L);
        double d5 = 0.0;
        switch ((int)l3) {
            case 10: {
                switch ((int)l2) {
                    case 1: {
                        return 0L;
                    }
                    case 2: {
                        if (n3 <= n2 && (double)n2 <= d3 || d3 <= (double)n2 && n2 <= n3) {
                            d5 = Math.abs(n - (int)d);
                            return (long)d5;
                        }
                        d5 = ((double)n2 - d3) * ((double)n2 - d3) + ((double)n - d) * ((double)n - d);
                        d5 = Math.sqrt(d5);
                        return (long)d5;
                    }
                    case 3: {
                        if (n3 <= n2 && (double)n2 <= d4 || d4 <= (double)n2 && n2 <= n3) {
                            d5 = Math.abs(n - (int)d2);
                            return (long)d5;
                        }
                        d5 = ((double)n2 - d4) * ((double)n2 - d4) + ((double)n - d2) * ((double)n - d2);
                        d5 = Math.sqrt(d5);
                        return (long)d5;
                    }
                }
                return (long)d5;
            }
            case 11: {
                switch ((int)l2) {
                    case 1: {
                        d5 = Math.abs(n2 - (int)l);
                        return (long)d5;
                    }
                    case 2: {
                        d5 = ((double)n2 - d3) * ((double)n2 - d3) + ((double)n - d) * ((double)n - d);
                        d5 = (long)Math.sqrt(d5);
                        return (long)d5;
                    }
                    case 3: {
                        d5 = ((double)n2 - d4) * ((double)n2 - d4) + ((double)n - d2) * ((double)n - d2);
                        d5 = (long)Math.sqrt(d5);
                        return (long)d5;
                    }
                }
                return (long)d5;
            }
            case 12: {
                switch ((int)l2) {
                    case 1: {
                        d5 = Math.abs(n2 - n3);
                        return (long)d5;
                    }
                    case 2: {
                        d5 = (double)((n2 - n3) * (n2 - n3)) + ((double)n - d) * ((double)n - d);
                        d5 = (long)Math.sqrt(d5);
                        return (long)d5;
                    }
                    case 3: {
                        d5 = (double)((n2 - n3) * (n2 - n3)) + ((double)n - d2) * ((double)n - d2);
                        d5 = (long)Math.sqrt(d5);
                        return (long)d5;
                    }
                }
                return (long)d5;
            }
        }
        return (long)d5;
    }

    public static int distance(int n, int n2, int n3) {
        if (n < n2) {
            return n2 - n;
        }
        if (n > n2 + n3) {
            return n - (n2 + n3);
        }
        return 0;
    }

    public static int distance(int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        return (int)Math.sqrt(n5 * n5 + n6 * n6);
    }

    public static int distance(int n, int n2, Rectangle rectangle) {
        int n3;
        int n4 = JCNumberUtil.distance(n, rectangle.x, rectangle.width);
        int n5 = n4 * n4 + (n3 = JCNumberUtil.distance(n2, rectangle.y, rectangle.height)) * n3;
        if (n5 <= 0) {
            return 0;
        }
        return (int)Math.sqrt(n5);
    }

    private static int findDecimal(String string) {
        if (string == null) {
            return -1;
        }
        return string.indexOf(JCNumberUtil.getDecimalPointChar());
    }

    public static String format(double d, int n) {
        String string = null;
        Object var4_3 = null;
        double d2 = JCNumberUtil.precCorrect(n, d);
        string = String.valueOf(d2);
        if (string.indexOf(101) != -1 || string.indexOf(69) != -1) {
            return string;
        }
        int n2 = JCNumberUtil.findDecimal(string);
        if (n > 0) {
            if (n2 < 0) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.append(JCNumberUtil.getDecimalPointChar());
                int n3 = 0;
                while (n3 < n) {
                    stringBuffer.append('0');
                    ++n3;
                }
                string = new String(stringBuffer);
            } else {
                int n4 = string.length() - n2 - 1;
                int n5 = n4 - n;
                if (n5 < 0) {
                    StringBuffer stringBuffer = new StringBuffer(string);
                    int n6 = 0;
                    while (n6 > n5) {
                        stringBuffer.append('0');
                        --n6;
                    }
                    string = new String(stringBuffer);
                } else if (n5 > 0) {
                    string = string.substring(0, string.length() - n5);
                }
            }
        } else if (n < 0) {
            int n7 = n2 < 0 ? string.length() : n2;
            int n8 = n7 + n;
            if (n8 >= 0) {
                StringBuffer stringBuffer = new StringBuffer(string.substring(0, n8));
                int n9 = 0;
                while (n9 < n7 - n8) {
                    stringBuffer.append('0');
                    ++n9;
                }
                string = new String(stringBuffer);
            } else {
                string = new String("0");
            }
        } else if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        return string;
    }

    public static void fudgeItalicLabel(Font font, Dimension dimension) {
        int n = font.getStyle();
        if ((n | 2) > 0) {
            int n2 = font.getSize();
            dimension.width += Math.max(1, n2 / 6);
        }
    }

    public static char getDecimalPointChar() {
        if (DECIMAL != '\u0000') {
            return DECIMAL;
        }
        DECIMAL = new Double(5.5).toString().charAt(1);
        return DECIMAL;
    }

    public static int iceil(double d) {
        int n = 0;
        n = d < 0.0 ? -JCNumberUtil.ifloor(-d) : (int)Math.ceil(d);
        return n;
    }

    public static int ifloor(double d) {
        int n = 0;
        if (d == Double.NEGATIVE_INFINITY) {
            return n;
        }
        n = d < 0.0 ? -JCNumberUtil.iceil(-d) : (int)d;
        return n;
    }

    public static int intLog10(double d) {
        return (int)JCNumberUtil.precCorrect(1, JCNumberUtil.log10(d));
    }

    public static String internalFormat(double d, int n) {
        String string = JCNumberUtil.format(d, n);
        if (string.indexOf(101) != -1 || string.indexOf(69) != -1) {
            string = JCNumberUtil.convertFromSN(string);
        }
        return string;
    }

    public static boolean isHTML(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("<html>");
    }

    public static int locateX(double d, double d2, double d3) {
        int n = (d > d3 ? 1 : 0) << 1;
        int n2 = d < d2 ? 1 : 0;
        return n | n2;
    }

    public static int locateXY(double d, double d2, double d3, double d4, double d5, double d6) {
        return JCNumberUtil.locateY(d2, d5, d6) | JCNumberUtil.locateX(d, d3, d4);
    }

    public static int locateY(double d, double d2, double d3) {
        int n = (d > d3 ? 1 : 0) << 3;
        int n2 = (d < d2 ? 1 : 0) << 2;
        return n | n2;
    }

    public static double log10(double d) {
        double d2 = Math.log(d);
        return d2 / 2.302585092994;
    }

    public static String logFormat(int n) {
        double d = JCNumberUtil.pow10(n);
        return JCNumberUtil.format(d, -n);
    }

    public static double max(double d, double d2) {
        return d > d2 ? d : d2;
    }

    public static double min(double d, double d2) {
        return d < d2 ? d : d2;
    }

    public static int nicePrecision(double d) {
        if (d <= 0.0) {
            return 0;
        }
        int n = (int)Math.floor(JCNumberUtil.log10(d));
        double d2 = d / JCNumberUtil.pow10(n);
        boolean bl = d2 < 3.0;
        return (int)(-Math.floor(JCNumberUtil.log10(d)) + (double)bl);
    }

    public static Polygon pointsToPolygon(Point[] pointArray) {
        Polygon polygon = new Polygon();
        int n = 0;
        while (n < pointArray.length) {
            if (n == 0) {
                polygon.addPoint(pointArray[n].x, pointArray[n].y);
            } else {
                polygon.addPoint(polygon.xpoints[n - 1] + pointArray[n].x, polygon.ypoints[n - 1] + pointArray[n].y);
            }
            ++n;
        }
        return polygon;
    }

    public static double pow10(int n) {
        int n2 = 12 + n;
        if (n2 >= 0 && n2 < tens_val.length) {
            return tens_val[n2];
        }
        return Math.pow(10.0, n);
    }

    public static double precCeil(int n, double d) {
        double d2 = d;
        if (d2 < 0.0) {
            d2 = -JCNumberUtil.precFloor(n, -d2);
        } else if (n >= 0) {
            int n2;
            char[] cArray = JCNumberUtil.internalFormat(d2, n + 1).toCharArray();
            if (cArray[n2 = cArray.length - 1] != '0') {
                cArray[n2] = 48;
                --n2;
                while (n2 >= 0) {
                    if (cArray[n2] != JCNumberUtil.getDecimalPointChar()) {
                        if (cArray[n2] != '9') {
                            int n3 = n2;
                            cArray[n3] = (char)(cArray[n3] + '\u0001');
                            break;
                        }
                        cArray[n2] = 48;
                    }
                    --n2;
                }
                if (n2 < 0) {
                    char[] cArray2 = cArray;
                    cArray = new char[cArray2.length + 1];
                    n2 = cArray2.length;
                    while (n2 > 0) {
                        cArray[n2] = cArray2[n2 - 1];
                        --n2;
                    }
                    cArray[0] = 49;
                }
            }
            double d3 = d2;
            d2 = Double.valueOf(new String(cArray));
            if (d2 < d3) {
                d2 += JCNumberUtil.pow10(-n);
            }
        } else {
            double d4 = JCNumberUtil.pow10(-n);
            d2 = d4 * Math.ceil(d2 / d4);
        }
        return d2;
    }

    public static double precCorrect(int n, double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (n >= 0) {
            double d2 = JCNumberUtil.pow10(n);
            return Math.floor(d * d2 + 0.5) / d2;
        }
        double d3 = JCNumberUtil.pow10(-n);
        return Math.floor(d / d3 + 0.5) * d3;
    }

    public static double precFloor(int n, double d) {
        double d2 = d;
        if (d2 < 0.0) {
            d2 = -JCNumberUtil.precCeil(n, -d2);
        } else if (n >= 0) {
            String string = JCNumberUtil.internalFormat(d2, n + 1);
            int n2 = string.length();
            if (n2 >= 1) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.setCharAt(n2 - 1, '0');
                string = new String(stringBuffer);
            }
            double d3 = d2;
            d2 = Double.valueOf(string);
            if (d2 > d3) {
                d2 -= JCNumberUtil.pow10(-n);
            }
        } else {
            double d4 = JCNumberUtil.pow10(-n);
            d2 = d4 * Math.floor(d2 / d4);
        }
        return d2;
    }

    public static final double radToDeg(double d) {
        return d * 57.29577951308232;
    }

    public static int tickBasedPrecision(double d) {
        int n;
        int n2;
        if (d <= 0.0) {
            return 0;
        }
        String string = new Double(d).toString();
        int n3 = string.indexOf(46);
        if (n3 >= 0) {
            n2 = string.length() - n3 - 1;
            n = string.length() - 1;
            while (n > n3) {
                if (string.charAt(n) == '0') {
                    --n2;
                } else {
                    n = n3;
                }
                --n;
            }
            if (n2 > 0) {
                return n2;
            }
        } else {
            n3 = string.length();
        }
        n2 = 0;
        n = n3 - 1;
        while (n >= 0) {
            if (string.charAt(n) == '0') {
                ++n2;
            } else {
                n = -1;
            }
            --n;
        }
        return -n2;
    }

    public static void trace() {
        try {
            throw new ArrayIndexOutOfBoundsException("");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return;
        }
    }

    public static boolean validUnit(int n) {
        return n == 1 || n == 2 || n == 3;
    }
}

