/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing.encode;

import com.klg.jclass.util.JCLocaleManager;
import com.klg.jclass.util.swing.JCMessageHelper;
import com.klg.jclass.util.swing.encode.Encoder;
import com.klg.jclass.util.swing.encode.EncoderException;
import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class JCEncodeComponent {
    public static final Encoding GIF = new Encoding("GIF", "CompuServe Graphic Interchange File", "com.klg.jclass.util.swing.encode.GIFEncoder", "ENCODE_NEEDS_GIFLICENSE");
    public static final Encoding PNG = new Encoding("PNG", "Portable Network Graphics", "com.klg.jclass.util.swing.encode.PNGEncoder", "ENCODER_LOAD_ERROR");
    public static final Encoding JPEG = new Encoding("JPEG", "Joint Photographic Experts Group", "com.klg.jclass.util.swing.encode.JPEGEncoder", "ENCODER_LOAD_ERROR");
    public static final Encoding EPS = new Encoding("EPS", "Encapsulated PostScript", "com.klg.jclass.util.swing.encode.page.EPSEncoder", "ENCODE_NEEDS_JCLASSPAGELAYOUT");
    public static final Encoding PCL = new Encoding("PCL", "HP Page Control Language Version 5", "com.klg.jclass.util.swing.encode.page.PCLEncoder", "ENCODE_NEEDS_JCLASSPAGELAYOUT");
    public static final Encoding PDF = new Encoding("PDF", "Adobe Acrobat Portable Document File", "com.klg.jclass.util.swing.encode.page.PDFEncoder", "ENCODE_NEEDS_JCLASSPAGELAYOUT");
    public static final Encoding PS = new Encoding("PS", "Adobe PostScript Level 2", "com.klg.jclass.util.swing.encode.page.PSEncoder", "ENCODE_NEEDS_JCLASSPAGELAYOUT");
    public static final Encoding[] ENCODINGS = new Encoding[]{PNG, GIF, JPEG, EPS, PCL, PDF, PS};

    public static void encode(Encoding encoding, Component component, File file) throws IOException, EncoderException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        JCEncodeComponent.encode(encoding, component, (OutputStream)fileOutputStream);
        ((OutputStream)fileOutputStream).close();
    }

    public static void encode(Encoding encoding, Component component, OutputStream outputStream) throws IOException, EncoderException {
        Encoder encoder = JCEncodeComponent.findEncoder(encoding, component.isShowing());
        if (encoder != null) {
            encoder.encode(component, outputStream);
        }
    }

    public static void encode(Encoding encoding, Image image, File file) throws IOException, EncoderException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        JCEncodeComponent.encode(encoding, image, (OutputStream)fileOutputStream);
        ((OutputStream)fileOutputStream).close();
    }

    public static void encode(Encoding encoding, Image image, OutputStream outputStream) throws IOException, EncoderException {
        Encoder encoder = JCEncodeComponent.findEncoder(encoding, false);
        if (encoder != null) {
            encoder.encode(image, outputStream);
        }
    }

    public static Encoder findEncoder(Encoding encoding, boolean bl) throws IOException, EncoderException {
        Encoder encoder = encoding.getEncoder();
        if (encoder == null) {
            JCLocaleManager.getDefault().add("com.klg.jclass.util.swing.encode.resources.LocaleInfo");
            String string = JCLocaleManager.getDefault().getString("ENCODE_DIALOG_TITLE");
            if (string == null) {
                string = "ENCODE_DIALOG_TITLE";
            }
            if (bl) {
                JCMessageHelper.showError(string, encoding.getFailureMessage());
            }
            throw new EncoderException(encoding.getFailureMessage());
        }
        return encoder;
    }

    public static class Encoding {
        private String shortName;
        private String longName;
        private String encoderClass;
        private String failureMessage;
        private Encoder encoder;

        public Encoding(String string, String string2, String string3, String string4) {
            this.shortName = string;
            this.longName = string2;
            this.encoderClass = string3;
            this.failureMessage = string4;
        }

        public Encoder getEncoder() {
            block6: {
                if (this.encoder != null) break block6;
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(this.encoderClass);
                }
                catch (ClassNotFoundException classNotFoundException) {}
                if (clazz != null) {
                    try {
                        this.encoder = (Encoder)clazz.newInstance();
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
            }
            return this.encoder;
        }

        public String getFailureMessage() {
            JCLocaleManager.getDefault().add("com.klg.jclass.util.swing.encode.resources.LocaleInfo");
            String string = JCLocaleManager.getDefault().getString(this.failureMessage);
            if (string == null) {
                string = this.failureMessage;
            }
            return string;
        }

        public String getLongName() {
            return this.longName;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String toString() {
            return String.valueOf(this.getLongName()) + " (" + this.getShortName() + ")";
        }
    }
}

