/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver;

import com.ws.utilities.PropertiesWithComments;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;

public class JServerProperties {
    private static final String INTEROP_NAMESPACE = "interop";
    private static PropertiesWithComments mProperties = new PropertiesWithComments();
    private static final String REPOSITORY = "rlog";
    private static final String SCHEMANAME_DEFAULT = "WS";
    private static final String mFileName = "jserver.properties";

    public static String getAdvertisedIPAddress(String protocolName, String protocolIFType, String defaultIP) {
        String ret = defaultIP;
        if (null != protocolName && null != protocolIFType) {
            String key = "com.ws.jserver." + protocolName.toLowerCase() + "." + protocolIFType.toLowerCase() + ".advertisedip";
            ret = mProperties.getProperty(key, defaultIP);
        }
        return ret;
    }

    public static String getAdvertisedPort(String protocolName, String protocolIFType, String defaultPort) {
        String ret = defaultPort;
        if (null != protocolName && null != protocolIFType) {
            String key = "com.ws.jserver." + protocolName.toLowerCase() + "." + protocolIFType.toLowerCase() + ".advertisedport";
            ret = mProperties.getProperty(key, defaultPort);
        }
        return ret;
    }

    public static String getAdvertisedScheme(String protocolName, String protocolIFType, String defaultScheme) {
        String ret = defaultScheme;
        if (null != protocolName && null != protocolIFType) {
            String key = "com.ws.jserver." + protocolName.toLowerCase() + "." + protocolIFType.toLowerCase() + ".advertisedscheme";
            ret = mProperties.getProperty(key, defaultScheme);
        }
        return ret;
    }

    public static String getBasedir() {
        return mProperties.getProperty("com.ws.jserver.basedir");
    }

    public static String getIndicationBackupDir() {
        return mProperties.getProperty("com.ws.jserver.IndicationsBackupDir");
    }

    public static String getBindIP() {
        String ret = mProperties.getProperty("com.ws.jserver.bindto");
        return ret != null && ret.length() == 0 ? null : ret;
    }

    public static String getClassPath() {
        return mProperties.getProperty("classpath");
    }

    public static String getHiddenNamespaces() {
        return mProperties.getProperty("com.ws.jserver.hidenamespaces");
    }

    public static String getInstallDate() {
        return mProperties.getProperty("com.ws.jserver.installdate");
    }

    public static String getInteropNamespace() {
        String ns = mProperties.getProperty("com.ws.jserver.interopnamespace");
        if (null == ns) {
            ns = INTEROP_NAMESPACE;
        }
        return ns;
    }

    public static String getMaxNumberRequestThreads() {
        return mProperties.getProperty("com.ws.jserver.requestthreads");
    }

    public static int getMaxObjectsPerNonPullRequest() {
        return JServerProperties.getMaxObjectsPerRequest("com.ws.jserver.nonpullmaxobjects");
    }

    public static int getMaxObjectsPerPullRequest() {
        return JServerProperties.getMaxObjectsPerRequest("com.ws.jserver.pullmaxobjects");
    }

    private static int getMaxObjectsPerRequest(String key) {
        int ret = Integer.parseInt(mProperties.getProperty(key, "5000"));
        if (ret < 100) {
            ret = 100;
        }
        return ret;
    }

    public static String getNumberProviderThreads() {
        return mProperties.getProperty("com.ws.jserver.providerthreads");
    }

    public static String getOMCAPropertiesFile() {
        return mProperties.getProperty("com.ws.jserver.CPAPortPropertiesFile");
    }

    public static String getPropertiesDirectory() {
        return mProperties.getProperty("com.ws.jserver.propdir");
    }

    public static String getProviderThreadFactory() {
        return mProperties.getProperty("com.ws.jserver.providerthreadfactory");
    }

    public static String getRepositoryAdapter() {
        return REPOSITORY;
    }

    public static String getRepositoryDirectory() {
        return mProperties.getProperty("com.ws.jserver.logdir");
    }

    public static String getSchemaName() {
        String schemaName = mProperties.getProperty("com.ws.jserver.schemaname");
        if (null == schemaName) {
            schemaName = SCHEMANAME_DEFAULT;
        }
        return schemaName;
    }

    public static String getSecurityPlugin() {
        return mProperties.getProperty("com.ws.jserver.security");
    }

    public static String getServerHost() {
        return mProperties.getProperty("com.ws.jserver.ServerHost");
    }

    public static List<String> getServices() {
        String str = mProperties.getProperty("com.ws.jserver.services");
        return Arrays.asList(str.split("\\s*,\\s*"));
    }

    public static String getSLPRefreshRate() {
        return mProperties.getProperty("com.ws.jserver.SLPRefreshValue");
    }

    public static String getThreadFactory() {
        return mProperties.getProperty("com.ws.jserver.threadfactory");
    }

    public static void load(String filename) throws IOException {
        mProperties.load((InputStream)new FileInputStream(filename));
    }

    public static void setBasedir(String dir) {
        mProperties.setProperty("com.ws.jserver.basedir", dir);
    }

    public static void setBindIP(String ip) {
        mProperties.setProperty("com.ws.jserver.bindto", ip);
    }

    public static void setClassPath(String classpath) {
        mProperties.setProperty("classpath", classpath);
    }

    public static void setHiddenNamespaces(String namespacelist) {
        mProperties.setProperty("com.ws.jserver.hidenamespaces", namespacelist);
    }

    public static void setInstallDate(String date) {
        mProperties.setProperty("com.ws.jserver.installdate", date);
    }

    public static void setMaxNumberRequestThreads(String num) {
        mProperties.setProperty("com.ws.jserver.requestthreads", num);
    }

    public static void setNumberOfProviderThreads(String num) {
        mProperties.setProperty("com.ws.jserver.providerthreads", num);
    }

    public static void setOMCAPropertiesFile(String path) {
        mProperties.setProperty("com.ws.jserver.CPAPortPropertiesFile", path);
    }

    public static void setPreferIPv4(boolean preference) {
        mProperties.setProperty("java.net.preferIPv4Stack", Boolean.toString(preference));
    }

    public static void setPropertiesdirectory(String dir) {
        mProperties.setProperty("com.ws.jserver.propdir", dir);
    }

    public static void setRespositoryDirectory(String dir) {
        mProperties.setProperty("com.ws.jserver.logdir", dir);
    }

    public static void setSchemaName(String name) {
        mProperties.setProperty("com.ws.jserver.schemaname", name);
    }

    public static void setSecurityPlugin(String name) {
        mProperties.setProperty("com.ws.jserver.security", name);
    }

    public static void setServerhost(String name) {
        mProperties.setProperty("com.ws.jserver.ServerHost", name);
    }

    public static void setServices(List<String> services) {
        StringBuilder b = new StringBuilder();
        int x = 0;
        for (String s : services) {
            if (x > 0) {
                b.append(", ");
            }
            b.append(s);
            ++x;
        }
        mProperties.setProperty("com.ws.jserver.services", b.toString());
    }

    public static void setSLPRefreshRate(String rate) {
        mProperties.setProperty("com.ws.jserver.SLPRefreshValue", rate);
    }

    public static void store(String filename) throws IOException {
        mProperties.store((OutputStream)new FileOutputStream(filename), "");
    }

    public JServerProperties(String basedir) throws IOException {
        JServerProperties.load(basedir + File.separator + "bin" + File.separator + mFileName);
        JServerProperties.setBasedir(basedir);
        for (String key : mProperties.stringPropertyNames()) {
            String value = mProperties.getProperty(key);
            Object[] argument = new Object[]{JServerProperties.getBasedir()};
            String newValue = MessageFormat.format(value, argument);
            mProperties.setProperty(key, newValue);
        }
    }

    public boolean getPreferIPv4() {
        return Boolean.parseBoolean(mProperties.getProperty("java.net.preferIPv4Stack"));
    }
}

