/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver;

import com.ws.wbem.jserver.WBEMServer;
import com.ws.wbem.jserver.embed.RequestHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

class ProtocolParsers {
    private static final String FILE_NAME = "com.ws.wbem.jserver.ProtocolParsers";
    private final Map<String, Parser> parserTypes = new HashMap<String, Parser>();

    public ProtocolParsers() {
        ResourceBundle props = ResourceBundle.getBundle(FILE_NAME);
        Enumeration<String> parserKeys = props.getKeys();
        while (parserKeys.hasMoreElements()) {
            String typeKey = parserKeys.nextElement();
            String clzName = props.getString(typeKey);
            try {
                Parser p = new Parser(typeKey, clzName);
                if (null == p) continue;
                this.parserTypes.put(typeKey, p);
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                Logger logger = Logger.getLogger("com.ws.wbem.jserver");
                logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    public Parser getParser(String name) {
        Parser p = this.parserTypes.get(name);
        return p;
    }

    public Parser[] getParsers() {
        Collection<Parser> parsers = this.parserTypes.values();
        Parser[] ret = parsers.toArray(new Parser[parsers.size()]);
        return ret;
    }

    public class Parser {
        private final String name;
        private final Constructor<? extends RequestHandler> ctor;

        public Parser(String name, String clzName) throws ClassNotFoundException, NoSuchMethodException, SecurityException {
            this.name = name;
            Class<?> clz = Class.forName(clzName);
            this.ctor = clz.getDeclaredConstructor(WBEMServer.class);
        }

        public String getName() {
            return this.name;
        }

        public RequestHandler getRequestHandler(WBEMServer srvrHandle) throws Exception {
            try {
                return this.ctor.newInstance(srvrHandle);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new Exception("Exception invoking CTOR for " + this.name, e);
            }
        }
    }
}

