/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.profiles.dmtf.wbemserver;

import com.ws.utilities.ShutdownThread;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.profiles.common.BaseSingletonInstanceProvider;
import com.ws.wbem.jserver.profiles.common.CommonProviderUtils;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTimeInterval;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.provider.ProviderHandle;

public class WBEMServerProvider
extends BaseSingletonInstanceProvider {
    private static final String CPV_ELEMENTNAME = JServerProperties.getSchemaName() + " J WBEM Server";
    private static final String CPV_PRIMARYOWNERCONTACT = "http://ws-inc.com/";
    static final int REQUESTEDSTATED_SHUTDOWN = 4;

    @Override
    public Object invokeMethod(CIMObjectPath target, String methodName, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        UnsignedInteger32 ret = null;
        if ("CreateWBEMServerNamespace".equalsIgnoreCase(methodName)) {
            ret = this.createNamespace(target, inArgs, outArgs);
        } else if ("RequestStateChange".equals(methodName)) {
            Object[] objs;
            UnsignedInteger16 requestedState = null;
            CIMDateTimeInterval timeoutPeriod = null;
            for (CIMArgument<?> inArg : inArgs) {
                if ("RequestedState".equals(inArg.getName())) {
                    requestedState = (UnsignedInteger16)inArg.getValue();
                    continue;
                }
                if (!"TimeoutPeriod".equals(inArg.getName())) continue;
                timeoutPeriod = (CIMDateTimeInterval)inArg.getValue();
            }
            if (null != timeoutPeriod && timeoutPeriod.getTotalMilliseconds() > 0L) {
                objs = new Object[]{methodName};
                mLogger.log(Level.WARNING, "{0}: The TimeoutPeriod argument is not supported", objs);
                ret = new UnsignedInteger32(4098L);
            } else if (null == requestedState) {
                objs = new Object[]{methodName};
                mLogger.log(Level.WARNING, "{0}: The RequestedState argument was null.", objs);
                ret = new UnsignedInteger32(5L);
            } else if (4 == requestedState.intValue()) {
                mLogger.info("Calling WBEMServer shutdown");
                new ShutdownThread().start();
                ret = new UnsignedInteger32(0L);
            } else {
                objs = new Object[]{methodName, requestedState};
                mLogger.log(Level.WARNING, "{0}: The RequestedState argument value ({1}) was invalid", objs);
                ret = new UnsignedInteger32(5L);
            }
        } else {
            throw WBEMOperationErrors.getMethodNotSupportedException((CIMObjectPath)target, (String)methodName, (WBEMOperation)WBEMOperation.INVOKEMETHOD);
        }
        return ret;
    }

    @Override
    public void initialize(ProviderHandle ch) throws WBEMException {
        super.initialize(ch);
        this.mClassName = JServerSettings.replaceSchemaClassName("WS_WBEMServer");
    }

    private UnsignedInteger32 createNamespace(CIMObjectPath target, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) {
        UnsignedInteger32 ret = new UnsignedInteger32(1L);
        CIMInstance nsTemplate = null;
        try {
            if (null != inArgs && inArgs.length == 1 && "NamespaceTemplate".equalsIgnoreCase(inArgs[0].getName())) {
                nsTemplate = (CIMInstance)inArgs[0].getValue();
            }
        }
        catch (Exception e) {
            mLogger.log(Level.WARNING, "WBEMServer.CreateWBEMServerNamespace could not retrieve the input argeuments", e);
        }
        if (null != nsTemplate) {
            String namespaceName = (String)nsTemplate.getPropertyValue("Name");
            if (null != namespaceName) {
                try {
                    mInternalProvider.createNamespace(namespaceName);
                    CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)(JServerProperties.getSchemaName() + ":" + namespaceName), true)};
                    CIMObjectPath nsOP = new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), JServerProperties.getInteropNamespace(), "WS_WBEMServerNamespace", keyProps);
                    CIMProperty[] props = new CIMProperty[]{keyProps[0], nsTemplate.getProperty("Name"), nsTemplate.getProperty("SchemaInformation"), nsTemplate.getProperty("Caption"), nsTemplate.getProperty("Description"), nsTemplate.getProperty("ElementName")};
                    try {
                        nsOP = mInternalProvider.createInstance(new CIMInstance(nsOP, props));
                    }
                    catch (WBEMException e) {
                        if (5 == e.getID()) {
                            // empty if block
                        }
                    }
                    outArgs[0] = new CIMArgument("Namespace", new CIMDataType("CIM_WBEMServerNamespace"), (Object)nsOP);
                    ret = new UnsignedInteger32(0L);
                }
                catch (WBEMException e) {
                    if (11 == e.getID()) {
                        mLogger.log(Level.WARNING, "WBEMServer.CreateWBEMServerNamespace already exists", e);
                    }
                    mLogger.log(Level.WARNING, "WBEMServer.CreateWBEMServerNamespace received exception trying to create the namespace!", e);
                }
            } else {
                mLogger.log(Level.WARNING, "WBEMServer.CreateWBEMServerNamespace name is null!");
            }
        }
        return ret;
    }

    private CIMProperty<?>[] getKeyPropertyArray() {
        String nameValue = CommonProviderUtils.getWBEMServerName();
        CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty("Name", CIMDataType.STRING_T, (Object)nameValue, true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)JServerSettings.replaceSchemaClassName("WS_WBEMServerSystem"), true), new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)this.mClassName, true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)this.getHostName(), true)};
        return keyProps;
    }

    private CIMObjectPath generateObjectPath(CIMObjectPath target) {
        return new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), JServerProperties.getInteropNamespace(), this.mClassName, this.getKeyPropertyArray());
    }

    @Override
    protected CIMInstance generateInstance(CIMObjectPath target) {
        CIMProperty<?>[] keyProps = this.getKeyPropertyArray();
        UnsignedInteger16[] ops = new UnsignedInteger16[]{new UnsignedInteger16(2)};
        CIMProperty[] props = new CIMProperty[]{keyProps[0], keyProps[1], keyProps[2], keyProps[3], new CIMProperty("Description", CIMDataType.STRING_T, (Object)CPV_ELEMENTNAME, false), new CIMProperty("PrimaryOwnerName", CIMDataType.STRING_T, (Object)JServerProperties.getSchemaName(), false), new CIMProperty("PrimaryOwnerContact", CIMDataType.STRING_T, (Object)CPV_PRIMARYOWNERCONTACT, false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(2), false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)ops, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)CPV_ELEMENTNAME, false)};
        return new CIMInstance(this.generateObjectPath(target), props);
    }
}

