/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.services;

import com.ws.utilities.CipherUtilities;
import com.ws.wbem.client.adapter.common.TLSInfo;
import com.ws.wbem.jserver.ClientProtocolAdapter;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.embed.EndPoint;
import com.ws.wbem.jserver.profiles.common.EnabledDefault;
import com.ws.wbem.jserver.profiles.common.ProtocolIFType;
import com.ws.wbem.jserver.profiles.common.WSBaseProvider;
import com.ws.wbem.jserver.profiles.dmtf.wbemserver.ProtocolServiceProvider;
import com.ws.wbem.jserver.profiles.dmtf.wbemserver.TCPProtocolEndpointProvider;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.logging.Level;
import javax.cim.CIMClass;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;

public class JServerEndpointHTTP
extends WSBaseProvider
implements EndPoint {
    private InetAddress mBoundedAddress;
    private boolean mDefaultEnabled;
    private final String mName;
    private final int mPort;
    private final String mProtocol;
    private final ProtocolIFType mProtocolIFType;
    private final ClientProtocolAdapter mAdapter;

    public JServerEndpointHTTP(ClientProtocolAdapter adapter, String name, int port, ProtocolIFType protocolIFType, String protocolName, InetAddress boundedAddress, boolean enabledDefault, ProviderHandle handle) throws WBEMException {
        this.mAdapter = adapter;
        this.mName = name;
        this.mPort = port;
        this.mProtocolIFType = protocolIFType;
        this.mProtocol = protocolName;
        this.mBoundedAddress = boundedAddress;
        this.mDefaultEnabled = enabledDefault;
    }

    public InetAddress getBoundToAddress() {
        return this.mBoundedAddress;
    }

    public boolean getEnabledDefault() {
        return this.mDefaultEnabled;
    }

    public String getName() {
        return this.mName;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getScheme() {
        return this.mProtocolIFType.getName();
    }

    private TLSInfo getTLSInfo() {
        TLSInfo tlsInfo;
        block8: {
            tlsInfo = null;
            try {
                String truststore;
                CIMObjectPath opSettingData;
                CloseableIterator iterSettingData;
                CIMObjectPath op = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), "", null);
                CIMObjectPath opProtocolService = ProtocolServiceProvider.generateProtocolServiceObjectPath(op, this.mProtocol);
                CloseableIterator iter = mHandle.associatorClasses(opProtocolService, "CIM_ElementSettingData", JServerSettings.replaceSchemaClassName("WS_ProtocolServiceSettingData"), "ManagedElement", "SettingData", false);
                if (!iter.hasNext() || !(iterSettingData = mHandle.enumerateInstances(opSettingData = new CIMObjectPath(null, null, null, opProtocolService.getNamespace(), ((CIMClass)iter.next()).getName(), null), null)).hasNext()) break block8;
                CIMInstance instSettingData = (CIMInstance)iterSettingData.next();
                String[] enabledCipherSuites = (String[])instSettingData.getPropertyValue("EnabledCipherSuites");
                String invalidCiphers = CipherUtilities.validateCiphers((String[])enabledCipherSuites);
                if (null != invalidCiphers) {
                    mLogger.log(Level.SEVERE, "the SettingData instance, {0}, contains the following invalid ciphers: {1}", new Object[]{instSettingData.getObjectPath(), invalidCiphers});
                    break block8;
                }
                String basedir = JServerProperties.getBasedir();
                Boolean tempVal = (Boolean)instSettingData.getPropertyValue("MutualAuthenticationRequired");
                boolean authReq = null != tempVal ? tempVal : false;
                tempVal = (Boolean)instSettingData.getPropertyValue("ValidateCertHostName");
                boolean validateCertHostname = null != tempVal ? tempVal : false;
                tempVal = null;
                String keystore = (String)instSettingData.getPropertyValue("KeyStoreFile");
                if (null != keystore) {
                    keystore = MessageFormat.format(keystore, basedir);
                }
                if (null != (truststore = (String)instSettingData.getPropertyValue("TrustStoreFile"))) {
                    truststore = MessageFormat.format(truststore, basedir);
                }
                String encryptedPassword = (String)instSettingData.getPropertyValue("KeyStorePassword");
                String decryptedPassword = null;
                try {
                    decryptedPassword = TLSInfo.decryptPassword((String)encryptedPassword);
                }
                catch (Exception e) {
                    mLogger.log(Level.WARNING, "Could not decrypt keystore password in SettingData instance {0}", new Object[]{opSettingData});
                }
                if (null != decryptedPassword) {
                    tlsInfo = new TLSInfo(authReq, validateCertHostname, keystore, decryptedPassword, truststore, enabledCipherSuites);
                }
            }
            catch (WBEMException we) {
                Object[] objs = new Object[]{this.mProtocol, we.getMessage()};
                mLogger.log(Level.SEVERE, "Caught error trying to get TLSInfo for protocol {0}: {1}", objs);
            }
        }
        return tlsInfo;
    }

    public void resetEndpoint(int port, InetAddress boundedAddress) throws WBEMException {
        this.stopEndpoint();
        this.mBoundedAddress = boundedAddress;
        this.startEndpoint();
    }

    public void setEnabledDefault(boolean enabled) throws WBEMException {
        EnabledDefault oldEnabledDefault;
        EnabledDefault newEnabledDefault = EnabledDefault.getEnabledDefault(enabled);
        CIMObjectPath op = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), "", null);
        CIMObjectPath opProtocolEndpoint = TCPProtocolEndpointProvider.generateTCPProtocolEndpointObjectPath(op, this.mProtocol, this.mName);
        CIMInstance instProtocolEndpoint = mInternalProvider.getInstance(this.cleanSystemName(opProtocolEndpoint), null);
        UnsignedInteger16 cpvEnabledDefault = (UnsignedInteger16)instProtocolEndpoint.getPropertyValue("EnabledDefault");
        EnabledDefault enabledDefault = oldEnabledDefault = null != cpvEnabledDefault ? EnabledDefault.getEnabledDefault(cpvEnabledDefault.intValue()) : EnabledDefault.Disabled;
        if (null == oldEnabledDefault || newEnabledDefault != oldEnabledDefault) {
            CIMProperty[] newProps = new CIMProperty[]{new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(newEnabledDefault.getValue()))};
            instProtocolEndpoint = this.deriveInstance(instProtocolEndpoint, newProps);
            mInternalProvider.modifyInstance(instProtocolEndpoint, new String[]{"EnabledDefault"});
            this.mDefaultEnabled = enabled;
        }
    }

    public void startEndpoint() throws WBEMException {
        String boundedAddress = null != this.mBoundedAddress ? this.mBoundedAddress.getHostName() : null;
        TLSInfo tlsInfo = this.mProtocolIFType == ProtocolIFType.HTTPS ? this.getTLSInfo() : null;
        this.mAdapter.createListeningPort(this.mPort, boundedAddress, tlsInfo);
    }

    public void stopEndpoint() {
        this.mAdapter.deleteListeningPort(this.mPort);
    }

    private void writePortValue(int portValue, ProtocolIFType protocolIFType) {
        String propFile = JServerProperties.getOMCAPropertiesFile();
        if (propFile != null) {
            String protocolPortString = protocolIFType.toString().toLowerCase();
            try {
                FileOutputStream fos = new FileOutputStream(propFile, true);
                StringBuffer buff = new StringBuffer(protocolPortString + "=" + portValue + "\n");
                byte[] vb = null;
                try {
                    vb = buff.toString().getBytes("UTF-8");
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (vb == null || vb.length == 0) {
                    mLogger.warning("error writing port info to properties file for protocol:" + protocolPortString);
                } else {
                    fos.write(vb);
                    fos.close();
                }
            }
            catch (Exception e) {
                mLogger.warning("error writing port info to properties file for protocol:" + protocolPortString);
            }
        }
    }
}

