/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.soma;

import com.ws.wbem.jserver.AuthService;
import com.ws.wbem.jserver.AuthServiceType;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSettings;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.client.WBEMClient;
import javax.wbem.provider.ProviderHandle;

public abstract class ThirdPartyAuthentication
implements AuthService {
    private static final Logger mLogger = Logger.getLogger("com.ws.wbem.jserver");
    private static final String SERVICENAME = "J Server Secruity Service";
    protected WBEMClient mHandle;

    protected void authenticate(String user) throws WBEMException {
        String keyValue = JServerProperties.getSchemaName() + ":" + user;
        CIMProperty kp = new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)keyValue, true);
        CIMObjectPath cop = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), JServerSettings.replaceSchemaClassName("WS_Identity"), new CIMProperty[]{kp});
        CIMInstance ci = null;
        try {
            ci = this.mHandle.getInstance(cop, null);
        }
        catch (Exception e) {
            mLogger.log(Level.INFO, "J Server Secruity Service: Could not find CIM_Identity instance for user - rejecting.");
            throw WBEMOperationErrors.getAccessDeniedException();
        }
        if (!((Boolean)ci.getPropertyValue("CurrentlyAuthenticated")).booleanValue()) {
            CIMProperty[] props = new CIMProperty[]{new CIMProperty("CurrentlyAuthenticated", CIMDataType.BOOLEAN_T, (Object)Boolean.TRUE)};
            try {
                ci = ci.deriveInstance(props);
                this.mHandle.modifyInstance(ci, new String[]{"CurrentlyAuthenticated"});
            }
            catch (Exception e) {
                mLogger.log(Level.WARNING, "J Server Secruity Service: Could not change CurrentlyAuthenticated to true.", e);
            }
        }
        mLogger.info("J Server Secruity Service: user authenticated!");
    }

    @Override
    public void initialize(ProviderHandle providerClient) {
        this.mHandle = providerClient;
    }

    @Override
    public void close() {
    }

    @Override
    public AuthServiceType getType() {
        return AuthServiceType.THIRDPARTY;
    }
}

