/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.soma.pam;

import com.ws.wbem.jserver.soma.pam.WorkMod51;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperationErrors;

public class CIMOMLibrary {
    public static final String CIMOM_LIBRARY = "wbemsec";
    private static boolean library_loaded = false;
    private static Logger mLogger = Logger.getLogger("com.ws.wbem.jserver");

    public static boolean authenticateUser(String username, String password) throws WBEMException {
        if (username == null || username.trim().length() == 0 || password == null || password.trim().length() == 0) {
            return false;
        }
        return CIMOMLibrary.authenticateUserOrRole(username, password, null);
    }

    private static boolean authenticateUserOrRole(String userOrRole, String password, String roleUser) throws WBEMException {
        if (library_loaded) {
            if (password == null) {
                return false;
            }
            if (password.trim().length() == 0) {
                password = "";
            }
        } else {
            mLogger.log(Level.WARNING, "Cannot find user password provider library");
            throw WBEMOperationErrors.getAccessDeniedException();
        }
        boolean authenticated = false;
        try {
            authenticated = CIMOMLibrary.doAuthenticate(userOrRole, password, roleUser);
        }
        catch (Exception ex) {
            mLogger.log(Level.SEVERE, "Unexpected exception from native method doAuthenticate: ", ex);
        }
        if (!authenticated) {
            if (roleUser != null) {
                mLogger.warning("Failed to authenticate role " + userOrRole + " for user " + roleUser);
            } else {
                mLogger.warning("Failed to authenticate user " + userOrRole);
            }
        }
        return authenticated;
    }

    private static synchronized native boolean doAuthenticate(String var0, String var1, String var2) throws Exception;

    public static String getEncryptedPassword(String username, int usertype) throws WBEMException {
        String encrypted_password = null;
        if (library_loaded) {
            encrypted_password = CIMOMLibrary.getPassword(username, usertype);
            if (encrypted_password == null) {
                return null;
            }
            if (encrypted_password.trim().length() < 2) {
                return "";
            }
        } else {
            mLogger.log(Level.WARNING, "Cannot find user password provider library");
            throw WBEMOperationErrors.getAccessDeniedException();
        }
        byte[] sf = encrypted_password.getBytes();
        byte[] salt = new byte[]{sf[0], sf[1]};
        byte[] tf = new WorkMod51().mod51Format(new byte[20], salt);
        String tfs = new String(tf);
        if (tfs.equals(encrypted_password)) {
            return "";
        }
        return encrypted_password;
    }

    private static native String getPassword(String var0, int var1);

    static {
        try {
            System.loadLibrary(CIMOM_LIBRARY);
            library_loaded = true;
        }
        catch (SecurityException exception) {
            mLogger.log(Level.WARNING, "Unexpected SecurityException: ", exception);
        }
        catch (UnsatisfiedLinkError exception) {
            mLogger.log(Level.WARNING, "Unexpected UnsatisfiedLinkError: ", exception);
        }
    }
}

