/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.soma.windows;

import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSettings;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.provider.ProviderHandle;

public class WindowsAuthServiceUtilities {
    public static final String CIMOM_LIBRARY = "wbemsec";
    private static boolean library_loaded = false;
    private static String defaultDomain = ".";
    private static Logger mLogger = Logger.getLogger("com.ws.wbem.jserver");

    public static boolean authenticateUser(String username, String password, ProviderHandle pHandle) throws WBEMException {
        if (username == null || username.trim().length() == 0 || password == null || password.trim().length() == 0) {
            return false;
        }
        if (library_loaded) {
            if (password.trim().length() == 0) {
                password = "";
            }
        } else {
            mLogger.log(Level.WARNING, "Cannot find user password provider library");
            throw WBEMOperationErrors.getAccessDeniedException();
        }
        boolean authenticated = false;
        String[] domains = WindowsAuthServiceUtilities.getWindowsDomains(pHandle);
        for (int i = 0; i < domains.length; ++i) {
            String dmn = domains[i];
            try {
                mLogger.info("Try and authenticate using Windows domain " + dmn);
                authenticated = WindowsAuthServiceUtilities.doAuthenticate(username, password, dmn);
                if (!authenticated) continue;
                i = domains.length;
                continue;
            }
            catch (Exception ex) {
                mLogger.log(Level.WARNING, "Unexpected exception from native method doAuthenticate using Windows domain: " + dmn + " - ", ex);
            }
        }
        if (!authenticated) {
            mLogger.warning("CIMOMLibrary.authenticateUser : failed to authenticate user " + username);
        }
        return authenticated;
    }

    private static native boolean doAuthenticate(String var0, String var1, String var2) throws Exception;

    private static String[] getWindowsDomains(ProviderHandle pHandle) {
        ArrayList<String> dList = new ArrayList<String>();
        if (pHandle != null) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), JServerSettings.replaceSchemaClassName("WS_WindowsDomain"), null);
                CloseableIterator insts = pHandle.enumerateInstances(op, null);
                while (insts.hasNext()) {
                    CIMInstance ci = (CIMInstance)insts.next();
                    CIMProperty prop = ci.getProperty("name");
                    if (prop == null || prop.getValue() == null || prop.getValue() == null) continue;
                    dList.add((String)prop.getValue());
                }
            }
            catch (WBEMException e) {
                mLogger.log(Level.WARNING, "caught exception trying to retrieve list of Windows domains ", e);
            }
        }
        if (dList.size() == 0) {
            dList.add(defaultDomain);
        }
        return dList.toArray(new String[dList.size()]);
    }

    static {
        try {
            System.loadLibrary(CIMOM_LIBRARY);
            library_loaded = true;
        }
        catch (SecurityException exception) {
            mLogger.log(Level.WARNING, "Unexpected SecurityException: ", exception);
        }
        catch (UnsatisfiedLinkError exception) {
            mLogger.log(Level.WARNING, "Unexpected UnsatisfiedLinkError: ", exception);
        }
    }
}

