/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JServerClassLoader
extends URLClassLoader {
    private static final String FILEURL = "file:";
    private String mBaseDir;
    private static KeyStore mKeyStore = null;
    private static String mKeystorePassword = null;
    private static String mKeystoreFile = null;

    public JServerClassLoader(String basedir, String pPath, ClassLoader pParent) {
        super(new URL[0], pParent);
        this.mBaseDir = basedir;
        this.addToClassPath(pPath);
    }

    public JServerClassLoader(String basedir, String[] pPaths, ClassLoader pParent) {
        super(new URL[0], pParent);
        this.mBaseDir = basedir;
        if (pPaths != null) {
            for (String pPath : pPaths) {
                this.addToClassPath(pPath);
            }
        }
    }

    public JServerClassLoader(ClassLoader pParent) {
        super(new URL[0], pParent);
    }

    public void addToClassPath(URL url) {
        try {
            this.addURL(url);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public void addToClassPath(String path) {
        if (null == path || path.isEmpty()) {
            return;
        }
        try {
            String spec = path;
            if (path.regionMatches(true, 0, FILEURL, 0, FILEURL.length())) {
                Object[] argument = new Object[]{this.mBaseDir};
                spec = MessageFormat.format(path, argument);
            }
            this.addToClassPath(new URL(spec));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public synchronized Class<?> loadClass(String name) throws ClassNotFoundException {
        return super.loadClass(name);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection pc = new AllPermission().newPermissionCollection();
        pc.add(new AllPermission());
        return pc;
    }

    public synchronized void setKeystoreInfo(String file, String pw) {
        mKeystoreFile = file;
        mKeystorePassword = pw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean verifyClassAuthorized(String name) {
        if (mKeystorePassword == null) {
            return true;
        }
        String classpath = name.replace('.', '/').concat(".class");
        final URL url = this.findResource(classpath);
        if (url == null) {
            return false;
        }
        JarFile jf = null;
        try {
            try {
                jf = AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                    @Override
                    public JarFile run() throws Exception {
                        JarURLConnection conn = (JarURLConnection)url.openConnection();
                        return conn.getJarFile();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                SecurityException se = new SecurityException("Cannot verify " + url.toString());
                se.initCause(pae);
                throw se;
            }
            byte[] buffer = new byte[8192];
            Vector<JarEntry> entriesVec = new Vector<JarEntry>();
            Enumeration<JarEntry> entries = jf.entries();
            while (entries.hasMoreElements()) {
                JarEntry je = entries.nextElement();
                entriesVec.addElement(je);
                try (BufferedInputStream is = new BufferedInputStream(jf.getInputStream(je));){
                    while (is.read(buffer, 0, buffer.length) != -1) {
                    }
                }
            }
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                JarEntry je = e.nextElement();
                if (je == null || je.isDirectory() || !je.getName().equalsIgnoreCase(classpath)) continue;
                Certificate[] providerCerts = je.getCertificates();
                if (providerCerts == null || providerCerts.length == 0) {
                    return false;
                }
                boolean keystoreRead = false;
                if (mKeyStore == null) {
                    this.readKeystore();
                    if (mKeyStore == null) {
                        return false;
                    }
                    keystoreRead = true;
                }
                for (int j = 0; j < 2; ++j) {
                    if (providerCerts != null) {
                        for (Certificate providerCert : providerCerts) {
                            try {
                                String alias = mKeyStore.getCertificateAlias(providerCert);
                                if (alias != null) {
                                    return true;
                                }
                            }
                            catch (KeyStoreException e1) {
                                // empty catch block
                            }
                        }
                    }
                    if (!keystoreRead) {
                        this.readKeystore();
                        if (mKeyStore == null) {
                            return false;
                        }
                        keystoreRead = true;
                        continue;
                    }
                    j = 2;
                }
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
        return false;
    }

    private void readKeystore() {
        try {
            if (mKeystoreFile == null) {
                System.out.println("JServerClassLoader keystore name is null");
            }
            mKeyStore = KeyStore.getInstance("JKS");
            FileInputStream fileInputStream = new FileInputStream(mKeystoreFile);
            mKeyStore.load(fileInputStream, mKeystorePassword.toCharArray());
        }
        catch (Exception e) {
            System.out.println("Could not load provider authorization keystore file or password for this file is invalid: " + mKeystoreFile);
        }
    }
}

