/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.baseinfo.aou;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import sanproject.client.baseinfo.aou.RJBaseInfoAOUPoolTablePanel;
import sanproject.client.baseinfo.aou.RJBaseInfoAOUVVolTablePanel;
import sanproject.client.baseinfo.aou.RJBaseInfoItemPool;
import sanproject.client.baseinfo.com.RJBaseInfoComboAdapter;
import sanproject.client.baseinfo.com.RJBaseInfoDataSupplier;
import sanproject.client.baseinfo.com.RJBaseInfoDef;
import sanproject.client.baseinfo.com.RJBaseInfoTabPanel;
import sanproject.client.baseinfo.ldev.RJBaseInfoItemCU;
import sanproject.client.baseinfo.ldev.RJBaseInfoItemLDKC;
import sanproject.client.com.RJComFont;
import sanproject.client.com.RJcBaseComboBox;
import sanproject.client.com.RJcComboBoxModel;
import sanproject.client.com.RJcCushionPanel;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcHeaderPanel;
import sanproject.client.com.RJcListPanel;
import sanproject.client.com.RJcMainTitlePanel;
import sanproject.common.Robj_interface_POOLIndex;
import sanproject.common.Robj_interface_POOLInfoDetail;
import sanproject.common.Robj_interface_RJiCUIndex;
import sanproject.common.Robj_interface_RJiLDKCIndex;

public class RJBaseInfoAOUPanel
extends RJBaseInfoTabPanel
implements RJBaseInfoDef {
    private RJBaseInfoAOUVVolTablePanel vvolTablePanel;
    private RJBaseInfoAOUPoolTablePanel poolTablePanel;
    private JRadioButton radioPool;
    private JRadioButton radioCU;
    private JComboBox poolCombo;
    private JComboBox ldkcCombo;
    private JComboBox cuCombo;
    private JPanel comboPanel;
    private CardLayout cardLayout = new CardLayout();
    private static final int TABLE_PANEL_HIGHT = 240;

    public RJBaseInfoAOUPanel(RJBaseInfoDataSupplier rJBaseInfoDataSupplier) {
        super(rJBaseInfoDataSupplier);
        this.initInstance();
    }

    public boolean showPanel(boolean bl) {
        boolean bl2 = true;
        this.supplier.putLog("[BaseInfo]", "[AOU]", "showPanel ");
        this.supplier.clearAllCache();
        this.supplier.getCUIndex();
        this.initRadioButton("CU");
        return bl2;
    }

    private void initRadioButton(String string) {
        if (this.radioCU.isSelected()) {
            this.radioItemStateChanged("CU", null);
        } else if (this.radioPool.isSelected()) {
            this.radioItemStateChanged("POOL", null);
        } else {
            JRadioButton jRadioButton = string.equals("CU") ? this.radioCU : this.radioPool;
            jRadioButton.setSelected(true);
        }
    }

    private void radioItemStateChanged(String string, ItemEvent itemEvent) {
        this.supplier.putLog("[BaseInfo]", "[LDEV]", "radioItemStateChanged " + string);
        if (itemEvent == null || itemEvent.getStateChange() == 1) {
            if (string.equals("CU")) {
                this.initLDKCComboBox((RJBaseInfoItemLDKC)this.ldkcCombo.getSelectedItem());
            } else if (string.equals("POOL")) {
                this.initPoolComboBox((RJBaseInfoItemPool)this.poolCombo.getSelectedItem());
            }
            this.cardLayout.show(this.comboPanel, string);
        } else {
            this.vvolTablePanel.reset();
            this.poolTablePanel.reset();
        }
    }

    private void initLDKCComboBox(RJBaseInfoItemLDKC rJBaseInfoItemLDKC) {
        Robj_interface_RJiLDKCIndex[] robj_interface_RJiLDKCIndexArray = this.supplier.getLDKCIndex();
        ArrayList<RJBaseInfoItemLDKC> arrayList = new ArrayList<RJBaseInfoItemLDKC>();
        for (int i = 0; i < robj_interface_RJiLDKCIndexArray.length; ++i) {
            RJBaseInfoItemLDKC rJBaseInfoItemLDKC2 = new RJBaseInfoItemLDKC((Comparable)robj_interface_RJiLDKCIndexArray[i]);
            arrayList.add(rJBaseInfoItemLDKC2);
        }
        if (arrayList.size() > 1) {
            arrayList.add(0, new RJBaseInfoItemLDKC(null));
        }
        RJcComboBoxModel rJcComboBoxModel = new RJcComboBoxModel(arrayList);
        rJcComboBoxModel.setSelectedItem(null);
        this.ldkcCombo.setModel(rJcComboBoxModel);
        if (rJBaseInfoItemLDKC == null || !arrayList.contains(rJBaseInfoItemLDKC)) {
            rJBaseInfoItemLDKC = (RJBaseInfoItemLDKC)this.ldkcCombo.getItemAt(0);
        }
        this.ldkcCombo.setSelectedItem(rJBaseInfoItemLDKC);
    }

    private void initCUComboBox(RJBaseInfoItemCU rJBaseInfoItemCU) {
        Robj_interface_RJiCUIndex[] robj_interface_RJiCUIndexArray;
        RJBaseInfoItemLDKC rJBaseInfoItemLDKC = (RJBaseInfoItemLDKC)this.ldkcCombo.getSelectedItem();
        ArrayList<RJBaseInfoItemCU> arrayList = new ArrayList<RJBaseInfoItemCU>();
        if (rJBaseInfoItemLDKC != null && rJBaseInfoItemLDKC.isValidity()) {
            robj_interface_RJiCUIndexArray = this.supplier.getCUIndex((Robj_interface_RJiLDKCIndex)rJBaseInfoItemLDKC.getValue());
            for (int i = 0; i < robj_interface_RJiCUIndexArray.length; ++i) {
                RJBaseInfoItemCU rJBaseInfoItemCU2 = new RJBaseInfoItemCU((Comparable)robj_interface_RJiCUIndexArray[i]);
                arrayList.add(rJBaseInfoItemCU2);
            }
        }
        if (arrayList.size() != 1) {
            arrayList.add(0, new RJBaseInfoItemCU(null));
        }
        robj_interface_RJiCUIndexArray = new RJcComboBoxModel(arrayList);
        robj_interface_RJiCUIndexArray.setSelectedItem(null);
        this.cuCombo.setModel(robj_interface_RJiCUIndexArray);
        if (rJBaseInfoItemCU == null || !arrayList.contains(rJBaseInfoItemCU)) {
            rJBaseInfoItemCU = (RJBaseInfoItemCU)this.cuCombo.getItemAt(0);
        }
        this.cuCombo.setSelectedItem(rJBaseInfoItemCU);
    }

    private void initPoolComboBox(RJBaseInfoItemPool rJBaseInfoItemPool) {
        Robj_interface_POOLInfoDetail[] robj_interface_POOLInfoDetailArray = this.supplier.getPoolList();
        ArrayList<RJBaseInfoItemPool> arrayList = new ArrayList<RJBaseInfoItemPool>();
        for (int i = 0; i < robj_interface_POOLInfoDetailArray.length; ++i) {
            if (robj_interface_POOLInfoDetailArray[i].getByPoolKind() != 2) continue;
            RJBaseInfoItemPool rJBaseInfoItemPool2 = new RJBaseInfoItemPool((Robj_interface_POOLIndex)robj_interface_POOLInfoDetailArray[i]);
            arrayList.add(rJBaseInfoItemPool2);
        }
        arrayList.add(0, new RJBaseInfoItemPool(null));
        RJcComboBoxModel rJcComboBoxModel = new RJcComboBoxModel(arrayList);
        rJcComboBoxModel.setSelectedItem(null);
        this.poolCombo.setModel(rJcComboBoxModel);
        if (rJBaseInfoItemPool == null || !arrayList.contains(rJBaseInfoItemPool)) {
            rJBaseInfoItemPool = (RJBaseInfoItemPool)this.poolCombo.getItemAt(0);
        }
        this.poolCombo.setSelectedItem(rJBaseInfoItemPool);
    }

    private void ldkcComboItemSelected(ItemEvent itemEvent) {
        RJBaseInfoItemLDKC rJBaseInfoItemLDKC;
        RJBaseInfoItemLDKC rJBaseInfoItemLDKC2 = (RJBaseInfoItemLDKC)this.ldkcCombo.getSelectedItem();
        this.supplier.putLog("[BaseInfo]", "[AOU]", "ldkcComboItemSelected " + rJBaseInfoItemLDKC2);
        if (rJBaseInfoItemLDKC2.isValidity() && !(rJBaseInfoItemLDKC = (RJBaseInfoItemLDKC)this.ldkcCombo.getItemAt(0)).isValidity()) {
            this.ldkcCombo.removeItemAt(0);
        }
        this.initCUComboBox((RJBaseInfoItemCU)this.cuCombo.getSelectedItem());
    }

    private void cuComboItemSelected(ItemEvent itemEvent) {
        RJBaseInfoItemCU rJBaseInfoItemCU;
        RJBaseInfoItemCU rJBaseInfoItemCU2 = (RJBaseInfoItemCU)this.cuCombo.getSelectedItem();
        this.supplier.putLog("[BaseInfo]", "[AOU]", "cuComboItemSelected " + rJBaseInfoItemCU2);
        if (rJBaseInfoItemCU2.isValidity() && !(rJBaseInfoItemCU = (RJBaseInfoItemCU)this.cuCombo.getItemAt(0)).isValidity()) {
            this.cuCombo.removeItemAt(0);
        }
        this.vvolTablePanel.showTable(rJBaseInfoItemCU2);
    }

    private void poolComboItemSelected(ItemEvent itemEvent) {
        RJBaseInfoItemPool rJBaseInfoItemPool;
        RJBaseInfoItemPool rJBaseInfoItemPool2 = (RJBaseInfoItemPool)this.poolCombo.getSelectedItem();
        this.supplier.putLog("[BaseInfo]", "[AOU]", "poolComboItemSelected " + rJBaseInfoItemPool2);
        if (rJBaseInfoItemPool2.isValidity() && !(rJBaseInfoItemPool = (RJBaseInfoItemPool)this.poolCombo.getItemAt(0)).isValidity()) {
            this.poolCombo.removeItemAt(0);
        }
        this.vvolTablePanel.showTable(rJBaseInfoItemPool2);
    }

    public boolean chgTab() {
        this.vvolTablePanel.reset();
        this.poolTablePanel.reset();
        this.ldkcCombo.removeAllItems();
        this.cuCombo.removeAllItems();
        this.poolCombo.removeAllItems();
        boolean bl = super.chgTab();
        return bl;
    }

    public void closePanel() {
    }

    public String collectExportData() {
        String string = this.getExportHeader();
        string = string + this.vvolTablePanel.collectExportData();
        string = string + this.poolTablePanel.collectExportData();
        return string;
    }

    protected JComponent createNorthComponent() {
        RJcMainTitlePanel rJcMainTitlePanel = (RJcMainTitlePanel)super.createNorthComponent();
        rJcMainTitlePanel.addExtra(this.createExtraPanel());
        return rJcMainTitlePanel;
    }

    private JPanel createExtraPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setPreferredSize(new Dimension(400, 28));
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel();
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.createCUPoolComboPanel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createCUPoolComboPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        RJcListPanel rJcListPanel = new RJcListPanel();
        rJcListPanel.setMinLabelWidth(0);
        rJcListPanel.addEntry("BasicInfo/CBOX_LBL_CUPOOL", this.createRadioPanel());
        rJcListPanel.completed();
        jPanel.add((Component)rJcListPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.createComboPanel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        return jPanel;
    }

    private JPanel createRadioPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.radioCU = new JRadioButton(RJcGuide.text("BasicInfo/RDBTN_CU"));
        buttonGroup.add(this.radioCU);
        this.radioCU.setOpaque(false);
        this.radioCU.setForeground(RJcGuide.color("BasicInfo/RDBTN_CU"));
        this.radioCU.setFont(RJComFont.labelFont);
        this.radioCU.addItemListener(new RJBaseInfoComboAdapter(this.supplier){

            public void itemStateSelected(ItemEvent itemEvent) {
                RJBaseInfoAOUPanel.this.radioItemStateChanged("CU", itemEvent);
            }
        });
        Dimension dimension = this.radioCU.getPreferredSize();
        this.radioCU.setPreferredSize(new Dimension(dimension.width, 24));
        this.radioPool = new JRadioButton(RJcGuide.text("BasicInfo/RDBTN_POOL"));
        buttonGroup.add(this.radioPool);
        this.radioPool.setOpaque(false);
        this.radioPool.setForeground(RJcGuide.color("BasicInfo/RDBTN_POOL"));
        this.radioPool.setFont(RJComFont.labelFont);
        this.radioPool.addItemListener(new RJBaseInfoComboAdapter(this.supplier){

            public void itemStateSelected(ItemEvent itemEvent) {
                RJBaseInfoAOUPanel.this.radioItemStateChanged("POOL", itemEvent);
            }
        });
        Dimension dimension2 = this.radioPool.getPreferredSize();
        this.radioPool.setPreferredSize(new Dimension(dimension2.width, 24));
        jPanel.add((Component)this.radioCU, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.radioPool, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createComboPanel() {
        this.comboPanel = new JPanel(this.cardLayout);
        this.comboPanel.add((Component)this.createCUCombo(), "CU");
        this.comboPanel.add((Component)this.createPOOLCombo(), "POOL");
        return this.comboPanel;
    }

    private JPanel createCUCombo() {
        this.ldkcCombo = new RJcBaseComboBox();
        this.ldkcCombo.addItemListener(new RJBaseInfoComboAdapter(this.supplier){

            public void itemStateSelected(ItemEvent itemEvent) {
                RJBaseInfoAOUPanel.this.ldkcComboItemSelected(itemEvent);
            }
        });
        this.ldkcCombo.setPreferredSize(new Dimension(80, 24));
        this.ldkcCombo.setMinimumSize(new Dimension(80, 24));
        this.cuCombo = new RJcBaseComboBox();
        this.cuCombo.addItemListener(new RJBaseInfoComboAdapter(this.supplier){

            public void itemStateSelected(ItemEvent itemEvent) {
                RJBaseInfoAOUPanel.this.cuComboItemSelected(itemEvent);
            }
        });
        this.cuCombo.setPreferredSize(new Dimension(80, 24));
        this.cuCombo.setMinimumSize(new Dimension(80, 24));
        JPanel jPanel = this.createComboPanel(this.ldkcCombo, this.cuCombo);
        return jPanel;
    }

    private JPanel createPOOLCombo() {
        this.poolCombo = new RJcBaseComboBox();
        this.poolCombo.addItemListener(new RJBaseInfoComboAdapter(this.supplier){

            public void itemStateSelected(ItemEvent itemEvent) {
                RJBaseInfoAOUPanel.this.poolComboItemSelected(itemEvent);
            }
        });
        this.poolCombo.setPreferredSize(new Dimension(80, 24));
        this.poolCombo.setMinimumSize(new Dimension(80, 24));
        JPanel jPanel = this.createComboPanel(this.poolCombo, null);
        return jPanel;
    }

    private JPanel createComboPanel(Component component, Component component2) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel.add(component, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (component2 != null) {
            jPanel.add(component2, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 4, 0, 0), 0, 0));
        }
        RJcCushionPanel rJcCushionPanel = new RJcCushionPanel(jPanel);
        return rJcCushionPanel;
    }

    protected JComponent createCenterComponent() {
        JSplitPane jSplitPane = new JSplitPane();
        Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        jSplitPane.setBorder(border);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setOrientation(0);
        jSplitPane.setDividerSize(4);
        jSplitPane.setDividerLocation(240);
        jSplitPane.setOpaque(false);
        jSplitPane.add((Component)this.createTopPanel(), "top");
        jSplitPane.add((Component)this.createBottomPanel(), "bottom");
        return jSplitPane;
    }

    private JPanel createTopPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(8, 4));
        RJcHeaderPanel rJcHeaderPanel = new RJcHeaderPanel("BasicInfo/VVOLTableTitle");
        Border border = BorderFactory.createEmptyBorder(4, 8, 4, 8);
        this.poolTablePanel = new RJBaseInfoAOUPoolTablePanel(this.supplier);
        this.vvolTablePanel = new RJBaseInfoAOUVVolTablePanel(this.poolTablePanel, this.supplier);
        RJcCushionPanel rJcCushionPanel = new RJcCushionPanel((JComponent)this.vvolTablePanel, 1);
        jPanel.setOpaque(false);
        jPanel.add((Component)rJcHeaderPanel, "North");
        jPanel.add((Component)rJcCushionPanel, "Center");
        return jPanel;
    }

    private JPanel createBottomPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(8, 4));
        RJcHeaderPanel rJcHeaderPanel = new RJcHeaderPanel("BasicInfo/POOLTableTitle");
        Border border = BorderFactory.createEmptyBorder(4, 8, 4, 8);
        RJcCushionPanel rJcCushionPanel = new RJcCushionPanel((JComponent)this.poolTablePanel, 1);
        jPanel.setOpaque(false);
        jPanel.add((Component)rJcHeaderPanel, "North");
        jPanel.add((Component)rJcCushionPanel, "Center");
        return jPanel;
    }

    public String getWindowName() {
        return "BasicInfo/AOU";
    }
}

