/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.baseinfo.port;

import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import sanproject.client.baseinfo.com.RJBaseInfoDataSupplier;
import sanproject.client.baseinfo.com.RJBaseInfoElement;
import sanproject.client.com.RJcGuide;
import sanproject.client.data.RJDataLPRControler;
import sanproject.common.Robj_interface_RJiPortIndex;
import sanproject.common.Robj_interface_RJiPortInfoDetail;
import sanproject.serverux.dataimpl.RJiPortIndex;
import sanproject.serverux.dataimpl.RJiWWN;

public class RJBaseInfoPortElement
extends RJBaseInfoElement {
    protected Robj_interface_RJiPortInfoDetail detail = null;
    private String slprString = null;
    private String typeString = null;
    private String hostSpeedString = null;
    private String addLoopIDString = null;
    private String fablicString = null;
    private String conectionString = null;
    private String attribuString = null;
    private String portWWNString = null;
    private String portRsgString = null;

    public RJBaseInfoPortElement(Robj_interface_RJiPortInfoDetail robj_interface_RJiPortInfoDetail, RJBaseInfoDataSupplier rJBaseInfoDataSupplier) {
        super(null, rJBaseInfoDataSupplier);
        this.initDetail(robj_interface_RJiPortInfoDetail);
    }

    public void initDetail(Robj_interface_RJiPortInfoDetail robj_interface_RJiPortInfoDetail) {
        Object object;
        this.detail = robj_interface_RJiPortInfoDetail;
        short s = this.detail.getSPort();
        this.setName(this.supplier.getPortName(s));
        RJDataLPRControler rJDataLPRControler = this.supplier.getLPRControler();
        this.slprNo = new Integer(this.detail.getSSLPR());
        this.slprName = rJDataLPRControler.getSLPRNoToName(this.detail.getSSLPR());
        this.slprString = RJBaseInfoPortElement.toClprString(this.slprNo, this.slprName);
        this.hostSpeedString = this.toHostSpeedString(this.detail.getByUserChannelSpeed());
        this.addLoopIDString = "--(--)";
        if (this.detail.getByPortKindNo() == 2 || this.detail.getByPortKindNo() == 6) {
            this.addLoopIDString = this.supplier.getPortFibreAddress(this.detail.getSPortFibreAddress());
            object = this.supplier.getFabricConnection(this.detail.getByPortFibreTopology());
            this.fablicString = this.toFablicString(((ArrayList)object).get(0));
            this.conectionString = (String)((ArrayList)object).get(1);
        }
        object = this.supplier.getPortAttributeInfoDetail((Robj_interface_RJiPortIndex)this.detail);
        this.attribuString = this.toAttributeString(object.getByPortKind());
        RJiWWN rJiWWN = new RJiWWN();
        rJiWWN.byWWN = this.detail.getByPortWWN();
        this.portWWNString = rJiWWN.getStringWWN();
        this.portRsgString = this.supplier.getPortRSG((RJiPortIndex)this.detail);
    }

    public Icon getIcon(boolean bl) {
        Icon icon = null;
        return icon;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof RJBaseInfoPortElement) {
            bl = this.detail.equals(((RJBaseInfoPortElement)object).getPortIndex());
        }
        return bl;
    }

    public int hashCode() {
        int n = this.detail.hashCode();
        return n;
    }

    public int compareTo(Object object) {
        int n = 0;
        if (object instanceof RJBaseInfoPortElement) {
            n = this.name.compareTo(((RJBaseInfoPortElement)object).getName());
        }
        return n;
    }

    public Robj_interface_RJiPortIndex getPortIndex() {
        return this.detail;
    }

    public String getSlprString() {
        return this.slprString;
    }

    public String getTypeString() {
        return this.typeString;
    }

    public void setTypeString(String string) {
        this.typeString = string;
    }

    public String getHostSpeedString() {
        return this.hostSpeedString;
    }

    private String toHostSpeedString(byte by) {
        HashMap hashMap = this.supplier.getChannelSpeedMap();
        String string = (String)hashMap.get(new Byte(by));
        if (string == null) {
            string = new String("-");
        }
        return string;
    }

    public String getAddLoopIDString() {
        return this.addLoopIDString;
    }

    public String getFablicString() {
        return this.fablicString;
    }

    public String toFablicString(Object object) {
        String string = "BasicInfo/FABLIC_NONE";
        if (object.equals("ON")) {
            string = "BasicInfo/FABLIC_ON";
        } else if (object.equals("OFF")) {
            string = "BasicInfo/FABLIC_OFF";
        }
        return RJcGuide.text(string);
    }

    public String getConectionString() {
        return this.conectionString;
    }

    public String getAttribuString() {
        return this.attribuString;
    }

    private String toAttributeString(byte by) {
        String[] stringArray = new String[]{"-", "BasicInfo/PortLCP", "BasicInfo/PortRCP", "BasicInfo/PortTarget", "BasicInfo/PortRCUTarget", "BasicInfo/PortInitiator", "BasicInfo/PortExt", "BasicInfo/PortHTP", "BasicInfo/PortFNP"};
        String string = "-";
        if (by > 0 && by < stringArray.length) {
            string = RJcGuide.text(stringArray[by]);
        }
        return string;
    }

    public String getPortWWNString() {
        return this.portWWNString;
    }

    public String getPortResourceGroupstring() {
        return this.portRsgString;
    }
}

