/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com;

import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class RJComTextFieldEX
extends JTextField {
    public static final boolean ON = true;
    public static final boolean OFF = false;
    public static final short ALPHABETIC = 1;
    public static final short NUMERIC = 2;
    public static final short HEXADECIMAL = 4;
    public static final short SPACE_UBAR = 8;
    public static final short SPACE = 16;
    public static final short UNDERBAR = 32;
    public static final short HYPHEN = 64;
    public static final short PERIOD = 128;
    static final int MAX_LEN = 65536;
    private boolean editChk = false;
    private boolean updFlg = false;
    private Toolkit toolkit;
    private int min = 0;
    private int max = 65536;
    private short chkStr = 0;
    private RJComTextFieldEX textField;
    private KeyListener keyListener = null;
    private char[] DefaultNGCharacters = new char[]{'\\', ',', '/', ':', ';', '*', '?', '\"', '<', '>', '|'};
    private boolean bDefaultNGCheckFlag = false;
    private boolean bUseBlueFont = true;

    public RJComTextFieldEX() {
        this.setDocument(new WholeNumberDocument());
        this.textField = this;
    }

    public RJComTextFieldEX(short s) {
        this.setChkStr(s);
        this.setDocument(new WholeNumberDocument());
        this.textField = this;
    }

    public RJComTextFieldEX(boolean bl) {
        this.bDefaultNGCheckFlag = true;
        this.setDocument(new WholeNumberDocument());
        this.textField = this;
    }

    public RJComTextFieldEX(short s, boolean bl) {
        this.setChkStr(s);
        this.setDocument(new WholeNumberDocument());
        this.textField = this;
        this.setEditChk(bl);
    }

    public RJComTextFieldEX(boolean bl, boolean bl2) {
        this.bDefaultNGCheckFlag = true;
        this.setDocument(new WholeNumberDocument());
        this.textField = this;
        this.setEditChk(bl2);
    }

    private void textField_keyPressed(KeyEvent keyEvent) {
        if (!this.isEditable()) {
            keyEvent.consume();
            return;
        }
        int n = keyEvent.getKeyCode();
        if (n == 8) {
            if (this.getCaretPosition() - 1 >= 0) {
                if (this.bUseBlueFont) {
                    this.setForeground(Color.blue);
                }
                this.setUpdFlg(true);
            }
            return;
        }
        if (n == 127) {
            if (this.getCaretPosition() == this.getText().length()) {
                keyEvent.consume();
                return;
            }
        } else {
            if (n == 10) {
                keyEvent.consume();
                return;
            }
            return;
        }
        if (this.bUseBlueFont) {
            this.setForeground(Color.blue);
        }
        this.setUpdFlg(true);
    }

    public void putText(String string) {
        this.setText(string);
        this.setCaretPosition(0);
        this.setUpdFlg(false);
        if (this.bUseBlueFont) {
            this.textField.setForeground(Color.black);
        }
    }

    public void setUpdFlg(boolean bl) {
        if (bl) {
            if (this.bUseBlueFont) {
                this.setFont(new Font(this.getFont().getName(), 3, this.getFont().getSize()));
            }
        } else {
            this.setFont(new Font(this.getFont().getName(), 0, this.getFont().getSize()));
        }
        this.updFlg = bl;
    }

    public boolean getUpdFlg() {
        return this.updFlg;
    }

    public void setEditChk(boolean bl) {
        this.editChk = bl;
        if (this.editChk) {
            if (this.keyListener == null) {
                this.keyListener = this.makeLister();
            }
            this.addKeyListener(this.keyListener);
        } else {
            this.removeKeyListener(this.keyListener);
        }
    }

    public void setMaxLen(int n) {
        this.max = n > 65536 ? 65536 : (n < this.min ? this.min : n);
    }

    public void setMinLen(int n) {
        this.min = n < 0 ? 0 : (n > this.max ? this.max : n);
    }

    public void setChkStr(short s) {
        this.chkStr = s;
    }

    private KeyListener makeLister() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                RJComTextFieldEX.this.textField_keyPressed(keyEvent);
            }
        };
    }

    public void setDefaultNGChecker(boolean bl) {
        this.bDefaultNGCheckFlag = bl;
    }

    public boolean isEnableDefaultNGChecker() {
        return this.bDefaultNGCheckFlag;
    }

    public void setDefaultNGCharacters(char[] cArray) {
        this.DefaultNGCharacters = cArray;
    }

    public char[] getDefaultNGCharacters() {
        return this.DefaultNGCharacters;
    }

    public void setUseBlueFont(boolean bl) {
        this.bUseBlueFont = bl;
    }

    public boolean isUseBlueFont() {
        return this.bUseBlueFont;
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        protected WholeNumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string != null && !string.equals("")) {
                int n2 = 0;
                if (attributeSet == null) {
                    if (this.getLength() > RJComTextFieldEX.this.max || this.getLength() < RJComTextFieldEX.this.min) {
                        return;
                    }
                    for (n2 = 0; n2 < string.length(); ++n2) {
                        char c = string.charAt(n2);
                        if (Character.UnicodeBlock.of(c) != Character.UnicodeBlock.BASIC_LATIN) {
                            string = string.substring(0, n2);
                            break;
                        }
                        if (this.checkCharacter(c) == 0 && this.checkLengthOver(n2)) continue;
                        string = string.substring(0, n2);
                        break;
                    }
                }
                if (RJComTextFieldEX.this.editChk && n2 > 0) {
                    if (RJComTextFieldEX.this.bUseBlueFont) {
                        RJComTextFieldEX.this.textField.setForeground(Color.blue);
                    }
                    RJComTextFieldEX.this.textField.setUpdFlg(true);
                }
                super.insertString(n, string, attributeSet);
            }
        }

        public int checkCharacter(char c) {
            int n = -1;
            n = RJComTextFieldEX.this.chkStr != 0 ? this.customCharCheck(c) : (RJComTextFieldEX.this.bDefaultNGCheckFlag ? this.defaultCharCheck(c) : 0);
            return n;
        }

        public int customCharCheck(char c) {
            int n = -1;
            if ((RJComTextFieldEX.this.chkStr & 1) == 1 && (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                n = 0;
            }
            if ((RJComTextFieldEX.this.chkStr & 2) == 2 && c >= '0' && c <= '9') {
                n = 0;
            }
            if ((RJComTextFieldEX.this.chkStr & 4) == 4 && (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9')) {
                n = 0;
            }
            if ((RJComTextFieldEX.this.chkStr & 8) == 8 && (c == ' ' || c == '_')) {
                n = 0;
            }
            if ((RJComTextFieldEX.this.chkStr & 0x10) == 16 && c == ' ') {
                n = 0;
            }
            if ((RJComTextFieldEX.this.chkStr & 0x20) == 32 && c == '_') {
                n = 0;
            }
            if ((RJComTextFieldEX.this.chkStr & 0x40) == 64 && c == '-') {
                n = 0;
            }
            if ((RJComTextFieldEX.this.chkStr & 0x80) == 128 && c == '.') {
                n = 0;
            }
            return n;
        }

        public int defaultCharCheck(char c) {
            int n = -1;
            boolean bl = false;
            for (int i = 0; RJComTextFieldEX.this.DefaultNGCharacters.length > i; ++i) {
                if (RJComTextFieldEX.this.DefaultNGCharacters[i] != c) continue;
                bl = true;
                break;
            }
            if (!bl) {
                n = 0;
            }
            return n;
        }

        public boolean checkLengthOver(int n) {
            boolean bl = true;
            if (RJComTextFieldEX.this.textField.getText().length() + n >= RJComTextFieldEX.this.max) {
                bl = false;
            }
            return bl;
        }
    }
}

