/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.com;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import sanproject.client.com.RJcElement;
import sanproject.client.com.RJcMenuAction;
import sanproject.client.com.RJcPopupMenu;
import sanproject.client.com.abs.RJaDataModelEntry;
import sanproject.client.com.abs.RJaTableManager;
import sanproject.client.data.RJDataMsg;
import sanproject.client.exdevice.com.AbstractTableColumnInfo;
import sanproject.client.exdevice.com.AbstractTableDataModel;
import sanproject.client.exdevice.com.CustomizableCellData;
import sanproject.client.exdevice.com.Guidance;
import sanproject.client.exdevice.com.Message;
import sanproject.client.exdevice.com.PresetDataElement;
import sanproject.client.exdevice.com.PresetViewPanel;
import sanproject.client.exdevice.com.TableColumnInfo;
import sanproject.client.exdevice.data.PresetData;
import sanproject.client.exdevice.data.PresetManager;

public abstract class PresetViewTableDataModel
extends AbstractTableDataModel {
    protected static final TableColumnInfo ERROR_CODE = new ErrorCodeColumnInfo();
    private PresetViewPanel viewPanel;
    private RJcMenuAction detailAction;
    private RJcMenuAction deleteAction;
    private boolean errorDetailMenu = false;
    static /* synthetic */ Class class$sanproject$client$exdevice$com$CustomizableCellData;

    public PresetViewTableDataModel() {
        this.setPageRowCount(8192);
        this.viewPanel = null;
        String string = Guidance.MENU_ERRORMESSAGE.getItemID();
        this.detailAction = new RJcMenuAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                PresetViewTableDataModel.this.onSelectDetail(actionEvent);
            }

            public String toString() {
                String string = (String)this.getValue("Name");
                return string;
            }
        };
        string = Guidance.MENU_DELETE.getItemID();
        this.deleteAction = new RJcMenuAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                PresetViewTableDataModel.this.onSelectDelete(actionEvent);
            }

            public String toString() {
                String string = (String)this.getValue("Name");
                return string;
            }
        };
    }

    public void setTable(RJaTableManager rJaTableManager) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            RJaDataModelEntry rJaDataModelEntry = (RJaDataModelEntry)enumeration.nextElement();
            rJaDataModelEntry.put("COLOR", null);
        }
        super.setTable(rJaTableManager);
    }

    public abstract PresetDataElement convertToElement(PresetData var1);

    public PresetDataElement[] getSelectedPresetDataElements() {
        int[] nArray = this.getSelectedRows();
        PresetDataElement[] presetDataElementArray = this.getPresetDataElements(nArray);
        return presetDataElementArray;
    }

    public PresetDataElement[] getPresetDataElements(int[] nArray) {
        ArrayList<RJcElement> arrayList = new ArrayList<RJcElement>();
        RJcElement[] rJcElementArray = this.getElements(nArray);
        for (int i = 0; i < rJcElementArray.length; ++i) {
            RJcElement rJcElement = rJcElementArray[i];
            if (!(rJcElement instanceof PresetDataElement)) continue;
            arrayList.add(rJcElement);
        }
        PresetDataElement[] presetDataElementArray = new PresetDataElement[]{};
        presetDataElementArray = arrayList.toArray(presetDataElementArray);
        return presetDataElementArray;
    }

    public boolean isErrorDetailMenu() {
        return this.errorDetailMenu;
    }

    public void setErrorDetailMenu(boolean bl) {
        this.errorDetailMenu = bl;
    }

    protected JPopupMenu createPopupMenu() {
        this.updateActionsStatus();
        RJcMenuAction[] rJcMenuActionArray = this.isErrorDetailMenu() ? new RJcMenuAction[]{this.detailAction} : new RJcMenuAction[]{this.detailAction, new RJcMenuAction(), this.deleteAction};
        RJcPopupMenu rJcPopupMenu = new RJcPopupMenu(rJcMenuActionArray);
        return rJcPopupMenu;
    }

    void setViewPanel(PresetViewPanel presetViewPanel) {
        this.viewPanel = presetViewPanel;
    }

    private void updateActionsStatus() {
        boolean bl = false;
        boolean bl2 = false;
        PresetDataElement[] presetDataElementArray = this.getSelectedPresetDataElements();
        if (presetDataElementArray != null && presetDataElementArray.length > 0) {
            PresetData presetData;
            RJDataMsg rJDataMsg;
            if (presetDataElementArray.length == 1 && (rJDataMsg = (presetData = presetDataElementArray[0].getPresetData()).getErrInfo()) != null) {
                int n = rJDataMsg.getErrorCode();
                bl = n != 0;
            }
            bl2 = true;
        }
        this.detailAction.setEnabled(bl);
        this.deleteAction.setEnabled(bl2);
    }

    private void onSelectDetail(ActionEvent actionEvent) {
        PresetDataElement presetDataElement;
        PresetData presetData;
        RJDataMsg rJDataMsg;
        PresetDataElement[] presetDataElementArray = this.getSelectedPresetDataElements();
        if (presetDataElementArray != null && presetDataElementArray.length > 0 && (rJDataMsg = (presetData = (presetDataElement = presetDataElementArray[0]).getPresetData()).getErrInfo()) != null) {
            JDialog jDialog = this.getPopupMenuOwnerDialog(actionEvent);
            Message message = Message.getMessage(rJDataMsg);
            message.showOKDialog(jDialog);
        }
    }

    private void onSelectDelete(ActionEvent actionEvent) {
        JDialog jDialog;
        int n;
        PresetDataElement[] presetDataElementArray = this.getSelectedPresetDataElements();
        if (presetDataElementArray.length > 0 && (n = Message.showOKCancelDialog(jDialog = this.getPopupMenuOwnerDialog(actionEvent), 610, 9060)) == 0) {
            PresetManager presetManager = PresetManager.getInstance();
            int n2 = this.getSelectedRow();
            PresetData[] presetDataArray = new PresetData[presetDataElementArray.length];
            for (int i = 0; i < presetDataElementArray.length; ++i) {
                PresetData presetData;
                PresetDataElement presetDataElement = presetDataElementArray[i];
                presetDataArray[i] = presetData = presetDataElement.getPresetData();
            }
            presetManager.remove(presetDataArray);
            this.removeRow();
            if (this.viewPanel != null) {
                this.viewPanel.updateObjectCount();
                this.absolutePage(this.getPageTopRow());
                if (this.getVisibleRowCount() <= 0) {
                    this.viewPanel.onClickPaging(false);
                } else {
                    this.viewPanel.moveSelectedRow(n2);
                    this.viewPanel.updatePagingPanel();
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class ErrorCodeColumnInfo
    extends AbstractTableColumnInfo {
        public Object getCellData(RJcElement rJcElement) {
            PresetDataElement presetDataElement;
            PresetData presetData;
            Object object;
            String string;
            Object object2 = null;
            if (rJcElement instanceof PresetDataElement && (string = this.toStringErrorInfo((RJDataMsg)(object = (presetData = (presetDataElement = (PresetDataElement)((Object)rJcElement)).getPresetData()).getErrInfo()))) != null) {
                Object object3 = presetData.getErrInfo();
                object = ErrorCodeColumnInfo.createSortKey((RJDataMsg)object3);
                object3 = new CustomizableCellData(string);
                ((CustomizableCellData)object3).setSortableObject(object);
                object2 = object3;
            }
            return object2;
        }

        public Guidance getColumnGuidance() {
            Guidance guidance = Guidance.HEADER_ERRORCODE;
            return guidance;
        }

        public int getColumnWidth() {
            int n = 120;
            return n;
        }

        public Class getColumnClass() {
            Class clazz = class$sanproject$client$exdevice$com$CustomizableCellData == null ? (class$sanproject$client$exdevice$com$CustomizableCellData = PresetViewTableDataModel.class$("sanproject.client.exdevice.com.CustomizableCellData")) : class$sanproject$client$exdevice$com$CustomizableCellData;
            return clazz;
        }

        private String toStringErrorInfo(RJDataMsg rJDataMsg) {
            int n;
            String string = null;
            if (rJDataMsg != null && (n = rJDataMsg.getErrorCode()) != 0) {
                int n2 = rJDataMsg.getPartId();
                string = "" + String.valueOf(n2) + ":" + String.valueOf(n) + "";
            }
            return string;
        }

        private static String createSortKey(RJDataMsg rJDataMsg) {
            String string = "";
            if (rJDataMsg != null) {
                int n = rJDataMsg.getPartId();
                String string2 = ErrorCodeColumnInfo.convertToString(n, 6);
                int n2 = rJDataMsg.getErrorCode();
                String string3 = ErrorCodeColumnInfo.convertToString(n2, 7);
                string = "" + string2 + ":" + string3 + "";
            }
            return string;
        }

        private static String convertToString(int n, int n2) {
            Serializable serializable = new StringBuffer();
            for (int i = 0; i < n2; ++i) {
                ((StringBuffer)serializable).append('0');
            }
            String string = ((StringBuffer)serializable).toString();
            serializable = new DecimalFormat(string);
            String string2 = ((NumberFormat)serializable).format(n);
            return string2;
        }
    }
}

