/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.ExternalVolumeManager;
import sanproject.client.exdevice.data.ModifyTaker;
import sanproject.client.exdevice.data.PhysicalPathInfo;
import sanproject.client.exdevice.data.PhysicalPathManager;
import sanproject.client.exdevice.data.ProductInfo;
import sanproject.client.exdevice.data.ProductManager;
import sanproject.serverux.dataimpl.EXDPathGroup;

public class PathGroupInfo
extends ModifyTaker
implements Comparable {
    private String mToString = null;
    private EXDPathGroup mRmiObj = null;
    private boolean mflgConfiguard = false;
    private ProductInfo mProductInfo = null;
    private ArrayList mPhysicalPathInfoList = null;
    private int mStatus;

    PathGroupInfo(EXDPathGroup eXDPathGroup) {
        this.mRmiObj = eXDPathGroup;
    }

    EXDPathGroup getEXDPathGroup() {
        return this.mRmiObj;
    }

    void setEXDPathGroup(EXDPathGroup eXDPathGroup) {
        this.mRmiObj = eXDPathGroup;
        this.clearPhysicalPathInfoList();
    }

    void clearPhysicalPathInfoList() {
        this.mPhysicalPathInfoList = null;
    }

    public int getId() {
        return this.mRmiObj.getPathGroupID();
    }

    public String getName() {
        return this.mRmiObj.getNickname();
    }

    public int referSubsystemId() {
        return this.mRmiObj.referSubsystemID();
    }

    public int[] referPhysicalPathIdList() {
        return this.mRmiObj.referAllPhysicalPathList();
    }

    public int getAltPathMode() {
        return this.mRmiObj.getPathMode();
    }

    public boolean isConfiguard() {
        return this.mflgConfiguard;
    }

    void setConfiguard(boolean bl) {
        this.mflgConfiguard = bl;
    }

    public ProductInfo getProductInfo() {
        if (this.mProductInfo == null) {
            ProductManager productManager = ProductManager.getInstance();
            this.mProductInfo = productManager.getProductInfo(this.referSubsystemId());
        }
        return this.mProductInfo;
    }

    public Collection getExternalVolumeInfo() throws EXDException {
        ExternalVolumeManager externalVolumeManager = ExternalVolumeManager.getInstance();
        return externalVolumeManager.getExternalVolumeInfo(this);
    }

    public List getPhysicalPathInfo() {
        if (this.mPhysicalPathInfoList == null) {
            PhysicalPathManager physicalPathManager = PhysicalPathManager.getInstance();
            int[] nArray = this.referPhysicalPathIdList();
            int n = nArray.length;
            this.mPhysicalPathInfoList = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                PhysicalPathInfo physicalPathInfo = physicalPathManager.getPhysicalPathInfo(nArray[i]);
                if (physicalPathInfo == null) continue;
                this.mPhysicalPathInfoList.add(physicalPathInfo);
            }
        }
        return this.mPhysicalPathInfoList;
    }

    void setStatus(int n) {
        this.mStatus = n;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public boolean equals(Object object) {
        if (object instanceof PathGroupInfo) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.getId();
    }

    public String toString() {
        if (this.mToString == null) {
            this.mToString = "Path Group " + this.getId();
        }
        return this.mToString;
    }

    public int compareTo(Object object) {
        PathGroupInfo pathGroupInfo = (PathGroupInfo)object;
        return this.toString().compareTo(pathGroupInfo.toString());
    }
}

