/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import sanproject.client.exdevice.data.AbstractDataControl;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.FilterManager;
import sanproject.client.exdevice.data.PhysicalPathInfo;
import sanproject.client.exdevice.data.Singleton;
import sanproject.client.exdevice.data.SingletonManager;
import sanproject.client.exdevice.data.TargetPortInfo;
import sanproject.client.exdevice.data.TargetPortManager;
import sanproject.client.exdevice.data.Utility;
import sanproject.common.Robj_interface_RJiPortIndex;
import sanproject.serverux.dataimpl.EXDPhysicalPath;

public class PhysicalPathManager
implements Singleton {
    private static final String LOG_NAME = "PhysicalPathManager";
    private ArrayList mPPathList = new ArrayList();
    static Comparator mPPathIdComparator = new PhysicalPathIdComparator();
    private static final Comparator COMP_PORT_ID = new Comparator(){

        public int compare(Object object, Object object2) {
            int n = this.getValue(object);
            int n2 = this.getValue(object2);
            return n - n2;
        }

        private int getValue(Object object) {
            int n;
            if (object instanceof PhysicalPathInfo) {
                n = ((PhysicalPathInfo)object).referPortId();
            } else if (object instanceof Robj_interface_RJiPortIndex) {
                n = ((Robj_interface_RJiPortIndex)object).getSPort();
            } else {
                throw new ClassCastException();
            }
            return n;
        }
    };
    private static final Comparator COMP_TARGET_PORT = new Comparator(){

        public int compare(Object object, Object object2) {
            int n = this.getValue(object);
            int n2 = this.getValue(object2);
            return n - n2;
        }

        private int getValue(Object object) {
            int n;
            if (object instanceof PhysicalPathInfo) {
                n = ((PhysicalPathInfo)object).referTargetPortId();
            } else if (object instanceof TargetPortInfo) {
                n = ((TargetPortInfo)object).getId();
            } else {
                throw new ClassCastException();
            }
            return n;
        }
    };
    static final Comparator COMP_PHYSICALPATH = new Comparator(){

        public int compare(Object object, Object object2) {
            EXDPhysicalPath eXDPhysicalPath = this.getObject(object);
            EXDPhysicalPath eXDPhysicalPath2 = this.getObject(object2);
            int n = eXDPhysicalPath.referInitiatorPortId() - eXDPhysicalPath2.referInitiatorPortId();
            if (n == 0) {
                if (eXDPhysicalPath.isConfigured() && eXDPhysicalPath2.isConfigured()) {
                    n = eXDPhysicalPath.referTargetPortId() - eXDPhysicalPath2.referTargetPortId();
                } else {
                    TargetPortInfo targetPortInfo = this.getReferObject(object);
                    TargetPortInfo targetPortInfo2 = this.getReferObject(object2);
                    n = targetPortInfo.getDisplayTargetAdr().compareTo(targetPortInfo2.getDisplayTargetAdr());
                }
            }
            return n;
        }

        private EXDPhysicalPath getObject(Object object) {
            EXDPhysicalPath eXDPhysicalPath;
            if (object instanceof PhysicalPathInfo) {
                PhysicalPathInfo physicalPathInfo = (PhysicalPathInfo)object;
                eXDPhysicalPath = physicalPathInfo.getEXDPhysicalPath();
            } else {
                eXDPhysicalPath = (EXDPhysicalPath)object;
            }
            return eXDPhysicalPath;
        }

        private TargetPortInfo getReferObject(Object object) {
            TargetPortInfo targetPortInfo;
            if (object instanceof PhysicalPathInfo) {
                PhysicalPathInfo physicalPathInfo = (PhysicalPathInfo)object;
                targetPortInfo = physicalPathInfo.getTargetPortInfo();
            } else if (object instanceof EXDPhysicalPath) {
                int n = ((EXDPhysicalPath)object).referTargetPortId();
                targetPortInfo = TargetPortManager.getInstance().getTargetPortInfo(n);
            } else {
                throw new ClassCastException();
            }
            return targetPortInfo;
        }
    };
    static final int ID_OFFSET_UNCONFIGURED = Integer.MIN_VALUE;
    ArrayList mDiscoveryPhysicalPaths = new ArrayList();
    static /* synthetic */ Class class$sanproject$client$exdevice$data$PhysicalPathManager;

    PhysicalPathManager() {
    }

    public static synchronized PhysicalPathManager getInstance() {
        return (PhysicalPathManager)SingletonManager.getInstance(class$sanproject$client$exdevice$data$PhysicalPathManager == null ? (class$sanproject$client$exdevice$data$PhysicalPathManager = PhysicalPathManager.class$("sanproject.client.exdevice.data.PhysicalPathManager")) : class$sanproject$client$exdevice$data$PhysicalPathManager);
    }

    public void destroy() {
    }

    void initialize(EXDPhysicalPath[] eXDPhysicalPathArray) {
        Utility.putLog(LOG_NAME, "initialize");
        this.mDiscoveryPhysicalPaths.clear();
        int n = eXDPhysicalPathArray.length;
        this.mPPathList = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            EXDPhysicalPath eXDPhysicalPath = eXDPhysicalPathArray[i];
            if (eXDPhysicalPath == null) continue;
            PhysicalPathInfo physicalPathInfo = new PhysicalPathInfo(eXDPhysicalPath);
            this.mPPathList.add(physicalPathInfo);
        }
        Collections.sort(this.mPPathList, mPPathIdComparator);
    }

    void update(EXDPhysicalPath[] eXDPhysicalPathArray) throws EXDException {
        Collections.sort(this.mPPathList, COMP_PHYSICALPATH);
        Collections.sort(this.mDiscoveryPhysicalPaths, COMP_PHYSICALPATH);
        BitSet bitSet = new BitSet(this.mPPathList.size());
        ArrayList<Comparable<StringBuffer>> arrayList = new ArrayList<Comparable<StringBuffer>>(this.mDiscoveryPhysicalPaths.size());
        for (int i = 0; i < eXDPhysicalPathArray.length; ++i) {
            Comparable<StringBuffer> comparable;
            EXDPhysicalPath eXDPhysicalPath = eXDPhysicalPathArray[i];
            if (eXDPhysicalPath == null) continue;
            int n = Collections.binarySearch(this.mPPathList, eXDPhysicalPath, COMP_PHYSICALPATH);
            if (n >= 0) {
                bitSet.set(n);
                continue;
            }
            int n2 = Collections.binarySearch(this.mDiscoveryPhysicalPaths, eXDPhysicalPath, COMP_PHYSICALPATH);
            if (n2 >= 0) {
                comparable = (PhysicalPathInfo)this.mDiscoveryPhysicalPaths.remove(n2);
                ((PhysicalPathInfo)comparable).setEXDPhysicalPath(eXDPhysicalPath);
                arrayList.add(comparable);
                continue;
            }
            comparable = new StringBuffer("Increase Data ->");
            ((StringBuffer)comparable).append(" External Port:").append(eXDPhysicalPath.referInitiatorPortId());
            ((StringBuffer)comparable).append(" Target Port ID:").append(eXDPhysicalPath.referTargetPortId());
            Utility.putLog(LOG_NAME, ((StringBuffer)comparable).toString());
            throw new EXDException(AbstractDataControl.ERP_CLIENT, 69041);
        }
        if (bitSet.cardinality() != this.mPPathList.size()) {
            StringBuffer stringBuffer = new StringBuffer("Decrease Data -> ");
            stringBuffer.append(this.mPPathList.get(bitSet.nextClearBit(0)));
            Utility.putLog(LOG_NAME, stringBuffer.toString());
            throw new EXDException(AbstractDataControl.ERP_CLIENT, 69041);
        }
        this.mPPathList.addAll(arrayList);
        Collections.sort(this.mPPathList, mPPathIdComparator);
        Collections.sort(this.mDiscoveryPhysicalPaths, mPPathIdComparator);
    }

    public Collection getPhysicalPathInfo() {
        List list = (List)this.mPPathList.clone();
        Collections.sort(list);
        return list;
    }

    public PhysicalPathInfo getPhysicalPathInfo(int n) {
        ArrayList arrayList = n >= 0 ? this.mPPathList : this.mDiscoveryPhysicalPaths;
        Integer n2 = new Integer(n);
        int n3 = Collections.binarySearch(arrayList, n2, mPPathIdComparator);
        PhysicalPathInfo physicalPathInfo = null;
        if (n3 >= 0) {
            physicalPathInfo = (PhysicalPathInfo)arrayList.get(n3);
        }
        return physicalPathInfo;
    }

    public PhysicalPathInfo[] getPhysicalPathInfo(Robj_interface_RJiPortIndex robj_interface_RJiPortIndex) {
        PhysicalPathInfo[] physicalPathInfoArray = this.getPhysicalPathInfoAll(robj_interface_RJiPortIndex);
        physicalPathInfoArray = this.maskOwnPhysicalPath(physicalPathInfoArray);
        return physicalPathInfoArray;
    }

    PhysicalPathInfo[] getPhysicalPathInfoAll(Robj_interface_RJiPortIndex robj_interface_RJiPortIndex) {
        PhysicalPathInfo[] physicalPathInfoArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = new ArrayList(this.mPPathList);
        Collections.sort(arrayList2, COMP_PORT_ID);
        int n = Collections.binarySearch(arrayList2, robj_interface_RJiPortIndex, COMP_PORT_ID);
        if (n >= 0) {
            PhysicalPathInfo physicalPathInfo;
            PhysicalPathInfo physicalPathInfo2;
            int n2;
            physicalPathInfoArray = (PhysicalPathInfo)arrayList2.get(n);
            arrayList.add(physicalPathInfoArray);
            for (n2 = n - 1; n2 >= 0 && COMP_PORT_ID.compare(physicalPathInfo2 = (PhysicalPathInfo)arrayList2.get(n2), physicalPathInfoArray) == 0; --n2) {
                arrayList.add(physicalPathInfo2);
            }
            n2 = arrayList2.size();
            for (int i = n + 1; i < n2 && COMP_PORT_ID.compare(physicalPathInfo = (PhysicalPathInfo)arrayList2.get(i), physicalPathInfoArray) == 0; ++i) {
                arrayList.add(physicalPathInfo);
            }
            Collections.sort(arrayList);
        }
        physicalPathInfoArray = new PhysicalPathInfo[arrayList.size()];
        physicalPathInfoArray = arrayList.toArray(physicalPathInfoArray);
        return physicalPathInfoArray;
    }

    PhysicalPathInfo[] maskOwnPhysicalPath(PhysicalPathInfo[] physicalPathInfoArray) {
        PhysicalPathInfo[] physicalPathInfoArray2;
        if (FilterManager.doShowOwnDevice()) {
            physicalPathInfoArray2 = physicalPathInfoArray;
        } else {
            ArrayList<PhysicalPathInfo> arrayList = new ArrayList<PhysicalPathInfo>(physicalPathInfoArray.length);
            for (int i = 0; i < physicalPathInfoArray.length; ++i) {
                if (physicalPathInfoArray[i].getProductInfo().isOwn()) continue;
                arrayList.add(physicalPathInfoArray[i]);
            }
            physicalPathInfoArray2 = new PhysicalPathInfo[arrayList.size()];
            physicalPathInfoArray2 = arrayList.toArray(physicalPathInfoArray2);
        }
        return physicalPathInfoArray2;
    }

    public PhysicalPathInfo[] getPhysicalPathInfo(TargetPortInfo targetPortInfo) {
        PhysicalPathInfo[] physicalPathInfoArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = new ArrayList(this.mPPathList);
        Collections.sort(arrayList2, COMP_TARGET_PORT);
        int n = Collections.binarySearch(arrayList2, targetPortInfo, COMP_TARGET_PORT);
        if (n >= 0) {
            PhysicalPathInfo physicalPathInfo;
            PhysicalPathInfo physicalPathInfo2;
            int n2;
            physicalPathInfoArray = (PhysicalPathInfo)arrayList2.get(n);
            arrayList.add(physicalPathInfoArray);
            for (n2 = n - 1; n2 >= 0 && COMP_TARGET_PORT.compare(physicalPathInfo2 = (PhysicalPathInfo)arrayList2.get(n2), physicalPathInfoArray) == 0; --n2) {
                arrayList.add(physicalPathInfo2);
            }
            n2 = arrayList2.size();
            for (int i = n + 1; i < n2 && COMP_TARGET_PORT.compare(physicalPathInfo = (PhysicalPathInfo)arrayList2.get(i), physicalPathInfoArray) == 0; ++i) {
                arrayList.add(physicalPathInfo);
            }
            Collections.sort(arrayList);
        }
        physicalPathInfoArray = new PhysicalPathInfo[arrayList.size()];
        physicalPathInfoArray = arrayList.toArray(physicalPathInfoArray);
        return physicalPathInfoArray;
    }

    PhysicalPathInfo createDiscoveryPhysicalPathInfo(EXDPhysicalPath eXDPhysicalPath) {
        PhysicalPathInfo physicalPathInfo = null;
        if (eXDPhysicalPath.isConfigured()) {
            int n = eXDPhysicalPath.getId();
            physicalPathInfo = this.getPhysicalPathInfo(n);
        } else {
            int n;
            int n2 = eXDPhysicalPath.referInitiatorPortId();
            int n3 = eXDPhysicalPath.referTargetPortId();
            for (n = 0; n < this.mDiscoveryPhysicalPaths.size(); ++n) {
                PhysicalPathInfo physicalPathInfo2 = (PhysicalPathInfo)this.mDiscoveryPhysicalPaths.get(n);
                int n4 = physicalPathInfo2.referPortId();
                int n5 = physicalPathInfo2.referTargetPortId();
                if (n2 != n4 || n3 != n5) continue;
                physicalPathInfo = physicalPathInfo2;
                break;
            }
            if (physicalPathInfo == null) {
                n = Integer.MIN_VALUE + this.mDiscoveryPhysicalPaths.size();
                eXDPhysicalPath.setId(n);
                physicalPathInfo = new PhysicalPathInfo(eXDPhysicalPath);
                this.mDiscoveryPhysicalPaths.add(physicalPathInfo);
            }
        }
        return physicalPathInfo;
    }

    void clearDiscoveryInfo() {
        this.mDiscoveryPhysicalPaths.clear();
    }

    void deletePhysicalPathInfo(PhysicalPathInfo physicalPathInfo) {
        int n = Collections.binarySearch(this.mPPathList, physicalPathInfo, mPPathIdComparator);
        if (n >= 0) {
            this.mPPathList.remove(n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class PhysicalPathIdComparator
    implements Comparator {
        PhysicalPathIdComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = this.getValue(object);
            int n2 = this.getValue(object2);
            return n - n2;
        }

        private int getValue(Object object) {
            int n = object instanceof PhysicalPathInfo ? ((PhysicalPathInfo)object).getId() : ((Integer)object).intValue();
            return n;
        }
    }
}

