/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.luoperation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import sanproject.client.com.RJComSpringUtilities;
import sanproject.client.com.RJcDlgMainTitlePanel;
import sanproject.client.com.RJcElement;
import sanproject.client.com.RJcListPanel;
import sanproject.client.com.RJcMainTitlePanel;
import sanproject.client.exdevice.com.Button;
import sanproject.client.exdevice.com.DialogContentsPanel;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.SsidInfo;
import sanproject.client.exdevice.luoperation.LocalGuidance;
import sanproject.client.exdevice.text.HexNumberDocument;

public class SSIDInputPanel
extends DialogContentsPanel {
    private static final String KEY_NAME = "InputSSID";
    private JComboBox ssidComboBox = null;
    private Button applyButton = null;
    private Button cancelButton = null;

    public SSIDInputPanel() {
        this.initializePanel();
        this.buildPanelLayout();
    }

    public void addNotify() {
        Object object;
        super.addNotify();
        final Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            object = new WindowAdapter(){

                public void windowOpened(WindowEvent windowEvent) {
                    SSIDInputPanel.this.putLog(SSIDInputPanel.KEY_NAME, "[InputSSID] opened.");
                }

                public void windowClosed(WindowEvent windowEvent) {
                    SSIDInputPanel.this.putLog(SSIDInputPanel.KEY_NAME, "[InputSSID] closed.");
                    window.removeWindowListener(this);
                }
            };
            window.addWindowListener((WindowListener)object);
        }
        if ((object = this.getWindowRootPane()) != null) {
            ((JRootPane)object).setDefaultButton(this.cancelButton);
        }
    }

    public String getWindowName() {
        String string = "ExDevice_LU";
        return string;
    }

    public void setSSIDList(Collection collection) {
        DefaultComboBoxModel<Object> defaultComboBoxModel;
        if (collection != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = collection.size();
            arrayList.ensureCapacity(n);
            for (int i = 0; i < n; ++i) {
                Integer n2 = (Integer)((ArrayList)collection).get(i);
                arrayList.add(RJcElement.toHexString(n2, 4));
            }
            defaultComboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
        } else {
            defaultComboBoxModel = new DefaultComboBoxModel();
        }
        this.ssidComboBox.setModel(defaultComboBoxModel);
    }

    public Integer getSelectedSSID() {
        Object object = this.ssidComboBox.getSelectedItem();
        Integer n = object != null && object.toString().length() > 0 ? (object instanceof Integer ? (Integer)object : Integer.valueOf(object.toString(), 16)) : null;
        return n;
    }

    private void initializePanel() {
        Serializable serializable;
        this.ssidComboBox = new JComboBox();
        Object object = this.ssidComboBox.getEditor();
        Serializable serializable2 = new HexNumberDocument(4);
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SSIDInputPanel.this.onChangeSSID();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SSIDInputPanel.this.onChangeSSID();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                SSIDInputPanel.this.onChangeSSID();
            }
        };
        serializable2.addDocumentListener(documentListener);
        if (object != null && (serializable = object.getEditorComponent()) instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)serializable;
            jTextComponent.setDocument((Document)((Object)serializable2));
        }
        this.ssidComboBox.setEditor((ComboBoxEditor)object);
        this.ssidComboBox.setEditable(true);
        serializable = this.ssidComboBox.getPreferredSize();
        ((Dimension)serializable).width = 60;
        this.ssidComboBox.setPreferredSize((Dimension)serializable);
        object = LocalGuidance.BUTTON_OK.getItemID();
        serializable2 = new AbstractAction((String)object){

            public void actionPerformed(ActionEvent actionEvent) {
                SSIDInputPanel.this.putLog(SSIDInputPanel.KEY_NAME, "[InputSSID] onClick Apply.");
                SSIDInputPanel.this.onClickApply();
            }
        };
        this.applyButton = new Button((String)object);
        this.applyButton.setAction((Action)((Object)serializable2));
        object = LocalGuidance.BUTTON_CANCEL.getItemID();
        serializable2 = new AbstractAction((String)object){

            public void actionPerformed(ActionEvent actionEvent) {
                SSIDInputPanel.this.putLog(SSIDInputPanel.KEY_NAME, "[InputSSID] onClick Cancel.");
                SSIDInputPanel.this.onClickCancel();
            }
        };
        this.cancelButton = new Button((String)object);
        this.cancelButton.setAction((Action)((Object)serializable2));
        this.onChangeSSID();
    }

    private void buildPanelLayout() {
        Object object = LocalGuidance.TITLE_ENTERSSID.getItemID();
        JPanel jPanel = new RJcDlgMainTitlePanel();
        ((RJcMainTitlePanel)jPanel).setMainTitle((String)object);
        RJcDlgMainTitlePanel rJcDlgMainTitlePanel = jPanel;
        jPanel = new RJcListPanel();
        Object object2 = "" + LocalGuidance.TEXT_SSID.getText() + " (" + RJcElement.toHexString(SsidInfo.SSID_MIN, 4) + "-" + RJcElement.toHexString(SsidInfo.SSID_MAX, 4) + ")" + "";
        Serializable serializable = Box.createVerticalStrut(1);
        Component component = Box.createGlue();
        SpringLayout springLayout = new SpringLayout();
        Object object3 = new JPanel();
        ((Container)object3).setLayout(springLayout);
        ((JComponent)object3).setOpaque(false);
        ((Container)object3).add((Component)serializable);
        ((Container)object3).add(this.ssidComboBox);
        ((Container)object3).add(component);
        RJComSpringUtilities.makeCompactGrid((Container)object3, 3, 1, 0, 0, 0, 0);
        serializable = new BorderLayout(4, 4);
        Serializable serializable2 = new JPanel();
        serializable2.setLayout((LayoutManager)((Object)serializable));
        serializable2.setOpaque(false);
        serializable2.add((Component)object3, "West");
        ((RJcListPanel)jPanel).addEntry((String)object2, (JComponent)serializable2);
        object2 = new BorderLayout(4, 4);
        object = new JPanel();
        ((Container)object).setLayout((LayoutManager)object2);
        ((JComponent)object).setOpaque(false);
        ((Container)object).add((Component)jPanel, "North");
        serializable2 = new GridLayout(1, 0, 4, 4);
        object2 = new JPanel();
        ((Container)object2).setLayout((LayoutManager)((Object)serializable2));
        ((JComponent)object2).setOpaque(false);
        ((Container)object2).add(this.applyButton);
        ((Container)object2).add(this.cancelButton);
        serializable2 = new BorderLayout(4, 4);
        object3 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)((Object)serializable2));
        jPanel.setOpaque(false);
        jPanel.setBorder((Border)object3);
        jPanel.add((Component)object2, "East");
        object2 = new BorderLayout(4, 4);
        this.setLayout((LayoutManager)object2);
        this.add((Component)rJcDlgMainTitlePanel, "North");
        this.add((Component)object, "Center");
        this.add((Component)jPanel, "South");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClickApply() {
        try {
            Object object;
            this.setWaitCursor();
            Integer n = this.getSelectedSSID();
            boolean bl = false;
            if (n != null) {
                object = RJcElement.toHexString(n, 4);
                int n2 = this.ssidComboBox.getItemCount();
                for (int i = 0; i < n2; ++i) {
                    Object e = this.ssidComboBox.getItemAt(i);
                    if (e == null || !((String)object).equals(e)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.setDialogStatus(APPLY_STATUS);
                this.closeContentDialog();
            } else {
                object = new EXDException(610, 69004);
                this.processEXDException((EXDException)object);
            }
        }
        finally {
            this.setDefaultCursor();
        }
    }

    private void onClickCancel() {
        this.closeContentDialog();
    }

    private void onChangeSSID() {
        Component component;
        ComboBoxEditor comboBoxEditor = this.ssidComboBox.getEditor();
        String string = null;
        if (comboBoxEditor != null && (component = comboBoxEditor.getEditorComponent()) instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            string = jTextComponent.getText();
        }
        if (string != null && string.length() > 0) {
            this.applyButton.setEnabled(true);
        } else {
            this.applyButton.setEnabled(false);
        }
    }
}

