/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.lunm;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import javax.swing.JScrollBar;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import sanproject.client.com.RJcTreePanel;
import sanproject.client.com.abs.RJaTreeNode;
import sanproject.client.lunm.RJLunConstants;
import sanproject.client.lunm.RJLunTNode;
import sanproject.client.lunm.data.RJLunElement;
import sanproject.client.lunm.data.RJLunHostElement;
import sanproject.client.lunm.data.RJLunPortElement;
import sanproject.client.lunm.data.RJLunWWNElement;

public class RJLunDnDTree
extends RJcTreePanel
implements Autoscroll,
RJLunConstants {
    static int top;
    static int left;
    static int bottom;
    static int right;
    private static TreePath[] alltp;
    private static int at_idx;

    public Insets getAutoscrollInsets() {
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollPane.getHorizontalScrollBar();
        Rectangle rectangle = this.tree.getVisibleRect();
        top = rectangle.y + 16;
        left = rectangle.x + 8;
        bottom = rectangle.y + rectangle.height - 16;
        right = rectangle.x + rectangle.width - 8;
        Insets insets = new Insets(top, left, jScrollBar.getMaximum() - bottom, jScrollBar2.getMaximum() - right);
        return insets;
    }

    public void autoscroll(Point point) {
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollPane.getHorizontalScrollBar();
        if (point.y < top) {
            int n = point.y < top - 8 ? 32 : 8;
            jScrollBar.setValue(jScrollBar.getValue() - n);
        } else if (point.y > bottom) {
            int n = point.y > bottom + 8 ? 32 : 8;
            jScrollBar.setValue(jScrollBar.getValue() + n);
        }
        if (point.x < left) {
            jScrollBar2.setValue(jScrollBar2.getValue() - 8);
        } else if (point.x > right) {
            jScrollBar2.setValue(jScrollBar2.getValue() + 8);
        }
    }

    private boolean getAllows(TreeNode treeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getTreeModel();
        boolean bl = defaultTreeModel.asksAllowsChildren();
        boolean bl2 = !bl ? treeNode.isLeaf() : !treeNode.getAllowsChildren();
        return bl2;
    }

    public boolean isLeaf(TreeNode treeNode) {
        return this.getAllows(treeNode);
    }

    public boolean isLeaf(TreePath treePath) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        return this.getAllows(treeNode);
    }

    public String makePathStr(Object[] objectArray, String string) {
        String string2 = "";
        for (int i = 0; i < objectArray.length; ++i) {
            string2 = i < 2 ? string2 + objectArray[i].toString() : string2 + string + objectArray[i].toString();
        }
        return string2;
    }

    public String makePathStr(TreePath treePath, String string) {
        Object[] objectArray = treePath.getPath();
        String string2 = "";
        for (int i = 0; i < objectArray.length; ++i) {
            string2 = i < 2 ? string2 + objectArray[i].toString() : string2 + string + objectArray[i].toString();
        }
        if (!this.isLeaf(treePath)) {
            string2 = string2 + string;
        }
        return string2;
    }

    private TreePath[] getChSub(TreeNode treeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getTreeModel();
        int n = defaultTreeModel.getChildCount(treeNode);
        TreePath[] treePathArray = new TreePath[n];
        for (int i = 0; i < n; ++i) {
            Object object = defaultTreeModel.getChild(treeNode, i);
            RJLunTNode rJLunTNode = (RJLunTNode)object;
            TreeNode[] treeNodeArray = rJLunTNode.getPath();
            treePathArray[i] = new TreePath(treeNodeArray);
        }
        return treePathArray;
    }

    public TreePath[] getChild(TreePath treePath) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        return this.getChSub(treeNode);
    }

    public TreePath[] getChild(TreeNode treeNode) {
        return this.getChSub(treeNode);
    }

    private int getAllChCnt(TreeNode treeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getTreeModel();
        int n = defaultTreeModel.getChildCount(treeNode);
        if (n > 0) {
            TreePath[] treePathArray = this.getChild(treeNode);
            for (int i = 0; i < treePathArray.length; ++i) {
                TreeNode treeNode2 = (TreeNode)treePathArray[i].getLastPathComponent();
                if (this.isLeaf(treeNode2)) continue;
                n += this.getAllChCnt(treeNode2);
            }
        }
        return n;
    }

    public int getAllChildCount(TreePath treePath) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        return this.getAllChCnt(treeNode);
    }

    public int getAllChildCount(TreeNode treeNode) {
        return this.getAllChCnt(treeNode);
    }

    private TreePath[] getAllCh(TreeNode treeNode, int n) {
        int n2;
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getTreeModel();
        if (n == 0) {
            n2 = this.getAllChCnt(treeNode);
            alltp = new TreePath[n2];
            at_idx = 0;
        }
        if ((n2 = defaultTreeModel.getChildCount(treeNode)) != 0) {
            TreePath[] treePathArray = this.getChild(treeNode);
            for (int i = 0; i < n2; ++i) {
                RJLunDnDTree.alltp[RJLunDnDTree.at_idx++] = treePathArray[i];
                if (this.isLeaf(treePathArray[i])) continue;
                TreeNode treeNode2 = (TreeNode)treePathArray[i].getLastPathComponent();
                this.getAllCh(treeNode2, 1);
            }
        }
        return alltp;
    }

    public TreePath[] getAllChild(TreePath treePath) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        return this.getAllCh(treeNode, 0);
    }

    public TreePath[] getAllChild(TreeNode treeNode) {
        return this.getAllCh(treeNode, 0);
    }

    public TreePath getMatchPath(TreePath treePath, String string) {
        TreePath treePath2 = null;
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getTreeModel();
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        int n = defaultTreeModel.getChildCount(treeNode);
        TreePath[] treePathArray = new TreePath[n];
        treePathArray = this.getChild(treePath);
        for (int i = 0; i < n; ++i) {
            if (!string.equalsIgnoreCase(treePathArray[i].getLastPathComponent().toString())) continue;
            treePath2 = treePathArray[i];
            break;
        }
        return treePath2;
    }

    public TreePath getParent(TreePath treePath) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        TreeNode treeNode2 = treeNode.getParent();
        TreePath treePath2 = new TreePath(((RJaTreeNode)treeNode2).getPath());
        return treePath2;
    }

    public TreePath getParent(RJLunTNode rJLunTNode) {
        RJLunTNode rJLunTNode2 = (RJLunTNode)rJLunTNode.getParent();
        TreePath treePath = new TreePath(rJLunTNode2.getPath());
        return treePath;
    }

    public int getStatus(TreePath treePath) {
        int n = 0;
        RJaTreeNode rJaTreeNode = (RJaTreeNode)treePath.getLastPathComponent();
        RJLunElement rJLunElement = (RJLunElement)rJaTreeNode.getUserObject();
        if (rJLunElement instanceof RJLunPortElement) {
            n = ((RJLunPortElement)rJLunElement).isPortSecuritySwitch() ? 1 : 2;
        } else if (rJLunElement instanceof RJLunHostElement) {
            RJLunHostElement rJLunHostElement = (RJLunHostElement)rJLunElement;
            n = rJLunHostElement.getPortElement().isPortSecuritySwitch() ? 3 : (rJLunHostElement.getPortNo() == 0 ? 4 : 5);
        } else if (rJLunElement instanceof RJLunWWNElement) {
            n = 6;
        }
        return n;
    }

    public String getItemStr(TreePath treePath) {
        String string = "";
        RJaTreeNode rJaTreeNode = (RJaTreeNode)treePath.getLastPathComponent();
        RJLunWWNElement rJLunWWNElement = (RJLunWWNElement)rJaTreeNode.getUserObject();
        string = rJLunWWNElement.getName();
        return string;
    }

    public TreeNode getNode(TreePath treePath) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        return treeNode;
    }

    public void delPath(TreePath treePath) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getTreeModel();
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        defaultTreeModel.removeNodeFromParent((MutableTreeNode)treeNode);
    }

    public void delPath(TreeNode treeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getTreeModel();
        defaultTreeModel.removeNodeFromParent((MutableTreeNode)treeNode);
    }

    public RJLunElement getSpecifyElement(RJaTreeNode rJaTreeNode, String string) {
        RJLunElement rJLunElement = null;
        RJaTreeNode rJaTreeNode2 = (RJaTreeNode)rJaTreeNode.getParent();
        RJLunElement rJLunElement2 = (RJLunElement)rJaTreeNode2.getUserObject();
        String string2 = rJLunElement2.getClass().toString();
        boolean bl = true;
        while (bl) {
            if (string2.indexOf(string) != -1) {
                rJLunElement = rJLunElement2;
                bl = false;
                break;
            }
            this.getSpecifyElement(rJaTreeNode2, string);
        }
        return rJLunElement;
    }
}

