/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.com;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.JDialog;
import javax.swing.JPanel;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComDialog;
import sanproject.client.com.RJComFuncPanel;
import sanproject.client.com.RJComPanel;
import sanproject.client.com.RJComUty;
import sanproject.client.data.RJDataCache;
import sanproject.client.data.RJDataChange;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataControlDoing;
import sanproject.client.data.RJDataLDEVPart;
import sanproject.client.data.RJDataMsg;
import sanproject.client.data.RJDataPGPart;
import sanproject.client.data.RJDataPathPart;
import sanproject.client.data.RJDataPortPart;
import sanproject.client.monitor.com.RJHihDef;
import sanproject.client.monitor.com.RJHihInfoSetter;
import sanproject.client.monitor.com.RJHihMonitoringInfo;
import sanproject.client.monitor.com.RJHihMonitoringLong;
import sanproject.client.monitor.com.RJHihMonitoringOptionInfo;
import sanproject.client.monitor.com.RJHihMonitoringShort;
import sanproject.client.monitor.com.RJHihTimePair;
import sanproject.common.Robj_interface_MonMonitoringData;
import sanproject.common.Robj_interface_MonMonitoringInfoLDKC;

public abstract class RJHihAbstractDataSupplier
implements RJHihDef {
    protected RJDataControl controller;
    protected RJDataControlDoing controlDoing;
    protected RJDataCache controlCache;
    protected RJDataPGPart controlPGPart;
    protected RJDataLDEVPart controlLDEVPart;
    protected RJDataPortPart controlPortPart;
    protected RJDataPathPart controlPathPart;
    protected RJHihMonitoringOptionInfo monitoringOption = new RJHihMonitoringOptionInfo(this);
    protected RJHihMonitoringShort monitoringShort = new RJHihMonitoringShort(this);
    protected RJHihMonitoringLong monitoringLong = new RJHihMonitoringLong(this);
    protected RJHihMonitoringInfo monitoringinfo = null;
    protected HashMap infoMap = new HashMap(8);
    private ArrayList infoSetterList = new ArrayList(8);
    private Stack parentPanel = new Stack();
    private JDialog dialog = null;
    private Object centerCompo = null;
    private Window window = null;
    private int messageShow = 0;
    private int disableCount = 0;
    protected boolean intializing = false;
    protected String osName = System.getProperty("os.name");
    protected boolean stayController = true;
    protected boolean addedBasePanel = false;
    protected boolean baseInfoRefreshing = false;
    private boolean editMode = false;

    public RJHihAbstractDataSupplier() {
        this(null);
    }

    public RJHihAbstractDataSupplier(RJDataControl rJDataControl) {
        this.controller = rJDataControl;
        if (rJDataControl != null) {
            this.controlDoing = rJDataControl.getControlDoing();
            this.controlCache = rJDataControl.getCache();
            this.controlPGPart = rJDataControl.getPGPart();
            this.controlLDEVPart = rJDataControl.getLDEVPart();
            this.controlPortPart = rJDataControl.getPortPart();
            this.controlPathPart = rJDataControl.getPathPart();
        }
    }

    public void addInfoSetter(RJHihInfoSetter rJHihInfoSetter) {
        if (rJHihInfoSetter != null) {
            this.infoSetterList.add(rJHihInfoSetter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        try {
            this.intializing = true;
            this.initMonitoringInfo();
            String string = null;
            if (this.monitoringinfo != null) {
                string = this.monitoringinfo.getIdentifier();
            }
            Iterator iterator = this.infoSetterList.iterator();
            while (iterator.hasNext()) {
                RJHihInfoSetter rJHihInfoSetter = (RJHihInfoSetter)iterator.next();
                rJHihInfoSetter.initMonitoringInfo(this.infoMap);
            }
            if (string != null) {
                this.changeAvailInfo(string);
            }
        }
        finally {
            this.intializing = false;
        }
    }

    public void initMonitoringInfo() {
        Robj_interface_MonMonitoringInfoLDKC robj_interface_MonMonitoringInfoLDKC = this.monitoringOption.init();
        Robj_interface_MonMonitoringData robj_interface_MonMonitoringData = null;
        Robj_interface_MonMonitoringData robj_interface_MonMonitoringData2 = null;
        if (robj_interface_MonMonitoringInfoLDKC != null) {
            robj_interface_MonMonitoringData = robj_interface_MonMonitoringInfoLDKC.getShortRangeInfo();
            robj_interface_MonMonitoringData2 = robj_interface_MonMonitoringInfoLDKC.getLongRangeInfo();
        }
        this.monitoringShort.init(robj_interface_MonMonitoringData);
        this.monitoringLong.init(robj_interface_MonMonitoringData2);
    }

    public void updateMonitoringInfo() {
        Robj_interface_MonMonitoringInfoLDKC robj_interface_MonMonitoringInfoLDKC = this.monitoringOption.init();
        this.monitoringShort.updateTime(robj_interface_MonMonitoringInfoLDKC.getShortRangeInfo());
        this.monitoringLong.updateTime(robj_interface_MonMonitoringInfoLDKC.getLongRangeInfo());
    }

    public void changeAvailInfo(String string) {
        this.monitoringinfo = (RJHihMonitoringInfo)this.infoMap.get(string);
    }

    public RJDataControl getDataControl() {
        return this.controller;
    }

    public RJDataChange getChangeTbl() {
        return this.controller.GetChangeTbl();
    }

    public RJHihMonitoringOptionInfo getMonitoringOption() {
        return this.monitoringOption;
    }

    public RJHihMonitoringShort getMonitoringShort() {
        return this.monitoringShort;
    }

    public RJHihMonitoringLong getMonitoringLong() {
        return this.monitoringLong;
    }

    public RJHihMonitoringInfo getMonitoringInfo() {
        return this.monitoringinfo;
    }

    public RJHihMonitoringInfo getMonitoringInfo(String string) {
        return (RJHihMonitoringInfo)this.infoMap.get(string);
    }

    public String getOSName() {
        return this.osName;
    }

    public boolean isStayController() {
        return this.stayController;
    }

    public void setStayController(boolean bl) {
        this.stayController = bl;
    }

    public boolean isWindows() {
        boolean bl = false;
        if (this.osName.startsWith("Windows")) {
            bl = true;
        }
        return bl;
    }

    public boolean isDragAndDropOKforWindows() {
        boolean bl = true;
        if (this.controller != null) {
            bl = this.controller.getStartParamClass().isDragAndDropOKforWindows();
        }
        return bl;
    }

    public void showMessage() {
        ++this.messageShow;
    }

    public void hideMessage() {
        --this.messageShow;
    }

    public boolean isMessageShow() {
        boolean bl = false;
        if (this.messageShow > 0) {
            bl = true;
        }
        return bl;
    }

    public void waitCursor(Component component) {
        RJCom.waitCursor(component);
    }

    protected void disableWindow() {
    }

    public void defaultCursor(Component component) {
        RJCom.defCursor(component);
    }

    public Window searchWindow(Component component) {
        Window window = null;
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            if (!(component2 instanceof Window)) continue;
            window = (Window)component2;
            break;
        }
        return window;
    }

    public RJDataMsg getMessage(int n) {
        return RJCom.getMsg(this.controller, n / 100000, n % 100000);
    }

    public int showMessage(Component component, RJDataMsg rJDataMsg, int n, Object[] objectArray, Object object) {
        ++this.messageShow;
        int n2 = RJComDialog.show(component, rJDataMsg, n, objectArray, object);
        --this.messageShow;
        return n2;
    }

    public boolean showMessage(Component component, RJDataMsg rJDataMsg) {
        boolean bl = false;
        Window window = this.searchWindow(component);
        ++this.messageShow;
        bl = window instanceof Frame ? RJComUty.SetMsg((Frame)window, rJDataMsg) : RJComUty.SetMsg((Dialog)window, rJDataMsg);
        --this.messageShow;
        return bl;
    }

    public boolean checkMonitoringTime() {
        boolean bl = true;
        RJHihTimePair rJHihTimePair = null;
        if (this.monitoringinfo != null) {
            rJHihTimePair = this.monitoringinfo.getMonitoringTime();
        }
        Object object = this.getCenterCompo();
        if (!this.intializing && rJHihTimePair == null && object == null && this.monitoringinfo != null && !this.monitoringinfo.isErrorShow()) {
            this.monitoringinfo.setErrorShow(true);
            Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
            RJDataMsg rJDataMsg = this.getMessage(521005010);
            RJComDialog.show(this.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
            bl = false;
        }
        return bl;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(JDialog jDialog) {
        this.dialog = jDialog;
    }

    public Object getCenterCompo() {
        return this.centerCompo;
    }

    public void setCenterCompo(Object object) {
        this.centerCompo = object;
    }

    public JPanel getParentPanel() {
        JPanel jPanel = null;
        try {
            jPanel = (JPanel)this.parentPanel.peek();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushParentPanel(JPanel jPanel) {
        try {
            this.putLog("[MONITOR]", "[COM]", "pushParentPanel: start" + this.parentPanel.toString());
            this.parentPanel.push(jPanel);
            this.putLog("[MONITOR]", "[COM]", "pushParentPanel: after push" + this.parentPanel.toString());
        }
        catch (EmptyStackException emptyStackException) {
            emptyStackException.printStackTrace();
            this.putLog("[MONITOR]", "[COM]", "pushParentPanel: err");
        }
        finally {
            this.controlCache.setWaitingDialogComponent(this.getParentPanel());
            this.putLog("[MONITOR]", "[COM]", "pushParentPanel: end" + this.parentPanel.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popParentPanel() {
        try {
            this.putLog("[MONITOR]", "[COM]", "popParentPanel: start" + this.parentPanel.toString());
            this.parentPanel.pop();
            this.putLog("[MONITOR]", "[COM]", "popParentPanel: after pop" + this.parentPanel.toString());
        }
        catch (EmptyStackException emptyStackException) {
            emptyStackException.printStackTrace();
            this.putLog("[MONITOR]", "[COM]", "popParentPanel: err");
        }
        finally {
            this.controlCache.setWaitingDialogComponent(this.getParentPanel());
            this.putLog("[MONITOR]", "[COM]", "popParentPanel: end" + this.parentPanel.toString());
        }
    }

    public boolean getEditMode() {
        boolean bl = this.editMode;
        if (this.controller != null) {
            bl = RJCom.getEditMode(this.controller);
        }
        return bl;
    }

    public boolean cancel() {
        this.waitControl();
        this.controller.Cancel();
        return true;
    }

    public void putLog(String string, String string2, String string3) {
        if (this.controller != null) {
            RJCom.putLog(this.controller, string, string2, string3, 0);
        } else {
            System.out.println(string + " " + string2 + " " + string3);
        }
    }

    public String toHexString(int n, int n2) {
        String string = "0000000" + Integer.toHexString(n).toUpperCase();
        return string.substring(string.length() - n2);
    }

    public void setEditMode(boolean bl) {
        this.editMode = bl;
    }

    public int getVenderID() {
        int n = 0;
        if (this.controller != null) {
            n = this.controller.getStartParamClass().getVenderID();
        }
        return n;
    }

    public boolean isTabOption(int n, int n2) {
        boolean bl = true;
        if (this.controller != null) {
            bl = this.controller.getStartParamClass().getTABOption(n, n2);
        }
        return bl;
    }

    public boolean isPermission(int n, int n2) {
        boolean bl = true;
        if (this.controller != null) {
            bl = this.controller.getStartParamClass().getPermissionTABOption(n, n2);
        }
        return bl;
    }

    public boolean isPP(String string) {
        boolean bl = true;
        if (this.controller != null) {
            bl = this.controller.getPPKeyData().CheckPP(string);
        }
        return bl;
    }

    protected void confirm() {
        this.confirm("unknown");
    }

    protected void confirm(String string) {
        this.confirm(string, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean confirm(String string, String string2) {
        boolean bl = true;
        this.disableWindow();
        JPanel jPanel = this.getParentPanel();
        if (string != null && (string.equals("getMonitoringInfo") || string.equals("useMonitor") || string.equals("getUserGlpr"))) {
            jPanel = null;
        }
        try {
            this.stayController = true;
            this.controller.waitDC(jPanel);
        }
        finally {
            this.stayController = false;
        }
        ArrayList arrayList = this.getEndStatus(string);
        if (this.isError(arrayList, string, string2)) {
            bl = false;
            this.showErrorMessage((Integer)arrayList.get(0), (Integer)arrayList.get(1));
            RJCom.forceDefCursol(this.getParentPanel());
        }
        return bl;
    }

    protected void showErrorMessage(int n, int n2) {
        this.errorReset(n, n2);
        RJDataMsg rJDataMsg = this.getMessage(n, n2);
        Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
        ++this.messageShow;
        RJComDialog.show(this.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
        --this.messageShow;
        int n3 = this.getErrorLevel(rJDataMsg);
        RJComFuncPanel rJComFuncPanel = (RJComFuncPanel)this.getParentPanel();
        rJComFuncPanel.endRequest(n3);
    }

    protected ArrayList getEndStatus(String string) {
        return this.controller.getEndStatus();
    }

    protected boolean isError(ArrayList arrayList, String string, String string2) {
        boolean bl = false;
        int n = (Integer)arrayList.get(0);
        int n2 = (Integer)arrayList.get(1);
        this.putLog("[Monitor]", "[confirm]", string + ", " + string2 + " (" + n + ", " + n2 + ")");
        if (n != 0) {
            bl = true;
        }
        return bl;
    }

    protected int getErrorLevel(RJDataMsg rJDataMsg) {
        int n = rJDataMsg.getErrorLevel();
        return n;
    }

    protected void waitControl() {
        while (this.controlDoing.getDoing()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public RJDataMsg getMessage(ArrayList arrayList) {
        RJDataMsg rJDataMsg = this.getMessage((Integer)arrayList.get(0), (Integer)arrayList.get(1));
        return rJDataMsg;
    }

    protected RJDataMsg getMessage(int n, int n2) {
        RJDataMsg rJDataMsg = RJCom.getMsg(this.controller, n, n2);
        return rJDataMsg;
    }

    protected void errorReset(int n, int n2) {
    }

    public void terminate() {
    }

    public static void setNextFocus(Container container, Container container2) {
        container.setFocusTraversalPolicy(container2.getFocusTraversalPolicy());
    }

    public int paraApply(RJComPanel rJComPanel) {
        return 0;
    }

    public int paraApplyEx(RJComPanel rJComPanel) {
        return 0;
    }

    public boolean paraCancel() {
        return true;
    }

    public void paraShowApplyEndMsg() {
    }

    public boolean paraChkSts() {
        return false;
    }

    public boolean paraChgTab(RJComPanel rJComPanel) {
        return true;
    }

    public boolean isAddedBasePanel() {
        return this.addedBasePanel;
    }

    public void setAddedBasePanel(boolean bl) {
        this.addedBasePanel = bl;
    }

    public void setBaseInfoRefreshing(boolean bl) {
        this.baseInfoRefreshing = bl;
    }

    public boolean isBaseInfoRefreshing() {
        return this.baseInfoRefreshing;
    }
}

