/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.performance.physical;

import sanproject.client.com.RJcTreePanel;
import sanproject.client.monitor.com.RJHihBoolIcon;
import sanproject.client.monitor.com.RJHihContainSel;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihElement;
import sanproject.client.monitor.com.RJHihTimePair;
import sanproject.serverux.data.HIHsmPhysicalCacheUseRate;
import sanproject.serverux.data.HIHsmUseRateBase;
import sanproject.serverux.data.MonitorInfoCollection;

public class RJHihPhClprElement
extends RJHihElement
implements RJHihContainSel {
    private RJHihBoolIcon selection = new RJHihBoolIcon(false);
    private int clprNo;
    private String clprName;
    private RJHihTimePair term = null;
    private Integer useRateAverage = null;
    private Integer useRateMaximum = null;
    private Integer writePendingAverage = null;
    private Integer writePendingMaximum = null;

    public RJHihPhClprElement(int n, String string, RJHihDataSupplier rJHihDataSupplier, RJcTreePanel rJcTreePanel) {
        super(RJHihElement.toClprString(new Integer(n), string), rJHihDataSupplier, rJcTreePanel);
        this.clprNo = n;
        this.clprName = string;
    }

    public void collectUseRate(MonitorInfoCollection monitorInfoCollection, int n) {
        this.useRateAverage = null;
        this.useRateMaximum = null;
        this.writePendingAverage = null;
        this.writePendingMaximum = null;
        if (monitorInfoCollection != null) {
            HIHsmUseRateBase hIHsmUseRateBase = (HIHsmUseRateBase)monitorInfoCollection.get(n);
            this.writePendingAverage = RJHihPhClprElement.newInteger(hIHsmUseRateBase.getTotalAverage());
            this.writePendingMaximum = RJHihPhClprElement.newInteger(hIHsmUseRateBase.getTotalMax());
            if (hIHsmUseRateBase instanceof HIHsmPhysicalCacheUseRate) {
                this.useRateAverage = RJHihPhClprElement.newInteger(((HIHsmPhysicalCacheUseRate)hIHsmUseRateBase).getTotalCacheAverage());
                this.useRateMaximum = RJHihPhClprElement.newInteger(((HIHsmPhysicalCacheUseRate)hIHsmUseRateBase).getTotalCacheMax());
            }
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof RJHihPhClprElement && this.clprNo == ((RJHihPhClprElement)object).getClprNo()) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        int n = this.clprNo;
        return n;
    }

    public int compareTo(Object object) {
        int n = 0;
        if (object instanceof RJHihPhClprElement) {
            n = this.clprNo - ((RJHihPhClprElement)object).getClprNo();
        }
        return n;
    }

    public RJHihBoolIcon getSelection() {
        return this.selection;
    }

    public void setSelection(boolean bl) {
        this.selection.setValue(bl);
    }

    public int getClprNo() {
        return this.clprNo;
    }

    public String getClprName() {
        return this.clprName;
    }

    public String getEditingName() {
        return super.getEditingName();
    }

    public Integer getRateAverage() {
        return this.useRateAverage;
    }

    public Integer getRateMaximum() {
        return this.useRateMaximum;
    }

    public Integer getWritePendingAverage() {
        return this.writePendingAverage;
    }

    public Integer getWritePendingMaximum() {
        return this.writePendingMaximum;
    }
}

