/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.utility;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

final class ShowHeapSizePanel
extends JPanel {
    private JProgressBar mpgbTotalHeapSize = new JProgressBar();
    private JProgressBar mpgbUsedHeapSize;
    private JLabel mlblMaximumSize;
    private boolean mbProcessRunning;

    ShowHeapSizePanel() {
        this.mpgbTotalHeapSize.setStringPainted(true);
        this.mpgbUsedHeapSize = new JProgressBar();
        this.mpgbUsedHeapSize.setStringPainted(true);
        this.mlblMaximumSize = new JLabel();
        this.mbProcessRunning = true;
        JLabel jLabel = new JLabel("Used Memory : ", 4);
        JLabel jLabel2 = new JLabel("Total Memory : ", 4);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagLayout.addLayoutComponent(jLabel, gridBagConstraints);
        this.add(jLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.addLayoutComponent(this.mpgbUsedHeapSize, gridBagConstraints);
        this.add(this.mpgbUsedHeapSize);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagLayout.addLayoutComponent(jLabel2, gridBagConstraints);
        this.add(jLabel2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.addLayoutComponent(this.mpgbTotalHeapSize, gridBagConstraints);
        this.add(this.mpgbTotalHeapSize);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 3;
        gridBagLayout.addLayoutComponent(this.mlblMaximumSize, gridBagConstraints);
        this.add(this.mlblMaximumSize);
        Thread thread = new Thread("checkingHeapThread"){

            public synchronized void run() {
                while (ShowHeapSizePanel.this.mbProcessRunning) {
                    ShowHeapSizePanel.this.updateHeapSize();
                    try {
                        1.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace(System.err);
                    }
                }
            }
        };
        thread.start();
    }

    private void updateHeapSize() {
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                int n = 1024;
                Runtime runtime = Runtime.getRuntime();
                long l = runtime.freeMemory() / (long)n;
                long l2 = runtime.totalMemory() / (long)n;
                long l3 = runtime.maxMemory() / (long)n;
                long l4 = l2 - l;
                DecimalFormat decimalFormat = new DecimalFormat("#,### KB");
                ShowHeapSizePanel.this.mpgbTotalHeapSize.setMaximum((int)l3);
                ShowHeapSizePanel.this.mpgbTotalHeapSize.setValue((int)l2);
                ShowHeapSizePanel.this.mpgbTotalHeapSize.setString(decimalFormat.format(l2));
                ShowHeapSizePanel.this.mpgbUsedHeapSize.setMaximum((int)l3);
                ShowHeapSizePanel.this.mpgbUsedHeapSize.setValue((int)l4);
                ShowHeapSizePanel.this.mpgbUsedHeapSize.setString(decimalFormat.format(l4));
                ShowHeapSizePanel.this.mlblMaximumSize.setText("Max Memory Size : " + decimalFormat.format(l3));
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void stopCheckThread() {
        this.mbProcessRunning = false;
    }
}

