/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.pool;

import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class RJPoolNumberField
extends JTextField {
    private int min;
    private int max;
    private NumberFormat integerFormatter;
    private int off = 0;
    private int len = 0;

    public RJPoolNumberField() {
        this(10);
    }

    public RJPoolNumberField(int n) {
        this(n, 0, Integer.MAX_VALUE);
    }

    public RJPoolNumberField(int n, int n2, int n3) {
        super(n);
        this.min = n2;
        this.max = n3;
        this.integerFormatter = NumberFormat.getNumberInstance();
        this.integerFormatter.setParseIntegerOnly(true);
        this.setHorizontalAlignment(4);
    }

    public void setMin(int n) {
        this.min = n;
    }

    public void setMax(int n) {
        this.max = n;
    }

    public Integer getValue() {
        Integer n = null;
        try {
            String string = this.getText();
            if (string != null) {
                n = new Integer(this.integerFormatter.parse(string).intValue());
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return n;
    }

    public void setValue(Integer n) {
        if (n != null) {
            this.setValue((int)n);
        }
    }

    public void setValue(int n) {
        this.setText(this.integerFormatter.format(n));
    }

    protected Document createDefaultModel() {
        return new NumberDocument();
    }

    protected boolean isRange(int n, String string) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(this.getText());
        stringBuffer = stringBuffer.insert(n, string);
        try {
            int n2 = Integer.parseInt(stringBuffer.toString());
            if (n2 >= this.min && n2 <= this.max) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bl;
    }

    private boolean checkWidth(int n) {
        boolean bl = false;
        if (this.getText().length() + n >= this.getColumns()) {
            bl = true;
        }
        return bl;
    }

    protected class NumberDocument
    extends PlainDocument {
        protected NumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string != null && !string.equals("")) {
                if (attributeSet == null) {
                    RJPoolNumberField.this.len = 0;
                    for (int i = 0; i < string.length(); ++i) {
                        char c = string.charAt(i);
                        String string2 = string.substring(0, i + 1);
                        if (Character.UnicodeBlock.of(c) == Character.UnicodeBlock.BASIC_LATIN && Character.isDigit(c) && !RJPoolNumberField.this.checkWidth(i) && RJPoolNumberField.this.isRange(n, string2)) continue;
                        string = string.substring(0, i);
                        break;
                    }
                } else {
                    RJPoolNumberField.this.off = n;
                    RJPoolNumberField.this.len = string.length();
                }
                super.insertString(n, string, attributeSet);
            }
        }
    }
}

