/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.profiles.common;

import com.ws.wbem.profiles.common.IndicationHandler;
import java.util.concurrent.ConcurrentHashMap;
import javax.wbem.WBEMException;

public class IndicationManager {
    private final IndicationHandler mImplementation;
    private final ConcurrentHashMap<String, Integer> mSubscriptionList;

    public static String collapseSpaces(String string) {
        return string.replaceAll("\\s+", " ").trim();
    }

    public IndicationManager(IndicationHandler indicationHandler) {
        this.mImplementation = indicationHandler;
        this.mSubscriptionList = new ConcurrentHashMap();
    }

    public synchronized int activate(String string) {
        String string2 = IndicationManager.collapseSpaces(string);
        int n = 1;
        Integer n2 = this.mSubscriptionList.get(string2);
        if (null != n2) {
            n = n2 + 1;
        }
        this.mSubscriptionList.put(string2, new Integer(n));
        return n;
    }

    public void authorize(String string) throws WBEMException {
        String string2 = IndicationManager.collapseSpaces(string);
        if (null == string2) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = this.mImplementation.getSupportedIndications();
        if (null != stringArray) {
            for (String string3 : stringArray) {
                if (!string3.equalsIgnoreCase(string2)) continue;
                return;
            }
        }
        throw new WBEMException(7);
    }

    public synchronized int deactivate(String string) {
        String string2 = IndicationManager.collapseSpaces(string);
        int n = 0;
        Integer n2 = this.mSubscriptionList.get(string2);
        if (null != n2 && n2 > 1) {
            n = n2 - 1;
        }
        if (0 == n) {
            this.mSubscriptionList.remove(string2);
        } else {
            this.mSubscriptionList.put(string2, new Integer(n));
        }
        return n;
    }
}

