/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.profiles.dmtf.recordlog;

import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.JServerTraceProperties;
import com.ws.wbem.profiles.dmtf.recordlog.Record;
import com.ws.wbem.profiles.dmtf.recordlog.RecordConsumerIF;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.wbem.WBEMException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class RecordLogProfileUtils
extends DefaultHandler
implements FilenameFilter {
    private static final String REPLACE_VALUE = "{0}";
    private static final String DEFAULT_DIR = "." + File.separator;
    public static final String JSERVER_PROP_FILE = "jserver.properties";
    public static final String JSERVER_TRACE_FILE = "jservertrace.properties";
    private static final String ERR_LOG_FILE_NOT_FOUND = "Unable to locate log file directory: ";
    public static final String PROCESSING_RECORDS_STOPPED = "Processing records stopped.";
    private StringBuffer mTextBuffer;
    private StringBuffer mExceptionBuffer = null;
    private String mFilePath;
    private RecordConsumerIF mRecordConsumer;
    private long mRecourdCounter = 0L;
    private Record mTempRecord;

    protected static String getLogFileDirectory() throws WBEMException {
        String string = JServerTraceProperties.getLogFileDirectory();
        if (null != string) {
            if (string.contains(REPLACE_VALUE)) {
                String string2 = JServerProperties.getBasedir();
                string = string.replace(REPLACE_VALUE, string2);
            }
        } else {
            string = DEFAULT_DIR;
        }
        return string;
    }

    protected static List<String> getLogFiles(String string) throws Exception {
        ArrayList<String> arrayList = null;
        if (null != string && !string.isEmpty()) {
            File file = new File(string);
            if (file.exists()) {
                String[] stringArray = file.list(new RecordLogProfileUtils());
                arrayList = new ArrayList<String>(stringArray.length);
                for (String string2 : stringArray) {
                    arrayList.add(string + File.separator + string2);
                }
            } else {
                throw new Exception(ERR_LOG_FILE_NOT_FOUND + file.getCanonicalPath());
            }
        }
        return arrayList;
    }

    protected static boolean getLogs(String string, RecordConsumerIF recordConsumerIF) throws WBEMException {
        RecordLogProfileUtils recordLogProfileUtils = new RecordLogProfileUtils(string, recordConsumerIF);
        return recordLogProfileUtils.parseDocument();
    }

    protected static String getRecordLogClassName() {
        return JServerSettings.replaceSchemaClassName((String)"WS_JRecordLog");
    }

    protected static String getSchemaName() {
        return JServerProperties.getSchemaName();
    }

    private RecordLogProfileUtils() {
    }

    private RecordLogProfileUtils(String string, RecordConsumerIF recordConsumerIF) throws WBEMException {
        this.mFilePath = string;
        this.mRecordConsumer = recordConsumerIF;
        if (null == this.mRecordConsumer) {
            throw new WBEMException("Invalid RecordConsumerIF passed in");
        }
    }

    @Override
    public boolean accept(File file, String string) {
        String string2;
        String string3;
        try {
            String string4 = JServerTraceProperties.getLogFileName();
            string3 = string4.substring(0, string4.lastIndexOf(46));
            string2 = string4.substring(string4.lastIndexOf(46), string4.length());
        }
        catch (Exception exception) {
            return false;
        }
        return string.contains(string3) && string.endsWith(string2);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.mTextBuffer.length() < 1027) {
            int n3 = 1024 - this.mTextBuffer.length();
            String string = new String(cArray, n, n2 > n3 ? n3 : n2);
            this.mTextBuffer.append(string);
            if (n2 > n3) {
                this.mTextBuffer.append("...");
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        block33: {
            if (string3.equalsIgnoreCase("record")) {
                this.mTempRecord.setRecord(String.valueOf(this.mRecourdCounter));
                try {
                    if (!this.mRecordConsumer.consumeRecord(this.mFilePath, this.mTempRecord)) {
                        throw new SAXException(new Exception(PROCESSING_RECORDS_STOPPED));
                    }
                    break block33;
                }
                catch (Exception exception) {
                    throw new SAXException(new Exception("Error on consuming record."));
                }
            }
            if (string3.equalsIgnoreCase("level")) {
                this.mTempRecord.setLevel(this.mTextBuffer.toString());
            } else if (string3.equalsIgnoreCase("date")) {
                this.mTempRecord.setDate(this.mTextBuffer.toString());
            } else if (string3.equalsIgnoreCase("thread")) {
                this.mTempRecord.setThread(this.mTextBuffer.toString());
            } else if (string3.equalsIgnoreCase("logger")) {
                this.mTempRecord.setLogger(this.mTextBuffer.toString());
            } else if (string3.equalsIgnoreCase("millis")) {
                this.mTempRecord.setMilli(this.mTextBuffer.toString());
            } else if (string3.equalsIgnoreCase("method")) {
                if (null != this.mExceptionBuffer) {
                    this.mExceptionBuffer.append(this.mTextBuffer.toString() + "</method>");
                } else {
                    this.mTempRecord.setMethod(this.mTextBuffer.toString());
                }
            } else if (string3.equalsIgnoreCase("sequence")) {
                this.mTempRecord.setSequence(this.mTextBuffer.toString());
            } else if (string3.equalsIgnoreCase("class")) {
                if (null != this.mExceptionBuffer) {
                    this.mExceptionBuffer.append(this.mTextBuffer.toString() + "</class>");
                } else {
                    this.mTempRecord.setClass(this.mTextBuffer.toString());
                }
            } else if (string3.equalsIgnoreCase("message")) {
                if (null != this.mExceptionBuffer) {
                    this.mExceptionBuffer.append(this.mTextBuffer.toString() + "</message>");
                } else {
                    this.mTempRecord.setMessage(this.mTextBuffer.toString());
                }
            } else if (string3.equalsIgnoreCase("exception")) {
                this.mTempRecord.setException(this.mExceptionBuffer.toString());
                this.mExceptionBuffer = null;
            } else if (string3.equalsIgnoreCase("frame")) {
                this.mTextBuffer.append(this.mTextBuffer.toString() + "\n</frame>");
            } else if (string3.equalsIgnoreCase("line")) {
                this.mTextBuffer.append(this.mTextBuffer.toString() + "</line>");
            }
        }
    }

    public boolean parseDocument() throws WBEMException {
        boolean bl = true;
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            File file = new File(this.mFilePath);
            xMLReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            xMLReader.setFeature("http://xml.org/sax/features/validation", false);
            this.mRecourdCounter = 0L;
            sAXParser.parse(file, (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            bl = !sAXException.getMessage().equals(PROCESSING_RECORDS_STOPPED) ? false : false;
        }
        catch (Exception exception) {
            throw new WBEMException(1, exception.getMessage());
        }
        return bl;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.mTextBuffer = new StringBuffer();
        if (string3.equalsIgnoreCase("record")) {
            ++this.mRecourdCounter;
            this.mTempRecord = new Record();
        } else if (string3.equalsIgnoreCase("exception")) {
            this.mExceptionBuffer = new StringBuffer();
        } else if (string3.equalsIgnoreCase("message")) {
            if (null != this.mExceptionBuffer) {
                this.mExceptionBuffer.append("<message>");
            }
        } else if (string3.equalsIgnoreCase("class")) {
            if (null != this.mExceptionBuffer) {
                this.mExceptionBuffer.append("\n<class>");
            }
        } else if (string3.equalsIgnoreCase("method")) {
            if (null != this.mExceptionBuffer) {
                this.mExceptionBuffer.append("\n<method>");
            }
        } else if (string3.equalsIgnoreCase("frame")) {
            this.mExceptionBuffer.append("\n<frame>");
        } else if (string3.equalsIgnoreCase("line")) {
            this.mExceptionBuffer.append("\n<line>");
        }
    }
}

