/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com;

import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class RJComTextField
extends JTextField {
    public static final boolean ON = true;
    public static final boolean OFF = false;
    public static final short ALPHABETIC = 1;
    public static final short NUMERIC = 2;
    public static final short HEXADECIMAL = 4;
    public static final short SPACE_UBAR = 8;
    public static final short SPACE = 16;
    public static final short UNDERBAR = 32;
    public static final short HYPHEN = 64;
    public static final short PERIOD = 128;
    static final int MAX_LEN = 65536;
    private boolean editChk = false;
    private boolean updFlg = false;
    private Toolkit toolkit;
    private int min = 0;
    private int max = 65536;
    private short chkStr = 0;
    private RJComTextField textField;
    private KeyListener keyListener = null;

    public RJComTextField() {
        this.setDocument(new WholeNumberDocument());
        this.textField = this;
    }

    public RJComTextField(short s) {
        this.setChkStr(s);
        this.setDocument(new WholeNumberDocument());
        this.textField = this;
    }

    public RJComTextField(short s, boolean bl) {
        this.setChkStr(s);
        this.setDocument(new WholeNumberDocument());
        this.textField = this;
        this.setEditChk(bl);
    }

    private void textField_keyPressed(KeyEvent keyEvent) {
        if (!this.isEditable()) {
            keyEvent.consume();
            return;
        }
        int n = keyEvent.getKeyCode();
        if (n == 8) {
            if (this.getCaretPosition() - 1 >= 0) {
                this.setForeground(Color.blue);
                this.setUpdFlg(true);
            }
            return;
        }
        if (n == 127) {
            if (this.getCaretPosition() == this.getText().length()) {
                keyEvent.consume();
                return;
            }
        } else {
            if (n == 10) {
                keyEvent.consume();
                return;
            }
            return;
        }
        this.setForeground(Color.blue);
        this.setUpdFlg(true);
    }

    public void putText(String string) {
        this.setText(string);
        this.setCaretPosition(0);
        this.setUpdFlg(false);
        this.textField.setForeground(Color.black);
    }

    public void setUpdFlg(boolean bl) {
        if (bl) {
            this.setFont(new Font(this.getFont().getName(), 3, this.getFont().getSize()));
        } else {
            this.setFont(new Font(this.getFont().getName(), 0, this.getFont().getSize()));
        }
        this.updFlg = bl;
    }

    public boolean getUpdFlg() {
        return this.updFlg;
    }

    public void setEditChk(boolean bl) {
        this.editChk = bl;
        if (this.editChk) {
            if (this.keyListener == null) {
                this.keyListener = this.makeLister();
            }
            this.addKeyListener(this.keyListener);
        } else {
            this.removeKeyListener(this.keyListener);
        }
    }

    public void setMaxLen(int n) {
        this.max = n > 65536 ? 65536 : (n < this.min ? this.min : n);
    }

    public void setMinLen(int n) {
        this.min = n < 0 ? 0 : (n > this.max ? this.max : n);
    }

    public void setChkStr(short s) {
        this.chkStr = s;
    }

    private KeyListener makeLister() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                RJComTextField.this.textField_keyPressed(keyEvent);
            }
        };
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        protected WholeNumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            int n2;
            if (RJComTextField.this.textField == null || string == null) {
                return;
            }
            if (this.getLength() > RJComTextField.this.max || this.getLength() < RJComTextField.this.min) {
                return;
            }
            if (RJComTextField.this.textField.getText().length() + string.length() > RJComTextField.this.max) {
                return;
            }
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n3 = 0;
            for (n2 = 0; n2 < cArray2.length; ++n2) {
                int n4 = -1;
                if (RJComTextField.this.chkStr != 0) {
                    if ((RJComTextField.this.chkStr & 1) == 1 && (cArray[n2] >= 'a' && cArray[n2] <= 'z' || cArray[n2] >= 'A' && cArray[n2] <= 'Z')) {
                        n4 = 0;
                    }
                    if ((RJComTextField.this.chkStr & 2) == 2 && cArray[n2] >= '0' && cArray[n2] <= '9') {
                        n4 = 0;
                    }
                    if ((RJComTextField.this.chkStr & 4) == 4 && (cArray[n2] >= 'a' && cArray[n2] <= 'f' || cArray[n2] >= 'A' && cArray[n2] <= 'F' || cArray[n2] >= '0' && cArray[n2] <= '9')) {
                        n4 = 0;
                    }
                    if ((RJComTextField.this.chkStr & 8) == 8 && (cArray[n2] == ' ' || cArray[n2] == '_')) {
                        n4 = 0;
                    }
                    if ((RJComTextField.this.chkStr & 0x10) == 16 && cArray[n2] == ' ') {
                        n4 = 0;
                    }
                    if ((RJComTextField.this.chkStr & 0x20) == 32 && cArray[n2] == '_') {
                        n4 = 0;
                    }
                    if ((RJComTextField.this.chkStr & 0x40) == 64 && cArray[n2] == '-') {
                        n4 = 0;
                    }
                    if ((RJComTextField.this.chkStr & 0x80) == 128 && cArray[n2] == '.') {
                        n4 = 0;
                    }
                } else {
                    n4 = 0;
                }
                if (n4 != 0) continue;
                cArray2[n3++] = cArray[n2];
                if (!RJComTextField.this.editChk) continue;
                RJComTextField.this.textField.setForeground(Color.blue);
                RJComTextField.this.textField.setUpdFlg(true);
            }
            if (n2 == n3) {
                super.insertString(n, new String(cArray2, 0, n3), attributeSet);
            }
        }
    }
}

