/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com.restoreview.light;

import java.awt.Component;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import sanproject.client.com.restoreview.TreeComponentParser;
import sanproject.client.com.restoreview.UnsupportedComponentException;
import sanproject.client.com.restoreview.light.LightTreeViewRestorer;
import sanproject.client.com.restoreview.utility.CollectionUtilities;
import sanproject.client.com.restoreview.utility.TreeComponentUtilities;

public class LightTreeComponentParser
implements TreeComponentParser {
    private JTree analysisComponent = null;
    private Map analysisPathMap = new HashMap(0);

    public synchronized TreePath searchTreeNode(TreePath treePath) {
        String string;
        JTree jTree;
        TreePath treePath2 = null;
        if (treePath != null && (jTree = (JTree)this.getAnalysisComponent()) != null && this.analysisPathMap.containsKey(string = this.createPathMapKey(treePath))) {
            treePath2 = (TreePath)this.analysisPathMap.get(string);
        }
        return treePath2;
    }

    public synchronized void setAnalysisComponent(Component component) throws UnsupportedComponentException {
        int n;
        if (component != null && !(component instanceof JTree)) {
            String string = "Any components other than 'javax.swing.JTree' are not supported.";
            throw new UnsupportedComponentException(string);
        }
        this.analysisComponent = (JTree)component;
        long l = System.currentTimeMillis();
        Map map = this.createPathMap(this.analysisComponent);
        if (map == null || map.isEmpty()) {
            this.analysisPathMap.clear();
            n = 0;
        } else {
            this.analysisPathMap = new HashMap(map);
            n = map.size();
        }
        this.debugPrint("path map : create time=" + (System.currentTimeMillis() - l) + "ms. " + "size=" + n);
    }

    protected synchronized Component getAnalysisComponent() {
        JTree jTree = this.analysisComponent;
        return jTree;
    }

    protected Map createPathMap(JTree jTree) {
        HashMap hashMap = null;
        if (jTree != null) {
            int n = TreeComponentUtilities.getAllNodeCount(jTree);
            int n2 = CollectionUtilities.getHashModerateSize(n);
            hashMap = new HashMap(n2);
            TreeModel treeModel = jTree.getModel();
            TreeNode treeNode = (TreeNode)treeModel.getRoot();
            this.createChildrenPathMap(hashMap, treeNode);
        }
        return hashMap;
    }

    protected void createChildrenPathMap(Map map, TreeNode treeNode) {
        if (map != null && treeNode != null) {
            TreePath treePath = TreeComponentUtilities.createTreePath(treeNode);
            String string = this.createPathMapKey(treePath);
            if (map.containsKey(string)) {
                System.err.println("found overlapping key [" + string + "].");
            } else {
                map.put(string, treePath);
            }
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                this.createChildrenPathMap(map, treeNode2);
            }
        }
    }

    protected String createPathMapKey(TreePath treePath) {
        String string = null;
        if (treePath != null) {
            string = treePath.toString();
        }
        return string;
    }

    public void debugPrint(String string) {
        String string2 = this.getClass().getName();
        LightTreeViewRestorer.debugPrint("<" + string2 + ">" + string);
    }
}

