/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com.restoreview.light;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import sanproject.client.com.restoreview.ComponentParser;
import sanproject.client.com.restoreview.ExpansionTreeComponentParser;
import sanproject.client.com.restoreview.TreeComponentParser;
import sanproject.client.com.restoreview.UnsupportedComponentException;
import sanproject.client.com.restoreview.UnsupportedRestoreModeException;
import sanproject.client.com.restoreview.ViewRestorer;
import sanproject.client.com.restoreview.utility.CollectionUtilities;
import sanproject.client.com.restoreview.utility.TreeComponentUtilities;

public class LightTreeViewRestorer
implements ViewRestorer {
    public static final int TREE_EXPAND_ONLY_SELECTION_RESTORE = 16;
    public static final int TREE_EXPAND_ALL_RESTORE = 32;
    public static final int TREE_EXPAND_COMPLETENESS_RESTORE = 64;
    public static final int TREE_EXPAND_MAINTENANCE_RESTORE = 128;
    private int restoreMode = 0;
    private TreeComponentParser componentParser = null;
    private Set selectionSet = new HashSet();
    private Set expandedSet = new HashSet();

    public LightTreeViewRestorer() {
        this.initInstance();
    }

    public void saveViewComponent(Component component) throws UnsupportedComponentException {
        if (component != null) {
            if (!(component instanceof JTree)) {
                String string = "Any components other than 'javax.swing.JTree' are not supported.";
                throw new UnsupportedComponentException(string);
            }
            try {
                TreePath treePath;
                int n;
                JTree jTree = (JTree)component;
                LightTreeViewRestorer.debugPrint("<" + this.getClass().getName() + ">execute save...");
                long l = System.currentTimeMillis();
                TreePath[] treePathArray = jTree.getSelectionPaths();
                if (treePathArray != null && treePathArray.length > 0) {
                    n = CollectionUtilities.getHashModerateSize(treePathArray.length);
                    this.selectionSet = new HashSet(n);
                    for (int i = 0; i < treePathArray.length; ++i) {
                        treePath = treePathArray[i];
                        TreePath treePath2 = this.createIdentifier(treePath);
                        boolean bl = this.selectionSet.add(treePath2);
                        if (bl) continue;
                        System.err.println("found same identifier : " + treePath2);
                    }
                }
                this.expandedSet.clear();
                int n2 = jTree.getRowCount();
                for (n = 0; n < n2; ++n) {
                    if (!jTree.isExpanded(n)) continue;
                    TreePath treePath3 = jTree.getPathForRow(n);
                    treePath = this.createIdentifier(treePath3);
                    this.expandedSet.add(treePath);
                }
                LightTreeViewRestorer.debugPrint("<" + this.getClass().getName() + ">save : " + (System.currentTimeMillis() - l) + "ms.");
            }
            catch (Exception exception) {
                System.err.println("[Light Tree]Save View Failure");
                exception.printStackTrace();
                this.releaseSavedViewComponent();
            }
        }
    }

    public void restoreViewComponent(Component component) throws UnsupportedComponentException {
        block14: {
            if (component != null) {
                if (!(component instanceof JTree)) {
                    String string = "Any components other than 'javax.swing.JTree' are not supported.";
                    throw new UnsupportedComponentException(string);
                }
                try {
                    TreePath treePath;
                    Iterator iterator;
                    if (!this.hasSavedViewComponent()) break block14;
                    LightTreeViewRestorer.debugPrint("<" + this.getClass().getName() + ">execute restore " + " [mode=" + Integer.toHexString(this.restoreMode) + "]...");
                    long l = System.currentTimeMillis();
                    JTree jTree = (JTree)component;
                    TreeComponentParser treeComponentParser = (TreeComponentParser)this.getComponentParser();
                    treeComponentParser.setAnalysisComponent(jTree);
                    if (this.isSpecified(64)) {
                        TreeComponentUtilities.collapseAllNodes(jTree);
                    }
                    jTree.clearSelection();
                    if (this.isSpecified(1)) {
                        iterator = this.selectionSet.iterator();
                        while (iterator.hasNext()) {
                            treePath = (TreePath)iterator.next();
                            TreePath treePath2 = treeComponentParser.searchTreeNode(treePath);
                            if (treePath2 == null) continue;
                            TreeComponentUtilities.expandNode(jTree, treePath2);
                            jTree.addSelectionPath(treePath2);
                        }
                    }
                    LightTreeViewRestorer.debugPrint("<" + this.getClass().getName() + ">restore [step1]: " + (System.currentTimeMillis() - l) + "ms.");
                    iterator = this.expandedSet.iterator();
                    while (iterator.hasNext()) {
                        TreePath treePath3;
                        treePath = (TreePath)iterator.next();
                        boolean bl = false;
                        if (this.isSpecified(16)) {
                            if (this.selectionSet.contains(treePath)) {
                                bl = true;
                            }
                        } else if (this.isSpecified(32)) {
                            bl = true;
                        }
                        if (!bl || (treePath3 = treeComponentParser.searchTreeNode(treePath)) == null) continue;
                        TreeComponentUtilities.expandNode(jTree, treePath3);
                    }
                    LightTreeViewRestorer.debugPrint("<" + this.getClass().getName() + ">restore [step2]: " + (System.currentTimeMillis() - l) + "ms.");
                    try {
                        treeComponentParser.setAnalysisComponent(null);
                    }
                    catch (UnsupportedComponentException unsupportedComponentException) {
                        // empty catch block
                    }
                    LightTreeViewRestorer.debugPrint("<" + this.getClass().getName() + ">restore : " + (System.currentTimeMillis() - l) + "ms.");
                }
                catch (Exception exception) {
                    System.err.println("[Light Tree]Restore View Failure");
                    exception.printStackTrace();
                }
            }
        }
    }

    public void setRestoreMode(int n) throws UnsupportedRestoreModeException {
        if (!this.isSupportedRestoreMode(n)) {
            String string = "The parameter which is not supported was specified [" + n + "].";
            throw new UnsupportedRestoreModeException(string);
        }
        this.restoreMode = n;
    }

    public int getRestoreMode() {
        int n = this.restoreMode;
        return n;
    }

    public void setComponentParser(ComponentParser componentParser) throws IllegalArgumentException {
        if (!(componentParser instanceof TreeComponentParser)) {
            String string = "Any components other than 'restoreview.TreeComponentParser' are not supported.";
            throw new IllegalArgumentException(string);
        }
        this.componentParser = (TreeComponentParser)componentParser;
    }

    public ComponentParser getComponentParser() {
        TreeComponentParser treeComponentParser = this.componentParser;
        return treeComponentParser;
    }

    public boolean isSupportedRestoreMode(int n) {
        int n2 = n;
        n2 &= 0xFFFFFFFE;
        n2 &= 0xFFFFFFDF;
        n2 &= 0xFFFFFFEF;
        n2 &= 0xFFFFFFBF;
        boolean bl = (n2 &= 0xFFFFFF7F) == 0;
        return bl;
    }

    public boolean hasSavedViewComponent() {
        boolean bl = true;
        if (this.selectionSet.isEmpty() && this.expandedSet.isEmpty()) {
            bl = false;
        }
        return bl;
    }

    public void releaseSavedViewComponent() {
        this.selectionSet.clear();
        this.expandedSet.clear();
    }

    protected void initInstance() {
        int n = 0;
        n |= 1;
        n |= 0x10;
        n |= 0x80;
        try {
            this.setRestoreMode(n);
        }
        catch (UnsupportedRestoreModeException unsupportedRestoreModeException) {
            throw new RuntimeException();
        }
        this.componentParser = new ExpansionTreeComponentParser();
    }

    protected boolean isSpecified(int n) {
        int n2 = this.getRestoreMode();
        boolean bl = (n2 & n) > 0;
        return bl;
    }

    protected TreePath createIdentifier(TreePath treePath) {
        int n = treePath.getPathCount();
        Object[] objectArray = treePath.getPath();
        Object[] objectArray2 = new Object[n];
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            if (object instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                objectArray2[i] = defaultMutableTreeNode.clone();
                continue;
            }
            objectArray2[i] = object.toString();
        }
        TreePath treePath2 = new TreePath(objectArray2);
        return treePath2;
    }

    public static void debugPrint(String string) {
        if (LightTreeViewRestorer.isDebugMode()) {
            System.err.println(string);
        }
    }

    public static boolean isDebugMode() {
        String string = System.getProperty("WebConsole.viewrestorer.debug");
        Object object = Boolean.valueOf(string);
        boolean bl = (Boolean)object;
        object = System.getProperty("WebConsole.viewrestorer.tree.debug");
        Boolean bl2 = Boolean.valueOf((String)object);
        boolean bl3 = bl2;
        boolean bl4 = bl || bl3;
        return bl4;
    }
}

