/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.com;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import sanproject.client.com.RJcElement;
import sanproject.client.com.RJcTablePanel;
import sanproject.client.com.RJcTreePanel;
import sanproject.client.com.abs.RJaContainMenu;
import sanproject.client.com.abs.RJaTreeNode;
import sanproject.client.com.restoreview.ViewRestorer;
import sanproject.client.com.restoreview.light.LightTreeViewRestorer;
import sanproject.client.exdevice.com.AbstractElement;
import sanproject.client.exdevice.event.ElementEvent;
import sanproject.client.exdevice.event.ElementListener;

public class AbstractTreePanel
extends RJcTreePanel {
    private transient Set elementListeners = new HashSet();
    private transient ElementListener allElementsListener = new ElementListener(){

        public void stateChanged(ElementEvent elementEvent) {
            AbstractTreePanel.this.fireStateChanged(elementEvent);
        }
    };
    private transient ViewRestorer restorer = new LightTreeViewRestorer();
    private JPanel detailPanel = null;

    public void refreshTree() {
        Object[] objectArray;
        Object object;
        Serializable serializable = this.getTree();
        this.restorer.saveViewComponent((Component)serializable);
        serializable = this.getRootNode();
        if (serializable != null && (object = ((DefaultMutableTreeNode)serializable).getUserObject()) instanceof AbstractElement) {
            objectArray = (Object[])object;
            objectArray.removeChildElements();
        }
        super.refreshTree();
        object = this.getTree();
        this.restorer.restoreViewComponent((Component)object);
        object = this.getSelectionNode();
        if (object == null && serializable != null) {
            objectArray = ((DefaultMutableTreeNode)serializable).getPath();
            TreePath treePath = new TreePath(objectArray);
            this.tree.setSelectionPath(treePath);
        }
        this.expandRoot();
    }

    public RJaTreeNode addObject(RJaTreeNode rJaTreeNode, Object object, boolean bl) {
        RJaTreeNode rJaTreeNode2 = super.addObject(rJaTreeNode, object, bl);
        if (object instanceof AbstractElement) {
            AbstractElement abstractElement = (AbstractElement)object;
            abstractElement.addElementListener(this.allElementsListener);
        }
        return rJaTreeNode2;
    }

    public void setRootObject(Object object) {
        AbstractElement abstractElement;
        RJaTreeNode rJaTreeNode = this.getRootNode();
        Object object2 = rJaTreeNode.getUserObject();
        if (object2 instanceof AbstractElement) {
            abstractElement = (AbstractElement)object2;
            abstractElement.removeChildElements();
            abstractElement.removeFromParentElement();
            abstractElement.removeElementListener(this.allElementsListener);
        }
        if (object instanceof AbstractElement) {
            abstractElement = (AbstractElement)object;
            abstractElement.addElementListener(this.allElementsListener);
        }
        super.setRootObject(object);
    }

    public void setTablePanel(RJcTablePanel rJcTablePanel) {
        super.setTablePanel(rJcTablePanel);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        RJcElement rJcElement;
        boolean bl;
        int n;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        JTree jTree = (JTree)mouseEvent.getSource();
        jTree.requestFocus();
        if (SwingUtilities.isRightMouseButton(mouseEvent) && (n = this.tree.getRowForLocation(n2, n3)) != -1 && !(bl = this.tree.isRowSelected(n))) {
            this.tree.setSelectionRow(n);
        }
        if (mouseEvent.isPopupTrigger() && (rJcElement = this.getSelectionElement()) instanceof RJaContainMenu) {
            RJaTreeNode rJaTreeNode = this.getSelectionNode();
            RJaContainMenu rJaContainMenu = (RJaContainMenu)((Object)rJcElement);
            rJaContainMenu.showMenu(this.tree, n2, n3, this.treeModel, rJaTreeNode);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mousePressed(mouseEvent);
    }

    public RJaTreeNode getSelectionNode() {
        TreePath treePath = this.tree.getSelectionPath();
        RJaTreeNode rJaTreeNode = null;
        if (treePath != null) {
            rJaTreeNode = (RJaTreeNode)treePath.getLastPathComponent();
        }
        return rJaTreeNode;
    }

    public RJcElement getSelectionElement() {
        RJaTreeNode rJaTreeNode = this.getSelectionNode();
        RJcElement rJcElement = null;
        if (rJaTreeNode != null) {
            rJcElement = (RJcElement)rJaTreeNode.getUserObject();
        }
        return rJcElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElementListener(ElementListener elementListener) {
        if (!this.elementListeners.contains(elementListener)) {
            Set set = this.elementListeners;
            synchronized (set) {
                this.elementListeners.add(elementListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElementListener(ElementListener elementListener) {
        if (this.elementListeners.contains(elementListener)) {
            Set set = this.elementListeners;
            synchronized (set) {
                this.elementListeners.remove(elementListener);
            }
        }
    }

    public void setDetailPanel(JPanel jPanel) {
        this.detailPanel = jPanel;
    }

    public JPanel getDetailPanel() {
        JPanel jPanel = this.detailPanel;
        return jPanel;
    }

    protected void initTree() {
        super.initTree();
        Border border = BorderFactory.createEmptyBorder(2, 4, 2, 4);
        JTree jTree = this.getTree();
        jTree.setBorder(border);
        jTree.addMouseListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStateChanged(ElementEvent elementEvent) {
        if (!this.elementListeners.isEmpty()) {
            HashSet hashSet;
            Object object = this.elementListeners;
            synchronized (object) {
                hashSet = new HashSet(this.elementListeners);
            }
            object = hashSet.iterator();
            while (object.hasNext()) {
                ElementListener elementListener = (ElementListener)object.next();
                elementListener.stateChanged(elementEvent);
            }
        }
    }
}

