/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import sanproject.client.com.RJComCHA;
import sanproject.common.Robj_interface_RJiCHAInfoDetail;
import sanproject.common.Robj_interface_RJiPortAttributeInfoDetail;
import sanproject.common.Robj_interface_RJiPortIndex;
import sanproject.common.Robj_interface_RJiPortInfoDetail;
import sanproject.serverux.dataimpl.RJiCHAInfoDetail;
import sanproject.serverux.dataimpl.RJiPortIndex;

public class CHAUtility {
    private static final byte CHA_MODE_UNKNOWN = -1;
    private static final byte CHA_MODE_BIT = 0;
    private static final byte CHA_MODE_NORMAL = 1;
    private static final byte CHA_MODE_HIGHSPEED = 2;
    private static final byte CHA_MODE_UNFIX = 3;
    private static final byte CHA_MODE_RESERVE = 4;
    public static final int SPEED_UNKNOWN = -1;
    public static final int SPEED_STD = 1;
    public static final int SPEED_HIGH = 2;
    public static final int SPEED_MIX = 258;
    public static final Comparator CHA_INFO_COMP = new Comparator(){

        public int compare(Object object, Object object2) {
            Robj_interface_RJiCHAInfoDetail robj_interface_RJiCHAInfoDetail = (Robj_interface_RJiCHAInfoDetail)object;
            Robj_interface_RJiCHAInfoDetail robj_interface_RJiCHAInfoDetail2 = (Robj_interface_RJiCHAInfoDetail)object2;
            int n = CHAUtility.makeChaInfoValue(robj_interface_RJiCHAInfoDetail.getSCHAClusterNumber(), robj_interface_RJiCHAInfoDetail.getSCHANumber());
            int n2 = CHAUtility.makeChaInfoValue(robj_interface_RJiCHAInfoDetail2.getSCHAClusterNumber(), robj_interface_RJiCHAInfoDetail2.getSCHANumber());
            return n - n2;
        }
    };

    private static int makeChaInfoValue(short s, short s2) {
        return s << 8 | s2;
    }

    public static boolean isHighSpeedMode(Robj_interface_RJiPortIndex robj_interface_RJiPortIndex, Robj_interface_RJiCHAInfoDetail robj_interface_RJiCHAInfoDetail) {
        return false;
    }

    public static int getChaMode(Robj_interface_RJiPortAttributeInfoDetail[] robj_interface_RJiPortAttributeInfoDetailArray, Robj_interface_RJiCHAInfoDetail robj_interface_RJiCHAInfoDetail) {
        int n = -1;
        if (robj_interface_RJiPortAttributeInfoDetailArray != null && robj_interface_RJiPortAttributeInfoDetailArray.length > 0 && robj_interface_RJiCHAInfoDetail != null && CHAUtility.isKeyPort((Robj_interface_RJiPortIndex)robj_interface_RJiPortAttributeInfoDetailArray[0], robj_interface_RJiCHAInfoDetail)) {
            if (CHAUtility.isHighSpeedMode((Robj_interface_RJiPortIndex)robj_interface_RJiPortAttributeInfoDetailArray[0], robj_interface_RJiCHAInfoDetail)) {
                n = 2;
                byte by = robj_interface_RJiPortAttributeInfoDetailArray[0].getByPortKind();
                for (int i = 0; i < robj_interface_RJiPortAttributeInfoDetailArray.length; ++i) {
                    if (by == robj_interface_RJiPortAttributeInfoDetailArray[i].getByPortKind()) continue;
                    n = 258;
                    break;
                }
            } else {
                n = 1;
            }
        }
        return n;
    }

    public static Robj_interface_RJiPortIndex[] getIntensivePorts(Robj_interface_RJiPortIndex robj_interface_RJiPortIndex, Robj_interface_RJiCHAInfoDetail robj_interface_RJiCHAInfoDetail) {
        RJiPortIndex[] rJiPortIndexArray = new RJiPortIndex[]{};
        if (robj_interface_RJiPortIndex != null && robj_interface_RJiCHAInfoDetail != null && CHAUtility.isKeyPort(robj_interface_RJiPortIndex, robj_interface_RJiCHAInfoDetail)) {
            int n = 1;
            short s = 1;
            rJiPortIndexArray = new RJiPortIndex[n];
            short s2 = robj_interface_RJiPortIndex.getSPort();
            for (int i = 0; i < rJiPortIndexArray.length; ++i) {
                rJiPortIndexArray[i] = new RJiPortIndex();
                rJiPortIndexArray[i].setSPort(s2);
                s2 = (short)(s2 + s);
            }
        }
        return rJiPortIndexArray;
    }

    public static boolean isKeyPort(Robj_interface_RJiPortIndex robj_interface_RJiPortIndex, Robj_interface_RJiCHAInfoDetail robj_interface_RJiCHAInfoDetail) {
        return true;
    }

    public static Robj_interface_RJiCHAInfoDetail searchChaInfoDetail(Robj_interface_RJiPortIndex robj_interface_RJiPortIndex, Robj_interface_RJiCHAInfoDetail[] robj_interface_RJiCHAInfoDetailArray) {
        Robj_interface_RJiCHAInfoDetail robj_interface_RJiCHAInfoDetail = null;
        if (robj_interface_RJiPortIndex != null && robj_interface_RJiCHAInfoDetailArray != null) {
            RJiCHAInfoDetail rJiCHAInfoDetail = new RJiCHAInfoDetail();
            short s = robj_interface_RJiPortIndex.getSPort();
            rJiCHAInfoDetail.sCHAClusterNumber = RJComCHA.getPortToCluster(s);
            rJiCHAInfoDetail.sCHANumber = RJComCHA.getPortToCHANumber(s);
            int n = Arrays.binarySearch(robj_interface_RJiCHAInfoDetailArray, rJiCHAInfoDetail, CHA_INFO_COMP);
            if (n >= 0) {
                robj_interface_RJiCHAInfoDetail = robj_interface_RJiCHAInfoDetailArray[n];
            }
        }
        return robj_interface_RJiCHAInfoDetail;
    }

    public static Collection toPortInfoDetail(Robj_interface_RJiPortIndex[] robj_interface_RJiPortIndexArray, Robj_interface_RJiPortIndex[] robj_interface_RJiPortIndexArray2) {
        ArrayList<Robj_interface_RJiPortIndex> arrayList = new ArrayList<Robj_interface_RJiPortIndex>();
        if (robj_interface_RJiPortIndexArray != null && robj_interface_RJiPortIndexArray2 != null) {
            for (int i = 0; i < robj_interface_RJiPortIndexArray.length; ++i) {
                int n = Arrays.binarySearch(robj_interface_RJiPortIndexArray2, robj_interface_RJiPortIndexArray[i]);
                if (n < 0) continue;
                arrayList.add(robj_interface_RJiPortIndexArray2[n]);
            }
        }
        return arrayList;
    }

    public static String toIntensivePortName(Robj_interface_RJiPortInfoDetail[] robj_interface_RJiPortInfoDetailArray) {
        StringBuffer stringBuffer = new StringBuffer(32);
        String string = "/";
        String string2 = "(";
        String string3 = ")";
        if (robj_interface_RJiPortInfoDetailArray != null) {
            boolean bl = false;
            for (int i = 0; i < robj_interface_RJiPortInfoDetailArray.length; ++i) {
                switch (i) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        stringBuffer.append(string2);
                        bl = true;
                        break;
                    }
                    default: {
                        stringBuffer.append(string);
                    }
                }
                stringBuffer.append(RJComCHA.toPortName(robj_interface_RJiPortInfoDetailArray[i].getSPort()));
            }
            if (bl) {
                stringBuffer.append(string3);
            }
        }
        return stringBuffer.toString();
    }

    private CHAUtility() {
    }
}

