/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import sanproject.client.com.RJcResume;
import sanproject.client.com.utility.OemType;
import sanproject.client.data.RJDataControl;
import sanproject.client.exdevice.data.EXDPolicyExchanger;
import sanproject.client.exdevice.data.PolicyInfo;
import sanproject.client.exdevice.data.Singleton;
import sanproject.client.exdevice.data.SingletonManager;
import sanproject.client.exdevice.data.Utility;
import sanproject.client.exdevice.data.VolumeOperationDataControl;
import sanproject.common.RCobj_interface_CheckRet;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serverux.dataimpl.EXDPolicy;

public class PolicyManager
implements Singleton {
    private static final String LOG_NAME = "PolicyManager";
    public static final int MAX_POLICY_COUNT = 1;
    private ArrayList mPolicyList = new ArrayList();
    private static EXDPolicy DEFAULT_POLICY = new EXDPolicy();
    static Comparator mPolicyIdComparator;
    static /* synthetic */ Class class$sanproject$client$exdevice$data$PolicyManager;

    PolicyManager() {
    }

    public static synchronized PolicyManager getInstance() {
        return (PolicyManager)SingletonManager.getInstance(class$sanproject$client$exdevice$data$PolicyManager == null ? (class$sanproject$client$exdevice$data$PolicyManager = PolicyManager.class$("sanproject.client.exdevice.data.PolicyManager")) : class$sanproject$client$exdevice$data$PolicyManager);
    }

    public void destroy() {
    }

    void initialize() {
        Object object;
        Utility.putLog(LOG_NAME, "initialize");
        EXDPolicy[] eXDPolicyArray = null;
        if (eXDPolicyArray == null || eXDPolicyArray.length == 0) {
            RJcResume rJcResume = null;
            Object object2 = VolumeOperationDataControl.getInstance();
            rJcResume = ((VolumeOperationDataControl)object2).getResume();
            object2 = new ArrayList(1);
            if (rJcResume != null) {
                for (int i = 0; i < 1; ++i) {
                    object = "EXDPolicy@" + i;
                    String string = rJcResume.getParam((String)object);
                    if (string == null) continue;
                    EXDPolicy eXDPolicy = EXDPolicyExchanger.parseEXDPolicy(string);
                    ((ArrayList)object2).add(eXDPolicy);
                }
            }
            if (((ArrayList)object2).size() == 0) {
                EXDPolicy eXDPolicy = new EXDPolicy(DEFAULT_POLICY);
                ((ArrayList)object2).add(eXDPolicy);
            }
            eXDPolicyArray = new EXDPolicy[((ArrayList)object2).size()];
            eXDPolicyArray = ((ArrayList)object2).toArray(eXDPolicyArray);
        }
        int n = eXDPolicyArray.length;
        this.mPolicyList = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            void var4_8 = eXDPolicyArray[i];
            if (var4_8 == null) continue;
            object = new PolicyInfo((EXDPolicy)var4_8);
            this.mPolicyList.add(object);
        }
        Collections.sort(this.mPolicyList, mPolicyIdComparator);
    }

    public void updateResume() {
        RJcResume rJcResume = null;
        Object object = VolumeOperationDataControl.getInstance();
        rJcResume = ((VolumeOperationDataControl)object).getResume();
        if (rJcResume == null) {
            return;
        }
        object = this.getPolicyInfo();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            PolicyInfo policyInfo = (PolicyInfo)iterator.next();
            EXDPolicy eXDPolicy = policyInfo.getEXDPolicy();
            if (eXDPolicy == null) continue;
            String string = EXDPolicyExchanger.toResumeKey(eXDPolicy);
            String string2 = EXDPolicyExchanger.toResumeParam(eXDPolicy);
            rJcResume.putParam(string, string2);
        }
    }

    public Collection getPolicyInfo() {
        List list = (List)this.mPolicyList.clone();
        Collections.sort(list);
        return list;
    }

    public PolicyInfo getPolicyInfo(int n) {
        Integer n2 = new Integer(n);
        int n3 = Collections.binarySearch(this.mPolicyList, n2, mPolicyIdComparator);
        PolicyInfo policyInfo = null;
        if (n3 >= 0) {
            policyInfo = (PolicyInfo)this.mPolicyList.get(n3);
        }
        return policyInfo;
    }

    public static EXDPolicy getDefaultPolicy() {
        return DEFAULT_POLICY;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DEFAULT_POLICY.setNickname("(Default Policy)");
        DEFAULT_POLICY.setPolicyID(0);
        DEFAULT_POLICY.setOneToOneMode(false);
        DEFAULT_POLICY.setAutoDiscovery(false);
        DEFAULT_POLICY.setEmulationId(625);
        DEFAULT_POLICY.setExceptOpenV(false);
        DEFAULT_POLICY.setInflowControl(false);
        DEFAULT_POLICY.setSlprLimited(true);
        DEFAULT_POLICY.setCLPR((short)0);
        DEFAULT_POLICY.setSLPR((short)0);
        DEFAULT_POLICY.setLdevMappingInterval(0);
        DEFAULT_POLICY.setLdevSize(Long.MAX_VALUE);
        DEFAULT_POLICY.setNumOfLdevInPG(2048);
        RJiLDEVIndex rJiLDEVIndex = new RJiLDEVIndex();
        rJiLDEVIndex.setLDEVIndex((short)0, (short)0, (short)0);
        DEFAULT_POLICY.setMappingStartLdev((Robj_interface_RJiLDEVIndex)rJiLDEVIndex);
        RJDataControl rJDataControl = RJDataControl.getDataControl();
        RCobj_interface_CheckRet rCobj_interface_CheckRet = rJDataControl.getCheckRetObjSx();
        int n = rCobj_interface_CheckRet.getNOEMTYPE();
        boolean bl = !OemType.isHP(n);
        DEFAULT_POLICY.setCacheMode(bl);
        mPolicyIdComparator = new PolicyIdComparator();
    }

    static class PolicyIdComparator
    implements Comparator {
        PolicyIdComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = this.getValue(object);
            int n2 = this.getValue(object2);
            return n - n2;
        }

        private int getValue(Object object) {
            int n = object instanceof PolicyInfo ? ((PolicyInfo)object).getId() : ((Integer)object).intValue();
            return n;
        }
    }
}

