/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.luoperation;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.swing.Icon;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcElement;
import sanproject.client.exdevice.com.Guidance;
import sanproject.client.exdevice.data.AddVolumeData;
import sanproject.client.exdevice.data.ExternalVolumeInfo;
import sanproject.client.exdevice.data.LogicalPathInfo;
import sanproject.client.exdevice.data.LogicalPathInfo_Fibre;
import sanproject.client.exdevice.data.PathGroupInfo;
import sanproject.client.exdevice.data.PhysicalPathInfo;
import sanproject.client.exdevice.data.PortManager;
import sanproject.client.exdevice.data.ProductInfo;
import sanproject.client.exdevice.data.ProfileInfo;
import sanproject.client.exdevice.data.SsidInfo;
import sanproject.client.exdevice.icon.IconManager;
import sanproject.client.exdevice.luoperation.LocalGuidance;
import sanproject.common.Robj_interface_RJiLDEVInfoDetail;
import sanproject.common.Robj_interface_RJiPGIndex;
import sanproject.common.Robj_interface_RJiPortIndex;
import sanproject.common.Robj_interface_RJiPortInfoDetail;
import sanproject.serverux.dataimpl.EXDExternalDevice;
import sanproject.serverux.dataimpl.EXDExternalVolume;

public final class ElementUtilities {
    private ElementUtilities() {
    }

    public static boolean isAbnormalDeviceStatus(int n) {
        boolean bl = false;
        if (1 != n && 0 != n) {
            bl = true;
        }
        return bl;
    }

    public static boolean isAbnormalFibrePathStatus(int n) {
        boolean bl = false;
        if (n != 64 && n != 0) {
            bl = true;
        }
        return bl;
    }

    public static Icon toCharacteristicIcon(AddVolumeData addVolumeData) {
        IconManager iconManager = IconManager.getInstance();
        Icon icon = iconManager.getIcon("ExternalDevice_ExternalGroup.gif");
        return icon;
    }

    public static Icon toGroupIcon(ExternalVolumeInfo externalVolumeInfo) {
        IconManager iconManager = IconManager.getInstance();
        int n = externalVolumeInfo.getExVolStatus();
        Icon icon = ElementUtilities.isAbnormalDeviceStatus(n) ? iconManager.createPilesupImageIcon("ExternalDevice_ExternalGroup.gif", "ExternalDevice_AbnormalSubImage.gif") : iconManager.getIcon("ExternalDevice_ExternalGroup.gif");
        return icon;
    }

    public static Icon toLDEVIcon(Robj_interface_RJiLDEVInfoDetail robj_interface_RJiLDEVInfoDetail) {
        IconManager iconManager = IconManager.getInstance();
        Icon icon = iconManager.getIcon("NormalLDEV.gif");
        return icon;
    }

    public static Icon toProductIcon(ProductInfo productInfo) {
        IconManager iconManager = IconManager.getInstance();
        int n = productInfo.getStatus();
        Icon icon = ElementUtilities.isAbnormalDeviceStatus(n) ? iconManager.createPilesupImageIcon("ExternalDevice_Product.gif", "ExternalDevice_AbnormalSubImage.gif") : iconManager.getIcon("ExternalDevice_Product.gif");
        return icon;
    }

    public static Icon toPathIcon(PhysicalPathInfo physicalPathInfo) {
        IconManager iconManager = IconManager.getInstance();
        Icon icon = iconManager.getIcon("ExternalDevice_PhysicalPath.gif");
        return icon;
    }

    public static Icon toPathIcon(LogicalPathInfo logicalPathInfo) {
        int n;
        IconManager iconManager = IconManager.getInstance();
        Icon icon = logicalPathInfo instanceof LogicalPathInfo_Fibre ? (ElementUtilities.isAbnormalFibrePathStatus(n = logicalPathInfo.getStatus()) ? iconManager.createPilesupImageIcon("ExternalDevice_LogicalPath.gif", "ExternalDevice_AbnormalSubImage.gif") : iconManager.getIcon("ExternalDevice_LogicalPath.gif")) : iconManager.getIcon("ExternalDevice_LogicalPath.gif");
        return icon;
    }

    public static Icon toPortIcon(Robj_interface_RJiPortInfoDetail robj_interface_RJiPortInfoDetail) {
        IconManager iconManager = IconManager.getInstance();
        Icon icon = iconManager.getIcon("Port_Short_Stand_OFF.gif");
        PortManager portManager = PortManager.getInstance();
        boolean bl = portManager.isMixMode((Robj_interface_RJiPortIndex)robj_interface_RJiPortInfoDetail);
        if (bl) {
            icon = iconManager.getIcon("Port_Short_Mix_OFF.gif");
        }
        return icon;
    }

    public static Icon toPathTargetIcon(PhysicalPathInfo physicalPathInfo) {
        IconManager iconManager = IconManager.getInstance();
        Icon icon = iconManager.getIcon("ExternalDevice_DiscoveryWWN.gif");
        return icon;
    }

    public static Icon toPathGroupIcon(PathGroupInfo pathGroupInfo) {
        IconManager iconManager = IconManager.getInstance();
        int n = pathGroupInfo.getStatus();
        Icon icon = ElementUtilities.isAbnormalDeviceStatus(n) ? iconManager.createPilesupImageIcon("ExternalDevice_PathGroup.gif", "ExternalDevice_AbnormalSubImage.gif") : iconManager.getIcon("ExternalDevice_PathGroup.gif");
        return icon;
    }

    public static String toStringCacheMode(boolean bl) {
        String string = bl ? LocalGuidance.TEXT_ENABLE.getText() : LocalGuidance.TEXT_DISABLE.getText();
        return string;
    }

    public static String toStringCacheMode(ExternalVolumeInfo externalVolumeInfo) {
        boolean bl = externalVolumeInfo.isCacheModeEnable();
        String string = ElementUtilities.toStringCacheMode(bl);
        return string;
    }

    public static String toStringInflowControl(boolean bl) {
        String string = bl ? LocalGuidance.TEXT_ENABLE.getText() : LocalGuidance.TEXT_DISABLE.getText();
        return string;
    }

    public static String toStringInflowControl(ExternalVolumeInfo externalVolumeInfo) {
        boolean bl = externalVolumeInfo.isInflowControlEnable();
        String string = ElementUtilities.toStringInflowControl(bl);
        return string;
    }

    public static String toStringPathMode(int n) {
        String string = null;
        if (n == ProfileInfo.PATHMODE_SINGLE) {
            string = LocalGuidance.TEXT_PATHMODESINGLE.getText();
        } else if (n == ProfileInfo.PATHMODE_MULTI) {
            string = LocalGuidance.TEXT_PATHMODEMULTI.getText();
        } else if (n == ProfileInfo.PATHMODE_ACTIVE_STANDBY) {
            string = LocalGuidance.TEXT_PATHMODESINGLE.getText();
        } else if (n == ProfileInfo.PATHMODE_ACTIVE_STANDBY_LU) {
            string = LocalGuidance.TEXT_PATHMODESINGLE.getText();
        } else if (n == ProfileInfo.PATHMODE_APLB) {
            string = LocalGuidance.TEXT_PATHMODEAPLB.getText();
        }
        return string;
    }

    public static String toStringDeviceInfomation(ExternalVolumeInfo externalVolumeInfo) {
        EXDExternalVolume eXDExternalVolume;
        String string = null;
        if (externalVolumeInfo != null && (eXDExternalVolume = externalVolumeInfo.getEXDExternalVolume()) != null) {
            String string2;
            StringBuffer stringBuffer = new StringBuffer();
            EXDExternalDevice eXDExternalDevice = eXDExternalVolume.getExternalDeviceInfo();
            short s = eXDExternalDevice.getDriveType();
            if (s != 0) {
                string2 = s == 3 ? LocalGuidance.TEXT_SSDSYMBOL.getText() : LocalGuidance.TEXT_SATASYMBOL.getText();
                stringBuffer.append(string2);
            }
            if (eXDExternalDevice.isInheritDrive()) {
                string2 = LocalGuidance.TEXT_INHERITSYMBOL.getText();
                stringBuffer.append(string2);
            }
            if (stringBuffer.length() != 0) {
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    public static String toStringDeviceStatus(int n) {
        String string = n == 0 ? null : (n == 1 ? LocalGuidance.TEXT_DEVICENORMAL.getText() : (n == 2 ? LocalGuidance.TEXT_DEVICEDISCONNECT.getText() : (n == 3 ? LocalGuidance.TEXT_DEVICECHECKING.getText() : (n == 4 ? LocalGuidance.TEXT_DEVICEUNKNOWN.getText() : (n == 5 ? LocalGuidance.TEXT_DEVICEDESTAGE.getText() : (n == 10 ? LocalGuidance.TEXT_DEVICEDESTAGEFAILED.getText() : (n == 6 ? LocalGuidance.TEXT_DEVICEPURGE.getText() : (n == 7 ? LocalGuidance.TEXT_DEVICEPURGEFAILED.getText() : (n == 8 ? LocalGuidance.TEXT_DEVICEWARNING.getText() : (n == 9 ? LocalGuidance.TEXT_DEVICEBLOCKADE.getText() : LocalGuidance.TEXT_DEVICEUNKNOWN.getText()))))))))));
        return string;
    }

    public static String toStringDeviceStatus(ExternalVolumeInfo externalVolumeInfo) {
        int n = externalVolumeInfo.getExVolStatus();
        String string = ElementUtilities.toStringDeviceStatus(n);
        return string;
    }

    public static String toStringDeviceStatus(ProductInfo productInfo) {
        int n = productInfo.getStatus();
        String string = ElementUtilities.toStringDeviceStatus(n);
        return string;
    }

    public static String toStringDeviceStatus(Robj_interface_RJiLDEVInfoDetail robj_interface_RJiLDEVInfoDetail) {
        String string = null;
        return string;
    }

    public static String toStringDeviceStatus(Robj_interface_RJiPortIndex robj_interface_RJiPortIndex) {
        PortManager portManager = PortManager.getInstance();
        int n = portManager.getStatus(robj_interface_RJiPortIndex);
        String string = ElementUtilities.toStringDeviceStatus(n);
        return string;
    }

    public static String toStringLPR(int n, int n2) {
        String string = n2 >= 0 && n >= 0 ? String.valueOf(n2) + "/" + String.valueOf(n) : null;
        return string;
    }

    public static String toStringLPR(ExternalVolumeInfo externalVolumeInfo) {
        int n = externalVolumeInfo.getClpr();
        int n2 = externalVolumeInfo.getSlpr();
        String string = ElementUtilities.toStringLPR(n, n2);
        return string;
    }

    public static String toStringLUNumber(int n) {
        String string = null;
        if (n != -1) {
            string = RJcElement.toHexString(n, 4);
        }
        return string;
    }

    public static String toStringLUNumber(LogicalPathInfo logicalPathInfo) {
        int n;
        String string = null;
        if (logicalPathInfo instanceof LogicalPathInfo_Fibre) {
            LogicalPathInfo_Fibre logicalPathInfo_Fibre = (LogicalPathInfo_Fibre)logicalPathInfo;
            n = logicalPathInfo_Fibre.getLun();
        } else {
            n = -1;
        }
        string = ElementUtilities.toStringLUNumber(n);
        return string;
    }

    public static String toStringMixCapacity(BigInteger bigInteger, boolean bl) {
        String string;
        if (bl) {
            Guidance guidance = LocalGuidance.TEXT_UNITMB;
            Guidance guidance2 = LocalGuidance.TEXT_UNITBLOCKS;
            BigDecimal bigDecimal = ElementUtilities.convertLBAToMB(bigInteger);
            string = bigDecimal.toString() + guidance.getText() + "(" + bigInteger.toString() + guidance2.getText() + ")";
        } else {
            Guidance guidance = LocalGuidance.TEXT_UNITCYLINDER;
            string = bigInteger.toString() + guidance.getText();
        }
        return string;
    }

    public static String toStringMixCapacity(Robj_interface_RJiLDEVInfoDetail robj_interface_RJiLDEVInfoDetail) {
        boolean bl = robj_interface_RJiLDEVInfoDetail.isOpenVolume();
        long l = bl ? robj_interface_RJiLDEVInfoDetail.getLLDEVLBASize() : robj_interface_RJiLDEVInfoDetail.getLLDEVSize();
        BigInteger bigInteger = BigInteger.valueOf(l);
        String string = ElementUtilities.toStringMixCapacity(bigInteger, bl);
        return string;
    }

    public static String toStringFibrePathStatus(int n) {
        String string;
        if (n == 0) {
            string = null;
        } else if (n == 1) {
            string = LocalGuidance.TEXT_PATHINDEFINITE.getText();
        } else if (n == 3) {
            string = LocalGuidance.TEXT_PATHBLOCKADE.getText();
        } else if (n == 64) {
            string = LocalGuidance.TEXT_PATHNORMAL.getText();
        } else if (n == 3) {
            string = LocalGuidance.TEXT_PATHPATHCHG.getText();
        } else if (n == 3) {
            string = LocalGuidance.TEXT_PATHTEMPBLOCK.getText();
        } else if (n == 128) {
            string = LocalGuidance.TEXT_PATHDISCONNECT.getText();
        } else if (n == 27) {
            string = LocalGuidance.TEXT_PATHDESTAGEFAILED.getText();
        } else if (n == 4) {
            string = LocalGuidance.TEXT_PATHSETTINGCHANGE.getText();
        } else if (n == 5) {
            string = LocalGuidance.TEXT_PATHSIZEREDUCE.getText();
        } else if (n == 6) {
            string = LocalGuidance.TEXT_PATHNOTREADY.getText();
        } else if (n == 7) {
            string = LocalGuidance.TEXT_PATHILLEGALREQ.getText();
        } else if (n == 8) {
            string = LocalGuidance.TEXT_PATHCMDABORT.getText();
        } else if (n == 9) {
            string = LocalGuidance.TEXT_PATHDEVBUSY.getText();
        } else if (n == 10) {
            string = LocalGuidance.TEXT_PATHDEVRESERVE.getText();
        } else if (n == 11) {
            string = LocalGuidance.TEXT_PATHRESPONSEERR.getText();
        } else if (n == 13) {
            string = LocalGuidance.TEXT_PATHINITIATOR.getText();
        } else if (n == 14) {
            string = LocalGuidance.TEXT_PATHRCUTARGET.getText();
        } else if (n == 15) {
            string = LocalGuidance.TEXT_PATHATRUNKNOWN.getText();
        } else if (n == 3) {
            string = LocalGuidance.TEXT_PATHUNDETECTION.getText();
        } else if (n == 16) {
            string = LocalGuidance.TEXT_PATHINTERNALERR.getText();
        } else if (n == 12) {
            string = LocalGuidance.TEXT_PATHTIMEOUT.getText();
        } else if (n == 3) {
            string = LocalGuidance.TEXT_PATHOTHERS.getText();
        } else if (n == 20) {
            string = LocalGuidance.TEXT_PATHDEVICECHKERR.getText();
        } else if (n == 21) {
            string = LocalGuidance.TEXT_PATHMEDIUMERR.getText();
        } else if (n == 192) {
            string = LocalGuidance.TEXT_PATHCHECKING.getText();
        } else if (n == 192) {
            string = LocalGuidance.TEXT_PATHCHECKINGNRM.getText();
        } else if (n == 192) {
            string = LocalGuidance.TEXT_PATHCHECKINGPASSIVE.getText();
        } else if (n == 2) {
            string = LocalGuidance.TEXT_PATHUNDETECTIONAR.getText();
        } else if (n == 3) {
            string = LocalGuidance.TEXT_PATHOTHERSAR.getText();
        } else if (n == 68) {
            string = LocalGuidance.TEXT_PATHLINKDOWN.getText();
        } else if (n == 65) {
            string = LocalGuidance.TEXT_PATHSTANDBY.getText();
        } else if (n == 17) {
            string = LocalGuidance.TEXT_PATHTARGETERROR.getText();
        } else if (n == 18) {
            string = LocalGuidance.TEXT_PATHUNAVAILABLE.getText();
        } else if (n == 19) {
            string = LocalGuidance.TEXT_PATHBACKOFF.getText();
        } else if (n == 66) {
            string = LocalGuidance.TEXT_PATHPASSIVE.getText();
        } else {
            String string2 = RJcElement.toHexString(n, 2);
            string = LocalGuidance.TEXT_PATHUNMOUNT.getText() + " (0x" + string2 + ")";
        }
        return string;
    }

    public static String toStringPathStatus(LogicalPathInfo logicalPathInfo) {
        String string;
        int n = logicalPathInfo.getStatus();
        if (logicalPathInfo instanceof LogicalPathInfo_Fibre) {
            string = ElementUtilities.toStringFibrePathStatus(n);
        } else {
            String string2 = RJcElement.toHexString(n, 2);
            string = LocalGuidance.TEXT_PATHUNMOUNT.getText() + " (0x" + string2 + ")";
        }
        return string;
    }

    public static String toStringSSID(int n) {
        String string = n != -1 ? RJcElement.toHexString(n, 4) : null;
        return string;
    }

    public static String toStringSSID(SsidInfo ssidInfo) {
        int n = ssidInfo.getSsid();
        String string = ElementUtilities.toStringSSID(n);
        return string;
    }

    public static String toStringVMAValid(boolean bl) {
        String string = bl ? LocalGuidance.TEXT_SATASYMBOL.getText() : null;
        return string;
    }

    public static String toStringVMAValid(ExternalVolumeInfo externalVolumeInfo) {
        boolean bl = externalVolumeInfo.isVmaValid();
        String string = ElementUtilities.toStringVMAValid(bl);
        return string;
    }

    public static Object getGroupSortObject(ExternalVolumeInfo externalVolumeInfo) {
        Robj_interface_RJiPGIndex robj_interface_RJiPGIndex = externalVolumeInfo.getPgIndex();
        Object object = ElementUtilities.getGroupSortObject(robj_interface_RJiPGIndex);
        return object;
    }

    public static Object getGroupSortObject(Robj_interface_RJiPGIndex robj_interface_RJiPGIndex) {
        int n = robj_interface_RJiPGIndex.getIPG();
        int n2 = robj_interface_RJiPGIndex.getIFB4();
        long l = n2 * 4096 + n;
        BigInteger bigInteger = BigInteger.valueOf(l);
        return bigInteger;
    }

    public static String getLDEVIdentifier(Robj_interface_RJiLDEVInfoDetail robj_interface_RJiLDEVInfoDetail) {
        String string = null;
        short s = robj_interface_RJiLDEVInfoDetail.getSLDKC();
        short s2 = robj_interface_RJiLDEVInfoDetail.getSCU();
        short s3 = robj_interface_RJiLDEVInfoDetail.getSLDEV();
        if (s != -1 && s2 != -1 && s3 != -1) {
            string = RJComUty.getLDEVDisplayName(robj_interface_RJiLDEVInfoDetail);
        }
        return string;
    }

    public static BigDecimal convertLBAToMB(BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger.shiftRight(1);
        BigDecimal bigDecimal = new BigDecimal(bigInteger2);
        BigDecimal bigDecimal2 = bigDecimal.setScale(32, 4);
        BigDecimal bigDecimal3 = bigDecimal2.divide(new BigDecimal(1024.0), 0, 1);
        BigDecimal bigDecimal4 = bigDecimal3.setScale(0, 1);
        return bigDecimal4;
    }
}

