/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.hur;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComModalDialog;
import sanproject.client.com.RJComPanel;
import sanproject.client.com.RJComUty;
import sanproject.client.data.RJDataChange;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataControlDoing;
import sanproject.client.data.RJDataException;
import sanproject.client.data.RJDataLDEVPart;
import sanproject.client.data.RJDataPGPart;
import sanproject.client.data.RJDataPPKey;
import sanproject.client.data.RJDataPathPart;
import sanproject.client.data.RJDataPortPart;
import sanproject.client.data.RJDataStartParam;
import sanproject.client.hur.RJHurAbsChildPanel;
import sanproject.client.hur.RJHurGuide;
import sanproject.client.hur.RJHurMacro;
import sanproject.client.hur.RJHurUsgGuide;
import sanproject.common.Robj_interface_RJSetGettingParamDevice;
import sanproject.common.Robj_interface_RJSetGettingParamLDEV;
import sanproject.common.Robj_interface_RJSetGettingParamVol;
import sanproject.common.Robj_interface_RJiCUIndex;
import sanproject.common.Robj_interface_RJiHostGroupInfoDetail;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiLDKCIndex;
import sanproject.common.Robj_interface_RJiLUPathIndex;
import sanproject.common.Robj_interface_RJiPGIndex;
import sanproject.common.Robj_interface_RJiPortIndex;
import sanproject.common.Robj_interface_RJiPortInfoDetail;
import sanproject.serversx.data.RJiCUIndex;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serversx.data.RJiLDKCIndex;
import sanproject.serversx.data.RJiPGIndex;
import sanproject.serverux.dataimpl.DKCgetLDEVInfoDetail_IN;
import sanproject.serverux.dataimpl.DKCgetLDEVInfoDetail_OUT;
import sanproject.serverux.dataimpl.HURget1PairDetail;
import sanproject.serverux.dataimpl.HURgetSystemOption;
import sanproject.serverux.dataimpl.PRMName;
import sanproject.serverux.dataimpl.RJSetGettingParamDevice;
import sanproject.serverux.dataimpl.RJSetGettingParamLDEV;
import sanproject.serverux.dataimpl.RJSetGettingParamVol;
import sanproject.serverux.dataimpl.RJiHURget1JNLG;
import sanproject.serverux.dataimpl.RJiHURgetJNLG1Mirror;
import sanproject.serverux.dataimpl.RJiHURgetJNLGrps;
import sanproject.serverux.dataimpl.RJiInputHurPairParam;
import sanproject.serverux.dataimpl.RJiLDEVInfoDetail3;
import sanproject.serverux.dataimpl.RJiPortIndex;
import sanproject.serverux.dataimpl.SanRmiInputInterface;

public class RJHurDataControl
implements RJHurMacro {
    private RJDataControl cmnDC;
    private RJHurGuide hurGuid;
    private RJHurUsgGuide usgGuid;
    private int ppKind;
    private String ppString;
    private RJiLDEVInfoDetail3[] ldevDetail;
    private ArrayList luPathArray = new ArrayList();
    private boolean debugMode = false;
    private HURgetSystemOption hurSystemOption = null;
    private final long MINIMUM_JNL_CYLINDER = 50L;
    static final String[] PortList_R600 = new String[]{"CL1-A", "CL3-A", "CL5-A", "CL7-A", "CL1-B", "CL3-B", "CL5-B", "CL7-B", "CL1-E", "CL3-E", "CL5-E", "CL7-E", "CL1-F", "CL3-F", "CL5-F", "CL7-F", "CL1-C", "CL3-C", "CL5-C", "CL7-C", "CL1-D", "CL3-D", "CL5-D", "CL7-D", "CL1-G", "CL3-G", "CL5-G", "CL7-G", "CL1-H", "CL3-H", "CL5-H", "CL7-H", "CL1-J", "CL3-J", "CL5-J", "CL7-J", "CL1-K", "CL3-K", "CL5-K", "CL7-K", "CL1-N", "CL3-N", "CL5-N", "CL7-N", "CL1-P", "CL3-P", "CL5-P", "CL7-P", "CL1-L", "CL3-L", "CL5-L", "CL7-L", "CL1-M", "CL3-M", "CL5-M", "CL7-M", "CL1-Q", "CL3-Q", "CL5-Q", "CL7-Q", "CL1-R", "CL3-R", "CL5-R", "CL7-R", "CL9-A", "CLB-A", "CLD-A", "CLF-A", "CL9-B", "CLB-B", "CLD-B", "CLF-B", "CL9-E", "CLB-E", "CLD-E", "CLF-E", "CL9-F", "CLB-F", "CLD-F", "CLF-F", "CL9-C", "CLB-C", "CLD-C", "CLF-C", "CL9-D", "CLB-D", "CLD-D", "CLF-D", "CL9-G", "CLB-G", "CLD-G", "CLF-G", "CL9-H", "CLB-H", "CLD-H", "CLF-H", "CL9-J", "CLB-J", "CLD-J", "CLF-J", "CL9-K", "CLB-K", "CLD-K", "CLF-K", "CL9-N", "CLB-N", "CLD-N", "CLF-N", "CL9-P", "CLB-P", "CLD-P", "CLF-P", "CL9-L", "CLB-L", "CLD-L", "CLF-L", "CL9-M", "CLB-M", "CLD-M", "CLF-M", "CL9-Q", "CLB-Q", "CLD-Q", "CLF-Q", "CL9-R", "CLB-R", "CLD-R", "CLF-R", "CL2-A", "CL4-A", "CL6-A", "CL8-A", "CL2-B", "CL4-B", "CL6-B", "CL8-B", "CL2-E", "CL4-E", "CL6-E", "CL8-E", "CL2-F", "CL4-F", "CL6-F", "CL8-F", "CL2-C", "CL4-C", "CL6-C", "CL8-C", "CL2-D", "CL4-D", "CL6-D", "CL8-D", "CL2-G", "CL4-G", "CL6-G", "CL8-G", "CL2-H", "CL4-H", "CL6-H", "CL8-H", "CL2-J", "CL4-J", "CL6-J", "CL8-J", "CL2-K", "CL4-K", "CL6-K", "CL8-K", "CL2-N", "CL4-N", "CL6-N", "CL8-N", "CL2-P", "CL4-P", "CL6-P", "CL8-P", "CL2-L", "CL4-L", "CL6-L", "CL8-L", "CL2-M", "CL4-M", "CL6-M", "CL8-M", "CL2-Q", "CL4-Q", "CL6-Q", "CL8-Q", "CL2-R", "CL4-R", "CL6-R", "CL8-R", "CLA-A", "CLC-A", "CLE-A", "CLG-A", "CLA-B", "CLC-B", "CLE-B", "CLG-B", "CLA-E", "CLC-E", "CLE-E", "CLG-E", "CLA-F", "CLC-F", "CLE-F", "CLG-F", "CLA-C", "CLC-C", "CLE-C", "CLG-C", "CLA-D", "CLC-D", "CLE-D", "CLG-D", "CLA-G", "CLC-G", "CLE-G", "CLG-G", "CLA-H", "CLC-H", "CLE-H", "CLG-H", "CLA-J", "CLC-J", "CLE-J", "CLG-J", "CLA-K", "CLC-K", "CLE-K", "CLG-K", "CLA-N", "CLC-N", "CLE-N", "CLG-N", "CLA-P", "CLC-P", "CLE-P", "CLG-P", "CLA-L", "CLC-L", "CLE-L", "CLG-L", "CLA-M", "CLC-M", "CLE-M", "CLG-M", "CLA-Q", "CLC-Q", "CLE-Q", "CLG-Q", "CLA-R", "CLC-R", "CLE-R", "CLG-R"};
    static final String[] PortList_R700 = new String[]{"CL1-A", "CL3-A", "CL5-A", "CL7-A", "CL1-B", "CL3-B", "CL5-B", "CL7-B", "CL1-E", "CL3-E", "CL5-E", "CL7-E", "CL1-F", "CL3-F", "CL5-F", "CL7-F", "CL1-C", "CL3-C", "CL5-C", "CL7-C", "CL1-D", "CL3-D", "CL5-D", "CL7-D", "CL1-G", "CL3-G", "CL5-G", "CL7-G", "CL1-H", "CL3-H", "CL5-H", "CL7-H", "CL1-J", "CL3-J", "CL5-J", "CL7-J", "CL1-K", "CL3-K", "CL5-K", "CL7-K", "CL1-N", "CL3-N", "CL5-N", "CL7-N", "CL1-P", "CL3-P", "CL5-P", "CL7-P", "CL1-L", "CL3-L", "CL5-L", "CL7-L", "CL1-M", "CL3-M", "CL5-M", "CL7-M", "CL1-Q", "CL3-Q", "CL5-Q", "CL7-Q", "CL1-R", "CL3-R", "CL5-R", "CL7-R", "CL9-A", "CLB-A", "CLD-A", "CLF-A", "CL9-B", "CLB-B", "CLD-B", "CLF-B", "CL9-C", "CLB-C", "CLD-C", "CLF-C", "CL9-D", "CLB-D", "CLD-D", "CLF-D", "CL9-J", "CLB-J", "CLD-J", "CLF-J", "CL9-K", "CLB-K", "CLD-K", "CLF-K", "CL9-L", "CLB-L", "CLD-L", "CLF-L", "CL9-M", "CLB-M", "CLD-M", "CLF-M", "CL2-A", "CL4-A", "CL6-A", "CL8-A", "CL2-B", "CL4-B", "CL6-B", "CL8-B", "CL2-E", "CL4-E", "CL6-E", "CL8-E", "CL2-F", "CL4-F", "CL6-F", "CL8-F", "CL2-C", "CL4-C", "CL6-C", "CL8-C", "CL2-D", "CL4-D", "CL6-D", "CL8-D", "CL2-G", "CL4-G", "CL6-G", "CL8-G", "CL2-H", "CL4-H", "CL6-H", "CL8-H", "CL2-J", "CL4-J", "CL6-J", "CL8-J", "CL2-K", "CL4-K", "CL6-K", "CL8-K", "CL2-N", "CL4-N", "CL6-N", "CL8-N", "CL2-P", "CL4-P", "CL6-P", "CL8-P", "CL2-L", "CL4-L", "CL6-L", "CL8-L", "CL2-M", "CL4-M", "CL6-M", "CL8-M", "CL2-Q", "CL4-Q", "CL6-Q", "CL8-Q", "CL2-R", "CL4-R", "CL6-R", "CL8-R", "CLA-A", "CLC-A", "CLE-A", "CLG-A", "CLA-B", "CLC-B", "CLE-B", "CLG-B", "CLA-C", "CLC-C", "CLE-C", "CLG-C", "CLA-D", "CLC-D", "CLE-D", "CLG-D", "CLA-J", "CLC-J", "CLE-J", "CLG-J", "CLA-K", "CLC-K", "CLE-K", "CLG-K", "CLA-L", "CLC-L", "CLE-L", "CLG-L", "CLA-M", "CLC-M", "CLE-M", "CLG-M"};
    static final String[] PortList_H700 = new String[]{"CL1-A", "CL3-A", "CL5-A", "CL7-A", "CL1-B", "CL3-B", "CL5-B", "CL7-B", "CL1-C", "CL3-C", "CL5-C", "CL7-C", "CL1-D", "CL3-D", "CL5-D", "CL7-D", "CL1-E", "CL3-E", "CL5-E", "CL7-E", "CL1-F", "CL3-F", "CL5-F", "CL7-F", "CL2-A", "CL4-A", "CL6-A", "CL8-A", "CL2-B", "CL4-B", "CL6-B", "CL8-B", "CL2-C", "CL4-C", "CL6-C", "CL8-C", "CL2-D", "CL4-D", "CL6-D", "CL8-D", "CL2-E", "CL4-E", "CL6-E", "CL8-E", "CL2-F", "CL4-F", "CL6-F", "CL8-F"};
    static final String[] PortList_ALL = new String[]{"CL1-A", "CL3-A", "CL5-A", "CL7-A", "CL1-B", "CL3-B", "CL5-B", "CL7-B", "CL1-C", "CL3-C", "CL5-C", "CL7-C", "CL1-D", "CL3-D", "CL5-D", "CL7-D", "CL1-E", "CL3-E", "CL5-E", "CL7-E", "CL1-F", "CL3-F", "CL5-F", "CL7-F", "CL1-G", "CL1-H", "CL1-J", "CL1-K", "CL1-L", "CL1-M", "CL1-N", "CL1-P", "CL2-A", "CL4-A", "CL6-A", "CL8-A", "CL2-B", "CL4-B", "CL6-B", "CL8-B", "CL2-C", "CL4-C", "CL6-C", "CL8-C", "CL2-D", "CL4-D", "CL6-D", "CL8-D", "CL2-E", "CL4-E", "CL6-E", "CL8-E", "CL2-F", "CL4-F", "CL6-F", "CL8-F", "CL1-Q", "CL1-R", "CL2-G", "CL2-H", "CL2-J", "CL2-K", "CL2-L", "CL2-M", "CL2-N", "CL2-P", "CL2-Q", "CL2-R", "CL3-G", "CL3-H", "CL3-J", "CL3-K", "CL3-L", "CL3-M", "CL3-N", "CL3-P", "CL3-Q", "CL3-R", "CL4-G", "CL4-H", "CL4-J", "CL4-K", "CL4-L", "CL4-M", "CL4-N", "CL4-P", "CL4-Q", "CL4-R", "CL5-G", "CL5-H", "CL5-J", "CL5-K", "CL5-L", "CL5-M", "CL5-N", "CL5-P", "CL5-Q", "CL5-R", "CL6-G", "CL6-H", "CL6-J", "CL6-K", "CL6-L", "CL6-M", "CL6-N", "CL6-P", "CL6-Q", "CL6-R", "CL7-G", "CL7-H", "CL7-J", "CL7-K", "CL7-L", "CL7-M", "CL7-N", "CL7-P", "CL7-Q", "CL7-R", "CL8-G", "CL8-H", "CL8-J", "CL8-K", "CL8-L", "CL8-M", "CL8-N", "CL8-P", "CL8-Q", "CL8-R", "CL9-A", "CL9-B", "CL9-C", "CL9-D", "CL9-E", "CL9-F", "CL9-G", "CL9-H", "CL9-J", "CL9-K", "CL9-L", "CL9-M", "CL9-N", "CL9-P", "CL9-Q", "CL9-R", "CLA-A", "CLA-B", "CLA-C", "CLA-D", "CLA-E", "CLA-F", "CLA-G", "CLA-H", "CLA-J", "CLA-K", "CLA-L", "CLA-M", "CLA-N", "CLA-P", "CLA-Q", "CLA-R", "CLB-A", "CLB-B", "CLB-C", "CLB-D", "CLB-E", "CLB-F", "CLB-G", "CLB-H", "CLB-J", "CLB-K", "CLB-L", "CLB-M", "CLB-N", "CLB-P", "CLB-Q", "CLB-R", "CLC-A", "CLC-B", "CLC-C", "CLC-D", "CLC-E", "CLC-F", "CLC-G", "CLC-H", "CLC-J", "CLC-K", "CLC-L", "CLC-M", "CLC-N", "CLC-P", "CLC-Q", "CLC-R", "CLD-A", "CLD-B", "CLD-C", "CLD-D", "CLD-E", "CLD-F", "CLD-G", "CLD-H", "CLD-J", "CLD-K", "CLD-L", "CLD-M", "CLD-N", "CLD-P", "CLD-Q", "CLD-R", "CLE-A", "CLE-B", "CLE-C", "CLE-D", "CLE-E", "CLE-F", "CLE-G", "CLE-H", "CLE-J", "CLE-K", "CLE-L", "CLE-M", "CLE-N", "CLE-P", "CLE-Q", "CLE-R", "CLF-A", "CLF-B", "CLF-C", "CLF-D", "CLF-E", "CLF-F", "CLF-G", "CLF-H", "CLF-J", "CLF-K", "CLF-L", "CLF-M", "CLF-N", "CLF-P", "CLF-Q", "CLF-R", "CLG-A", "CLG-B", "CLG-C", "CLG-D", "CLG-E", "CLG-F", "CLG-G", "CLG-H", "CLG-J", "CLG-K", "CLG-L", "CLG-M", "CLG-N", "CLG-P", "CLG-Q", "CLG-R"};
    static final short[] pairstatus = new short[]{0, 1, 1, 2, 2, 4, 3, 8, 4, 8, 5, 8, 6, 8, 7, 8, 8, 16, 9, 16, 80, 16, 98, 16, 96, 32, 97, 64, 99, 8};

    public RJHurDataControl(RJDataControl rJDataControl, int n) {
        this.cmnDC = rJDataControl;
        this.ppKind = n;
    }

    public void setGuide(RJHurGuide rJHurGuide) {
        this.hurGuid = rJHurGuide;
        this.ppString = this.ppKind == 1 ? RJHurGuide.text("HUR") : RJHurGuide.text("HURMF");
    }

    public RJDataControl getCommonDC() {
        return this.cmnDC;
    }

    public RJHurGuide getHurGuide() {
        return this.hurGuid;
    }

    public boolean isInstalled() {
        boolean bl = false;
        if (this.ppKind == 1) {
            if (this.cmnDC.getPPKeyData().getInstallStat(RJDataPPKey.FUNC_NAME_HUR) != 0) {
                bl = true;
            }
        } else if (this.cmnDC.getPPKeyData().getInstallStat(RJDataPPKey.FUNC_NAME_HURMF) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean hasWritePermission() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        if (this.cmnDC.getViewModifyStatus() == 1) {
            RJDataStartParam rJDataStartParam = this.cmnDC.getStartParamClass();
            if (this.ppKind == 1) {
                n = 16;
                n2 = 1;
            } else {
                n = 17;
                n2 = 1;
            }
            bl = rJDataStartParam.getPermissionTABOption(n, n2);
        }
        return bl;
    }

    public int getPPKind() {
        return this.ppKind;
    }

    public boolean isURxURMultiTargetSupport() {
        boolean bl = true;
        if (this.getCommonDC().isHM()) {
            bl = false;
        } else if (this.getPPKind() != 1) {
            bl = false;
        }
        return bl;
    }

    public String getLUNDisplayString(int n) {
        return this.getLUNDisplayString(n, false);
    }

    public String getLUNDisplayString(int n, boolean bl) {
        String string = "";
        string = this.getCommonDC().isHM() ? RJComUty.itoa(n, 1) : RJComUty.itoh(n, 3, bl);
        return string;
    }

    public int getMyControllerId() {
        int n = 6;
        if (this.getCommonDC().isHM()) {
            n = 19;
        }
        return n;
    }

    public String getPPString() {
        return this.ppString;
    }

    public int getClientPart() {
        if (this.ppKind == 1) {
            return 6510;
        }
        return 6610;
    }

    public ArrayList getCUListOfFreeVol(short s) throws Exception {
        ArrayList<Robj_interface_RJiCUIndex> arrayList = new ArrayList<Robj_interface_RJiCUIndex>();
        try {
            RJiLDKCIndex[] rJiLDKCIndexArray = new RJiLDKCIndex[1];
            RJiLDKCIndex rJiLDKCIndex = new RJiLDKCIndex();
            rJiLDKCIndex.setSLDKC(s);
            rJiLDKCIndexArray[0] = rJiLDKCIndex;
            RJSetGettingParamVol rJSetGettingParamVol = new RJSetGettingParamVol();
            if (this.ppKind == 1) {
                rJSetGettingParamVol.setBOpenVolume(true);
            } else {
                rJSetGettingParamVol.setBOpenVolume(true);
                rJSetGettingParamVol.setBMFVolume(true);
            }
            RJDataLDEVPart rJDataLDEVPart = this.cmnDC.getLDEVPart();
            Robj_interface_RJiCUIndex[] robj_interface_RJiCUIndexArray = rJDataLDEVPart.getCUIndex((Robj_interface_RJiLDKCIndex[])rJiLDKCIndexArray, (Robj_interface_RJSetGettingParamVol)rJSetGettingParamVol);
            if (robj_interface_RJiCUIndexArray != null) {
                for (int i = 0; i < robj_interface_RJiCUIndexArray.length; ++i) {
                    arrayList.add(robj_interface_RJiCUIndexArray[i]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        return arrayList;
    }

    public ArrayList getFreeVolList(RJHurAbsChildPanel rJHurAbsChildPanel, RJComModalDialog rJComModalDialog, int n, int n2, int n3) throws Exception {
        ArrayList arrayList = null;
        try {
            boolean bl = false;
            RJDataPGPart rJDataPGPart = this.cmnDC.getPGPart();
            RJSetGettingParamDevice rJSetGettingParamDevice = new RJSetGettingParamDevice();
            rJSetGettingParamDevice.setBInternalDevice(true);
            rJSetGettingParamDevice.setBExternalDevice(true);
            Robj_interface_RJiPGIndex[] robj_interface_RJiPGIndexArray = rJDataPGPart.getPGIndex((Robj_interface_RJSetGettingParamDevice)rJSetGettingParamDevice);
            for (int i = 0; i < robj_interface_RJiPGIndexArray.length && !bl; ++i) {
                if (robj_interface_RJiPGIndexArray[i].getIFB4() != n2 || robj_interface_RJiPGIndexArray[i].getIPG() != n3) continue;
                bl = true;
            }
            if (!bl) {
                return new ArrayList();
            }
            RJiPGIndex[] rJiPGIndexArray = new RJiPGIndex[1];
            RJiPGIndex rJiPGIndex = new RJiPGIndex();
            rJiPGIndex.setPGIndex((int)((short)n2), (int)((short)n3));
            rJiPGIndexArray[0] = rJiPGIndex;
            RJDataLDEVPart rJDataLDEVPart = this.cmnDC.getLDEVPart();
            Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray = rJDataLDEVPart.getLDEVIndex((Robj_interface_RJiPGIndex[])rJiPGIndexArray);
            if (robj_interface_RJiLDEVIndexArray == null || robj_interface_RJiLDEVIndexArray.length <= 0) {
                System.out.println(this.getPPString() + " getFreeVolList(), no LDEV Index...");
                rJHurAbsChildPanel.putLog(this.getPPString(), "getFreeVolList()", "no LDEV Index...", 0);
                return new ArrayList();
            }
            arrayList = this.getValidVolForJNL(rJHurAbsChildPanel, rJComModalDialog, n, robj_interface_RJiLDEVIndexArray);
        }
        catch (Exception exception) {
            System.out.println(this.getPPString() + ", getFreeVolList(), Create Exception!!");
            rJHurAbsChildPanel.putLog(this.getPPString(), "getFreeVolList()", "Create Exception!!", 0);
            if (exception instanceof RJDataException) {
                rJHurAbsChildPanel.doErrorProcessWhenGet(exception);
            }
            throw exception;
        }
        return arrayList;
    }

    public ArrayList getFreeVolList(RJHurAbsChildPanel rJHurAbsChildPanel, RJComModalDialog rJComModalDialog, int n, int n2) throws Exception {
        ArrayList arrayList = null;
        try {
            RJiCUIndex rJiCUIndex = new RJiCUIndex();
            rJiCUIndex.setCUIndex((short)n, (short)n2);
            RJDataLDEVPart rJDataLDEVPart = this.cmnDC.getLDEVPart();
            Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray = rJDataLDEVPart.getLDEVIndex((Robj_interface_RJiCUIndex)rJiCUIndex);
            if (robj_interface_RJiLDEVIndexArray == null || robj_interface_RJiLDEVIndexArray.length <= 0) {
                System.out.println(this.getPPString() + " getFreeVolList(), no LDEV Index...");
                rJHurAbsChildPanel.putLog(this.getPPString(), "getFreeVolList()", "no LDEV Index...", 0);
                return new ArrayList();
            }
            arrayList = this.getValidVolForJNL(rJHurAbsChildPanel, rJComModalDialog, n, robj_interface_RJiLDEVIndexArray);
        }
        catch (Exception exception) {
            System.out.println(this.getPPString() + ", getFreeVolList(), Create Exception!!");
            rJHurAbsChildPanel.putLog(this.getPPString(), "getFreeVolList()", "Create Exception!!", 0);
            if (exception instanceof RJDataException) {
                rJHurAbsChildPanel.doErrorProcessWhenGet(exception);
            }
            throw exception;
        }
        return arrayList;
    }

    private ArrayList getValidVolForJNL(RJHurAbsChildPanel rJHurAbsChildPanel, RJComModalDialog rJComModalDialog, int n, Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray) throws Exception {
        ArrayList<RJiLDEVInfoDetail3> arrayList = new ArrayList<RJiLDEVInfoDetail3>();
        try {
            int n2 = 0;
            ArrayList<Robj_interface_RJiLDEVIndex> arrayList2 = new ArrayList<Robj_interface_RJiLDEVIndex>();
            for (n2 = 0; n2 < robj_interface_RJiLDEVIndexArray.length; ++n2) {
                if (n != robj_interface_RJiLDEVIndexArray[n2].getSLDKC()) continue;
                arrayList2.add(robj_interface_RJiLDEVIndexArray[n2]);
            }
            if (arrayList2.size() <= 0) {
                System.out.println(this.getPPString() + " getValidVolForJNL(), All LDEVs are different LDKC...");
                rJHurAbsChildPanel.putLog(this.getPPString(), "getValidVolForJNL()", "All LDEVs are different LDKC...", 0);
                return arrayList;
            }
            Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray2 = new Robj_interface_RJiLDEVIndex[arrayList2.size()];
            for (n2 = 0; n2 < robj_interface_RJiLDEVIndexArray2.length; ++n2) {
                robj_interface_RJiLDEVIndexArray2[n2] = (Robj_interface_RJiLDEVIndex)arrayList2.get(n2);
            }
            RJDataLDEVPart rJDataLDEVPart = this.cmnDC.getLDEVPart();
            RJSetGettingParamLDEV rJSetGettingParamLDEV = new RJSetGettingParamLDEV();
            rJSetGettingParamLDEV.setBBasic(true);
            rJSetGettingParamLDEV.setBSize(true);
            rJSetGettingParamLDEV.setBLUPath(true);
            rJSetGettingParamLDEV.setBPool(true);
            rJSetGettingParamLDEV.setBVDEVindex(true);
            RJiLDEVInfoDetail3[] rJiLDEVInfoDetail3Array = this.getLDEVInfoDetail_Srv(robj_interface_RJiLDEVIndexArray2, (Robj_interface_RJSetGettingParamLDEV)rJSetGettingParamLDEV);
            if (rJiLDEVInfoDetail3Array == null || rJiLDEVInfoDetail3Array.length <= 0) {
                System.out.println(this.getPPString() + " getValidVolForJNL(), no LDEV Detail!!");
                rJHurAbsChildPanel.putLog(this.getPPString(), "getValidVolForJNL()", "no LDEV Detail!!", 0);
                return arrayList;
            }
            RJiLDEVInfoDetail3[] rJiLDEVInfoDetail3Array2 = rJiLDEVInfoDetail3Array;
            if (this.ppKind == 0 && ((rJiLDEVInfoDetail3Array2 = this.excludeURMFPairs(rJHurAbsChildPanel, rJComModalDialog, rJiLDEVInfoDetail3Array)) == null || rJiLDEVInfoDetail3Array2.length <= 0)) {
                System.out.println(this.getPPString() + " getValidVolForJNL(), All LDEVs are UR-MF pairs...");
                rJHurAbsChildPanel.putLog(this.getPPString(), "getValidVolForJNL()", "All LDEVs are UR-MF pairs...", 0);
                return arrayList;
            }
            if (rJiLDEVInfoDetail3Array2 != null) {
                for (n2 = 0; n2 < rJiLDEVInfoDetail3Array2.length; ++n2) {
                    if (!this.isValidVol(rJiLDEVInfoDetail3Array2[n2], 1)) continue;
                    arrayList.add(rJiLDEVInfoDetail3Array2[n2]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        return arrayList;
    }

    private RJiLDEVInfoDetail3[] excludeURMFPairs(RJHurAbsChildPanel rJHurAbsChildPanel, RJComModalDialog rJComModalDialog, RJiLDEVInfoDetail3[] rJiLDEVInfoDetail3Array) throws Exception {
        RJiLDEVInfoDetail3[] rJiLDEVInfoDetail3Array2 = rJiLDEVInfoDetail3Array;
        int n = 0;
        ArrayList<RJiLDEVInfoDetail3> arrayList = new ArrayList<RJiLDEVInfoDetail3>();
        for (n = 0; n < rJiLDEVInfoDetail3Array.length; ++n) {
            arrayList.add(rJiLDEVInfoDetail3Array[n]);
        }
        RJiLDEVInfoDetail3[] rJiLDEVInfoDetail3Array3 = null;
        int n2 = rJiLDEVInfoDetail3Array.length;
        for (int i = 0; i < n2; i += 2048) {
            rJiLDEVInfoDetail3Array3 = n2 - i < 2048 ? new RJiLDEVInfoDetail3[n2 - i] : new RJiLDEVInfoDetail3[2048];
            for (n = 0; n < rJiLDEVInfoDetail3Array3.length; ++n) {
                rJiLDEVInfoDetail3Array3[n] = rJiLDEVInfoDetail3Array[i + n];
            }
            RJiInputHurPairParam rJiInputHurPairParam = new RJiInputHurPairParam();
            rJiInputHurPairParam.setPP((short)(this.ppKind + 16));
            rJiInputHurPairParam.setFilterStatus((short)254);
            rJiInputHurPairParam.setLDEVs((Robj_interface_RJiLDEVIndex[])rJiLDEVInfoDetail3Array3);
            rJHurAbsChildPanel.waitCtl();
            this.getCommonDC().waitDC(rJComModalDialog);
        }
        rJiLDEVInfoDetail3Array2 = new RJiLDEVInfoDetail3[arrayList.size()];
        for (n = 0; n < rJiLDEVInfoDetail3Array2.length; ++n) {
            rJiLDEVInfoDetail3Array2[n] = (RJiLDEVInfoDetail3)arrayList.get(n);
        }
        return rJiLDEVInfoDetail3Array2;
    }

    public RJiLDEVInfoDetail3[] getVolList(RJHurAbsChildPanel rJHurAbsChildPanel, int n) throws Exception {
        ArrayList arrayList = null;
        this.ldevDetail = null;
        RJiLDEVInfoDetail3[] rJiLDEVInfoDetail3Array = null;
        try {
            short s;
            if (this.ppKind == 1) {
                arrayList = this.getVolListOPEN(rJHurAbsChildPanel, n);
            } else {
                s = (short)((n & 0xF00000) - 1 >>> 20);
                ArrayList<Short> arrayList2 = new ArrayList<Short>();
                if ((n & 0xFF) != 0) {
                    arrayList2.add(new Short((short)((n & 0xFF) - 1)));
                } else {
                    RJDataLDEVPart rJDataLDEVPart = this.cmnDC.getLDEVPart();
                    RJiLDKCIndex[] rJiLDKCIndexArray = new RJiLDKCIndex[]{new RJiLDKCIndex()};
                    rJiLDKCIndexArray[0].setSLDKC(s);
                    RJSetGettingParamVol rJSetGettingParamVol = new RJSetGettingParamVol();
                    rJSetGettingParamVol.setBMFVolume(true);
                    rJSetGettingParamVol.setBMiddleVolume(true);
                    Robj_interface_RJiCUIndex[] robj_interface_RJiCUIndexArray = rJDataLDEVPart.getCUIndex((Robj_interface_RJiLDKCIndex[])rJiLDKCIndexArray, (Robj_interface_RJSetGettingParamVol)rJSetGettingParamVol);
                    int n2 = (n & 0xFF00) - 1 >>> 8;
                    for (int i = 0; i < robj_interface_RJiCUIndexArray.length; ++i) {
                        short s2 = robj_interface_RJiCUIndexArray[i].getSCU();
                        short s3 = (short)(n2 * 8);
                        short s4 = (short)((n2 + 1) * 8);
                        if (s3 > s2 || s2 >= s4) continue;
                        arrayList2.add(new Short(s2));
                    }
                }
                arrayList = this.getVolListMF(rJHurAbsChildPanel, s, arrayList2);
            }
            rJiLDEVInfoDetail3Array = new RJiLDEVInfoDetail3[arrayList.size()];
            for (s = 0; s < rJiLDEVInfoDetail3Array.length; ++s) {
                rJiLDEVInfoDetail3Array[s] = (RJiLDEVInfoDetail3)arrayList.get(s);
            }
            this.ldevDetail = rJiLDEVInfoDetail3Array;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        return rJiLDEVInfoDetail3Array;
    }

    public boolean isValidVol(RJiLDEVInfoDetail3 rJiLDEVInfoDetail3, int n) {
        boolean bl = false;
        try {
            if (n == 1) {
                if (!this.isEmulationCorrectForJNL(rJiLDEVInfoDetail3)) {
                    return bl;
                }
                if (0 < rJiLDEVInfoDetail3.getILUPathNumber()) {
                    return bl;
                }
                if (1 != rJiLDEVInfoDetail3.getSLUSEElmCount()) {
                    return bl;
                }
                if (rJiLDEVInfoDetail3.isVvol()) {
                    return bl;
                }
                if (rJiLDEVInfoDetail3.isBLockVolume()) {
                    return bl;
                }
                if (rJiLDEVInfoDetail3.getLLDEVLBASize() < 0x300000L) {
                    return bl;
                }
            } else {
                if (!this.isEmulationCorrect(rJiLDEVInfoDetail3)) {
                    return bl;
                }
                if (rJiLDEVInfoDetail3.isQSVvol()) {
                    return bl;
                }
            }
            if (rJiLDEVInfoDetail3.isBJNLVolume()) {
                return bl;
            }
            if (rJiLDEVInfoDetail3.isBLUPathCmdDev()) {
                return bl;
            }
            if (rJiLDEVInfoDetail3.isBPoolVol()) {
                return bl;
            }
            if (rJiLDEVInfoDetail3.isBSystemDisk()) {
                return bl;
            }
            if (rJiLDEVInfoDetail3.isExternalMFVolume()) {
                return bl;
            }
            if (rJiLDEVInfoDetail3.isBOdmVolume()) {
                return bl;
            }
            bl = true;
        }
        catch (Exception exception) {
            System.out.println(this.getPPString() + ", isValidVol(), Exception!!");
        }
        return bl;
    }

    private boolean isEmulationCorrect(RJiLDEVInfoDetail3 rJiLDEVInfoDetail3) throws Exception {
        boolean bl = false;
        String string = null;
        try {
            RJDataChange rJDataChange;
            if (this.ppKind == 0) {
                RJDataChange rJDataChange2;
                if (rJiLDEVInfoDetail3.isMFVolume()) {
                    RJDataChange rJDataChange3 = this.cmnDC.getChangeTbl();
                    string = rJDataChange3.getEmulationTypeName(rJiLDEVInfoDetail3.getIEmulationType());
                    if (!string.substring(0, 6).equals("3390-V")) {
                        bl = true;
                    }
                } else if (rJiLDEVInfoDetail3.isMiddleVolume() && ((string = (rJDataChange2 = this.cmnDC.getChangeTbl()).getEmulationTypeName(rJiLDEVInfoDetail3.getIEmulationType())).substring(0, 7).equals("3390-9A") || string.substring(0, 7).equals("6588-9A"))) {
                    bl = true;
                }
            } else if (rJiLDEVInfoDetail3.isOpenVolume() && (string = (rJDataChange = this.cmnDC.getChangeTbl()).getEmulationTypeName(rJiLDEVInfoDetail3.getIEmulationType())).substring(0, 6).equals("OPEN-V")) {
                bl = true;
            }
        }
        catch (Exception exception) {
            System.out.println(this.getPPString() + ", isEmulationCorrect(), Exception!!");
        }
        return bl;
    }

    private boolean isEmulationCorrectForJNL(RJiLDEVInfoDetail3 rJiLDEVInfoDetail3) {
        boolean bl = false;
        try {
            RJDataChange rJDataChange;
            String string;
            if (rJiLDEVInfoDetail3.isOpenVolume()) {
                RJDataChange rJDataChange2 = this.cmnDC.getChangeTbl();
                String string2 = rJDataChange2.getEmulationTypeName(rJiLDEVInfoDetail3.getIEmulationType());
                if (string2.substring(0, 6).equals("OPEN-V")) {
                    bl = true;
                }
            } else if (this.ppKind == 0 && rJiLDEVInfoDetail3.isMFVolume() && !(string = (rJDataChange = this.cmnDC.getChangeTbl()).getEmulationTypeName(rJiLDEVInfoDetail3.getIEmulationType())).substring(0, 6).equals("3390-V") && 50L <= rJiLDEVInfoDetail3.getLLDEVSize()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            System.out.println(this.getPPString() + ", isEmulationCorrectForJNL(), Exception!!");
        }
        return bl;
    }

    private ArrayList getVolListOPEN(RJHurAbsChildPanel rJHurAbsChildPanel, int n) throws Exception {
        int n2 = 0;
        ArrayList<RJiLDEVInfoDetail3> arrayList = new ArrayList<RJiLDEVInfoDetail3>();
        this.luPathArray.clear();
        try {
            short s = (short)((n & 0xFF00) >>> 8);
            short s2 = (short)(n & 0xFF);
            RJiPortIndex rJiPortIndex = new RJiPortIndex();
            rJiPortIndex.setSPort(s);
            RJDataPathPart rJDataPathPart = this.cmnDC.getPathPart();
            Robj_interface_RJiLUPathIndex[] robj_interface_RJiLUPathIndexArray = rJDataPathPart.getLUPathIndex((Robj_interface_RJiPortIndex)rJiPortIndex);
            if (robj_interface_RJiLUPathIndexArray == null || robj_interface_RJiLUPathIndexArray.length <= 0) {
                System.out.println(this.getPPString() + ", getVolListOPEN(), no Path Index...");
                rJHurAbsChildPanel.putLog(this.getPPString(), "getVolListOPEN()", "no Path Index...", 0);
                return arrayList;
            }
            RJiLDEVIndex[] rJiLDEVIndexArray = new RJiLDEVIndex[robj_interface_RJiLUPathIndexArray.length];
            for (n2 = 0; n2 < rJiLDEVIndexArray.length; ++n2) {
                rJiLDEVIndexArray[n2] = new RJiLDEVIndex();
                rJiLDEVIndexArray[n2].setLDEVIndex(robj_interface_RJiLUPathIndexArray[n2].getSLDKC(), robj_interface_RJiLUPathIndexArray[n2].getSCU(), robj_interface_RJiLUPathIndexArray[n2].getSLDEV());
            }
            RJSetGettingParamLDEV rJSetGettingParamLDEV = new RJSetGettingParamLDEV();
            rJSetGettingParamLDEV.setBBasic(true);
            rJSetGettingParamLDEV.setBSize(true);
            rJSetGettingParamLDEV.setBLUPath(true);
            rJSetGettingParamLDEV.setBPool(true);
            RJDataLDEVPart rJDataLDEVPart = this.getCommonDC().getLDEVPart();
            RJiLDEVInfoDetail3[] rJiLDEVInfoDetail3Array = this.getLDEVInfoDetail_Srv((Robj_interface_RJiLDEVIndex[])rJiLDEVIndexArray, (Robj_interface_RJSetGettingParamLDEV)rJSetGettingParamLDEV);
            if (rJHurAbsChildPanel.doErrorProocessWhenGet() != 0) {
                System.out.println(this.getPPString() + ", getVolListOPEN(), Create Exception!!");
                rJHurAbsChildPanel.putLog(this.getPPString(), "getVolListOPEN()", "Create Exception!!", 0);
                Exception exception = new Exception();
            }
            if (rJiLDEVInfoDetail3Array != null) {
                for (n2 = 0; n2 < rJiLDEVInfoDetail3Array.length; ++n2) {
                    if ((n & 0x10000000) != 0 && s2 != robj_interface_RJiLUPathIndexArray[n2].getSHostGroup() || !this.isValidVol(rJiLDEVInfoDetail3Array[n2], 2)) continue;
                    arrayList.add(rJiLDEVInfoDetail3Array[n2]);
                    this.luPathArray.add(robj_interface_RJiLUPathIndexArray[n2]);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(this.getPPString() + ", getVolListOPEN(), Create Exception!!");
            rJHurAbsChildPanel.putLog(this.getPPString(), "getVolListOPEN()", "Create Exception!!", 0);
            throw exception;
        }
        return arrayList;
    }

    private ArrayList getVolListMF(RJHurAbsChildPanel rJHurAbsChildPanel, short s, ArrayList arrayList) throws Exception {
        int n = 0;
        ArrayList<RJiLDEVInfoDetail3> arrayList2 = new ArrayList<RJiLDEVInfoDetail3>();
        try {
            RJiCUIndex[] rJiCUIndexArray = new RJiCUIndex[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                short s2 = (Short)arrayList.get(i);
                rJiCUIndexArray[i] = new RJiCUIndex();
                rJiCUIndexArray[i].setCUIndex(s, s2);
            }
            RJDataLDEVPart rJDataLDEVPart = this.cmnDC.getLDEVPart();
            Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray = rJDataLDEVPart.getLDEVIndex((Robj_interface_RJiCUIndex[])rJiCUIndexArray);
            if (robj_interface_RJiLDEVIndexArray == null || robj_interface_RJiLDEVIndexArray.length <= 0) {
                System.out.println(this.getPPString() + ", getVolListMF(), no LDEV Index...");
                rJHurAbsChildPanel.putLog(this.getPPString(), "getVolListMF()", "no LDEV Index...", 0);
                return arrayList2;
            }
            RJSetGettingParamLDEV rJSetGettingParamLDEV = new RJSetGettingParamLDEV();
            rJSetGettingParamLDEV.setBBasic(true);
            rJSetGettingParamLDEV.setBSize(true);
            rJSetGettingParamLDEV.setBLUPath(true);
            rJSetGettingParamLDEV.setBPool(true);
            RJiLDEVInfoDetail3[] rJiLDEVInfoDetail3Array = this.getLDEVInfoDetail_Srv(robj_interface_RJiLDEVIndexArray, (Robj_interface_RJSetGettingParamLDEV)rJSetGettingParamLDEV);
            if (rJiLDEVInfoDetail3Array != null) {
                for (n = 0; n < rJiLDEVInfoDetail3Array.length; ++n) {
                    if (!this.isValidVol(rJiLDEVInfoDetail3Array[n], 2)) continue;
                    arrayList2.add(rJiLDEVInfoDetail3Array[n]);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(this.getPPString() + ", getVolListMF(), Create Exception!!");
            rJHurAbsChildPanel.putLog(this.getPPString(), "getVolListMF()", "Create Exception!!", 0);
            throw exception;
        }
        return arrayList2;
    }

    public RJiLDEVInfoDetail3[] getLdevDetail() {
        return this.ldevDetail;
    }

    public ArrayList getLUPathArray() {
        return this.luPathArray;
    }

    public String getFormattedCLPRName(PRMName pRMName, int n) {
        String string = "";
        try {
            string = string + RJComUty.itoa(n, 2);
            String string2 = pRMName.getCLPRName(n);
            string = string + ":" + string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    public static String[] getPortList(int n) {
        String[] stringArray = PortList_R700;
        switch (n) {
            case 19: {
                stringArray = PortList_H700;
                break;
            }
            case 6: {
                break;
            }
            default: {
                stringArray = PortList_R600;
                System.out.println("RJHurDataControl.getPortList(), future modelID = " + n);
            }
        }
        return stringArray;
    }

    public static String convertPortName(int n, int n2) {
        String string = null;
        if (0 <= n2 && n2 < 256) {
            string = PortList_ALL[n2];
        }
        if (string == null) {
            System.out.println("RJHurDataControl.convertPortName Invalid modelID,port=" + n + "," + n2);
        }
        return string;
    }

    public static int convertPortNumber(int n, String string) {
        int n2 = -1;
        for (int i = 0; i < PortList_ALL.length; ++i) {
            if (!PortList_ALL[i].equals(string)) continue;
            n2 = i;
            break;
        }
        if (n2 == -1) {
            System.out.println("RJHurDataControl.convertPortNumber Invalid modelID,name=" + n + "," + string);
        }
        return n2;
    }

    public String convertDetailStatusString(HURget1PairDetail hURget1PairDetail) {
        String string = "Unknown";
        if (RJHurDataControl.checkPairStatus(hURget1PairDetail.status, 1)) {
            string = "SMPL";
        } else if (RJHurDataControl.checkPairStatus(hURget1PairDetail.status, 2)) {
            if (hURget1PairDetail.queu == 1) {
                string = RJHurGuide.text("PAIRDT_COPY") + " (" + RJHurGuide.text("PAIRDT_Queuing") + ")";
                return string;
            }
            string = "COPY";
        } else if (RJHurDataControl.checkPairStatus(hURget1PairDetail.status, 4)) {
            string = "PAIR";
        } else if (RJHurDataControl.checkPairStatus(hURget1PairDetail.status, 8, hURget1PairDetail.delta)) {
            switch (hURget1PairDetail.status) {
                case 3: {
                    string = "PSUS_OPEP";
                    break;
                }
                case 4: {
                    string = "PSUS_OPES";
                    break;
                }
                case 5: {
                    string = "PSUS_MCU";
                    break;
                }
                case 6: {
                    string = "PSUS_RCU";
                    break;
                }
                case 7: {
                    string = "PSUS_DEL";
                    break;
                }
                case 99: {
                    string = "PSUS_SOVR";
                    break;
                }
                default: {
                    string = "PSUS";
                    break;
                }
            }
        } else if (RJHurDataControl.checkPairStatus(hURget1PairDetail.status, 16, hURget1PairDetail.delta)) {
            switch (hURget1PairDetail.status) {
                case 8: {
                    string = "PSUE_SVLF";
                    break;
                }
                case 9: {
                    string = "PSUE_IMPL";
                    break;
                }
                case 80: {
                    string = "PSUE_ICPY";
                    break;
                }
                case 98: {
                    string = "PSUE_PSOF";
                    break;
                }
                default: {
                    string = "PSUE";
                    break;
                }
            }
        } else if (RJHurDataControl.checkPairStatus(hURget1PairDetail.status, 32)) {
            string = "Suspending";
        } else if (RJHurDataControl.checkPairStatus(hURget1PairDetail.status, 64)) {
            string = "Deleting";
        } else if (RJHurDataControl.checkPairStatus(hURget1PairDetail.status, 256, hURget1PairDetail.delta)) {
            string = "HOLD";
        } else if (RJHurDataControl.checkPairStatus(hURget1PairDetail.status, 512, hURget1PairDetail.delta)) {
            string = "HLDE";
        } else if (RJHurDataControl.checkPairStatus(hURget1PairDetail.status, 1024, hURget1PairDetail.delta)) {
            string = "HOLDING";
        }
        return "PAIRDT_" + string;
    }

    public Icon convertDetailStatusIcon(HURget1PairDetail hURget1PairDetail) {
        String string = "HURPairSMPL";
        Icon icon = null;
        if (RJHurDataControl.checkPairStatus(hURget1PairDetail.status, 1)) {
            string = "HURPairSMPL";
        } else if (RJHurDataControl.checkPairStatus(hURget1PairDetail.status, 2)) {
            string = hURget1PairDetail.volType == 0 ? "HURPairCOPY_P" : "HURPairCOPY_S";
        } else if (RJHurDataControl.checkPairStatus(hURget1PairDetail.status, 4)) {
            string = hURget1PairDetail.volType == 0 ? "HURPairPAIR_P" : "HURPairPAIR_S";
        } else if (RJHurDataControl.checkPairStatus(hURget1PairDetail.status, 8, hURget1PairDetail.delta) || RJHurDataControl.checkPairStatus(hURget1PairDetail.status, 256, hURget1PairDetail.delta) || RJHurDataControl.checkPairStatus(hURget1PairDetail.status, 1024, hURget1PairDetail.delta)) {
            string = hURget1PairDetail.volType == 0 ? "HURPairPSUS_P" : "HURPairPSUS_S";
        } else if (RJHurDataControl.checkPairStatus(hURget1PairDetail.status, 16, hURget1PairDetail.delta) || RJHurDataControl.checkPairStatus(hURget1PairDetail.status, 512, hURget1PairDetail.delta)) {
            string = hURget1PairDetail.volType == 0 ? "HURPairPSUE_P" : "HURPairPSUE_S";
        } else if (RJHurDataControl.checkPairStatus(hURget1PairDetail.status, 32)) {
            string = hURget1PairDetail.volType == 0 ? "HURPairSuspending_P" : "HURPairSuspending_S";
        } else if (RJHurDataControl.checkPairStatus(hURget1PairDetail.status, 64)) {
            string = hURget1PairDetail.volType == 0 ? "HURPairDeleting_P" : "HURPairDeleting_S";
        }
        icon = RJCom.createImgIcon(this.cmnDC, string + ".gif");
        return icon;
    }

    public static boolean checkPairStatus(int n, int n2) {
        int n3 = 128;
        for (int i = 0; i < pairstatus.length; i += 2) {
            if (pairstatus[i] != n) continue;
            n3 = pairstatus[i + 1];
            break;
        }
        if (n3 == 128) {
            System.out.println("RJHurDataControl.checkPairStatus Invalid status=" + n);
        }
        return (n3 & n2) != 0;
    }

    public static boolean checkPairStatus(int n, int n2, int n3) {
        int n4 = 128;
        for (int i = 0; i < pairstatus.length; i += 2) {
            if (pairstatus[i] != n) continue;
            n4 = pairstatus[i + 1];
            break;
        }
        if (n4 == 128) {
            System.out.println("RJHurDataControl.checkPairStatus2 Invalid status=" + n);
        }
        if (n4 == 8) {
            switch (n3) {
                case 0: {
                    break;
                }
                case 2: {
                    n4 = 256;
                    break;
                }
                case 3: {
                    n4 = 512;
                    break;
                }
                case 6: {
                    n4 = 1024;
                    break;
                }
                default: {
                    System.out.println("RJHurDataControl.checkPairStatus2 Invalid Delta=" + n3);
                }
            }
        }
        return (n4 & n2) != 0;
    }

    public static int getMaxCUNumber(int n) {
        int n2 = 254;
        switch (n) {
            case 4: {
                n2 = 63;
                break;
            }
            case 5: 
            case 6: 
            case 19: {
                n2 = 254;
                break;
            }
            default: {
                System.out.println("RJHurDataControl.getMaxCUNumber Unknown modelID=" + n);
            }
        }
        return n2;
    }

    public static int getMaxHOSTGNumber(int n) {
        int n2 = 254;
        switch (n) {
            case 4: 
            case 5: 
            case 6: 
            case 19: {
                n2 = 254;
                break;
            }
            default: {
                System.out.println("RJHurDataControl.getMaxHOSTGNumber Unknown modelID=" + n);
            }
        }
        return n2;
    }

    public static int getMaxLUNNumber(int n) {
        int n2 = 2047;
        switch (n) {
            case 4: {
                n2 = 1023;
                break;
            }
            case 5: 
            case 6: 
            case 19: {
                n2 = 2047;
                break;
            }
            default: {
                System.out.println("RJHurDataControl.getMaxLUNNumber Unknown modelID=" + n);
            }
        }
        return n2;
    }

    public int getMaxJNLNumber(int n) {
        int n2 = 255;
        switch (n) {
            case 4: 
            case 5: {
                n2 = 255;
                break;
            }
            case 6: 
            case 19: {
                HURgetSystemOption hURgetSystemOption = this.getHurSystemOption(null, false);
                if ((hURgetSystemOption.support & 0x8000) == 32768) {
                    n2 = 511;
                    break;
                }
                n2 = 255;
                break;
            }
            default: {
                System.out.println("RJHurDataControl.getMaxJNLNumber Unknown modelID=" + n);
            }
        }
        return n2;
    }

    public static int getMaxLDKCNumber(int n) {
        int n2 = 0;
        switch (n) {
            case 4: {
                n2 = 0;
                break;
            }
            case 5: 
            case 6: 
            case 19: {
                n2 = 0;
                break;
            }
            default: {
                System.out.println("RJHurDataControl.getMaxLDKCNumber() Unknown modelID = " + n);
            }
        }
        return n2;
    }

    public void setUsgGuide(RJHurUsgGuide rJHurUsgGuide) {
        this.usgGuid = rJHurUsgGuide;
    }

    public RJHurUsgGuide getUsgGuide() {
        return this.usgGuid;
    }

    public RJiHURgetJNLG1Mirror getRMI1MID(RJiHURgetJNLGrps[] rJiHURgetJNLGrpsArray, int n, int n2) {
        RJiHURgetJNLG1Mirror rJiHURgetJNLG1Mirror = null;
        int n3 = this.getLdkcNum(n);
        int n4 = this.getJnlgNum(n);
        try {
            block2: for (int i = 0; i < rJiHURgetJNLGrpsArray.length; ++i) {
                Iterator iterator = rJiHURgetJNLGrpsArray[i].jnlGroups.iterator();
                while (iterator.hasNext()) {
                    RJiHURget1JNLG rJiHURget1JNLG = (RJiHURget1JNLG)iterator.next();
                    if (rJiHURget1JNLG.jnlGrpNumber != n4 || rJiHURget1JNLG.ldkc != n3) continue;
                    Iterator iterator2 = rJiHURget1JNLG.mirrors.iterator();
                    while (iterator2.hasNext()) {
                        RJiHURgetJNLG1Mirror rJiHURgetJNLG1Mirror2 = (RJiHURgetJNLG1Mirror)iterator2.next();
                        if (rJiHURgetJNLG1Mirror2.mirrorID != n2) continue;
                        rJiHURgetJNLG1Mirror = rJiHURgetJNLG1Mirror2;
                        continue block2;
                    }
                    break block3;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return rJiHURgetJNLG1Mirror;
    }

    public String getVolAttrbSign(int n) {
        String string = "";
        if (n != 0) {
            if ((n & 1) == 1) {
                string = string + " #";
            }
            if ((n & 2) == 2) {
                string = string + " X";
            }
            if (string.equals("")) {
                System.out.println("[HUR] getVolAttrbSign(), iAttrb = " + n);
            }
        }
        return string;
    }

    public static long convertCYLtoKB(long l, String string) {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 15L;
        try {
            String string2 = string.substring(0, 5);
            if (string2.equals("3390-") || string2.equals("6588-") || string2.equals("BL90-")) {
                l3 = 58L;
            } else if (string2.equals("3380-") || string2.equals("6586-") || string2.equals("NF80-")) {
                l3 = 48L;
            }
            l2 = l * l4 * l3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return l2;
    }

    public long convertKBtoCYL(long l, String string) {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 15L;
        try {
            if (string != null && 5 <= string.length()) {
                String string2 = string.substring(0, 5);
                if (string2.equals("3390-") || string2.equals("6588-") || string2.equals("BL90-")) {
                    l3 = 58L;
                } else if (string2.equals("3380-") || string2.equals("6586-") || string2.equals("NF80-")) {
                    l3 = 48L;
                } else {
                    return 0L;
                }
                l2 = l / l4 / l3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return l2;
    }

    public boolean hasActiveMirror(RJiHURgetJNLGrps[] rJiHURgetJNLGrpsArray, int n) {
        boolean bl = false;
        int n2 = this.getLdkcNum(n);
        int n3 = this.getJnlgNum(n);
        try {
            block2: for (int i = 0; i < rJiHURgetJNLGrpsArray.length; ++i) {
                Iterator iterator = rJiHURgetJNLGrpsArray[i].jnlGroups.iterator();
                while (iterator.hasNext()) {
                    RJiHURget1JNLG rJiHURget1JNLG = (RJiHURget1JNLG)iterator.next();
                    if (rJiHURget1JNLG.jnlGrpNumber != n3 || rJiHURget1JNLG.ldkc != n2) continue;
                    Iterator iterator2 = rJiHURget1JNLG.mirrors.iterator();
                    while (iterator2.hasNext()) {
                        RJiHURgetJNLG1Mirror rJiHURgetJNLG1Mirror = (RJiHURgetJNLG1Mirror)iterator2.next();
                        if (rJiHURgetJNLG1Mirror.status != 16) continue;
                        bl = true;
                        continue block2;
                    }
                    break block3;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public Object[] getLunsGroupName(RJHurAbsChildPanel rJHurAbsChildPanel, Robj_interface_RJiPortInfoDetail robj_interface_RJiPortInfoDetail) throws Exception {
        Object[] objectArray = null;
        Object var4_4 = null;
        Robj_interface_RJiHostGroupInfoDetail[] robj_interface_RJiHostGroupInfoDetailArray = null;
        boolean bl = false;
        try {
            RJDataPortPart rJDataPortPart = this.cmnDC.getPortPart();
            RJiPortIndex[] rJiPortIndexArray = new RJiPortIndex[]{new RJiPortIndex()};
            rJiPortIndexArray[0].setSPort(robj_interface_RJiPortInfoDetail.getSPort());
            switch (robj_interface_RJiPortInfoDetail.getByPortKindNo()) {
                case 2: 
                case 6: {
                    robj_interface_RJiHostGroupInfoDetailArray = rJDataPortPart.getHostGroupInfoDetail((Robj_interface_RJiPortIndex[])rJiPortIndexArray);
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    System.out.println(this.getPPString() + ", getLunsGroupName(), Illegal PCB Type!!");
                    rJHurAbsChildPanel.putLog(this.getPPString(), "getLunsGroupName()", "Illegal PCB Type!!", 0);
                    return objectArray;
                }
            }
            if (robj_interface_RJiPortInfoDetail.getByPortKindNo() == 2 || robj_interface_RJiPortInfoDetail.getByPortKindNo() == 6) {
                if (robj_interface_RJiHostGroupInfoDetailArray != null) {
                    objectArray = robj_interface_RJiHostGroupInfoDetailArray;
                }
            } else if (var4_4 != null) {
                objectArray = var4_4;
            }
        }
        catch (Exception exception) {
            System.out.println(this.getPPString() + ", getLunsGroupName(), ABEND!!");
            rJHurAbsChildPanel.putLog(this.getPPString(), "getLunsGroupName()", "ABEND!!", 0);
            if (exception instanceof RJDataException) {
                rJHurAbsChildPanel.doErrorProcessWhenGet(exception);
            }
            throw exception;
        }
        return objectArray;
    }

    public int getMirrorStatus(RJiHURgetJNLGrps[] rJiHURgetJNLGrpsArray, int n, int n2) {
        int n3 = 0;
        try {
            RJiHURgetJNLG1Mirror rJiHURgetJNLG1Mirror = this.getRMI1MID(rJiHURgetJNLGrpsArray, n, n2);
            if (rJiHURgetJNLG1Mirror != null) {
                n3 = this.checkDeltaMirror(rJiHURgetJNLG1Mirror.status, rJiHURgetJNLG1Mirror.delta);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n3;
    }

    public int hasSpecifiedMirror(RJiHURgetJNLGrps[] rJiHURgetJNLGrpsArray, int n, int n2) {
        int n3 = -1;
        try {
            int n4 = this.getLdkcNum(n);
            int n5 = this.getJnlgNum(n);
            block2: for (int i = 0; i < rJiHURgetJNLGrpsArray.length; ++i) {
                Iterator iterator = rJiHURgetJNLGrpsArray[i].jnlGroups.iterator();
                while (iterator.hasNext()) {
                    RJiHURget1JNLG rJiHURget1JNLG = (RJiHURget1JNLG)iterator.next();
                    if (rJiHURget1JNLG.jnlGrpNumber != n5 || rJiHURget1JNLG.ldkc != n4) continue;
                    Iterator iterator2 = rJiHURget1JNLG.mirrors.iterator();
                    while (iterator2.hasNext()) {
                        RJiHURgetJNLG1Mirror rJiHURgetJNLG1Mirror = (RJiHURgetJNLG1Mirror)iterator2.next();
                        int n6 = this.checkDeltaMirror(rJiHURgetJNLG1Mirror.status, rJiHURgetJNLG1Mirror.delta);
                        if (n6 != n2) continue;
                        n3 = rJiHURgetJNLG1Mirror.mirrorID;
                        continue block2;
                    }
                    break block3;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n3;
    }

    public int checkDeltaMirror(int n, int n2) {
        if (n == 64) {
            switch (n2) {
                case 1: {
                    n = 256;
                    break;
                }
                case 2: {
                    n = 512;
                    break;
                }
                case 3: {
                    n = 1024;
                    break;
                }
            }
        }
        return n;
    }

    public int getLdkcNum(int n) {
        return (n & 0xFF0000) >>> 16;
    }

    public int getJnlgNum(int n) {
        return n & 0x1FF;
    }

    public RJiLDEVInfoDetail3 getLDEVInfoDetailData(int n, int n2, int n3) {
        RJiLDEVInfoDetail3 rJiLDEVInfoDetail3 = null;
        if (this.ldevDetail != null) {
            for (int i = 0; i < this.ldevDetail.length; ++i) {
                if (this.ldevDetail[i].getSLDKC() != n || this.ldevDetail[i].getSCU() != n2 || this.ldevDetail[i].getSLDEV() != n3) continue;
                rJiLDEVInfoDetail3 = this.ldevDetail[i];
                break;
            }
        }
        return rJiLDEVInfoDetail3;
    }

    public boolean isFibrePort(Robj_interface_RJiPortInfoDetail robj_interface_RJiPortInfoDetail) {
        if (robj_interface_RJiPortInfoDetail == null) {
            System.out.println(this.getPPString() + ", isFibrePort(), dataPortInf = null");
            return false;
        }
        byte by = robj_interface_RJiPortInfoDetail.getByPortKindNo();
        switch (by) {
            case 2: 
            case 6: {
                break;
            }
            default: {
                System.out.println(this.getPPString() + ", isFibrePort(), Not Fibre");
                return false;
            }
        }
        return true;
    }

    public HURgetSystemOption getHurSystemOption(RJComPanel rJComPanel, boolean bl) {
        if (bl || this.hurSystemOption == null) {
            rJComPanel.waitCtl();
            this.cmnDC.getHurSystemOption(this.ppKind);
            this.cmnDC.waitDC();
            this.hurSystemOption = this.cmnDC.getHurSystemOptionData();
        }
        return this.hurSystemOption;
    }

    public static String getStrRCmdDev(int n) {
        String string = new String();
        string = n != -1 ? RJComUty.itoh(n >> 16 & 0xFF, 2) + ":" + RJComUty.itoh(n >> 8 & 0xFF, 2) + ":" + RJComUty.itoh(n & 0xFF, 2) + " #" : RJHurGuide.text("JNLTAB_RCMD_NOT_USE");
        return string;
    }

    public RJiHURget1JNLG findRMIof1JNLGrp(RJiHURgetJNLGrps[] rJiHURgetJNLGrpsArray, int n, int n2) {
        RJiHURget1JNLG rJiHURget1JNLG = null;
        try {
            for (int i = 0; i < rJiHURgetJNLGrpsArray.length; ++i) {
                Iterator iterator = rJiHURgetJNLGrpsArray[i].jnlGroups.iterator();
                while (iterator.hasNext()) {
                    RJiHURget1JNLG rJiHURget1JNLG2 = (RJiHURget1JNLG)iterator.next();
                    if (rJiHURget1JNLG2.jnlGrpNumber != n2 || rJiHURget1JNLG2.ldkc != n) continue;
                    rJiHURget1JNLG = rJiHURget1JNLG2;
                    break;
                }
                if (rJiHURget1JNLG == null) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return rJiHURget1JNLG;
    }

    public String makeJNLGAttrb(int n, int n2) {
        String string = new String("");
        if (n2 != 0) {
            string = string + " [M]";
        }
        if (n != 0) {
            if (string.length() <= 0) {
                string = string + " ";
            }
            string = string + "[&]";
        }
        return string;
    }

    public RJiLDEVInfoDetail3[] getLDEVInfoDetail_Srv(Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray, Robj_interface_RJSetGettingParamLDEV robj_interface_RJSetGettingParamLDEV) {
        RJiLDEVInfoDetail3[] rJiLDEVInfoDetail3Array = null;
        DKCgetLDEVInfoDetail_OUT dKCgetLDEVInfoDetail_OUT = null;
        DKCgetLDEVInfoDetail_IN dKCgetLDEVInfoDetail_IN = new DKCgetLDEVInfoDetail_IN();
        dKCgetLDEVInfoDetail_IN.setRJiLDEVIndex(robj_interface_RJiLDEVIndexArray);
        dKCgetLDEVInfoDetail_IN.setGettingParamLDEV(robj_interface_RJSetGettingParamLDEV);
        this.waitCtl();
        this.cmnDC.getDataInfEx((SanRmiInputInterface)dKCgetLDEVInfoDetail_IN);
        this.cmnDC.waitDC();
        dKCgetLDEVInfoDetail_OUT = (DKCgetLDEVInfoDetail_OUT)this.cmnDC.getDataInfExData();
        rJiLDEVInfoDetail3Array = (RJiLDEVInfoDetail3[])dKCgetLDEVInfoDetail_OUT.getLDEVInfoDetail();
        return rJiLDEVInfoDetail3Array;
    }

    public void waitCtl() {
        RJDataControlDoing rJDataControlDoing = this.cmnDC.getControlDoing();
        while (rJDataControlDoing.getDoing()) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {}
        }
    }

    public static String makeStatusString(int n, String string, String string2) {
        String string3 = string2;
        if (!(n != 1 || string == null || string.isEmpty() || string.equals(string2) || string3.startsWith(string))) {
            string3 = string3 + "/" + string;
        }
        return string3;
    }
}

