/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.ldevguard.dctl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sanproject.client.ldevguard.dctl.OperationNothing;
import sanproject.client.ldevguard.dctl.OperationVtocArea;
import sanproject.client.ldevguard.dctl.RJDGDDataControl;
import sanproject.client.ldevguard.dctl.RJDGDErrInfo;
import sanproject.client.ldevguard.dctl.RJDGDException;
import sanproject.client.openldevguard.dctl.com.LdevNumberInterface;
import sanproject.client.openldevguard.dctl.com.ManageReadWriteData;
import sanproject.client.openldevguard.dctl.com.Utility;
import sanproject.serverux.dataimpl.DGDgetVtocArea;
import sanproject.serverux.dataimpl.DGDgetVtocArea_IN;
import sanproject.serverux.dataimpl.DGDgetVtocArea_OUT;
import sanproject.serverux.dataimpl.DGDsetVtocArea;
import sanproject.serverux.dataimpl.DGDsetVtocArea_IN;
import sanproject.serverux.dataimpl.DGDsetVtocArea_OUT;
import sanproject.serverux.dataimpl.SanRmiInputInterface;
import sanproject.serverux.dataimpl.SanRmiOutputInterface;

public class ManageVtocArea
extends ManageReadWriteData {
    private static final int VTOC_START = 1;
    private static final int VTOC_INVALID_END = 0;
    private static final int TPC = 15;
    private static final int MASK_CYL = -16;
    private static final int MASK_HEAD = 15;
    private static final int BITSIZE_HEAD = 4;
    private static final GetDataVtocArea NULL_DATA_GET_VTOCAREA = new GetDataVtocArea(-1, -1);
    private static final SetDataVtocArea NULL_DATA_SET_VTOCAREA = new SetDataVtocArea(0, -1, 0);
    private final SetDataVtocArea changeCompareData;
    private final GetDataVtocArea originalCompareData;
    private final RJDGDDataControl vrmDataControl;

    public ManageVtocArea(RJDGDDataControl rJDGDDataControl) {
        super(4, "VtocArea", rJDGDDataControl, COMP_LDKC_CU, (Object)NULL_DATA_GET_VTOCAREA, COMP_CULDEV, NULL_DATA_SET_VTOCAREA, OperationVtocArea.getInstance(), OperationNothing.getInstance());
        this.vrmDataControl = rJDGDDataControl;
        this.originalCompareData = new GetDataVtocArea(-1, -1);
        this.changeCompareData = new SetDataVtocArea(0, -1, 0);
    }

    private int convertToCylinder(int n) {
        return (n & 0xFFFFFFF0) >> 4;
    }

    private int convertToHeader(int n) {
        return n & 0xF;
    }

    private int convertToPosition(int n, int n2) {
        return n << 4 | n2 % 15;
    }

    private int convertToTrack(int n) {
        return this.convertToCylinder(n) * 15 + this.convertToHeader(n);
    }

    private boolean garbageChangeData(int n, int n2, int n3) {
        boolean bl = false;
        SetDataVtocArea setDataVtocArea = (SetDataVtocArea)this.getChangeDataObject(n, n2, n3);
        if (!NULL_DATA_SET_VTOCAREA.equals(setDataVtocArea)) {
            GetDataVtocArea getDataVtocArea = (GetDataVtocArea)((Object)this.getOriginalDataObject(n, n2, n3));
            if (setDataVtocArea.iEnd == getDataVtocArea.iEnd[n3]) {
                bl = this.removeChangeData(n, n2, n3);
            }
        }
        return bl;
    }

    private int getStart(int n, int n2, int n3) {
        return 1;
    }

    private int getEnd(int n, int n2, int n3) {
        int n4 = 0;
        byte by = this.vrmDataControl.getGuardStatusManager().getGuardStatus(n, n2, n3);
        if (this.isSupportVtocAttribute(by)) {
            SetDataVtocArea setDataVtocArea = (SetDataVtocArea)this.getChangeDataObject(n, n2, n3);
            n4 = !NULL_DATA_SET_VTOCAREA.equals(setDataVtocArea) ? setDataVtocArea.iEnd : this.getOriginalEnd(n, n2, n3);
        }
        return n4;
    }

    private int getOriginalEnd(int n, int n2, int n3) {
        GetDataVtocArea getDataVtocArea = (GetDataVtocArea)((Object)this.getOriginalDataObject(n, n2, n3));
        return getDataVtocArea.iEnd[n3];
    }

    private boolean isSupportVtocAttribute(byte by) {
        boolean bl = false;
        switch (by) {
            case -126: {
                bl = true;
            }
        }
        return bl;
    }

    protected Object[] getData() throws Exception {
        SanRmiInputInterface sanRmiInputInterface = this.makeSanRmiInputInterface();
        DGDgetVtocArea_OUT dGDgetVtocArea_OUT = (DGDgetVtocArea_OUT)this.getRmiData(sanRmiInputInterface);
        return dGDgetVtocArea_OUT.getVtocArea();
    }

    protected boolean isSupport() {
        return true;
    }

    protected Object makeChangeCompareData(int n, int n2, int n3) {
        this.changeCompareData.iCu_Ldev = Utility.convertCuAndLdevToLdevNumber(n2, n3);
        return this.changeCompareData;
    }

    protected Exception makeException(int n, int n2) {
        return new RJDGDException(n, n2);
    }

    protected Object makeOriginalCompareData(int n, int n2, int n3) {
        this.originalCompareData.setCUIndex((short)n, (short)n2);
        return this.originalCompareData;
    }

    protected Object makeOriginalData(Object object) {
        return new GetDataVtocArea((DGDgetVtocArea)object);
    }

    protected SanRmiInputInterface makeSanRmiInputInterface() {
        DGDgetVtocArea_IN dGDgetVtocArea_IN = new DGDgetVtocArea_IN();
        dGDgetVtocArea_IN.setParameter((byte)this.vrmDataControl.getLdkc(), this.vrmDataControl.getEquipCuBitmap());
        return dGDgetVtocArea_IN;
    }

    public boolean isModify() {
        return this.getModifyCount() != 0;
    }

    public boolean isModify(int n, int n2, int n3) {
        SetDataVtocArea setDataVtocArea = (SetDataVtocArea)this.getChangeDataObject(n, n2, n3);
        return !NULL_DATA_SET_VTOCAREA.equals(setDataVtocArea);
    }

    public List makeApplyData() {
        DGDsetVtocArea[] dGDsetVtocAreaArray = this.getChangeDataAll().toArray(new DGDsetVtocArea[0]);
        DGDsetVtocArea_IN dGDsetVtocArea_IN = new DGDsetVtocArea_IN();
        dGDsetVtocArea_IN.setParameter(dGDsetVtocAreaArray.length, (byte)this.vrmDataControl.getLdkc(), dGDsetVtocAreaArray);
        ArrayList<DGDsetVtocArea_IN> arrayList = new ArrayList<DGDsetVtocArea_IN>();
        arrayList.add(dGDsetVtocArea_IN);
        return arrayList;
    }

    public List makeErrInfo(SanRmiOutputInterface sanRmiOutputInterface) {
        ArrayList<RJDGDErrInfo> arrayList = new ArrayList<RJDGDErrInfo>();
        if (sanRmiOutputInterface instanceof DGDsetVtocArea_OUT) {
            DGDsetVtocArea[] dGDsetVtocAreaArray = ((DGDsetVtocArea_OUT)sanRmiOutputInterface).resultVtocArea();
            for (int i = 0; i < dGDsetVtocAreaArray.length; ++i) {
                if (dGDsetVtocAreaArray[i].iError == 0) continue;
                int n = this.vrmDataControl.getLdkc();
                int n2 = Utility.convertLdevNumberToCu(dGDsetVtocAreaArray[i].iCu_Ldev);
                int n3 = Utility.convertLdevNumberToLdev(dGDsetVtocAreaArray[i].iCu_Ldev);
                arrayList.add(new RJDGDErrInfo(this.vrmDataControl, n, n2, n3, 9205, dGDsetVtocAreaArray[i].iError));
            }
        }
        return arrayList;
    }

    public void updateData() {
        Iterator iterator = this.getChangeDataAll().iterator();
        while (iterator.hasNext()) {
            SetDataVtocArea setDataVtocArea = (SetDataVtocArea)iterator.next();
            int n = this.vrmDataControl.getLdkc();
            int n2 = setDataVtocArea.getCu();
            int n3 = setDataVtocArea.getLdev();
            GetDataVtocArea getDataVtocArea = (GetDataVtocArea)((Object)this.getOriginalDataObject(n, n2, n3));
            if (getDataVtocArea.iEnd[n3] == 0) continue;
            getDataVtocArea.iEnd[n3] = setDataVtocArea.iEnd;
        }
        this.initChangeData();
    }

    public boolean canChgVtocArea(int n, int n2, int n3) {
        byte by;
        boolean bl = false;
        if (this.isSupport() && this.isSupportVtocAttribute(by = this.vrmDataControl.getGuardStatusManager().getGuardStatus(n, n2, n3)) && this.getOriginalEnd(n, n2, n3) != 0) {
            bl = true;
        }
        return bl;
    }

    public int getStartCC(int n, int n2, int n3) {
        return this.convertToCylinder(this.getStart(n, n2, n3));
    }

    public int getStartHH(int n, int n2, int n3) {
        return this.convertToHeader(this.getStart(n, n2, n3));
    }

    public int getEndCC(int n, int n2, int n3) {
        return this.convertToCylinder(this.getEnd(n, n2, n3));
    }

    public int getEndHH(int n, int n2, int n3) {
        return this.convertToHeader(this.getEnd(n, n2, n3));
    }

    public int getTrackSize(int n, int n2, int n3) {
        return this.convertToTrack(this.getEnd(n, n2, n3)) - this.convertToTrack(this.getStart(n, n2, n3)) + 1;
    }

    public void setEnd(int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        SetDataVtocArea setDataVtocArea = (SetDataVtocArea)this.getChangeDataObject(n, n2, n3);
        if (NULL_DATA_SET_VTOCAREA.equals(setDataVtocArea)) {
            bl = false;
            this.addChangeData(new SetDataVtocArea(n2, n3, this.convertToPosition(n4, n5)));
        } else {
            bl = true;
            setDataVtocArea.iEnd = this.convertToPosition(n4, n5);
        }
        boolean bl2 = !this.garbageChangeData(n, n2, n3);
        this.updateModifyCount(bl, bl2);
    }

    private static class SetDataVtocArea
    extends DGDsetVtocArea
    implements LdevNumberInterface {
        public SetDataVtocArea(int n, int n2, int n3) {
            this.iCu_Ldev = Utility.convertCuAndLdevToLdevNumber(n, n2);
            this.iEnd = n3;
            this.iError = -1;
        }

        public int getCu() {
            return Utility.convertLdevNumberToCu(this.iCu_Ldev);
        }

        public int getLdev() {
            return Utility.convertLdevNumberToLdev(this.iCu_Ldev);
        }

        public int getLdevNumber() {
            return this.iCu_Ldev;
        }
    }

    private static class GetDataVtocArea
    extends DGDgetVtocArea {
        public GetDataVtocArea(DGDgetVtocArea dGDgetVtocArea) {
            this.byLDKC = dGDgetVtocArea.byLDKC;
            this.byCU = dGDgetVtocArea.byCU;
            this.iEnd = (int[])dGDgetVtocArea.iEnd.clone();
        }

        public GetDataVtocArea(int n, int n2) {
            this.byLDKC = (byte)n;
            this.byCU = (byte)n2;
        }
    }
}

