/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.option;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import sanproject.client.com.RJcConst;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihTablePanel;
import sanproject.client.monitor.option.RJHihCUTableModel;
import sanproject.client.monitor.option.RJHihMoCUElement;

class RJHihCUTablePanel
extends RJHihTablePanel
implements RJcConst {
    private JLabel targetCUsField = new JLabel();

    public RJHihCUTablePanel(RJHihDataSupplier rJHihDataSupplier) {
        super(rJHihDataSupplier);
        this.add((Component)this.createSouthPanel(), "South");
    }

    public void init() {
        RJHihCUTableModel rJHihCUTableModel = new RJHihCUTableModel(this.supplier);
        this.createTable(rJHihCUTableModel);
        rJHihCUTableModel.initialize();
        this.setCountLabel();
    }

    public void setTarget(boolean bl) {
        ((RJHihCUTableModel)this.model).setTarget(bl);
        this.setCountLabel();
        this.refresh();
    }

    public RJHihMoCUElement[][] getCUModel() {
        return ((RJHihCUTableModel)this.model).getCUModel();
    }

    public boolean isChange() {
        boolean bl = ((RJHihCUTableModel)this.model).isChange();
        return bl;
    }

    private void setCountLabel() {
        this.targetCUsField.setText(null);
        if (this.model != null) {
            int n = ((RJHihCUTableModel)this.model).getTargetCount();
            Object[] objectArray = new Object[]{new Integer(n)};
            String string = MessageFormat.format("{0,number,#,##0}", objectArray);
            this.targetCUsField.setText(string);
        }
    }

    private JPanel createSouthPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setPreferredSize(new Dimension(200, 20));
        jPanel.setMinimumSize(new Dimension(200, 20));
        jPanel.setBackground(Color.white);
        Border border = BorderFactory.createLineBorder(Color.gray, 1);
        jPanel.setBorder(border);
        JLabel jLabel = new JLabel("Monitoring Target CUs : ");
        jLabel.setForeground(Color.black);
        jLabel.setHorizontalAlignment(4);
        jLabel.setFont(RJcConst.boldFont);
        this.targetCUsField.setForeground(Color.black);
        this.targetCUsField.setPreferredSize(new Dimension(32, 14));
        this.targetCUsField.setMinimumSize(new Dimension(32, 14));
        this.targetCUsField.setFont(RJcConst.boldFont);
        this.targetCUsField.setHorizontalAlignment(0);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 8, 0, 0), 0, 0));
        jPanel.add((Component)this.targetCUsField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        return jPanel;
    }
}

