/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.performance.port;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JCheckBox;
import sanproject.client.com.RJcElement;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.abs.RJaDataModelEntry;
import sanproject.client.monitor.com.RJHihChartData;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihElement;
import sanproject.client.monitor.com.RJHihTimePair;
import sanproject.client.monitor.performance.port.RJHihPortChartAxisComboBox;
import sanproject.client.monitor.performance.port.RJHihPortChartPanel;
import sanproject.client.monitor.performance.port.RJHihPortDetailComboBox;
import sanproject.client.monitor.performance.port.RJHihPortTableModel;
import sanproject.client.monitor.performance.port.RJHihPtLunDetailChartData;
import sanproject.client.monitor.performance.port.RJHihPtLunElement;
import sanproject.client.monitor.performance.port.RJHihPtLunFolderElement;
import sanproject.serverux.arg.monitor.ArgLUAbility;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.LDEVMonitorLUAbility;
import sanproject.serverux.data.MonitorElementInfo;
import sanproject.serverux.data.MonitorInfoCollection;

public class RJHihPtLunTableModel
extends RJHihPortTableModel {
    private static final String DETAIL_LABEL_IOSEQ = new String(RJcGuide.text("Port_LUN/CHARTLEGEND_IO_SEQ"));
    private static final String DETAIL_LABEL_IORND = new String(RJcGuide.text("Port_LUN/CHARTLEGEND_IO_RND"));
    private static final String DETAIL_LABEL_READSEQ = new String(RJcGuide.text("Port_LUN/CHARTLEGEND_READ_SEQ"));
    private static final String DETAIL_LABEL_READRND = new String(RJcGuide.text("Port_LUN/CHARTLEGEND_READ_RND"));
    private static final String DETAIL_LABEL_WRITESEQ = new String(RJcGuide.text("Port_LUN/CHARTLEGEND_WRITE_SEQ"));
    private static final String DETAIL_LABEL_WRITERND = new String(RJcGuide.text("Port_LUN/CHARTLEGEND_WRITE_RND"));
    private static final String DETAIL_LABEL_READHITSEQ = new String(RJcGuide.text("Port_LUN/CHARTLEGEND_READHIT_SEQ"));
    private static final String DETAIL_LABEL_READHITRND = new String(RJcGuide.text("Port_LUN/CHARTLEGEND_READHIT_RND"));
    private static final String DETAIL_LABEL_WRITEHITSEQ = new String(RJcGuide.text("Port_LUN/CHARTLEGEND_WRITEHIT_SEQ"));
    private static final String DETAIL_LABEL_WRITEHITRND = new String(RJcGuide.text("Port_LUN/CHARTLEGEND_WRITEHIT_RND"));
    private static final String DETAIL_LABEL_BACKCTD = new String(RJcGuide.text("Port_LUN/CHARTLEGEND_BACKTRANS_CTD"));
    private static final String DETAIL_LABEL_BACKDCS = new String(RJcGuide.text("Port_LUN/CHARTLEGEND_BACKTRANS_DTC_SEQ"));
    private static final String DETAIL_LABEL_BACKDCR = new String(RJcGuide.text("Port_LUN/CHARTLEGEND_BACKTRANS_DTC_RND"));
    private RJHihPtLunDetailChartData DetailData = null;
    private RJHihPortChartPanel m_chartPanel = null;

    public RJHihPtLunTableModel(RJHihDataSupplier rJHihDataSupplier, RJHihPortDetailComboBox rJHihPortDetailComboBox, JCheckBox jCheckBox, RJHihPortChartAxisComboBox rJHihPortChartAxisComboBox, RJHihPortChartPanel rJHihPortChartPanel, int n) {
        super(rJHihDataSupplier, rJHihPortDetailComboBox, jCheckBox, rJHihPortChartAxisComboBox);
        this.m_chartPanel = rJHihPortChartPanel;
        this.defineTable(n);
    }

    public void defineTable(int n) {
        this.setAutoResizeMode(0);
        this.setHeaderMode(1);
        super.defineTable(n);
        this.columnNames.addKey("COLOR");
        this.addRHColumnInfo("ELM", RJcGuide.text("Port_LUN/COLUMN_LU_LUN_IO"), 60, new RJHihElement(), false, 0);
        this.setVisibleIcon("ELM", false);
        this.columnNames.setSearchKey("ELM");
        this.addColumnInfo("CULDEV", RJcGuide.text("COMMON/LDEV"), 96, new String(""), false, 0);
        this.addColumnInfo("EMULATION", RJcGuide.text("Port_LUN/COLUMN_LU_EMULATION_IO"), 70, new String(""), false, 0);
        this.addColumnInfo("PATHS", RJcGuide.text("Port_LUN/COLUMN_LU_PATHS_IO"), 40, new Integer(0), false, 0);
        if (this.modelId == 0) {
            this.addColumnInfo("CURRENT", RJcGuide.text("Port_LUN/COLUMN_LU_CURRENT_IO"), 90, new Long(0L), false, 4);
            this.addColumnInfo("AVE", RJcGuide.text("Port_LUN/COLUMN_LU_AVE_IO"), 80, new Long(0L), false, 4);
            this.addColumnInfo("MAX", RJcGuide.text("Port_LUN/COLUMN_LU_MAX_IO"), 80, new Long(0L), false, 4);
        } else {
            this.addColumnInfo("CURRENT", RJcGuide.text("Port_LUN/COLUMN_LU_CURRENT_MB"), 90, new Long(0L), false, 4);
            this.addColumnInfo("AVE", RJcGuide.text("Port_LUN/COLUMN_LU_AVE_MB"), 80, new Long(0L), false, 4);
            this.addColumnInfo("MAX", RJcGuide.text("Port_LUN/COLUMN_LU_MAX_MB"), 80, new Long(0L), false, 4);
        }
        this.addColumnInfo("RESPONSE TIME", RJcGuide.text("Port_LUN/COLUMN_LU_RESPONSETIME_IO"), 80, new Long(0L), false, 4);
    }

    public void addRow(RJcElement rJcElement) {
        RJaDataModelEntry rJaDataModelEntry = super.setElement(rJcElement);
        rJaDataModelEntry = this.availEntry(rJaDataModelEntry);
        rJaDataModelEntry.put("COLOR", ((RJHihPtLunElement)rJcElement).getAbnoCompo());
        rJaDataModelEntry.put("SEL", ((RJHihPtLunElement)rJcElement).getSelection());
        rJaDataModelEntry.put("ELM", rJcElement);
        rJaDataModelEntry.put("CULDEV", ((RJHihPtLunElement)rJcElement).getCULDEV());
        rJaDataModelEntry.put("EMULATION", ((RJHihPtLunElement)rJcElement).getEType());
        rJaDataModelEntry.put("PATHS", ((RJHihPtLunElement)rJcElement).getPathCount());
        if (this.modelId == 0) {
            rJaDataModelEntry.put("CURRENT", ((RJHihPtLunElement)rJcElement).getCurrentIO());
            rJaDataModelEntry.put("AVE", ((RJHihPtLunElement)rJcElement).getAverageIO());
            rJaDataModelEntry.put("MAX", ((RJHihPtLunElement)rJcElement).getMaximumIO());
        } else {
            rJaDataModelEntry.put("CURRENT", ((RJHihPtLunElement)rJcElement).getCurrentMB());
            rJaDataModelEntry.put("AVE", ((RJHihPtLunElement)rJcElement).getAverageMB());
            rJaDataModelEntry.put("MAX", ((RJHihPtLunElement)rJcElement).getMaximumMB());
        }
        rJaDataModelEntry.put("RESPONSE TIME", ((RJHihPtLunElement)rJcElement).getResponseTime());
    }

    public Object getValueAt(int n, Object object) {
        Long l;
        Object object2 = super.getValueAt(n, object);
        if (object.equals("RESPONSE TIME") && (l = (Long)((RJaDataModelEntry)this.rows.get(n)).get("RESPONSE TIME")) != null) {
            object2 = RJcElement.toSecValue(l);
        }
        if (this.modelId == 1) {
            if (object.equals("CURRENT")) {
                l = (Long)((RJaDataModelEntry)this.rows.get(n)).get("CURRENT");
                if (l != null) {
                    object2 = RJHihElement.toMiBValue(l);
                }
            } else if (object.equals("AVE")) {
                l = (Long)((RJaDataModelEntry)this.rows.get(n)).get("AVE");
                if (l != null) {
                    object2 = RJHihElement.toMiBValue(l);
                }
            } else if (object.equals("MAX") && (l = (Long)((RJaDataModelEntry)this.rows.get(n)).get("MAX")) != null) {
                object2 = RJHihElement.toMiBValue(l);
            }
        }
        return object2;
    }

    protected void addChartValues(RJHihChartData rJHihChartData, RJHihElement rJHihElement) {
        RJHihTimePair rJHihTimePair = this.supplier.getMonitoringInfo().getMonitoringTime();
        if (rJHihTimePair != null) {
            if (this.DetailCheck.isEnabled() && this.DetailCheck.isSelected() && this.DetailCombo.isEnabled()) {
                this.DetailData = ((RJHihPtLunElement)rJHihElement).getDetailChart();
                if (this.DetailData != null) {
                    int n = this.DetailCombo.getSelectedIndex();
                    if (n != -1) {
                        if (this.modelId == 1) {
                            n += 3;
                        }
                        switch (n) {
                            case 0: {
                                rJHihChartData.addChartValues((Object)this.DetailData.nIOSeq, null);
                                rJHihChartData.addChartValues((Object)this.DetailData.nIORnd, null);
                                break;
                            }
                            case 1: {
                                rJHihChartData.addChartValues((Object)this.DetailData.nReadSeq, null);
                                rJHihChartData.addChartValues((Object)this.DetailData.nReadRnd, null);
                                break;
                            }
                            case 2: {
                                rJHihChartData.addChartValues((Object)this.DetailData.nWriteSeq, null);
                                rJHihChartData.addChartValues((Object)this.DetailData.nWriteRnd, null);
                                break;
                            }
                            case 3: {
                                rJHihChartData.addChartValues((Object)this.DetailData.nReadHitSeq, null);
                                rJHihChartData.addChartValues((Object)this.DetailData.nReadHitRnd, null);
                                break;
                            }
                            case 4: {
                                rJHihChartData.addChartValues((Object)this.DetailData.nWriteHitSeq, null);
                                rJHihChartData.addChartValues((Object)this.DetailData.nWriteHitRnd, null);
                                break;
                            }
                            case 5: {
                                rJHihChartData.addChartValues((Object)this.DetailData.nBackTransCtoD, null);
                                rJHihChartData.addChartValues((Object)this.DetailData.nBackTransDtoCSeq, null);
                                rJHihChartData.addChartValues((Object)this.DetailData.nBackTransDtoCRnd, null);
                                break;
                            }
                        }
                    }
                    this.m_chartPanel.setDetailData(this.DetailData);
                }
            } else if (this.modelId == 0) {
                long[] lArray = ((RJHihPtLunElement)rJHihElement).getChart(((RJHihPtLunElement)rJHihElement).MONITOR_RATE_IO);
                rJHihChartData.addChartValues((Object)lArray, null);
            } else {
                long[] lArray = ((RJHihPtLunElement)rJHihElement).getChart(((RJHihPtLunElement)rJHihElement).MONITOR_RATE_MB);
                rJHihChartData.addChartValues((Object)lArray, 1);
            }
        }
    }

    private void addLabels(RJHihChartData rJHihChartData) {
        int n = this.DetailCombo.getSelectedIndex();
        if (n != -1) {
            if (this.modelId == 1) {
                n += 3;
            }
            switch (n) {
                case 0: {
                    rJHihChartData.addLabel(DETAIL_LABEL_IOSEQ);
                    rJHihChartData.addLabel(DETAIL_LABEL_IORND);
                    break;
                }
                case 1: {
                    rJHihChartData.addLabel(DETAIL_LABEL_READSEQ);
                    rJHihChartData.addLabel(DETAIL_LABEL_READRND);
                    break;
                }
                case 2: {
                    rJHihChartData.addLabel(DETAIL_LABEL_WRITESEQ);
                    rJHihChartData.addLabel(DETAIL_LABEL_WRITERND);
                    break;
                }
                case 3: {
                    rJHihChartData.addLabel(DETAIL_LABEL_READHITSEQ);
                    rJHihChartData.addLabel(DETAIL_LABEL_READHITRND);
                    break;
                }
                case 4: {
                    rJHihChartData.addLabel(DETAIL_LABEL_WRITEHITSEQ);
                    rJHihChartData.addLabel(DETAIL_LABEL_WRITEHITRND);
                    break;
                }
                case 5: {
                    rJHihChartData.addLabel(DETAIL_LABEL_BACKCTD);
                    rJHihChartData.addLabel(DETAIL_LABEL_BACKDCS);
                    rJHihChartData.addLabel(DETAIL_LABEL_BACKDCR);
                    break;
                }
            }
        }
    }

    public void SetChartDrawButton(RJHihChartData rJHihChartData, ArrayList arrayList) {
        this.m_chartPanel.m_UndoCheckEvent = true;
        if (!this.m_bRealTimeEvent) {
            this.DetailCheck.setSelected(false);
            this.DetailCheck.setEnabled(false);
            this.DetailCombo.setEnabled(false);
        }
        this.SetChartData(rJHihChartData, arrayList);
        if (arrayList.size() == 1) {
            this.DetailCheck.setEnabled(true);
        }
        this.m_chartPanel.m_UndoCheckEvent = false;
    }

    public void SetChartData(RJHihChartData rJHihChartData, ArrayList arrayList) {
        RJHihTimePair rJHihTimePair = this.supplier.getMonitoringInfo().getMonitoringTime();
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJHihPtLunElement rJHihPtLunElement = (RJHihPtLunElement)iterator.next();
            nArray[n3] = rJHihPtLunElement.nLUN;
            n = rJHihPtLunElement.nPortID;
            n2 = rJHihPtLunElement.nHostID;
            ++n3;
        }
        boolean bl = false;
        if (this.DetailCheck.isEnabled() && this.DetailCheck.isSelected() && this.DetailCombo.isEnabled()) {
            bl = true;
        }
        this.getChart(rJHihChartData, nArray, n, n2, rJHihTimePair, bl);
        this.m_chartPanel.SetDetailFlg(bl);
    }

    private void getChart(RJHihChartData rJHihChartData, int[] nArray, int n, int n2, RJHihTimePair rJHihTimePair, boolean bl) {
        this.supplier.putLog("[Monitor]", "[Port]", "RJHihPtLunTableModel.getChartLUN Start");
        MonitorInfoCollection monitorInfoCollection = null;
        if (rJHihTimePair != null) {
            ArgLUAbility argLUAbility = new ArgLUAbility(1, rJHihTimePair.getFromTime(), rJHihTimePair.getToTime());
            for (int i = 0; i < nArray.length; ++i) {
                argLUAbility.addLU(n, n2, nArray[i]);
            }
            monitorInfoCollection = (MonitorInfoCollection)this.supplier.getMonitorInfo((MonArg)argLUAbility);
        }
        if (monitorInfoCollection != null) {
            for (int i = 0; i < nArray.length; ++i) {
                LDEVMonitorLUAbility lDEVMonitorLUAbility = null;
                LDEVMonitorLUAbility lDEVMonitorLUAbility2 = null;
                lDEVMonitorLUAbility2 = new LDEVMonitorLUAbility();
                lDEVMonitorLUAbility2.setLU(n, n2, nArray[i]);
                long[] lArray = null;
                int n3 = monitorInfoCollection.indexOf((MonitorElementInfo)lDEVMonitorLUAbility2);
                if (n3 != -1) {
                    lDEVMonitorLUAbility = (LDEVMonitorLUAbility)monitorInfoCollection.get(n3);
                    if (bl) {
                        RJHihPtLunDetailChartData rJHihPtLunDetailChartData = new RJHihPtLunDetailChartData();
                        rJHihPtLunDetailChartData.nIOSeq = lDEVMonitorLUAbility.getIORateSeq();
                        rJHihPtLunDetailChartData.nIORnd = lDEVMonitorLUAbility.getIORateRnd();
                        rJHihPtLunDetailChartData.nReadSeq = lDEVMonitorLUAbility.getReadSeq();
                        rJHihPtLunDetailChartData.nReadRnd = lDEVMonitorLUAbility.getReadRnd();
                        rJHihPtLunDetailChartData.nWriteSeq = lDEVMonitorLUAbility.getWriteSeq();
                        rJHihPtLunDetailChartData.nWriteRnd = lDEVMonitorLUAbility.getWriteRnd();
                        rJHihPtLunDetailChartData.nReadHitSeq = lDEVMonitorLUAbility.getReadHitSeq();
                        rJHihPtLunDetailChartData.nReadHitRnd = lDEVMonitorLUAbility.getReadHitRnd();
                        rJHihPtLunDetailChartData.nWriteHitSeq = lDEVMonitorLUAbility.getWriteHitSeq();
                        rJHihPtLunDetailChartData.nWriteHitRnd = lDEVMonitorLUAbility.getWriteHitRnd();
                        rJHihPtLunDetailChartData.nBackTransCtoD = lDEVMonitorLUAbility.getBackTransCtoD();
                        rJHihPtLunDetailChartData.nBackTransDtoCSeq = lDEVMonitorLUAbility.getBackTransDtoCSeq();
                        rJHihPtLunDetailChartData.nBackTransDtoCRnd = lDEVMonitorLUAbility.getBackTransDtoCRnd();
                        this.addDetailChartValue(rJHihChartData, rJHihPtLunDetailChartData);
                        this.m_chartPanel.setDetailData(rJHihPtLunDetailChartData);
                        continue;
                    }
                    rJHihChartData.addLabel(this.supplier.toHexString(nArray[i], 4));
                    if (this.modelId == 0) {
                        lArray = lDEVMonitorLUAbility.getIOPerSec();
                        rJHihChartData.addChartValues((Object)lArray, null);
                        continue;
                    }
                    lArray = lDEVMonitorLUAbility.getTransRate();
                    rJHihChartData.addChartValues((Object)lArray, 1);
                    continue;
                }
                this.supplier.putLog("[Monitor]", "[Port]", "RJHihPtLunTableModel.getChart:Matched Error Port ID = " + lDEVMonitorLUAbility2.getPortID());
            }
        }
        this.supplier.putLog("[Monitor]", "[Port]", "RJHihPtLunTableModel.getChart End");
    }

    private void addDetailChartValue(RJHihChartData rJHihChartData, RJHihPtLunDetailChartData rJHihPtLunDetailChartData) {
        int n = this.DetailCombo.getSelectedIndex();
        if (n != -1) {
            if (this.modelId == 1) {
                n += 3;
            }
            switch (n) {
                case 0: {
                    rJHihChartData.addLabel(DETAIL_LABEL_IOSEQ);
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nIOSeq, null);
                    rJHihChartData.addLabel(DETAIL_LABEL_IORND);
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nIORnd, null);
                    break;
                }
                case 1: {
                    rJHihChartData.addLabel(DETAIL_LABEL_READSEQ);
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nReadSeq, null);
                    rJHihChartData.addLabel(DETAIL_LABEL_READRND);
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nReadRnd, null);
                    break;
                }
                case 2: {
                    rJHihChartData.addLabel(DETAIL_LABEL_WRITESEQ);
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nWriteSeq, null);
                    rJHihChartData.addLabel(DETAIL_LABEL_WRITERND);
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nWriteRnd, null);
                    break;
                }
                case 3: {
                    rJHihChartData.addLabel(DETAIL_LABEL_READHITSEQ);
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nReadHitSeq, null);
                    rJHihChartData.addLabel(DETAIL_LABEL_READHITRND);
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nReadHitRnd, null);
                    break;
                }
                case 4: {
                    rJHihChartData.addLabel(DETAIL_LABEL_WRITEHITSEQ);
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nWriteHitSeq, null);
                    rJHihChartData.addLabel(DETAIL_LABEL_WRITEHITRND);
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nWriteHitRnd, null);
                    break;
                }
                case 5: {
                    rJHihChartData.addLabel(DETAIL_LABEL_BACKCTD);
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nBackTransCtoD, null);
                    rJHihChartData.addLabel(DETAIL_LABEL_BACKDCS);
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nBackTransDtoCSeq, null);
                    rJHihChartData.addLabel(DETAIL_LABEL_BACKDCR);
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nBackTransDtoCRnd, null);
                    break;
                }
            }
        }
    }

    public void updateTable(RJHihElement rJHihElement) {
        Object object;
        RJaDataModelEntry rJaDataModelEntry;
        Enumeration enumeration;
        Enumeration enumeration2;
        this.supplier.putLog("[Monitor]", "[Port]", "RJHihPtLunTableModel.updateTable start");
        RJHihTimePair rJHihTimePair = this.supplier.getMonitoringInfo().getMonitoringTime();
        RJHihTimePair rJHihTimePair2 = this.supplier.getMonitoringInfo().getMonitoringCurrentTime();
        short s = ((RJHihPtLunFolderElement)rJHihElement).portInfo.getSPort();
        short s2 = ((RJHihPtLunFolderElement)rJHihElement).HostGroup.getSHostgroupID();
        MonitorInfoCollection monitorInfoCollection = null;
        MonitorInfoCollection monitorInfoCollection2 = null;
        if (rJHihTimePair != null) {
            enumeration2 = new ArgLUAbility(2, rJHihTimePair.getFromTime(), rJHihTimePair.getToTime());
            enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                rJaDataModelEntry = (RJaDataModelEntry)enumeration.nextElement();
                object = (RJHihPtLunElement)rJaDataModelEntry.get("ELM");
                enumeration2.addLU(s, s2, ((RJHihPtLunElement)object).nLUN);
            }
            monitorInfoCollection = (MonitorInfoCollection)this.supplier.getMonitorInfo((MonArg)enumeration2);
        }
        if (rJHihTimePair2 != null) {
            enumeration2 = new ArgLUAbility(2, rJHihTimePair2.getFromTime(), rJHihTimePair2.getToTime());
            enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                rJaDataModelEntry = (RJaDataModelEntry)enumeration.nextElement();
                object = (RJHihPtLunElement)rJaDataModelEntry.get("ELM");
                enumeration2.addLU(s, s2, ((RJHihPtLunElement)object).nLUN);
            }
            monitorInfoCollection2 = (MonitorInfoCollection)this.supplier.getMonitorInfo((MonArg)enumeration2);
        }
        enumeration2 = this.elements();
        while (enumeration2.hasMoreElements()) {
            int n;
            LDEVMonitorLUAbility lDEVMonitorLUAbility;
            enumeration = null;
            rJaDataModelEntry = null;
            object = (RJaDataModelEntry)enumeration2.nextElement();
            RJHihPtLunElement rJHihPtLunElement = (RJHihPtLunElement)((RJaDataModelEntry)object).get("ELM");
            if (monitorInfoCollection != null) {
                lDEVMonitorLUAbility = new LDEVMonitorLUAbility();
                lDEVMonitorLUAbility.setLU((int)s, (int)s2, rJHihPtLunElement.nLUN);
                n = monitorInfoCollection.indexOf((MonitorElementInfo)lDEVMonitorLUAbility);
                if (n != -1) {
                    enumeration = (LDEVMonitorLUAbility)monitorInfoCollection.get(n);
                } else {
                    this.supplier.putLog("[Monitor]", "[Port]", "RJHihPtLunTableModel.updateTable port =" + lDEVMonitorLUAbility.getPortID() + ":element=" + rJHihPtLunElement);
                }
            }
            rJHihPtLunElement.collectUseRate((LDEVMonitorLUAbility)enumeration);
            if (this.modelId == 0) {
                ((RJaDataModelEntry)object).put("AVE", rJHihPtLunElement.getAverageIO());
                ((RJaDataModelEntry)object).put("MAX", rJHihPtLunElement.getMaximumIO());
            } else {
                ((RJaDataModelEntry)object).put("AVE", rJHihPtLunElement.getAverageMB());
                ((RJaDataModelEntry)object).put("MAX", rJHihPtLunElement.getMaximumMB());
            }
            ((RJaDataModelEntry)object).put("RESPONSE TIME", rJHihPtLunElement.getResponseTime());
            if (monitorInfoCollection2 != null) {
                lDEVMonitorLUAbility = new LDEVMonitorLUAbility();
                lDEVMonitorLUAbility.setLU((int)s, (int)s2, rJHihPtLunElement.nLUN);
                n = monitorInfoCollection2.indexOf((MonitorElementInfo)lDEVMonitorLUAbility);
                if (n != -1) {
                    rJaDataModelEntry = (LDEVMonitorLUAbility)monitorInfoCollection2.get(n);
                } else {
                    this.supplier.putLog("[Monitor]", "[Port]", "RJHihPtLunTableModel.updateTable port =" + lDEVMonitorLUAbility.getPortID() + ":element=" + rJHihPtLunElement);
                }
            }
            rJHihPtLunElement.collectCurrentUseRate((LDEVMonitorLUAbility)rJaDataModelEntry);
            if (this.modelId == 0) {
                ((RJaDataModelEntry)object).put("CURRENT", rJHihPtLunElement.getCurrentIO());
                continue;
            }
            ((RJaDataModelEntry)object).put("CURRENT", rJHihPtLunElement.getCurrentMB());
        }
        this.refresh();
        this.supplier.putLog("[Monitor]", "[Port]", "RJHihPtLunTableModel.updateTable end");
    }
}

