/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.gui;

import java.awt.Dialog;
import java.awt.Frame;
import java.util.logging.Level;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComFuncPanel;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJComWaitingDialog;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataMsg;
import sanproject.client.openldevguard.gui.DataControlWrapper;
import sanproject.client.openldevguard.gui.OpenLDEVGuardException;
import sanproject.client.openldevguard.gui.logging.Logger;

public class DefaultDataControlWrapper
implements DataControlWrapper {
    private static final String MODULE_NAME = "DefaultWrapper";
    private final RJDataControl mrdcController;
    private transient RJComWaitingDialog mrcwWaitingDialog;

    protected DefaultDataControlWrapper(RJDataControl rJDataControl) throws OpenLDEVGuardException {
        if (rJDataControl == null) {
            Logger.put(Level.SEVERE, "DataControl is null.");
            RJDataMsg rJDataMsg = this.createMessageObject(9610, 7060);
            throw new OpenLDEVGuardException(rJDataMsg);
        }
        this.mrdcController = rJDataControl;
        this.mrcwWaitingDialog = null;
    }

    public final boolean isWrapped() {
        boolean bl = false;
        return bl;
    }

    public final RJDataControl getDataCtl() {
        return this.mrdcController;
    }

    public final boolean isModifyMode() {
        RJDataControl rJDataControl = this.getDataCtl();
        boolean bl = RJCom.getEditMode(rJDataControl);
        return bl;
    }

    public final RJDataMsg createMessageObject(int n, int n2) {
        RJDataMsg rJDataMsg = RJCom.getMsg(this.mrdcController, n, n2);
        return rJDataMsg;
    }

    public final void openWaitDialog(Frame frame) {
        this.openWaitDialog(frame, null);
    }

    public final void openWaitDialog(Frame frame, Runnable runnable) {
        if (this.mrcwWaitingDialog == null) {
            Logger.put(Level.FINER, MODULE_NAME, "Open waiting dialog.");
            RJDataControl rJDataControl = this.getDataCtl();
            if (frame == null) {
                Logger.put(Level.WARNING, MODULE_NAME, "Can not lookup frame.");
            }
            this.mrcwWaitingDialog = RJComUty.getDefaultWaitingDialog(rJDataControl, frame);
            this.mrcwWaitingDialog.show(runnable);
        }
    }

    public final void openWaitDialog(Dialog dialog) {
        this.openWaitDialog(dialog, null);
    }

    public final void openWaitDialog(Dialog dialog, Runnable runnable) {
        if (this.mrcwWaitingDialog == null) {
            Logger.put(Level.FINER, MODULE_NAME, "Open waiting dialog.");
            RJDataControl rJDataControl = this.getDataCtl();
            if (dialog == null) {
                Logger.put(Level.WARNING, MODULE_NAME, "Can not lookup frame.");
            }
            this.mrcwWaitingDialog = RJComUty.getDefaultWaitingDialog(rJDataControl, dialog);
            this.mrcwWaitingDialog.show(runnable);
        }
    }

    public final void closeWaitDialog() {
        if (this.mrcwWaitingDialog != null) {
            Logger.put(Level.FINER, MODULE_NAME, "Close waiting dialog.");
            this.mrcwWaitingDialog.dispose();
            this.mrcwWaitingDialog = null;
        }
    }

    public void pushParentPanel(RJComFuncPanel rJComFuncPanel) {
        throw new UnsupportedOperationException();
    }
}

