/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.gui.main;

import java.awt.Image;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.Icon;
import sanproject.client.openldevguard.dctl.com.Utility;
import sanproject.client.openldevguard.gui.OpenLDEVGuardProperties;
import sanproject.client.openldevguard.gui.main.CUWrapper;
import sanproject.client.openldevguard.gui.main.LDEVWrapper;
import sanproject.client.openldevguard.gui.main.OpenLDEVGuardDataControlWrapper;
import sanproject.client.openldevguard.icon.IconManager;
import sanproject.client.openldevguard.utility.StringUtilities;
import sanproject.client.openldevguard.utility.VolumeSizeConverter;

public final class ViewDefine {
    private static final Icon PROTECT_ATTRIBUTE;
    private static final Icon READONLY_ATTRIBUTE;
    private static final Icon READWRITE_ATTRIBUTE;
    private static final Icon DISABLED_ATTRIBUTE;
    private static final Image EXTENT_IMAGE;
    private static final Image VMA_IMAGE;
    private static final Icon EXT_READONLY_ATTRIBUTE;
    private static final Icon EXT_READWRITE_ATTRIBUTE;
    private static final Icon EXT_DISABLED_ATTRIBUTE;
    static /* synthetic */ Class class$sanproject$client$openldevguard$gui$main$ViewDefine;

    private ViewDefine() {
    }

    public static boolean isSupportSortKindHeader() {
        String string = "support_kindsort_header";
        String string2 = OpenLDEVGuardProperties.getProperty(string);
        Boolean bl = new Boolean(string2);
        boolean bl2 = bl;
        return bl2;
    }

    public static boolean isSupportLoadViewProperties() {
        String string = "support_load_viewproperties";
        String string2 = OpenLDEVGuardProperties.getProperty(string);
        Boolean bl = new Boolean(string2);
        boolean bl2 = bl;
        return bl2;
    }

    public static boolean isSupportUnforcusedLinePaint() {
        String string = "support_unfocusedcolor_paint";
        String string2 = OpenLDEVGuardProperties.getProperty(string);
        Boolean bl = new Boolean(string2);
        boolean bl2 = bl;
        return bl2;
    }

    public static boolean isSupportThreeWaySort() {
        String string = "support_threeway_sort";
        String string2 = OpenLDEVGuardProperties.getProperty(string);
        Boolean bl = new Boolean(string2);
        boolean bl2 = bl;
        return bl2;
    }

    public static String convertToLDKCNumberString(int n) {
        String string = StringUtilities.toHexString(n, 2, true);
        return string;
    }

    public static String convertToCUGroupString(int n) {
        int n2 = Utility.convertCuGroupToIndexStart(n);
        int n3 = Utility.convertCuGroupToIndexEnd(n) - 1;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ViewDefine.convertToCUNumberString(n2));
        stringBuffer.append(" - ");
        stringBuffer.append(ViewDefine.convertToCUNumberString(n3));
        String string = stringBuffer.toString();
        return string;
    }

    public static String convertToLDKCCULDEVString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, LDEVWrapper lDEVWrapper) {
        String string = lDEVWrapper.toString();
        return string;
    }

    public static String convertToCUNumberString(int n) {
        String string = StringUtilities.toHexString(n, 2, true);
        return string;
    }

    public static String convertToCUTreeNodeString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, CUWrapper cUWrapper) {
        String string = openLDEVGuardDataControlWrapper.getGuidanceString("COMMON/CU");
        int n = cUWrapper.getCUNumber();
        String string2 = ViewDefine.convertToCUNumberString(n);
        String string3 = string + " " + string2;
        return string3;
    }

    public static String convertToLDEVNumberString(int n) {
        String string = StringUtilities.toHexString(n, 2, true);
        return string;
    }

    public static String convertToLDEVString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, LDEVWrapper lDEVWrapper) {
        String string = ":";
        int n = 1;
        String string2 = lDEVWrapper.toString();
        int n2 = string2.length();
        for (int i = 0; i < n; ++i) {
            n2 = string2.lastIndexOf(string, n2 - 1);
        }
        String string3 = string2.substring(n2 + 1);
        return string3;
    }

    public static String convertToLDEVTreeNodeString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, LDEVWrapper lDEVWrapper) {
        String string = openLDEVGuardDataControlWrapper.getGuidanceString("COMMON/LDEV");
        String string2 = ViewDefine.convertToAttributeShortString(openLDEVGuardDataControlWrapper, lDEVWrapper.getAttribute());
        String string3 = ViewDefine.convertToCULDEVString(openLDEVGuardDataControlWrapper, lDEVWrapper);
        StringBuffer stringBuffer = new StringBuffer(string3);
        int n = stringBuffer.lastIndexOf(" ");
        if (n < 0) {
            n = stringBuffer.length();
        }
        stringBuffer.insert(n, " (" + string2 + ")");
        stringBuffer.insert(0, string + " ");
        String string4 = stringBuffer.toString();
        return string4;
    }

    public static String convertToCULDEVString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, LDEVWrapper lDEVWrapper) {
        String string = ":";
        int n = 2;
        String string2 = lDEVWrapper.toString();
        int n2 = string2.length();
        for (int i = 0; i < n; ++i) {
            n2 = string2.lastIndexOf(string, n2 - 1);
        }
        String string3 = string2.substring(n2 + 1);
        return string3;
    }

    public static String convertToAttributeString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, byte by) {
        String string = by == -127 ? "LDEV Guard/STRING_STE_PROTECT" : (by == -126 ? "LDEV Guard/STRING_STE_READONLY" : (by == -128 ? "LDEV Guard/STRING_STE_READWRITE" : null));
        String string2 = "";
        if (string != null) {
            string2 = openLDEVGuardDataControlWrapper.getGuidanceString(string);
        }
        return string2;
    }

    public static String convertToAttributeShortString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, byte by) {
        String string = by == -127 ? "LDEV Guard/STRING_STE_PROTECT_S" : (by == -126 ? "LDEV Guard/STRING_STE_READONLY_S" : (by == -128 ? "LDEV Guard/STRING_STE_READWRITE_S" : null));
        String string2 = "";
        if (string != null) {
            string2 = openLDEVGuardDataControlWrapper.getGuidanceString(string);
        }
        return string2;
    }

    public static Icon convertToAttributeIcon(byte by) {
        Icon icon = null;
        icon = by == -127 ? PROTECT_ATTRIBUTE : (by == -126 ? READONLY_ATTRIBUTE : (by == -128 ? READWRITE_ATTRIBUTE : DISABLED_ATTRIBUTE));
        return icon;
    }

    public static Icon convertToExtAttributeIcon(byte by) {
        Icon icon = null;
        icon = by == -126 ? EXT_READONLY_ATTRIBUTE : (by == -128 ? EXT_READWRITE_ATTRIBUTE : EXT_DISABLED_ATTRIBUTE);
        return icon;
    }

    public static Icon convertToAttributeWithOptionIcon(byte by, boolean bl, boolean bl2) {
        IconManager iconManager = IconManager.getInstance();
        Icon icon = ViewDefine.convertToAttributeIcon(by);
        if (bl) {
            icon = iconManager.createDoubleImageIcon(icon, VMA_IMAGE);
        }
        if (bl2) {
            icon = iconManager.createDoubleImageIcon(icon, EXTENT_IMAGE);
        }
        return icon;
    }

    public static Icon convertToAttributeWithOptionIcon(LDEVWrapper lDEVWrapper) {
        byte by = lDEVWrapper.getAttribute();
        boolean bl = lDEVWrapper.hasVMAArea();
        boolean bl2 = lDEVWrapper.hasExtentArea();
        Icon icon = ViewDefine.convertToAttributeWithOptionIcon(by, bl, bl2);
        return icon;
    }

    public static String convertToEmulationTypeString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, LDEVWrapper lDEVWrapper) {
        String string;
        String string2 = lDEVWrapper.getEmulationType();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        LDEVWrapper[] lDEVWrapperArray = lDEVWrapper.getLUSEVolumes();
        int n = lDEVWrapperArray.length;
        if (n > 1) {
            string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_LUSESEPARATOR");
            stringBuffer.append(string);
            String string3 = String.valueOf(n);
            stringBuffer.append(string3);
        }
        string = stringBuffer.toString();
        return string;
    }

    public static String convertToChangedAttributeString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, byte by, byte by2) {
        String string;
        if (by != by2) {
            String string2 = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_CHANGEDATA");
            String string3 = ViewDefine.convertToAttributeShortString(openLDEVGuardDataControlWrapper, by);
            String string4 = ViewDefine.convertToAttributeShortString(openLDEVGuardDataControlWrapper, by2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string3);
            stringBuffer.append(string2);
            stringBuffer.append(string4);
            string = stringBuffer.toString();
        } else {
            string = ViewDefine.convertToAttributeString(openLDEVGuardDataControlWrapper, by2);
        }
        return string;
    }

    public static String convertToSVolAdaptString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, LDEVWrapper lDEVWrapper) {
        String string;
        boolean bl;
        boolean bl2 = lDEVWrapper.getOriginalSVolAdapt();
        if (bl2 == (bl = lDEVWrapper.isSVolAdapt())) {
            string = bl2 ? openLDEVGuardDataControlWrapper.getGuidanceString("COMMON/Permit") : openLDEVGuardDataControlWrapper.getGuidanceString("COMMON/Refuse");
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            if (bl2) {
                stringBuffer.append(openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_ENABLE_S"));
            } else {
                stringBuffer.append(openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_DISABLE_S"));
            }
            stringBuffer.append(openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_CHANGEDATA"));
            if (bl) {
                stringBuffer.append(openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_ENABLE_S"));
            } else {
                stringBuffer.append(openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_DISABLE_S"));
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String convertToReservedStateString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, LDEVWrapper lDEVWrapper) {
        String string = lDEVWrapper.isReserved() ? openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_RAIDMANAGER") : openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_NODATA");
        return string;
    }

    public static String convertToTermString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, int n, int n2) {
        String string;
        String string2 = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_DAYS");
        String string3 = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_UNLIMITED");
        StringBuffer stringBuffer = new StringBuffer();
        if (n == n2) {
            if (n != -1) {
                stringBuffer.append(n);
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(string3);
            }
        } else {
            if (n != -1) {
                stringBuffer.append(n);
            } else {
                stringBuffer.append(string3);
            }
            string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_CHANGEDATA");
            stringBuffer.append(string);
            if (n2 != -1) {
                stringBuffer.append(n2);
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(string3);
            }
        }
        string = stringBuffer.toString();
        return string;
    }

    public static String convertToTermTipString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, int n, int n2) {
        String string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_YEARS");
        String string2 = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_DAYS");
        String string3 = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_UNLIMITED");
        String string4 = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_BLANK");
        StringBuffer stringBuffer = new StringBuffer();
        if (n == n2) {
            if (n != -1) {
                int n3 = n / 365;
                int n4 = n - n3 * 365;
                if (n3 > 0) {
                    stringBuffer.append(n3);
                    stringBuffer.append(string);
                    if (n4 > 0) {
                        stringBuffer.append(string4);
                        stringBuffer.append(n4);
                        stringBuffer.append(string2);
                    }
                } else if (n4 > 0) {
                    stringBuffer.append(n4);
                    stringBuffer.append(string2);
                }
            } else {
                stringBuffer.append(string3);
            }
        } else {
            int n5;
            if (n != -1) {
                int n6 = n / 365;
                n5 = n - n6 * 365;
                if (n6 > 0) {
                    stringBuffer.append(n6);
                    stringBuffer.append(string);
                    stringBuffer.append(string4);
                }
                stringBuffer.append(n5);
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(string3);
            }
            String string5 = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_CHANGEDATA");
            stringBuffer.append(string5);
            if (n2 != -1) {
                n5 = n2 / 365;
                int n7 = n2 - n5 * 365;
                if (n5 > 0) {
                    stringBuffer.append(n5);
                    stringBuffer.append(string);
                    if (n7 > 0) {
                        stringBuffer.append(string4);
                        stringBuffer.append(n7);
                        stringBuffer.append(string2);
                    }
                } else if (n7 > 0) {
                    stringBuffer.append(n7);
                    stringBuffer.append(string2);
                }
            } else {
                stringBuffer.append(string3);
            }
        }
        String string6 = stringBuffer.toString();
        return string6;
    }

    public static String convertToModeString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, LDEVWrapper lDEVWrapper) {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        if (lDEVWrapper.isZeroReadCap()) {
            string2 = "LDEV Guard/STRING_DAT_ZEROREADCAP_S";
            string = openLDEVGuardDataControlWrapper.getGuidanceString(string2);
            stringBuffer.append(string);
        }
        if (lDEVWrapper.isZeroReadCap() && lDEVWrapper.isInvisible()) {
            string2 = "LDEV Guard/STRING_DAT_MODESEPARATOR";
            string = openLDEVGuardDataControlWrapper.getGuidanceString(string2);
            stringBuffer.append(string);
        }
        if (lDEVWrapper.isInvisible()) {
            string2 = "LDEV Guard/STRING_DAT_INVISIBLE_S";
            string = openLDEVGuardDataControlWrapper.getGuidanceString(string2);
            stringBuffer.append(string);
        }
        if (!lDEVWrapper.isZeroReadCap() && !lDEVWrapper.isInvisible()) {
            string2 = "LDEV Guard/STRING_DAT_NODATA";
            string = openLDEVGuardDataControlWrapper.getGuidanceString(string2);
            stringBuffer.append(string);
        }
        string2 = stringBuffer.toString();
        return string2;
    }

    public static String convertToLDEVCapacityString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, long l) {
        double d = VolumeSizeConverter.convertVolumeSize(l, "K to Gi");
        double d2 = ViewDefine.getArrangedValue(d, -2);
        String string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_LDEVCAPACITYFORMAT");
        DecimalFormat decimalFormat = new DecimalFormat(string);
        String string2 = decimalFormat.format(d2);
        return string2;
    }

    public static String convertToExtentCapacityString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, long l) {
        double d = VolumeSizeConverter.convertVolumeSize(l, "K to Mi");
        double d2 = ViewDefine.getArrangedValue(d, -2, 0);
        String string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_EXTENTCAPACITYFORMAT");
        DecimalFormat decimalFormat = new DecimalFormat(string);
        String string2 = decimalFormat.format(d2);
        return string2;
    }

    public static String convertToLBARangeString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, long l, long l2) {
        String string;
        if (l == l2) {
            string = String.valueOf(l);
        } else {
            String string2 = "-";
            string = String.valueOf(l) + string2 + String.valueOf(l2);
        }
        return string;
    }

    public static String convertToLDEVVMASizeString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, int n) {
        String string;
        if (n > 0) {
            String string2 = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_VMASIZEFORMAT");
            DecimalFormat decimalFormat = new DecimalFormat(string2);
            string = decimalFormat.format(n);
        } else {
            string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_NODATA");
        }
        return string;
    }

    public static String convertToOperationString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, int n) {
        String string;
        switch (n) {
            case 0: {
                string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_NOOPERATION");
                break;
            }
            case 1: {
                string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_VOLUMEOPERATION");
                break;
            }
            case 2: {
                string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_VMAOPERATION");
                break;
            }
            case 8: {
                string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_EXTCOPYOPERATION");
                break;
            }
            case 10: {
                string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_EXTDEFOPERATION");
                break;
            }
            case 11: {
                string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_EXTALLRELOPERATION");
                break;
            }
            case 3: {
                string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_LOCKOPERATION");
                break;
            }
            case 4: {
                string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_EXTSETOPERATION");
                break;
            }
            case 5: {
                string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_EXTRELEASEOPERATION");
                break;
            }
            case 6: {
                string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_EXTOPERATION");
                break;
            }
            case 7: {
                string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_SHREDCANCELOPERATION");
                break;
            }
            default: {
                string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_UNKNOWNOPERATION");
            }
        }
        return string;
    }

    public static String convertToExtentStatusString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, byte by) {
        String string;
        switch (by) {
            case 0: {
                string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_NODATA");
                break;
            }
            case 1: {
                string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_SHREDDING");
                break;
            }
            case 2: {
                string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_SHREDFAILED");
                break;
            }
            case 3: {
                string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_NODATA");
                break;
            }
            default: {
                string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_UNKNOWN");
            }
        }
        return string;
    }

    public static String convertToExtentProgressString(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, int n) {
        String string = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DAT_PERCENTSEPARATOR");
        String string2 = String.valueOf(n) + string;
        return string2;
    }

    public static double getArrangedValue(double d, int n) {
        double d2 = ViewDefine.getArrangedValue(d, n, 1);
        return d2;
    }

    public static double getArrangedValue(double d, int n, int n2) {
        int n3 = n > 0 ? n - 1 : n;
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.movePointLeft(n3);
        bigDecimal = bigDecimal.setScale(0, n2);
        bigDecimal = bigDecimal.movePointRight(n3);
        double d2 = bigDecimal.doubleValue();
        return d2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Object object;
        Package package_ = (class$sanproject$client$openldevguard$gui$main$ViewDefine == null ? (class$sanproject$client$openldevguard$gui$main$ViewDefine = ViewDefine.class$("sanproject.client.openldevguard.gui.main.ViewDefine")) : class$sanproject$client$openldevguard$gui$main$ViewDefine).getPackage();
        String string = package_.getName();
        String string2 = string + ".viewdefine";
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string2);
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            String string3 = OpenLDEVGuardProperties.getProperty((String)object);
            if (string3 != null) continue;
            String string4 = resourceBundle.getString((String)object);
            OpenLDEVGuardProperties.setProperty((String)object, string4);
        }
        object = IconManager.getInstance();
        PROTECT_ATTRIBUTE = ((IconManager)object).getIcon("protect.gif");
        READONLY_ATTRIBUTE = ((IconManager)object).getIcon("readonly.gif");
        READWRITE_ATTRIBUTE = ((IconManager)object).getIcon("readwrite.gif");
        DISABLED_ATTRIBUTE = ((IconManager)object).getIcon("disabled.gif");
        EXTENT_IMAGE = ((IconManager)object).getImage("extent.gif");
        VMA_IMAGE = ((IconManager)object).getImage("vma.gif");
        EXT_READONLY_ATTRIBUTE = ((IconManager)object).getIcon("ext_readonly.gif");
        EXT_READWRITE_ATTRIBUTE = ((IconManager)object).getIcon("ext_readwrite.gif");
        EXT_DISABLED_ATTRIBUTE = ((IconManager)object).getIcon("ext_disabled.gif");
    }
}

