/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.pool;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import sanproject.client.com.RJcBaseDialog;
import sanproject.client.com.RJcCushionPanel;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcHeaderPanel;
import sanproject.client.com.RJcSouthPanel;
import sanproject.client.com.RJcTablePanel;
import sanproject.client.com.abs.RJaDataModelEntry;
import sanproject.client.data.RJDataMsg;
import sanproject.client.pool.RJPoolDataSupplier;
import sanproject.client.pool.RJPoolErrorItem;
import sanproject.client.pool.RJPoolGuideDef;
import sanproject.client.pool.RJPoolLdevElement;
import sanproject.client.pool.RJPoolTableModel;

public class RJPoolErrorDialog
extends RJcBaseDialog
implements RJPoolGuideDef {
    private RJPoolDataSupplier supplier;
    private ErrorTableModel model = null;

    public RJPoolErrorDialog(Frame frame, RJPoolDataSupplier rJPoolDataSupplier) {
        super(frame);
        this.supplier = rJPoolDataSupplier;
        this.dialogName = "Pool/ErrDialog";
        this.setResizable(false);
        this.setSize(new Dimension(520, 300));
        this.model = new ErrorTableModel(rJPoolDataSupplier);
        super.initInstance();
    }

    public void show(ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJPoolErrorItem rJPoolErrorItem = (RJPoolErrorItem)iterator.next();
            this.model.addRow(rJPoolErrorItem);
        }
        this.model.completedModel();
        super.show();
    }

    private void okButton_actionPerformed(ActionEvent actionEvent) {
        this.windowClosing();
    }

    protected JPanel createNorthComponent() {
        RJcHeaderPanel rJcHeaderPanel = new RJcHeaderPanel("Pool/ErrDetailTitle");
        return rJcHeaderPanel;
    }

    protected JPanel createCenterComponent() {
        ErrorTablePanel errorTablePanel = new ErrorTablePanel();
        errorTablePanel.createTable(this.model);
        RJcCushionPanel rJcCushionPanel = new RJcCushionPanel(errorTablePanel);
        Border border = BorderFactory.createEmptyBorder(4, 8, 4, 8);
        rJcCushionPanel.setBackground(RJcGuide.color("Pool/ErrCenterPanelBgClr"));
        rJcCushionPanel.setBorder(border);
        return rJcCushionPanel;
    }

    protected JPanel createSouthComponent() {
        RJcSouthPanel rJcSouthPanel = (RJcSouthPanel)super.createSouthComponent();
        JButton jButton = this.newButton("Pool/ErrDlgOkBtn");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJPoolErrorDialog.this.okButton_actionPerformed(actionEvent);
            }
        });
        rJcSouthPanel.addComponent(jButton, 0);
        return rJcSouthPanel;
    }

    class ErrorTableModel
    extends RJPoolTableModel {
        ErrorTableModel(RJPoolDataSupplier rJPoolDataSupplier) {
            super(rJPoolDataSupplier);
        }

        protected void defineTable() {
            this.setAutoResizeMode(0);
            this.addRHColumnInfo("POOL", RJcGuide.text("Pool/ErrListPoolLbl"), 80, new String(""), false, 0);
            this.addColumnInfo("LDEV", RJcGuide.text("Pool/ErrListLDEVLbl"), 80, new String(""), false, 0);
            this.columnNames.addKey("DATAMSG");
            this.addColumnInfo("MSG", RJcGuide.text("Pool/ErrListMsgLbl"), 380, new String(""), false, 2);
        }

        public void addRow(RJPoolErrorItem rJPoolErrorItem) {
            RJPoolLdevElement rJPoolLdevElement = null;
            if (rJPoolErrorItem.getCu() >= 0) {
                rJPoolLdevElement = new RJPoolLdevElement(rJPoolErrorItem.getLdkc(), rJPoolErrorItem.getCu(), rJPoolErrorItem.getLdev());
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(new Integer(3005));
            arrayList.add(new Integer(rJPoolErrorItem.getCode()));
            RJDataMsg rJDataMsg = RJPoolErrorDialog.this.supplier.getMessage(arrayList);
            RJaDataModelEntry rJaDataModelEntry = this.newEntry();
            rJaDataModelEntry.put("POOL", new Integer(rJPoolErrorItem.getPoolId()));
            rJaDataModelEntry.put("LDEV", rJPoolLdevElement);
            rJaDataModelEntry.put("DATAMSG", rJDataMsg);
            rJaDataModelEntry.put("MSG", rJDataMsg.getMessage());
            this.addRow(rJaDataModelEntry);
        }

        public void completedModel() {
            int n = this.getMaxWidth("MSG");
            this.setColumnWidth("MSG", n + 8);
        }
    }

    class ErrorTablePanel
    extends RJcTablePanel {
    }
}

