/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.ppkey;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComDef;
import sanproject.client.com.RJComDialog;
import sanproject.client.com.RJComFont;
import sanproject.client.com.RJComUty;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataMsg;
import sanproject.client.openldevguard.com.StandardPanel;
import sanproject.client.openldevguard.gui.ComponentUtilities;
import sanproject.client.ppkey.DefaultComponentFactory;
import sanproject.client.ppkey.ExtensionFileFilter;
import sanproject.client.ppkey.GZIPCompressor;
import sanproject.client.ppkey.RJPPKeyGuidance;
import sanproject.client.ppkey.RJPPKeyInfoClass;
import sanproject.client.ppkey.UninstallLicenseInformation;
import sanproject.client.ppkey.UninstallLicenseListTableCellRenderer;
import sanproject.client.ppkey.UninstallLicenseListTableModel;
import sanproject.serverux.dataimpl.PPKget1PPInfo;
import sanproject.serverux.dataimpl.PPKget1PortableLicense;
import sanproject.serverux.dataimpl.PPKgetKeyDetail;

public class UninstallLicenseListPanel
extends StandardPanel {
    private static final String CRLF = "\r\n";
    private static File lastExportedFile = null;
    private RJDataControl controller;
    private RJPPKeyGuidance guidance;
    private JTable licenseListTable;
    private JButton exportButton;
    private UninstallLicenseListTableModel licenseTableModel;
    private List licenseList;
    private boolean exported;
    private boolean doingExport;

    public UninstallLicenseListPanel(RJDataControl rJDataControl, RJPPKeyGuidance rJPPKeyGuidance, PPKgetKeyDetail pPKgetKeyDetail) {
        this.controller = rJDataControl;
        this.guidance = rJPPKeyGuidance;
        this.licenseListTable = null;
        this.exportButton = null;
        this.licenseTableModel = null;
        this.exported = false;
        this.doingExport = false;
        this.licenseList = this.convertToLicenseList(pPKgetKeyDetail);
        this.putLog("initialize panel.");
        this.initialzePanel();
        this.buildPanelLayout();
        this.loadColumnWidthds();
    }

    public void addNotify() {
        super.addNotify();
        final JDialog jDialog = (JDialog)SwingUtilities.getAncestorOfClass(Window.class, this);
        if (jDialog != null) {
            AbstractAction abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    WindowEvent windowEvent = new WindowEvent(jDialog, 201);
                    jDialog.dispatchEvent(windowEvent);
                }
            };
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            JRootPane jRootPane = jDialog.getRootPane();
            InputMap inputMap = jRootPane.getInputMap();
            inputMap.put(keyStroke, "window_escape");
            ActionMap actionMap = jRootPane.getActionMap();
            actionMap.put("window_escape", abstractAction);
        }
    }

    public boolean canCloseOwnerWindow() {
        boolean bl = true;
        if (!this.exported) {
            int n = 410;
            int n2 = 59304;
            RJDataMsg rJDataMsg = RJCom.getMsg(this.controller, n, n2);
            Object[] objectArray = rJDataMsg.getMessage();
            this.putLog((String)objectArray);
            objectArray = new Object[]{RJComUty.CAPTION_MSG_OK, RJComUty.CAPTION_MSG_CANCEL};
            n2 = RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[1]);
            if (n2 == 0) {
                this.putLog("'OK' was specified by user.");
            } else {
                this.putLog("'Cancel' was specified by user.");
                bl = false;
            }
        }
        return bl;
    }

    public boolean isDoingExport() {
        boolean bl = this.doingExport;
        return bl;
    }

    private void initialzePanel() {
        DefaultComponentFactory defaultComponentFactory = new DefaultComponentFactory(this.guidance);
        this.licenseTableModel = new UninstallLicenseListTableModel(this.guidance, this.licenseList);
        Object object = new UninstallLicenseListTableCellRenderer();
        this.licenseListTable = defaultComponentFactory.createTable();
        this.licenseListTable.setAutoResizeMode(0);
        this.licenseListTable.setCellSelectionEnabled(false);
        this.licenseListTable.setColumnSelectionAllowed(false);
        this.licenseListTable.setDefaultRenderer(Integer.class, (TableCellRenderer)object);
        this.licenseListTable.setDefaultRenderer(String.class, (TableCellRenderer)object);
        this.licenseListTable.setDragEnabled(false);
        this.licenseListTable.setForeground(Color.BLACK);
        this.licenseListTable.setRowSelectionAllowed(true);
        this.licenseListTable.setSelectionMode(0);
        this.licenseListTable.setModel(this.licenseTableModel);
        Object object2 = new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                Point point;
                int n;
                JTableHeader jTableHeader;
                Rectangle rectangle;
                Rectangle rectangle2;
                if (!mouseEvent.isPopupTrigger() && (rectangle2 = ComponentUtilities.getClickableRectangle(rectangle = (jTableHeader = (JTableHeader)mouseEvent.getSource()).getHeaderRect(n = jTableHeader.columnAtPoint(point = mouseEvent.getPoint())))).contains(point)) {
                    UninstallLicenseListPanel.this.licenseTableModel.setSortAt(n);
                }
            }
        };
        Object object3 = this.licenseListTable.getTableHeader();
        ((Component)object3).addMouseListener((MouseListener)object2);
        ((JTableHeader)object3).setReorderingAllowed(false);
        object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UninstallLicenseListPanel.this.clickExportButton();
            }
        };
        object3 = this.guidance.exportButton.getGuidance();
        object2 = this.guidance.exportButton.getColor();
        this.exportButton = defaultComponentFactory.createButton();
        this.exportButton.setText((String)object3);
        this.exportButton.setForeground((Color)object2);
        this.exportButton.addActionListener((ActionListener)object);
    }

    private void buildPanelLayout() {
        DefaultComponentFactory defaultComponentFactory = new DefaultComponentFactory(this.guidance);
        Object object = this.guidance.uninstalledListTitle.getGuidance();
        Serializable serializable = new Dimension(12, 24);
        Serializable serializable2 = new Color(0, 0, 153);
        JPanel jPanel = defaultComponentFactory.createPanel();
        jPanel.setOpaque(true);
        jPanel.setBackground((Color)serializable2);
        jPanel.setPreferredSize((Dimension)serializable);
        serializable2 = RJComFont.ppTitleFont;
        Color color = Color.BLACK;
        serializable = defaultComponentFactory.createLabel((String)object);
        ((JComponent)serializable).setFont((Font)serializable2);
        ((JComponent)serializable).setForeground(color);
        serializable2 = new BorderLayout(8, 0);
        JPanel jPanel2 = defaultComponentFactory.createPanel();
        jPanel2.setLayout((LayoutManager)((Object)serializable2));
        jPanel2.setOpaque(false);
        jPanel2.add((Component)jPanel, "West");
        jPanel2.add((Component)serializable, "Center");
        serializable2 = new Dimension(680, 244);
        serializable = defaultComponentFactory.createScrollPane(this.licenseListTable);
        ((JScrollPane)serializable).setVerticalScrollBarPolicy(22);
        ((JComponent)serializable).setPreferredSize((Dimension)serializable2);
        serializable2 = new BorderLayout();
        jPanel = defaultComponentFactory.createPanel();
        jPanel.setLayout((LayoutManager)((Object)serializable2));
        jPanel.setOpaque(false);
        jPanel.add((Component)serializable, "Center");
        ComponentUtilities.decorateInputAreaBorder(jPanel);
        serializable = new BorderLayout(5, 8);
        object = defaultComponentFactory.createPanel();
        ((Container)object).setLayout((LayoutManager)((Object)serializable));
        ((JComponent)object).setOpaque(false);
        ((Container)object).add((Component)jPanel, "Center");
        serializable2 = new GridLayout(1, 0, 5, 3);
        serializable = defaultComponentFactory.createPanel();
        ((Container)serializable).setLayout((LayoutManager)((Object)serializable2));
        ((JComponent)serializable).setOpaque(false);
        ((Container)serializable).add(this.exportButton);
        serializable2 = new BorderLayout(5, 3);
        jPanel = defaultComponentFactory.createPanel();
        jPanel.setLayout((LayoutManager)((Object)serializable2));
        jPanel.setOpaque(false);
        jPanel.add((Component)serializable, "East");
        ComponentUtilities.decorateInputAreaMarginBorder(jPanel);
        serializable = new BorderLayout(5, 3);
        serializable2 = this.guidance.BASEPANEL.getColor();
        this.setLayout((LayoutManager)((Object)serializable));
        this.setOpaque(true);
        this.setBackground((Color)serializable2);
        this.add((Component)jPanel2, "North");
        this.add((Component)object, "Center");
        this.add((Component)jPanel, "South");
        ComponentUtilities.decoratePanelAreaMarginBorder(this);
    }

    private void loadColumnWidthds() {
        TableColumnModel tableColumnModel = this.licenseListTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int n2 = this.licenseTableModel.getPreferredColumnWidth(i);
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setPreferredWidth(n2);
        }
    }

    private void closeOwnerWindow() {
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        if (window != null) {
            WindowEvent windowEvent = new WindowEvent(window, 201);
            window.dispatchEvent(windowEvent);
            this.putLog("has window closing request.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clickExportButton() {
        int n;
        Object object;
        this.doingExport = true;
        File file = null;
        if (lastExportedFile != null) {
            file = lastExportedFile.getParentFile();
        }
        String string = "gz";
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(string);
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setCurrentDirectory(file);
        jFileChooser.setDialogTitle(RJComDef.DlgTitle);
        jFileChooser.setDialogType(1);
        jFileChooser.setDragEnabled(false);
        jFileChooser.setFileFilter(extensionFileFilter);
        jFileChooser.setFileHidingEnabled(false);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setSelectedFile(lastExportedFile);
        File file2 = null;
        int n2 = jFileChooser.showSaveDialog(this);
        if (n2 == 0) {
            Object[] objectArray;
            file2 = jFileChooser.getSelectedFile();
            object = file2.getAbsolutePath();
            if (!((String)(object = ((String)object).toLowerCase())).endsWith((String)(objectArray = "." + string.toLowerCase()))) {
                object = (String)object + (String)objectArray;
                lastExportedFile = file2 = new File((String)object);
            }
            if (file2.exists()) {
                int n3 = 410;
                n = 59303;
                object = RJCom.getMsg(this.controller, n3, n);
                objectArray = ((RJDataMsg)object).getMessage();
                this.putLog((String)objectArray);
                objectArray = new Object[]{RJComUty.CAPTION_MSG_OK, RJComUty.CAPTION_MSG_CANCEL};
                n2 = RJComDialog.show(this, (RJDataMsg)object, 0, objectArray, objectArray[1]);
                if (n2 == 0) {
                    this.putLog("'OK' was specified by user.");
                    n2 = 0;
                } else {
                    this.putLog("'Cancel' was specified by user.");
                    n2 = 1;
                }
            }
        }
        if (n2 == 0) {
            Object[] objectArray;
            int n4 = 410;
            n = 59301;
            object = RJCom.getMsg(this.controller, n4, n);
            try {
                this.putLog("export license list. [" + file2 + "]");
                objectArray = new UninstallLicenseInformation[]{};
                objectArray = this.licenseList.toArray(objectArray);
                this.exportLicenseList(file2, (UninstallLicenseInformation[])objectArray);
                objectArray = ((RJDataMsg)object).getMessage();
                this.putLog((String)objectArray);
            }
            catch (Exception exception) {
                Object[] objectArray2;
                try {
                    exception.printStackTrace(System.err);
                    n = 410;
                    int n5 = 59302;
                    object = RJCom.getMsg(this.controller, n, n5);
                    objectArray2 = ((RJDataMsg)object).getMessage();
                    this.putLog((String)objectArray2);
                }
                catch (Throwable throwable) {
                    Object[] objectArray3 = ((RJDataMsg)object).getMessage();
                    this.putLog((String)objectArray3);
                    objectArray3 = new Object[]{RJComUty.CAPTION_MSG_OK};
                    RJComDialog.show(this, (RJDataMsg)object, 0, objectArray3, objectArray3[0]);
                    throw throwable;
                }
                objectArray2 = new Object[]{RJComUty.CAPTION_MSG_OK};
                RJComDialog.show(this, (RJDataMsg)object, 0, objectArray2, objectArray2[0]);
            }
            objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
            RJComDialog.show(this, (RJDataMsg)object, 0, objectArray, objectArray[0]);
        }
        this.doingExport = false;
        if (this.exported) {
            this.closeOwnerWindow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportLicenseList(File file, UninstallLicenseInformation[] uninstallLicenseInformationArray) throws IOException {
        if (file != null && uninstallLicenseInformationArray != null) {
            Object object;
            File file2 = File.createTempFile("licenses", null);
            file2.deleteOnExit();
            FileWriter fileWriter = null;
            try {
                object = UninstallLicenseInformation.getCSVHeader();
                fileWriter = new FileWriter(file2);
                fileWriter.write((String)object);
                fileWriter.write(CRLF);
                for (int i = 0; i < uninstallLicenseInformationArray.length; ++i) {
                    UninstallLicenseInformation uninstallLicenseInformation = uninstallLicenseInformationArray[i];
                    String string = uninstallLicenseInformation.toCSVLine();
                    fileWriter.write(string);
                    fileWriter.write(CRLF);
                }
            }
            finally {
                if (fileWriter != null) {
                    try {
                        fileWriter.flush();
                        fileWriter.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                    }
                }
            }
            object = new GZIPCompressor(file2, file);
            this.putLog("tempfile = " + file2);
            this.putLog("targetfile = " + file);
            this.putLog("buffersize = " + ((GZIPCompressor)object).getBufferSize());
            ((GZIPCompressor)object).compress();
            this.exported = true;
        }
    }

    private List convertToLicenseList(RJPPKeyInfoClass[] rJPPKeyInfoClassArray) {
        ArrayList<UninstallLicenseInformation> arrayList = new ArrayList<UninstallLicenseInformation>();
        if (rJPPKeyInfoClassArray != null) {
            for (int i = 0; i < rJPPKeyInfoClassArray.length; ++i) {
                RJPPKeyInfoClass rJPPKeyInfoClass = rJPPKeyInfoClassArray[i];
                long l = rJPPKeyInfoClass.m_lSerialNumber;
                Iterator iterator = rJPPKeyInfoClass.licenseList.iterator();
                while (iterator.hasNext()) {
                    PPKget1PortableLicense pPKget1PortableLicense = (PPKget1PortableLicense)iterator.next();
                    if (pPKget1PortableLicense.nInstall != 0) continue;
                    String string = rJPPKeyInfoClass.m_strPPID;
                    String string2 = rJPPKeyInfoClass.m_strPPName;
                    String string3 = pPKget1PortableLicense.strKeyCode;
                    int n = pPKget1PortableLicense.nCapaKind;
                    UninstallLicenseInformation uninstallLicenseInformation = new UninstallLicenseInformation(l, string, string2, string3, n);
                    arrayList.add(uninstallLicenseInformation);
                }
            }
        }
        return arrayList;
    }

    private List convertToLicenseList(PPKgetKeyDetail pPKgetKeyDetail) {
        ArrayList<UninstallLicenseInformation> arrayList = new ArrayList<UninstallLicenseInformation>();
        if (pPKgetKeyDetail != null) {
            for (int i = 0; i < pPKgetKeyDetail.ppkget1ppinfo.length; ++i) {
                PPKget1PPInfo pPKget1PPInfo = pPKgetKeyDetail.ppkget1ppinfo[i];
                long l = pPKget1PPInfo.nSN;
                Iterator iterator = pPKget1PPInfo.portableLicenseList.iterator();
                while (iterator.hasNext()) {
                    PPKget1PortableLicense pPKget1PortableLicense = (PPKget1PortableLicense)iterator.next();
                    if (pPKget1PortableLicense.nInstall != 0) continue;
                    String string = pPKget1PPInfo.strPPID;
                    String string2 = pPKget1PPInfo.strPPName;
                    String string3 = pPKget1PortableLicense.strKeyCode;
                    int n = pPKget1PortableLicense.nCapaKind;
                    UninstallLicenseInformation uninstallLicenseInformation = new UninstallLicenseInformation(l, string, string2, string3, n);
                    arrayList.add(uninstallLicenseInformation);
                }
            }
        }
        return arrayList;
    }

    private void putLog(String string) {
        String string2 = "[UninstallLicenseList]";
        String string3 = "[PPKey]";
        System.out.println(string3 + " " + string2 + " " + string);
        RJCom.putLog(this.controller, string3, string2, string, 0);
    }
}

