/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.prm;

import java.util.ArrayList;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComCHA;
import sanproject.client.data.RJDataControl;
import sanproject.client.prm.RJPRMBasePanel;
import sanproject.client.prm.RJPRMConst;
import sanproject.client.prm.RJPRMGuide;
import sanproject.common.Robj_interface_RJiCHAInfoDetail;
import sanproject.common.Robj_interface_RJiPortAttributeInfoDetail;
import sanproject.common.Robj_interface_RJiPortInfoDetail;

public class RJPRMPortDataControl
implements RJPRMConst {
    private ArrayList alPort;
    public static final int RJPORT_MODE_UNKNOWN = 0;
    public static final int RJPORT_MODE_LCP = 1;
    public static final int RJPORT_MODE_RCP = 2;
    public static final int RJPORT_MODE_TARGET = 3;
    public static final int RJPORT_MODE_RCUTARGET = 4;
    public static final int RJPORT_MODE_INITIATOR = 5;
    public static final int RJPORT_MODE_EXTERNAL = 6;
    public static final int RJPORT_MODE_FICON = 7;
    public static final int RJPORT_MODE_ISCSI = 9;
    static String[] RJPORT_MODE_STRING;
    static final int RJPORT_SPEED_UNKNOWN = 0;
    static final int RJPORT_SPEED_STANDARD = 1;
    static final int RJPORT_SPEED_HIGH = 2;
    static final int RJPORT_SPEED_2MPHIGH = 4;
    static final int RJPORT_SPEED_NA = 3;
    static final int RJPORT_SPEED_HIGH_H = 5;
    static final int RJPORT_SPEED_HIGH_L = 6;
    RJDataControl data;
    RJPRMBasePanel.RJPRMDataSupply m_prmDataSupply;
    RJPRMGuide RJHorcGuide;
    RJComCHA chu;
    Robj_interface_RJiCHAInfoDetail[] chas;
    Robj_interface_RJiPortInfoDetail[] ports;
    Robj_interface_RJiPortAttributeInfoDetail[] ports_attr;
    private final int[] HIGHSPEED_UNIT = new int[]{0, 0, 1, 1, 2, 2, 3, 3};

    private void defineMacroString() {
        String[] stringArray = new String[11];
        stringArray[0] = RJPRMGuide.Get3Asterisk.getGuidance();
        stringArray[1] = RJPRMGuide.Port_LCP.getGuidance();
        stringArray[2] = RJPRMGuide.Port_RCP.getGuidance();
        stringArray[3] = RJPRMGuide.Port_Target.getGuidance();
        stringArray[4] = RJPRMGuide.Port_RCUTarget.getGuidance();
        stringArray[5] = RJPRMGuide.Port_Initiator.getGuidance();
        stringArray[6] = RJPRMGuide.Port_External.getGuidance();
        stringArray[7] = RJPRMGuide.Port_FICON.getGuidance();
        stringArray[8] = RJPRMGuide.Port_ENAS.getGuidance();
        stringArray[9] = RJPRMGuide.Port_ISCSI.getGuidance();
        stringArray[10] = "";
        String[] stringArray2 = stringArray;
        RJPORT_MODE_STRING = stringArray2;
    }

    public RJPRMPortDataControl(RJPRMBasePanel.RJPRMDataSupply rJPRMDataSupply) {
        this.m_prmDataSupply = rJPRMDataSupply;
        this.data = rJPRMDataSupply.getDC();
        this.chu = new RJComCHA();
        this.defineMacroString();
        this.create(this.data);
    }

    private void create(RJDataControl rJDataControl) {
        this.alPort = new ArrayList();
        RJPRMPortDataControl rJPRMPortDataControl = this;
        RJCom.putLog(this.data, rJPRMPortDataControl.RJHorcGuide.getTRCKey(), "RJPRMPortDataControl", "create()", 0);
        try {
            this.chas = this.m_prmDataSupply.getCHAInfoDetail();
            this.ports = this.m_prmDataSupply.getPortInfoDetail();
            this.ports_attr = this.m_prmDataSupply.getPortAttribute();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        Object var2_3 = null;
        this.alPort.clear();
        for (int i = 0; i < this.ports.length; ++i) {
            RJPort rJPort = new RJPort();
            rJPort.m_PortNo = this.ports[i].getSPort();
            if (rJPort.m_PortNo < 0 || 192 <= rJPort.m_PortNo) {
                RJPRMPortDataControl rJPRMPortDataControl2 = this;
                RJCom.putLog(this.data, rJPRMPortDataControl2.RJHorcGuide.getTRCKey(), "create()", "PortNo = " + rJPort.m_PortNo, 0);
                rJPort = null;
                continue;
            }
            rJPort.m_PortName = RJComCHA.toPortName((short)rJPort.m_PortNo);
            rJPort.m_Cluster = RJComCHA.getPortToCluster((short)rJPort.m_PortNo);
            rJPort.m_ChaNo = RJComCHA.getPortToCHANumber((short)rJPort.m_PortNo);
            boolean bl = false;
            Robj_interface_RJiCHAInfoDetail robj_interface_RJiCHAInfoDetail = this.getCHAInfoDetail(rJPort.m_Cluster, rJPort.m_ChaNo);
            if (robj_interface_RJiCHAInfoDetail != null) {
                rJPort.m_ChaType = robj_interface_RJiCHAInfoDetail.getByCHAPackageType();
                rJPort.m_ChaName = robj_interface_RJiCHAInfoDetail.getStrCHADisplayName();
                bl = true;
                if (!this.isSerialPackage(rJPort.m_ChaType) && !this.isFibrePackage(rJPort.m_ChaType)) {
                    bl = false;
                }
            } else {
                rJPort.m_ChaType = 0;
                rJPort.m_ChaName = "XXX";
            }
            if (!bl) {
                if (this.isFICONPackage(rJPort.m_ChaType)) {
                    rJPort.m_Mode = 7;
                } else if (this.isIscsiPackage(rJPort.m_ChaType)) {
                    rJPort.m_Mode = 9;
                } else {
                    rJPort.m_Mode = 0;
                    System.out.println("RJDataPortInf p=" + rJPort.m_PortNo + ":" + rJPort.m_PortName + ",cha=" + rJPort.m_Cluster + "-" + rJPort.m_ChaNo + ",pk=" + rJPort.m_ChaType + ",typ=" + rJPort.m_ChaType + ",mod=Unknown");
                }
                rJPort.m_strMode = RJPORT_MODE_STRING[rJPort.m_Mode];
            } else {
                byte by = this.getPortAttribute(rJPort.m_PortNo);
                switch (by) {
                    case 1: 
                    case 2: {
                        rJPort.m_Mode = by;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        rJPort.m_Mode = by;
                        break;
                    }
                    default: {
                        rJPort.m_Mode = 0;
                        System.out.println("RJDataPortInf p=" + rJPort.m_PortNo + ":" + rJPort.m_PortName + ",cha=" + rJPort.m_Cluster + "-" + rJPort.m_ChaNo + ",pk=" + rJPort.m_ChaType + ",pkmod=" + ",spd=" + ",typ=" + rJPort.m_ChaType + ",mod=" + by);
                    }
                }
                rJPort.m_strMode = RJPORT_MODE_STRING[rJPort.m_Mode];
            }
            this.alPort.add(rJPort);
        }
    }

    private int calcModeId(int n, int n2, int n3, int n4) {
        return ((n * 100 + n2) * 100 + n3) * 1000 + n4;
    }

    private int calcSpeed(byte[] byArray, int n) {
        int n2 = 1;
        short s = RJComCHA.getPortBlockID((short)n);
        int n3 = 128 >> s;
        return n2;
    }

    private int getGrp(int n, int n2, int n3) {
        int n4 = 99;
        short s = RJComCHA.getPortToCHAPort((short)n2);
        n4 = n3 == 1 ? (int)s : this.HIGHSPEED_UNIT[s];
        return n4;
    }

    public int[] getPortList() {
        int n = this.alPort.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = ((RJPort)this.alPort.get((int)i)).m_PortNo;
        }
        return nArray;
    }

    private int searchPort(int n) {
        int n2 = -1;
        for (int i = 0; i < this.alPort.size(); ++i) {
            RJPort rJPort = (RJPort)this.alPort.get(i);
            if (n != rJPort.m_PortNo) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public int getCluster(int n) {
        int n2 = this.searchPort(n);
        if (n2 < 0) {
            return -1;
        }
        return ((RJPort)this.alPort.get((int)n2)).m_Cluster;
    }

    public int getMode(int n) {
        int n2 = this.searchPort(n);
        if (n2 < 0) {
            return -1;
        }
        return ((RJPort)this.alPort.get((int)n2)).m_Mode;
    }

    public int getSpeed(int n) {
        int n2 = this.searchPort(n);
        if (n2 < 0) {
            return -1;
        }
        return ((RJPort)this.alPort.get((int)n2)).m_Speed;
    }

    public int getModeId(int n) {
        int n2 = this.searchPort(n);
        if (n2 < 0) {
            return -1;
        }
        return ((RJPort)this.alPort.get((int)n2)).m_ModeId;
    }

    public String convertPortNoToName(int n) {
        int n2 = this.searchPort(n);
        if (n2 < 0) {
            return null;
        }
        return ((RJPort)this.alPort.get((int)n2)).m_PortName;
    }

    public String convertModeToString(int n) {
        if (n < 0) {
            n = 0;
        }
        return RJPORT_MODE_STRING[n];
    }

    private boolean isFibrePackage(int n) {
        boolean bl = false;
        bl = RJComCHA.isPKFibre((byte)n);
        return bl;
    }

    private boolean isSerialPackage(int n) {
        boolean bl = false;
        bl = RJComCHA.isPKSerial((byte)n);
        return bl;
    }

    private boolean isFICONPackage(int n) {
        boolean bl = false;
        bl = RJComCHA.isPKMfibre((byte)n);
        return bl;
    }

    public String getCHAName(int n) {
        int n2 = this.searchPort(n);
        if (n2 < 0) {
            return "";
        }
        return ((RJPort)this.alPort.get((int)n2)).m_ChaName;
    }

    private boolean isIscsiPackage(int n) {
        boolean bl = false;
        bl = RJComCHA.isPKIscsi((byte)n);
        return bl;
    }

    private Robj_interface_RJiCHAInfoDetail getCHAInfoDetail(int n, int n2) {
        Robj_interface_RJiCHAInfoDetail robj_interface_RJiCHAInfoDetail = null;
        if (this.chas != null) {
            for (int i = 0; i < this.chas.length; ++i) {
                if (this.chas[i].getSCHAClusterNumber() != n || this.chas[i].getSCHANumber() != n2) continue;
                robj_interface_RJiCHAInfoDetail = this.chas[i];
                break;
            }
        }
        return robj_interface_RJiCHAInfoDetail;
    }

    private byte getPortAttribute(int n) {
        byte by = -1;
        if (this.ports_attr != null) {
            for (int i = 0; i < this.ports_attr.length; ++i) {
                if (this.ports_attr[i].getSPort() != n) continue;
                by = this.ports_attr[i].getByPortKind();
                break;
            }
        }
        return by;
    }

    private class RJPort {
        int m_Cluster;
        int m_PortNo;
        String m_PortName;
        int m_Mode;
        String m_strMode;
        int m_Speed;
        int m_ModeId;
        int m_ChaType;
        int m_ChaNo;
        String m_ChaName;

        private RJPort() {
        }
    }
}

