/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.query;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.cim.CIMDateTime;
import javax.cim.CIMInstance;
import javax.wbem.WBEMException;
import org.wbemservices.wbem.query.AnyValueExp;
import org.wbemservices.wbem.query.ArrayValueExp;
import org.wbemservices.wbem.query.AttributeExp;
import org.wbemservices.wbem.query.BooleanExp;
import org.wbemservices.wbem.query.DateTimeExp;
import org.wbemservices.wbem.query.EveryValueExp;
import org.wbemservices.wbem.query.NumericArrayValue;
import org.wbemservices.wbem.query.NumericValue;
import org.wbemservices.wbem.query.QueryExp;
import org.wbemservices.wbem.query.StringValueExp;
import org.wbemservices.wbem.query.ValueExp;

public class BinaryRelQueryExp
extends QueryExp {
    static final long serialVersionUID = 7002632221491684778L;
    private int relOp;
    private ValueExp expOne;
    private ValueExp expTwo;

    public BinaryRelQueryExp(int op, ValueExp v1, ValueExp v2) {
        this.relOp = op;
        this.expOne = v1;
        this.expTwo = v2;
    }

    public BinaryRelQueryExp() {
    }

    public int getOperator() {
        return this.relOp;
    }

    public ValueExp getLeftValue() {
        return this.expOne;
    }

    public ValueExp getRightValue() {
        return this.expTwo;
    }

    @Override
    public boolean apply(CIMInstance obj) throws WBEMException {
        return this.doApply(this.expOne.apply(obj), this.expTwo.apply(obj));
    }

    private boolean doApply(Object val1, Object val2) throws WBEMException {
        Object[] aval1;
        boolean numeric = val1 instanceof NumericValue;
        if (val1 == null || val2 == null) {
            return this.relOp == 5 && (val1 != null || val2 != null);
        }
        if (numeric) {
            BigDecimal bdval1 = new BigDecimal(val1.toString());
            BigDecimal bdval2 = new BigDecimal(val2.toString());
            switch (this.relOp) {
                case 0: {
                    return bdval1.compareTo(bdval2) > 0;
                }
                case 1: {
                    return bdval1.compareTo(bdval2) < 0;
                }
                case 2: {
                    return bdval1.compareTo(bdval2) >= 0;
                }
                case 3: {
                    return bdval1.compareTo(bdval2) <= 0;
                }
                case 4: {
                    return bdval1.compareTo(bdval2) == 0;
                }
                case 5: {
                    return bdval1.compareTo(bdval2) != 0;
                }
            }
        }
        if (val1 instanceof BooleanExp) {
            if (!(val2 instanceof BooleanExp)) {
                throw new WBEMException(1, "Trying to compare boolean value to non boolean: " + val1.toString() + " -> " + val2.toString());
            }
            Boolean bVal1 = ((BooleanExp)val1).getValue();
            Boolean bVal2 = ((BooleanExp)val2).getValue();
            switch (this.relOp) {
                case 4: {
                    return bVal1.equals(bVal2);
                }
                case 5: {
                    return !bVal1.equals(bVal2);
                }
            }
            throw new WBEMException(1, "boolean comparison only supports '=' and '<>'");
        }
        if (this.expOne instanceof AnyValueExp) {
            aval1 = ((NumericArrayValue)val1).getValue();
            switch (this.relOp) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    for (int i = 0; i < aval1.length; ++i) {
                        Number v1 = (Number)aval1[i];
                        if (!this.doApply(new NumericValue(v1), this.expTwo)) continue;
                        return true;
                    }
                    return false;
                }
                case 5: {
                    for (int i = 0; i < aval1.length; ++i) {
                        Number v1 = (Number)aval1[i];
                        if (!this.doApply(new NumericValue(v1), this.expTwo)) continue;
                        return true;
                    }
                    return false;
                }
            }
        }
        if (this.expOne instanceof EveryValueExp) {
            aval1 = ((NumericArrayValue)val1).getValue();
            switch (this.relOp) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    for (int i = 0; i < aval1.length; ++i) {
                        Number v1 = (Number)aval1[i];
                        if (this.doApply(new NumericValue(v1), this.expTwo)) continue;
                        return false;
                    }
                    return true;
                }
                case 5: {
                    for (int i = 0; i < aval1.length; ++i) {
                        Number v1 = (Number)aval1[i];
                        if (this.doApply(new NumericValue(v1), this.expTwo)) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        if (val1 instanceof NumericArrayValue && this.expOne instanceof AttributeExp && this.expTwo instanceof NumericValue && (aval1 = ((NumericArrayValue)val1).getValue()).length > 0 && aval1[0] instanceof Number) {
            switch (this.relOp) {
                case 4: {
                    Number v1;
                    for (int i = 0; i < aval1.length; ++i) {
                        v1 = (Number)aval1[i];
                        if (!this.doApply(new NumericValue(v1), this.expTwo)) continue;
                        return true;
                    }
                    return false;
                }
                case 5: {
                    Number v1;
                    for (int i = 0; i < aval1.length; ++i) {
                        v1 = (Number)aval1[i];
                        if (!this.doApply(new NumericValue(v1), this.expTwo)) continue;
                        return false;
                    }
                    return true;
                }
            }
            throw new WBEMException(7);
        }
        if (val1 instanceof NumericArrayValue && val2 instanceof NumericArrayValue && (this.expOne instanceof AttributeExp && this.expTwo instanceof AttributeExp || this.expOne instanceof ArrayValueExp && this.expTwo instanceof ArrayValueExp)) {
            aval1 = ((NumericArrayValue)val1).getValue();
            Object[] aval2 = ((NumericArrayValue)val2).getValue();
            if (aval1 == null || aval2 == null) {
                return false;
            }
            Arrays.sort(aval1);
            Arrays.sort(aval2);
            boolean eq = aval1.length == aval2.length && Arrays.equals(aval1, aval2);
            switch (this.relOp) {
                case 4: {
                    return eq;
                }
                case 5: {
                    return !eq;
                }
            }
            throw new WBEMException(7);
        }
        if (val1 instanceof DateTimeExp || val2 instanceof DateTimeExp) {
            if (!(val1 instanceof DateTimeExp)) {
                try {
                    val1 = new DateTimeExp(((StringValueExp)val1).getValue());
                }
                catch (Exception e) {
                    throw new WBEMException(1, val1.toString());
                }
            }
            CIMDateTime dtval1 = ((DateTimeExp)val1).getValue();
            if (!(val2 instanceof DateTimeExp)) {
                try {
                    val2 = new DateTimeExp(((StringValueExp)val2).getValue());
                }
                catch (Exception e) {
                    throw new WBEMException(1, val2.toString());
                }
            }
            CIMDateTime dtval2 = ((DateTimeExp)val2).getValue();
            switch (this.relOp) {
                case 0: {
                    return dtval1.compareTo((Object)dtval2) > 0;
                }
                case 1: {
                    return dtval1.compareTo((Object)dtval2) < 0;
                }
                case 2: {
                    return dtval1.compareTo((Object)dtval2) >= 0;
                }
                case 3: {
                    return dtval1.compareTo((Object)dtval2) <= 0;
                }
                case 4: {
                    return dtval1.compareTo((Object)dtval2) == 0;
                }
                case 5: {
                    return dtval1.compareTo((Object)dtval2) != 0;
                }
            }
        } else {
            String sval2;
            String sval1;
            try {
                sval1 = ((StringValueExp)val1).getValue();
                sval2 = ((StringValueExp)val2).getValue();
            }
            catch (Exception exc) {
                throw new WBEMException(7);
            }
            switch (this.relOp) {
                case 0: {
                    return sval1.compareTo(sval2) > 0;
                }
                case 1: {
                    return sval1.compareTo(sval2) < 0;
                }
                case 2: {
                    return sval1.compareTo(sval2) >= 0;
                }
                case 3: {
                    return sval1.compareTo(sval2) <= 0;
                }
                case 4: {
                    return sval1.compareTo(sval2) == 0;
                }
                case 5: {
                    return sval1.compareTo(sval2) != 0;
                }
                case 6: {
                    return this.like(sval1, sval2);
                }
                case 7: {
                    return !this.like(sval1, sval2);
                }
            }
        }
        return false;
    }

    public String toString() {
        return this.expOne + " " + this.relOpString() + " " + this.expTwo;
    }

    private String relOpString() {
        switch (this.relOp) {
            case 0: {
                return ">";
            }
            case 1: {
                return "<";
            }
            case 2: {
                return ">=";
            }
            case 3: {
                return "<=";
            }
            case 4: {
                return "=";
            }
            case 5: {
                return "<>";
            }
            case 6: {
                return "LIKE";
            }
            case 7: {
                return "NOT LIKE";
            }
            case 8: {
                return "ISA";
            }
            case 9: {
                return "NOT ISA";
            }
        }
        return "=";
    }

    private boolean like(String match, String pattern) {
        Pattern r = Pattern.compile(pattern);
        return r.matcher(match).find();
    }
}

