/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import sanproject.serverux.data.GetRmiException;
import sanproject.serverux.data.RmiConIPSetUp;
import sanproject.serverux.data.RmiConObjLicenseData;
import sanproject.serverux.data.RmiControlObjImpl;
import sanproject.serverux.data.RmiLoginInfo;
import sanproject.serverux.data.RmiObjImpl;
import sanproject.serverux.data.RmiObjUserInfo;
import sanproject.serverux.data.SANRmiException;
import sanproject.serverux.data.SHA256;
import sanproject.serverux.data.SanRmiExecuteInterface;
import sanproject.serverux.data.SanRmiMultiDKCUtility;
import sanproject.serverux.data.SanServer;
import sanproject.serverux.data.SyncException;
import sanproject.session.client.SJsessionClient;
import sanproject.session.client.exception.SJsessionAuthenticationException;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcBitSetUty;
import sanproject.sn2.com.utility.SJcSNAuthBitUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;

public class RmiConObjSync {
    SJsessionClient sessionClient = null;
    final int OneTime = 0;
    final int HPBackDoor = 1;
    static final int ADD_TABLE = 0;
    static final int REMOVE_TABLE = 1;
    static final int REMOVE_TABLE_TIMEOUT = 2;
    private static final int LIMIT_MIN = 5;
    private Random rand = new Random();
    static final int PR_ADMIN_SLPR = 65535;
    static final int ACCOUNT_LOCK_MAX = 96;
    final int USER_DEFAULT_AUTH = 1;
    final int USER_DEFAULT_ACCOUNT_FLG = 1;
    final String USER_DEFAULT_PP = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
    static final String CLIENT_FACTORY = "sanproject.serverux.ssl.RMISSLClientSocketFactory_2010Security";
    static final String SERVER_FACTORY = "sanproject.serverux.ssl.RMISSLServerSocketFactory_2010Security";
    static final String CLIENT_FACTORY_REG = "com.hitachi.sanproject.rmi.ssl.SanSSLClientSocketFactory";
    static final int AUTHBIT_PS_ONOFF_EXEC = 121;
    SanRmiExecuteInterface stub = null;
    static final String EXE_PROPERTY = "..\\..\\..\\..\\supervisor\\dkcman\\cnf\\env.properties";
    private static final String lockFile = System.getProperty("user.dir") + "\\..\\..\\san\\files\\exporttoollogin.lck";
    private LinkedList loginTable = new LinkedList();
    private LinkedList OneTimeTable = new LinkedList();
    private LinkedList ForHpTable = new LinkedList();
    private LinkedList AccountLockTable = new LinkedList();
    private boolean isUse = false;

    RmiConObjSync() {
    }

    private String makeBindName(String string) {
        String string2 = Integer.toString(Math.abs(this.rand.nextInt()), 16).toUpperCase();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.replace('\\', '/'));
        for (int i = string2.length(); i < 8; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    private String makeUrl(String string, String string2) throws SyncException {
        return "rmi://" + RmiConIPSetUp.getStartUpIP_URL(string2) + "/" + string;
    }

    private RmiObjImpl makeRmiObj(String string, String string2, int n) throws SyncException {
        RmiObjImpl rmiObjImpl = null;
        try {
            int n2 = SanRmiMultiDKCUtility.getPortNum();
            if (SanServer.isSSL) {
                Class<?> clazz = Class.forName(CLIENT_FACTORY);
                RMIClientSocketFactory rMIClientSocketFactory = (RMIClientSocketFactory)clazz.newInstance();
                Class<?> clazz2 = Class.forName(SERVER_FACTORY);
                RMIServerSocketFactory rMIServerSocketFactory = (RMIServerSocketFactory)clazz2.newInstance();
                rmiObjImpl = new RmiObjImpl(string, string2, n, rMIClientSocketFactory, rMIServerSocketFactory);
                this.stub = (SanRmiExecuteInterface)UnicastRemoteObject.exportObject(rmiObjImpl, n2, rMIClientSocketFactory, rMIServerSocketFactory);
            } else {
                rmiObjImpl = new RmiObjImpl(string, string2, n);
                this.stub = (SanRmiExecuteInterface)UnicastRemoteObject.exportObject((Remote)rmiObjImpl, n2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SyncException(4007, ": makeRmiObj Failed" + classNotFoundException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new SyncException(4007, ": makeRmiObj Failed" + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SyncException(4007, ": makeRmiObj Failed" + illegalAccessException.getMessage());
        }
        catch (RemoteException remoteException) {
            throw new SyncException(4007, ": makeRmiObj Failed" + remoteException.getMessage());
        }
        catch (GetRmiException getRmiException) {
            throw new SyncException(getRmiException.nErrData, ": makeRmiObj Failed" + getRmiException.getMessage());
        }
        catch (IllegalStateException illegalStateException) {
            throw new SyncException(4001, ": makeRmiObj Failed" + illegalStateException.getMessage());
        }
        return rmiObjImpl;
    }

    private void doBind(String string, Remote remote) throws SyncException {
        try {
            Registry registry;
            Object object;
            Properties properties = new Properties();
            try {
                object = new FileInputStream(new File(EXE_PROPERTY));
                properties.load((InputStream)object);
                ((InputStream)object).close();
            }
            catch (Exception exception) {
                System.out.println("property file Error");
                System.out.println(exception.getMessage());
                exception.printStackTrace(System.out);
                throw new SyncException(4007, "RmiConObjSync: property file Error : " + string);
            }
            object = properties.getProperty("com.hitachi.sanproject.registry.publicport");
            int n = Integer.parseInt((String)object);
            String string2 = properties.getProperty("com.hitachi.sanproject.registry.host");
            try {
                Class<?> clazz = Class.forName(CLIENT_FACTORY_REG);
                RMIClientSocketFactory rMIClientSocketFactory = (RMIClientSocketFactory)clazz.newInstance();
                registry = LocateRegistry.getRegistry(string2, n, rMIClientSocketFactory);
            }
            catch (Exception exception) {
                System.out.println("RmiConObjSync: exec getRegistry Error");
                exception.printStackTrace(System.out);
                System.out.println(exception.getMessage());
                throw new SyncException(4007, "RmiConObjSync: RMI Object Registration Failure publicport : " + string);
            }
            registry.rebind(string, remote);
        }
        catch (RemoteException remoteException) {
            System.out.println("RmiConObjSync: RMI Object Registration Failure publicport: " + string);
        }
    }

    private void doBindLocal(String string, Remote remote) throws SyncException {
        try {
            Registry registry;
            Object object;
            Properties properties = new Properties();
            try {
                object = new FileInputStream(new File(EXE_PROPERTY));
                properties.load((InputStream)object);
                ((InputStream)object).close();
            }
            catch (Exception exception) {
                System.out.println("property file Error");
                exception.printStackTrace(System.out);
                System.out.println(exception.getMessage());
                throw new SyncException(4007, "RmiConObjSync: RMI Object Registration Failure : " + string);
            }
            object = properties.getProperty("com.hitachi.sanproject.registry.privateport");
            int n = Integer.parseInt((String)object);
            try {
                registry = LocateRegistry.getRegistry(n);
            }
            catch (Exception exception) {
                System.out.println("RmiConObjSync: exec getRegistry Error");
                exception.printStackTrace(System.out);
                System.out.println(exception.getMessage());
                throw new SyncException(4007, "RmiConObjSync: RMI Object Registration Failure privateport: " + string);
            }
            registry.rebind(string, remote);
        }
        catch (RemoteException remoteException) {
            throw new SyncException(4007, "RmiConObjSync: RMI Object Registration Failure : " + string);
        }
    }

    private void doUnbind(String string) throws SyncException {
        Registry registry;
        Object object;
        Properties properties = new Properties();
        try {
            object = new FileInputStream(new File(EXE_PROPERTY));
            properties.load((InputStream)object);
            ((InputStream)object).close();
        }
        catch (Exception exception) {
            System.out.println("property file Error");
            System.out.println(exception.getMessage());
            exception.printStackTrace(System.out);
            throw new SyncException(4007, "RmiConObjSync: property file Error : " + string);
        }
        object = properties.getProperty("com.hitachi.sanproject.registry.publicport");
        int n = Integer.parseInt((String)object);
        String string2 = properties.getProperty("com.hitachi.sanproject.registry.host");
        try {
            Class<?> clazz = Class.forName(CLIENT_FACTORY_REG);
            RMIClientSocketFactory rMIClientSocketFactory = (RMIClientSocketFactory)clazz.newInstance();
            registry = LocateRegistry.getRegistry(string2, n, rMIClientSocketFactory);
        }
        catch (Exception exception) {
            System.out.println("RmiConObjSync: exec getRegistry Error");
            exception.printStackTrace(System.out);
            System.out.println(exception.getMessage());
            throw new SyncException(4007, "RmiConObjSync: RMI Object Registration Failure publicport : " + string);
        }
        try {
            registry.unbind(string);
        }
        catch (RemoteException remoteException) {
            throw new SyncException(4007, "RmiConObjSync: Object Registration Failure : " + string);
        }
        catch (NotBoundException notBoundException) {
            throw new SyncException(4010, "RmiConObjSync: Object Registration Failure : " + string);
        }
    }

    private void doUnBindLocal(String string) throws SyncException {
        Registry registry;
        Object object;
        Properties properties = new Properties();
        try {
            object = new FileInputStream(new File(EXE_PROPERTY));
            properties.load((InputStream)object);
            ((InputStream)object).close();
        }
        catch (Exception exception) {
            System.out.println("property file Error");
            exception.printStackTrace(System.out);
            System.out.println(exception.getMessage());
            throw new SyncException(4007, "RmiConObjSync: RMI Object Registration Failure : " + string);
        }
        object = properties.getProperty("com.hitachi.sanproject.registry.privateport");
        int n = Integer.parseInt((String)object);
        try {
            registry = LocateRegistry.getRegistry(n);
        }
        catch (Exception exception) {
            System.out.println("RmiConObjSync: exec getRegistry Error");
            exception.printStackTrace(System.out);
            System.out.println(exception.getMessage());
            throw new SyncException(4007, "RmiConObjSync: RMI Object Registration Failure privateport: " + string);
        }
        try {
            registry.unbind(string);
        }
        catch (RemoteException remoteException) {
            throw new SyncException(4007, "RmiConObjSync: Object Registration Failure : " + string);
        }
        catch (NotBoundException notBoundException) {
            throw new SyncException(4010, "RmiConObjSync: Object Registration Failure : " + string);
        }
    }

    protected synchronized LoginInfo getLoginInfoByUserID(String string) {
        Iterator iterator = this.loginTable.iterator();
        while (iterator.hasNext()) {
            LoginInfo loginInfo = (LoginInfo)iterator.next();
            if (!loginInfo.getUserID().equals(string)) continue;
            return loginInfo;
        }
        return null;
    }

    private LoginInfo getLoginInfoByBindName(String string) {
        Iterator iterator = this.loginTable.iterator();
        while (iterator.hasNext()) {
            LoginInfo loginInfo = (LoginInfo)iterator.next();
            if (!loginInfo.getBindName().equals(string)) continue;
            return loginInfo;
        }
        return null;
    }

    ArrayList getLoginInfoByVenderFlag(int n) {
        Iterator iterator = this.loginTable.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            LoginInfo loginInfo = (LoginInfo)iterator.next();
            if (loginInfo.getVenderID() != n) continue;
            arrayList.add(loginInfo.getUserID());
        }
        return arrayList;
    }

    int getOneTimeUserInfoSize() {
        return this.OneTimeTable.size();
    }

    private LinkedList getUserListbyVender(int n) {
        LinkedList linkedList = null;
        switch (n) {
            case 0: {
                linkedList = this.OneTimeTable;
                break;
            }
            case 1: {
                linkedList = this.ForHpTable;
                break;
            }
        }
        return linkedList;
    }

    synchronized IDInfo getIDInfoByUserID(int n, String string) {
        LinkedList linkedList = this.getUserListbyVender(n);
        IDInfo iDInfo = null;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext() && !(iDInfo = (IDInfo)iterator.next()).getUserID().equals(string)) {
            iDInfo = null;
        }
        return iDInfo;
    }

    private void addLoginUser_Vender(String string, String string2, RmiObjImpl rmiObjImpl, int n, String string3, String string4, String string5) {
        this.loginTable.add(new LoginInfo(string, string2, rmiObjImpl, n, string3, string4, string5));
    }

    String getIPAdressByUserInfo(String string) {
        String string2 = "";
        LoginInfo loginInfo = this.getLoginInfoByBindName(string);
        string2 = loginInfo != null ? loginInfo.ip : "(Unknown)";
        return string2;
    }

    private String delLoginUserByBindName(String string) {
        LoginInfo loginInfo = this.getLoginInfoByBindName(string);
        if (loginInfo != null) {
            this.snbaseAuthLogout(loginInfo.getStrGlblSessionID());
            String string2 = loginInfo.getUserID();
            loginInfo.getRmiObj().vanish();
            this.loginTable.remove(loginInfo);
            return string2;
        }
        return null;
    }

    synchronized void notifyTrap(String string) {
        Iterator iterator = this.loginTable.iterator();
        while (iterator.hasNext()) {
            LoginInfo loginInfo = (LoginInfo)iterator.next();
            loginInfo.getRmiObj().strTrapRefCode = string;
        }
    }

    protected synchronized RmiLoginInfo login(String string, String string2, int n, int n2, int n3, boolean bl, int n4, String string3, long[] lArray, String string4) throws SyncException {
        String string5 = null;
        if (string.length() > 16) {
            int n5 = string.length() - 16;
            string5 = this.makeBindName(string.substring(n5));
        } else {
            string5 = this.makeBindName(string);
        }
        RmiObjImpl rmiObjImpl = null;
        rmiObjImpl = this.makeRmiObj(string5, string, n);
        System.out.println("make RmiObj");
        RmiObjImpl.strRMIServerVersion = RmiControlObjImpl.getEnvInfo().getServerVersion();
        SHA256 sHA256 = new SHA256();
        String string6 = sHA256.encode32(string, string5);
        sHA256 = null;
        String string7 = this.makeUrl(string6, string2);
        rmiObjImpl.info.setInfo(RmiControlObjImpl.getEnvInfo().getServerVersion(), string7, string5, string, n, new Date(), string2, "", n2, n3, bl, n4, lArray, string6);
        rmiObjImpl._preProc();
        this.doBind(string6, this.stub);
        this.doBindLocal(string6, this.stub);
        this.addLoginUser_Vender(string, string5, rmiObjImpl, n, string3, string4, string2);
        if (n == 0) {
            try {
                File file = new File(lockFile);
                file.createNewFile();
                file.deleteOnExit();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return new RmiLoginInfo(string7, string5, string6);
    }

    synchronized String logOff(String string) throws SyncException {
        Object object;
        LoginInfo loginInfo = this.getLoginInfoByBindName(string);
        String string2 = loginInfo.getAudit_userid();
        String string3 = this.delLoginUserByBindName(string);
        String string4 = null;
        try {
            object = new SHA256();
            string4 = ((SHA256)object).encode32(string3, string);
            object = null;
            this.doUnbind(string4);
            this.doUnBindLocal(string4);
        }
        catch (SyncException syncException) {
            if (4007 == syncException.getErrData()) {
                while (true) {
                    try {
                        Thread.sleep(10000L);
                        this.doUnbind(string4);
                        this.doUnBindLocal(string4);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
            throw syncException;
        }
        object = new File(lockFile);
        ((File)object).delete();
        return string2;
    }

    synchronized ArrayList getUserIDList() {
        Iterator iterator = this.loginTable.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            LoginInfo loginInfo = (LoginInfo)iterator.next();
            arrayList.add(loginInfo.getUserID());
        }
        return arrayList;
    }

    protected synchronized void setUserIDSx(String string, String string2, int n, Object object) throws SANRmiException {
        System.out.println(" [setUserIDSx]RmiConObjSync START");
        this.setOneTimeInfo(string, string2, n, object, 0);
        RunTimeTask runTimeTask = new RunTimeTask(0, string, string2, 5);
        runTimeTask.start();
        System.out.println(" [setUserIDSx]RmiConObjSync END");
    }

    protected synchronized boolean setOneTimeInfo(String string, String string2, int n, Object object, int n2) {
        boolean bl = false;
        if (n2 == 0) {
            bl = this.OneTimeTable.add(new IDInfo(string, string2, n, "", object));
        } else if (n2 == 1) {
            Iterator iterator = this.OneTimeTable.iterator();
            while (iterator.hasNext()) {
                IDInfo iDInfo = (IDInfo)iterator.next();
                if (!iDInfo.userID.equals(string) || !iDInfo.Password.equals(string2)) continue;
                bl = this.OneTimeTable.remove(iDInfo);
                break;
            }
        }
        return bl;
    }

    protected synchronized void getOneTimeInfo(RmiConObjLicenseData rmiConObjLicenseData) {
        Iterator iterator = this.OneTimeTable.iterator();
        while (iterator.hasNext()) {
            IDInfo iDInfo = (IDInfo)iterator.next();
            if (!iDInfo.userID.equals(rmiConObjLicenseData.userID) || !iDInfo.Password.equals(rmiConObjLicenseData.password)) continue;
            rmiConObjLicenseData.slpr = iDInfo.SLPRno;
            rmiConObjLicenseData.setSessionObj(iDInfo.objSessionObject);
            break;
        }
        this.setOneTimeInfo(rmiConObjLicenseData.userID, rmiConObjLicenseData.password, 0, null, 1);
        this.setDefaultLicenseData(rmiConObjLicenseData);
    }

    protected void setDefaultLicenseData(RmiConObjLicenseData rmiConObjLicenseData) {
        rmiConObjLicenseData.pp_flag = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
        rmiConObjLicenseData.ppread_flag = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
        rmiConObjLicenseData.auth = 1;
        rmiConObjLicenseData.AccountFlg = 1;
        rmiConObjLicenseData.aryResourceID = new long[32];
        for (int i = 0; i < 32; ++i) {
            rmiConObjLicenseData.aryResourceID[i] = -1L;
        }
    }

    protected synchronized boolean certificationInfo(int n, String string, String string2) {
        boolean bl = false;
        LinkedList linkedList = this.getUserListbyVender(n);
        if (linkedList != null) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                IDInfo iDInfo = (IDInfo)iterator.next();
                if (!iDInfo.userID.equals(string) || !iDInfo.Password.equals(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    protected RmiObjUserInfo[] getUserInfo() {
        Iterator iterator = this.loginTable.iterator();
        RmiObjUserInfo[] rmiObjUserInfoArray = new RmiObjUserInfo[this.loginTable.size()];
        int n = 0;
        while (iterator.hasNext()) {
            LoginInfo loginInfo = (LoginInfo)iterator.next();
            rmiObjUserInfoArray[n] = loginInfo.getRmiObj().getUserStatusInfo();
            ++n;
        }
        return rmiObjUserInfoArray;
    }

    protected RmiObjUserInfo[] getUserInfo(int n) {
        Iterator iterator = this.loginTable.iterator();
        RmiObjUserInfo[] rmiObjUserInfoArray = new RmiObjUserInfo[this.getLoginInfoByVenderFlag(n).size()];
        int n2 = 0;
        while (iterator.hasNext()) {
            LoginInfo loginInfo = (LoginInfo)iterator.next();
            RmiObjUserInfo rmiObjUserInfo = loginInfo.getRmiObj().getUserStatusInfo();
            if (rmiObjUserInfo.getVenderID() != n) continue;
            rmiObjUserInfoArray[n2] = loginInfo.getRmiObj().getUserStatusInfo();
            ++n2;
        }
        return rmiObjUserInfoArray;
    }

    protected void forceLogoff(String string, String string2) {
        Iterator iterator = this.loginTable.iterator();
        while (iterator.hasNext()) {
            LoginInfo loginInfo = (LoginInfo)iterator.next();
            try {
                if (!loginInfo.getBindName().equals(string2)) continue;
                loginInfo.getRmiObj().DontBe(string);
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected synchronized void checkAccountLock(String string) {
        IDInfo iDInfo = null;
        int n = 1;
        iDInfo = this.getAccountLockInfo(string);
        if (iDInfo != null) {
            n = iDInfo.getRetryCount();
            this.AccountLockTable.remove(iDInfo);
            if (++n >= RmiControlObjImpl.getEnvInfo().getLoginRetryCount()) {
                try {
                    Thread.sleep(RmiControlObjImpl.getEnvInfo().getLoginRetryWait() * 60000);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
        } else if (this.AccountLockTable.size() >= 96) {
            this.AccountLockTable.removeFirst();
        }
        this.AccountLockTable.add(new IDInfo(string, n));
    }

    synchronized IDInfo getAccountLockInfo(String string) {
        IDInfo iDInfo = null;
        Iterator iterator = this.AccountLockTable.iterator();
        while (iterator.hasNext() && !(iDInfo = (IDInfo)iterator.next()).getUserID().equals(string)) {
            iDInfo = null;
        }
        return iDInfo;
    }

    protected synchronized boolean certificationUP(RmiConObjLicenseData rmiConObjLicenseData) {
        boolean bl = false;
        bl = this.snbaseAuth(rmiConObjLicenseData);
        return bl;
    }

    protected synchronized void setIsUse(boolean bl) {
        this.isUse = bl;
    }

    protected synchronized boolean getIsUse() {
        return this.isUse;
    }

    protected synchronized void snbaseAuthInstance() {
        System.out.println("\n [snbaseAuthInstance]START");
        String string = "RMIAPI";
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("APPLICATIONID", string);
            this.sessionClient = SJsessionClient.getInstance(hashMap);
            System.out.println(" [snbaseAuthInstance]OK");
        }
        catch (Exception exception) {
            System.out.println(" [snbaseAuthInstance]Exception");
            exception.printStackTrace();
        }
        System.out.println(" [snbaseAuthInstance]END");
    }

    protected synchronized boolean snbaseAuth(RmiConObjLicenseData rmiConObjLicenseData) {
        boolean bl = false;
        System.out.println("\n [snbaseAuth]START");
        String string = "NOR";
        try {
            if (this.sessionClient == null) {
                System.out.println(" [snbaseAuth]sessionClient is null! \n");
                return false;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("AUTHENTICATION_USERID", rmiConObjLicenseData.userID);
            hashMap.put("AUTHENTICATION_PASSWORD", rmiConObjLicenseData.password);
            hashMap.put("ADDRESS", rmiConObjLicenseData.ip);
            hashMap.put("LOGINTYPE", string);
            HashMap hashMap2 = this.sessionClient.login(hashMap);
            SJcRoleResourceContainer sJcRoleResourceContainer = (SJcRoleResourceContainer)hashMap2.get("RESOURCE_ROLE");
            Integer n = (Integer)hashMap2.get("IDENTICAL_USERID");
            rmiConObjLicenseData.iConnectionID = n;
            rmiConObjLicenseData.strGlblSessionID = (String)hashMap2.get("GLOBALSESSIONID");
            System.out.println(" [snbaseAuth]resouceRole:" + sJcRoleResourceContainer.getAllAuthBit());
            System.out.println(" [snbaseAuth]iConnectionID:" + rmiConObjLicenseData.iConnectionID);
            System.out.println(" [snbaseAuth]strGlblSessionID:" + rmiConObjLicenseData.strGlblSessionID);
            String[] stringArray = SJcSNAuthBitUty.getAuthBitSN2toSN((String)sJcRoleResourceContainer.getAllAuthBit());
            rmiConObjLicenseData.ppread_flag = stringArray[0];
            rmiConObjLicenseData.pp_flag = stringArray[1];
            System.out.println(" [snbaseAuth]ppread_flag:" + rmiConObjLicenseData.ppread_flag);
            System.out.println(" [snbaseAuth]pp_flag:" + rmiConObjLicenseData.pp_flag);
            rmiConObjLicenseData.setAryResourceID(SJcBitSetUty.booolean2bitset((boolean[])sJcRoleResourceContainer.getResourceGroup()));
            System.out.println(" [snbaseAuth]aryResourceID[0]:" + rmiConObjLicenseData.aryResourceID[0]);
            System.out.println(" [snbaseAuth]aryResourceID[1]:" + rmiConObjLicenseData.aryResourceID[1]);
            System.out.println(" [snbaseAuth]aryResourceID[31]:" + rmiConObjLicenseData.aryResourceID[31]);
            rmiConObjLicenseData.aryAuthBit = sJcRoleResourceContainer.getAllAuthInfo();
            bl = true;
        }
        catch (SJsessionAuthenticationException sJsessionAuthenticationException) {
            System.out.println(" [snbaseAuth]SJsessionAuthenticationException!");
            sJsessionAuthenticationException.printStackTrace();
        }
        catch (SJcException sJcException) {
            System.out.println(" [snbaseAuth]SJcException! getAuthBitSN2toSN()");
            sJcException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println(" [snbaseAuth]Exception");
            exception.printStackTrace();
        }
        return bl;
    }

    protected synchronized boolean snbaseAuthSSO(RmiConObjLicenseData rmiConObjLicenseData) {
        boolean bl = false;
        System.out.println("\n [snbaseAuthSSO]START");
        String string = "SSO";
        try {
            if (this.sessionClient == null) {
                System.out.println(" [snbaseAuthSSO]sessionClient is null! \n");
                return false;
            }
            this.setDefaultLicenseData(rmiConObjLicenseData);
            System.out.println(" [snbaseAuthSSO]TorF:True Only");
            System.out.println(" [snbaseAuthSSO]iConnectionID:" + rmiConObjLicenseData.iConnectionID);
            System.out.println(" [snbaseAuthSSO]strGlblSessionID:" + rmiConObjLicenseData.strGlblSessionID);
            bl = true;
        }
        catch (SJsessionAuthenticationException sJsessionAuthenticationException) {
            System.out.println(" [snbaseAuthSSO]SJsessionAuthenticationException!");
            rmiConObjLicenseData.strGlblSessionID = "";
            sJsessionAuthenticationException.printStackTrace();
        }
        catch (SJcException sJcException) {
            System.out.println(" [snbaseAuthSSO]SJcException! getAuthBitSN2toSN()");
            rmiConObjLicenseData.strGlblSessionID = "";
            sJcException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println(" [snbaseAuthSSO]Exception");
            rmiConObjLicenseData.strGlblSessionID = "";
            exception.printStackTrace();
        }
        return bl;
    }

    protected synchronized void snbaseAuthLogout(String string) {
        boolean bl = false;
        System.out.println("\n [snbaseAuthLogout]START");
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("GLOBALSESSIONID", string);
            HashMap hashMap2 = this.sessionClient.logout(hashMap);
            System.out.println(" [snbaseAuthLogout]OK");
        }
        catch (Exception exception) {
            System.out.println(" [snbaseAuthLogout]Exception");
            exception.printStackTrace();
        }
        System.out.println(" [snbaseAuthLogout]END");
    }

    protected synchronized String getLoginKey(String string, String string2) {
        String string3 = Integer.toString(Math.abs(this.rand.nextInt()), 16).toUpperCase();
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = new String();
        for (int i = string3.length(); i < 10; ++i) {
            stringBuffer.append('0');
        }
        string4 = string3 + stringBuffer.toString();
        this.setHPUserInfo(string, string4, string2, 0);
        RunTimeTask runTimeTask = new RunTimeTask(1, string, string4, 5);
        runTimeTask.start();
        return string4;
    }

    protected synchronized boolean setHPUserInfo(String string, String string2, String string3, int n) {
        boolean bl = false;
        if (n == 0) {
            bl = this.ForHpTable.add(new HPLoginIDInfo(string, string2, 65535, string3));
        } else if (n == 1) {
            Iterator iterator = this.ForHpTable.iterator();
            while (iterator.hasNext()) {
                HPLoginIDInfo hPLoginIDInfo = (HPLoginIDInfo)iterator.next();
                if (!hPLoginIDInfo.getUserID().equals(string) || !hPLoginIDInfo.getPassword().equals(string2)) continue;
                bl = this.ForHpTable.remove(hPLoginIDInfo);
                break;
            }
        }
        return bl;
    }

    private class LimitTimeTask
    extends TimerTask {
        String userID;
        String Password;
        int Vender;

        LimitTimeTask(int n, String string, String string2) {
            this.Vender = n;
            this.userID = string;
            this.Password = string2;
        }

        public void run() {
            if (RmiConObjSync.this.certificationInfo(this.Vender, this.userID, this.Password)) {
                switch (this.Vender) {
                    case 0: {
                        RmiConObjSync.this.setOneTimeInfo(this.userID, this.Password, 65535, "", 1);
                        break;
                    }
                    case 1: {
                        RmiConObjSync.this.setHPUserInfo(this.userID, this.Password, "Remove", 1);
                        break;
                    }
                }
            }
        }
    }

    private class RunTimeTask
    extends Thread {
        String userID;
        String Password;
        int LimitTime;
        int Vender;

        RunTimeTask(int n, String string, String string2, int n2) {
            this.Vender = n;
            this.userID = string;
            this.Password = string2;
            this.LimitTime = n2;
        }

        public void run() {
            Timer timer = new Timer();
            LimitTimeTask limitTimeTask = new LimitTimeTask(this.Vender, this.userID, this.Password);
            timer.schedule((TimerTask)limitTimeTask, this.LimitTime * 60000);
        }
    }

    private static class HPLoginIDInfo
    extends IDInfo {
        private String HPInfo;

        HPLoginIDInfo(String string, String string2, int n, String string3) {
            super(string, string2, n, "", null);
            this.HPInfo = string3;
        }

        String getHPInfo() {
            return this.HPInfo;
        }
    }

    private static class IDInfo {
        private String userID = "";
        private String Password = "";
        private int SLPRno = 0;
        private String DigestKey = "";
        private int RetryCount = 0;
        private Object objSessionObject = null;

        IDInfo(String string, String string2, int n, String string3, Object object) {
            this.userID = string;
            this.Password = string2;
            this.SLPRno = n;
            this.DigestKey = string3;
            this.objSessionObject = object;
        }

        IDInfo(String string, int n) {
            this.userID = string;
            this.RetryCount = n;
        }

        String getUserID() {
            return this.userID;
        }

        String getPassword() {
            return this.Password;
        }

        int getSLPRno() {
            return this.SLPRno;
        }

        String getDigestKey() {
            return this.DigestKey;
        }

        int getRetryCount() {
            return this.RetryCount;
        }
    }

    private static class LoginInfo {
        private String userID;
        private String bindName;
        private RmiObjImpl rmiObj;
        private int VenderID = 0;
        private String strGlblSessionID = null;
        private String audit_userid = "";
        private String ip = "";

        LoginInfo(String string, String string2, RmiObjImpl rmiObjImpl) {
            this.userID = string;
            this.bindName = string2;
            this.rmiObj = rmiObjImpl;
        }

        LoginInfo(String string, String string2, RmiObjImpl rmiObjImpl, int n, String string3, String string4, String string5) {
            this.userID = string;
            this.bindName = string2;
            this.rmiObj = rmiObjImpl;
            this.VenderID = n;
            this.strGlblSessionID = string3;
            this.audit_userid = string4;
            this.ip = string5;
        }

        String getUserID() {
            return this.userID;
        }

        String getBindName() {
            return this.bindName;
        }

        RmiObjImpl getRmiObj() {
            return this.rmiObj;
        }

        int getVenderID() {
            return this.VenderID;
        }

        String getStrGlblSessionID() {
            return this.strGlblSessionID;
        }

        String getAudit_userid() {
            return this.audit_userid;
        }

        String getIpaddress() {
            return this.ip;
        }
    }
}

