/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.jserver.soma;

import com.hitachi.jserver.soma.LicenseManager;
import com.hitachi.jserver.soma.SMISSecurityLib;
import com.hitachi.smi.common.ProviderProperties;
import com.hitachi.smi.common.ProviderStatusUtils;
import com.ws.wbem.jserver.AuthService;
import com.ws.wbem.jserver.AuthServiceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMObjectPath;
import javax.security.auth.Subject;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import javax.wbem.provider.ProviderHandle;

public class HitachiAuthService
implements AuthService {
    protected static Logger mLogger = Logger.getLogger("com.ws.wbem.jserver");
    private static boolean suspended = false;
    private static LicenseManager mLicenseManager;
    private static final String LICENSE_NOT_VALID = "License not valid";
    private static final String[] writeOpsArray;
    private static final String[] readOpsArray;
    final List<String> readOps;
    final List<String> writeOps;

    public static void suspend(boolean shouldSuspend) {
        suspended = shouldSuspend;
        if (suspended) {
            ProviderStatusUtils.setProviderStatus(ProviderStatusUtils.ProviderStatus.Suspended, ProviderStatusUtils.ProviderStatusDetailCode.NONE);
        } else {
            ProviderStatusUtils.setProviderStatus(ProviderStatusUtils.ProviderStatus.Ready, ProviderStatusUtils.ProviderStatusDetailCode.NONE);
        }
    }

    public HitachiAuthService() {
        System.setProperty("sun.security.ssl.allowUnsafeRenegotiation", "false");
        this.readOps = new ArrayList<String>(Arrays.asList(readOpsArray));
        this.writeOps = new ArrayList<String>(Arrays.asList(writeOpsArray));
        Collections.sort(this.readOps);
        Collections.sort(this.writeOps);
    }

    public String authenticate(Subject subject, String clientIP) throws WBEMException {
        char[] password = null;
        String user = null;
        Set<UserPrincipal> upSet = subject.getPrincipals(UserPrincipal.class);
        if (!upSet.isEmpty()) {
            UserPrincipal up = upSet.iterator().next();
            user = up.getName();
        }
        if (ProviderProperties.isEmbedded()) {
            Set<PasswordCredential> pcSet = subject.getPrivateCredentials(PasswordCredential.class);
            if (!pcSet.isEmpty()) {
                PasswordCredential pc = pcSet.iterator().next();
                password = pc.getUserPassword();
            }
            if (null == user || null == password) {
                mLogger.log(Level.FINE, "User name or password is null, user: {0}, Pwd: {1}", new Object[]{user, null != password ? "****" : "null"});
                throw WBEMOperationErrors.getAccessDeniedException();
            }
            String pwd = new String(password);
            if (!this.authenticateUser(user, pwd, clientIP)) {
                throw WBEMOperationErrors.getAccessDeniedException();
            }
        }
        UUID x = UUID.randomUUID();
        return x.toString();
    }

    private boolean authenticateUser(String username, String password, String clientIP) throws WBEMException {
        mLogger.log(Level.FINE, "authenticate called for {0} from client {1}", new Object[]{username, clientIP});
        Boolean ret = ProviderProperties.isEmbedded() ? Boolean.valueOf(SMISSecurityLib.authenticate(username, password, clientIP)) : Boolean.valueOf(true);
        mLogger.log(Level.FINE, "authenticate returned {0} for {1} from {2}", new Object[]{ret, username, clientIP});
        return ret;
    }

    public void authorizeRequest(Subject subject, String operationName, String sessionID, CIMObjectPath target) throws WBEMException {
        String userName = null;
        if (!(!suspended && mLicenseManager.isValid() || target.getObjectName().equalsIgnoreCase("HITACHI_ProviderStatusService"))) {
            if (!mLicenseManager.isValid()) {
                throw new WBEMException(2, LICENSE_NOT_VALID);
            }
            mLogger.log(Level.SEVERE, "Provider is suspended. Request, {0}, wil be denied", operationName);
            throw WBEMOperationErrors.getAccessDeniedException();
        }
        Set<UserPrincipal> upSet = subject.getPrincipals(UserPrincipal.class);
        if (!upSet.isEmpty()) {
            UserPrincipal up = upSet.iterator().next();
            userName = up.getName();
        }
        if (Collections.binarySearch(this.readOps, operationName) >= 0) {
            SMISSecurityLib.authorizeRead(userName);
        } else if (Collections.binarySearch(this.writeOps, operationName) >= 0) {
            SMISSecurityLib.authorizeWrite(userName);
        } else {
            mLogger.log(Level.SEVERE, "{0} is not authorized for {1}", new String[]{userName, operationName});
            throw WBEMOperationErrors.getAccessDeniedException();
        }
    }

    public void close() {
        ProviderStatusUtils.setProviderStatus(ProviderStatusUtils.ProviderStatus.Stopped, ProviderStatusUtils.ProviderStatusDetailCode.NONE);
        mLicenseManager.stop();
        ProviderStatusUtils.setProviderStatus(ProviderStatusUtils.ProviderStatus.Stopped, ProviderStatusUtils.ProviderStatusDetailCode.NONE);
    }

    public AuthServiceType getType() {
        return AuthServiceType.OTHER;
    }

    public void initialize(ProviderHandle providerClient) {
        System.setProperty("SN_LogPath", "SMI-S");
        mLogger.info("SMI-S Security Library initializing");
        mLicenseManager = new LicenseManager();
        mLogger.fine("SMI-S Security Library got LM, checking license.");
        mLicenseManager.checkLicense();
        mLogger.fine("SMI-S Security Library license OK.");
        SMISSecurityLib.init();
        ProviderStatusUtils.setProviderStatus(ProviderStatusUtils.ProviderStatus.Initializing, ProviderStatusUtils.ProviderStatusDetailCode.NONE);
    }

    public void sessionCompleted(String sessionID) {
    }

    static {
        writeOpsArray = new String[]{WBEMOperation.CREATECLASS.getName(), WBEMOperation.CREATEQUALIFIERTYPE.getName(), WBEMOperation.DELETECLASS.getName(), WBEMOperation.DELETEQUALIFIERTYPE.getName(), WBEMOperation.MODIFYCLASS.getName(), WBEMOperation.MODIFYQUALIFIERTYPE.getName(), WBEMOperation.CREATEINSTANCE.getName(), WBEMOperation.DELETEINSTANCE.getName(), WBEMOperation.INVOKEMETHOD.getName(), WBEMOperation.INVOKESTATICMETHOD.getName(), WBEMOperation.MODIFYINSTANCE.getName()};
        readOpsArray = new String[]{WBEMOperation.ASSOCIATORCLASSES.getName(), WBEMOperation.ENUMERATECLASSES.getName(), WBEMOperation.ENUMERATEQUALIFIERTYPES.getName(), WBEMOperation.GETCLASS.getName(), WBEMOperation.GETQUALIFIERTYPE.getName(), WBEMOperation.REFERENCECLASSES.getName(), WBEMOperation.CLOSEENUMERATION.getName(), WBEMOperation.ENUMERATEINSTANCES.getName(), WBEMOperation.GETINSTANCE.getName(), WBEMOperation.OPENASSOCIATORS.getName(), WBEMOperation.OPENENUMERATEINSTANCES.getName(), WBEMOperation.OPENQUERYINSTANCES.getName(), WBEMOperation.OPENREFERENCES.getName(), WBEMOperation.PULLINSTANCES.getName(), WBEMOperation.PULLINSTANCESWITHPATH.getName(), WBEMOperation.ENUMERATEQUALIFIERTYPES.getName(), WBEMOperation.ENUMERATECLASSNAMES.getName(), WBEMOperation.EXECUTEQUERY.getName(), WBEMOperation.ASSOCIATORS.getName(), WBEMOperation.REFERENCES.getName()};
    }
}

