/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderDataProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcProductUty;

public class DeviceData
implements Comparable<DeviceData> {
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.provider");
    public static final String DEVICE_DATA_PROP_FILENAME = "array-setting-%02d.properties";
    private String server;
    private String user;
    private String pwd;
    private String poolRestriction;
    private String volumeRestriction;
    private boolean useLegacyVol;
    private String dkcRoot;
    private String serialNumber;
    private String usableRSGs;
    private int sjcModelType;

    private static String getFormattedFileName(int fileNumber) {
        return String.format(DEVICE_DATA_PROP_FILENAME, fileNumber);
    }

    public static void setSystemProperties(String baseDir) {
        File f = new File(baseDir);
        if (f.exists()) {
            String absolutePath = f.getAbsolutePath();
            int index = absolutePath.indexOf("SMI");
            if (index >= 0) {
                String SMI = absolutePath.substring(0, index - 1);
                StringBuilder basePath = new StringBuilder(SMI);
                basePath.append(File.separatorChar);
                basePath.append("DKC200");
                StringBuilder dataPath = new StringBuilder(basePath);
                dataPath.append(File.separatorChar);
                dataPath.append("san");
                dataPath.append(File.separatorChar);
                dataPath.append("SN2");
                dataPath.append(File.separatorChar);
                dataPath.append("SN2Files");
                dataPath.append(File.separatorChar);
                StringBuilder logPath = new StringBuilder(dataPath);
                logPath.append("log");
                logPath.append(File.separatorChar);
                logPath.append("smi-s");
                logPath.append(File.separatorChar);
                System.setProperty("SN_BasePath", basePath.toString());
                System.setProperty("SN_DataPath", dataPath.toString());
                System.setProperty("SN_LogPath", logPath.toString());
                int index2 = SMI.indexOf("wk");
                StringBuilder installDir = new StringBuilder(SMI.substring(0, index2 + 2));
                installDir.append(File.separatorChar);
                installDir.append("supervisor");
                installDir.append(File.separatorChar);
                System.setProperty("Cmn_BasePath=", installDir.toString());
            } else {
                mLogger.log(Level.SEVERE, "Unable to parse install dir from {0}", absolutePath);
            }
        }
    }

    public DeviceData() throws FileNotFoundException, WBEMException {
        this(DeviceData.getFormattedFileName(1), true);
    }

    public DeviceData(int fileNumber) throws WBEMException, FileNotFoundException {
        this(DeviceData.getFormattedFileName(fileNumber));
    }

    public DeviceData(String fileName) throws WBEMException, FileNotFoundException {
        this(fileName, false);
    }

    private DeviceData(String fileName, boolean isEmbedded) throws WBEMException, FileNotFoundException {
        block28: {
            Properties mProps = new Properties();
            StringBuilder propFile = new StringBuilder(ProviderConstants.getConfigDirectory());
            propFile.append(fileName);
            File udFile = new File(propFile.toString());
            mLogger.info("Reading data from " + propFile);
            try (FileInputStream in = new FileInputStream(udFile);){
                mProps.load(in);
                if (isEmbedded) {
                    this.useJSanSN2Tools();
                } else {
                    this.server = mProps.getProperty("IPAddress");
                    if (null == this.server) {
                        throw new WBEMException("Server entry must have value");
                    }
                    this.user = mProps.getProperty("UserID");
                    if (null == this.user) {
                        throw new WBEMException("User entry must have a value");
                    }
                    this.pwd = mProps.getProperty("Password");
                    if (null == this.pwd) {
                        throw new WBEMException("Password entry must have a value");
                    }
                    this.serialNumber = mProps.getProperty("SerialNumber");
                    if (null == this.serialNumber) {
                        throw new WBEMException("SerialNumber entry must have a value");
                    }
                    String tmpModel = mProps.getProperty("ModelID", null);
                    this.sjcModelType = null != tmpModel ? Integer.parseInt(tmpModel) : 8320;
                    this.dkcRoot = "UNKNOWN";
                }
                this.poolRestriction = mProps.getProperty("PoolIDForSnapshot", null);
                this.volumeRestriction = mProps.getProperty("VVolForSnapshot", null);
                String val = mProps.getProperty("ReportLegacyVolumeName", "false");
                this.useLegacyVol = Boolean.parseBoolean(val);
                this.usableRSGs = this.processResourceGroupRestriction(mProps);
            }
            catch (FileNotFoundException fne) {
                if (isEmbedded) {
                    this.useJSanSN2Tools();
                    break block28;
                }
                throw fne;
            }
            catch (IOException ioe) {
                throw new WBEMException(1, "Error getting data from " + fileName, null, (Throwable)ioe);
            }
            catch (Throwable t) {
                Throwable x = t;
                while (!(x instanceof WBEMException) && null != x.getCause()) {
                    x = t.getCause();
                }
                throw new WBEMException(1, "Unexpected error initializing DeviceData.", null, x);
            }
            finally {
                mLogger.info("Done reading data from " + propFile);
            }
        }
    }

    @Override
    public int compareTo(DeviceData o) {
        return this.getDeviceHostName().compareToIgnoreCase(o.getDeviceHostName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceData other = (DeviceData)obj;
        if (this.dkcRoot == null ? other.dkcRoot != null : !this.dkcRoot.equals(other.dkcRoot)) {
            return false;
        }
        if (this.poolRestriction == null ? other.poolRestriction != null : !this.poolRestriction.equals(other.poolRestriction)) {
            return false;
        }
        if (this.pwd == null ? other.pwd != null : !this.pwd.equals(other.pwd)) {
            return false;
        }
        if (this.serialNumber == null ? other.serialNumber != null : !this.serialNumber.equals(other.serialNumber)) {
            return false;
        }
        if (this.server == null ? other.server != null : !this.server.equals(other.server)) {
            return false;
        }
        if (this.useLegacyVol != other.useLegacyVol) {
            return false;
        }
        if (this.user == null ? other.user != null : !this.user.equals(other.user)) {
            return false;
        }
        return !(this.volumeRestriction == null ? other.volumeRestriction != null : !this.volumeRestriction.equals(other.volumeRestriction));
    }

    public String getDeviceHostName() {
        return this.server;
    }

    protected String getDeviceUserPassword() {
        return this.pwd;
    }

    public String getDkcRoot() {
        return this.dkcRoot;
    }

    protected String getRestrictedPoolString() {
        return this.poolRestriction;
    }

    protected String getRestrictedVVolForSnapshot() {
        return this.volumeRestriction;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    protected int getSjcModelType() {
        return this.sjcModelType;
    }

    public final String getUsableRSGs() {
        return this.usableRSGs;
    }

    protected String getUser() {
        return this.user;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dkcRoot == null ? 0 : this.dkcRoot.hashCode());
        result = 31 * result + (this.poolRestriction == null ? 0 : this.poolRestriction.hashCode());
        result = 31 * result + (this.pwd == null ? 0 : this.pwd.hashCode());
        result = 31 * result + (this.serialNumber == null ? 0 : this.serialNumber.hashCode());
        result = 31 * result + (this.server == null ? 0 : this.server.hashCode());
        result = 31 * result + (this.useLegacyVol ? 1231 : 1237);
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        result = 31 * result + (this.volumeRestriction == null ? 0 : this.volumeRestriction.hashCode());
        return result;
    }

    protected boolean isUseLegacyVol() {
        return this.useLegacyVol;
    }

    private String processResourceGroupRestriction(Properties props) throws WBEMException {
        ProviderDataProperties pdp = ProviderDataProperties.getProviderData();
        String usableRSGs = pdp.getResourceGroupRestriction();
        if (null != props && (null == usableRSGs || usableRSGs.isEmpty())) {
            usableRSGs = props.getProperty("ResourceGroup", null);
        }
        return usableRSGs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeviceData [server=");
        builder.append(this.server);
        builder.append(", user=");
        builder.append(this.user);
        builder.append(", pwd=");
        if (mLogger.isLoggable(Level.FINEST)) {
            builder.append(this.pwd);
        } else {
            builder.append("*****");
        }
        builder.append(", poolRestriction=");
        builder.append(this.poolRestriction);
        builder.append(", volumeRestriction=");
        builder.append(this.volumeRestriction);
        builder.append(", useLegacyVol=");
        builder.append(this.useLegacyVol);
        builder.append(", dkcRoot=");
        builder.append(this.dkcRoot);
        builder.append(", serialNumber=");
        builder.append(this.serialNumber);
        builder.append("]");
        return builder.toString();
    }

    private void useJSanSN2Tools() throws WBEMException {
        DeviceData.setSystemProperties(ProviderConstants.getConfigDirectory());
        this.server = "127.0.0.1";
        this.user = SJcEnvUty.getManageUserName();
        this.pwd = SJcEnvUty.getManagePassword();
        this.dkcRoot = SJcEnvUty.getDkcRootName();
        String model = SJcProductUty.getModel();
        this.sjcModelType = Integer.parseInt(model) + 8300;
        this.serialNumber = SJcProductUty.getSerialNumber().replaceFirst("^0+(?!$)", "");
        this.usableRSGs = this.processResourceGroupRestriction(null);
        this.poolRestriction = null;
        this.volumeRestriction = null;
        this.useLegacyVol = false;
    }
}

