/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.AbstractVersionChecker;
import com.hitachi.smi.cache.CacheUpdateType;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.RmcpPairInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import sanproject.common.Robj_interface_HURVerAllJnlg;
import sanproject.common.Robj_interface_HURVerJnlgPer256Grp;
import sanproject.common.Robj_interface_RJiCUIndex;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_VerLeaf;

public class HURBranchChecker
extends AbstractVersionChecker {
    protected HURBranchChecker(String serialNum) {
        super(serialNum);
        CacheUpdater.registerVersionChecker(CacheUpdater.ConfVerID.REMOTE_COPY_J, this);
    }

    @Override
    public void checkVersionDetails(Robj_interface_VerLeaf[] currentChildren, Robj_interface_VerLeaf[] prevChildren) {
        mLogger.info("Change detected in HUR branch");
        Robj_interface_HURVerAllJnlg current = (Robj_interface_HURVerAllJnlg)currentChildren[0];
        Robj_interface_HURVerAllJnlg prev = (Robj_interface_HURVerAllJnlg)prevChildren[0];
        if (current.getNVer() != prev.getNVer() || prev.getNSummaryVer() != current.getNSummaryVer()) {
            ArrayList<Robj_interface_RJiCUIndex> cuIndexes = new ArrayList<Robj_interface_RJiCUIndex>();
            try {
                Robj_interface_RJiLDEVIndex[] lDEVIndexes2Get;
                RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(this.getSerialNumber()).getRMIObject();
                mLogger.log(Level.INFO, "Detected change in HUR version on {0}", new Object[]{this.getSerialNumber()});
                Robj_interface_HURVerJnlgPer256Grp[] curHURData = (Robj_interface_HURVerJnlgPer256Grp[])current.getObjChildren();
                Robj_interface_HURVerJnlgPer256Grp[] prevHURData = (Robj_interface_HURVerJnlgPer256Grp[])prev.getObjChildren();
                for (short i = 0; i < curHURData.length; i = (short)((short)(i + 1))) {
                    if (curHURData[i].getNVer() == prevHURData[i].getNVer()) continue;
                    mLogger.log(Level.INFO, "Detected change in CU: {0} on {1}", new Object[]{i, this.getSerialNumber()});
                    Robj_interface_RJiCUIndex temp = (Robj_interface_RJiCUIndex)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJICUINDEX);
                    temp.setSCU(i);
                    temp.setSLDKC((short)0);
                    cuIndexes.add(temp);
                }
                if (cuIndexes.size() > 0) {
                    mLogger.log(Level.FINE, "Convert {0} CU indexes", cuIndexes.size());
                    lDEVIndexes2Get = rmiObj.getLDEVIndex(cuIndexes.toArray(new Robj_interface_RJiCUIndex[cuIndexes.size()]));
                } else {
                    mLogger.warning("Cache update looking for all HURPairInfo from back end, informational only");
                    lDEVIndexes2Get = null;
                }
                ArrayList<RmcpPairInfo> added = new ArrayList<RmcpPairInfo>();
                ArrayList<RmcpPairInfo> modified = new ArrayList<RmcpPairInfo>();
                ArrayList<RmcpPairInfo> removed = new ArrayList<RmcpPairInfo>();
                RmcpPairInfo.checkCachedPairs(rmiObj, RmcpPairInfo.PairCheckType.HUR, lDEVIndexes2Get, added, modified, removed);
                if (!added.isEmpty()) {
                    CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.REMOTE_COPY_J, (Serializable[])added.toArray(new RmcpPairInfo[added.size()]));
                }
                if (!modified.isEmpty()) {
                    CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.MODIFY, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.REMOTE_COPY_J, (Serializable[])new RmcpPairInfo[1]);
                }
                if (!removed.isEmpty()) {
                    CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.REMOTE_COPY_J, (Serializable[])removed.toArray(new RmcpPairInfo[removed.size()]));
                }
            }
            catch (Throwable t) {
                while (null != t.getCause()) {
                    t = t.getCause();
                }
                mLogger.log(Level.SEVERE, "Exception updating RmcpPairInfo in cache for  " + this.getSerialNumber() + " - " + t, t);
            }
        }
    }
}

