/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.AbstractVersionChecker;
import com.hitachi.smi.cache.CacheUpdateType;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.cache.ResourceGroupInfoVersionChecker;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.ResourceGroupInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_BASICVerAllLDEV;
import sanproject.common.Robj_interface_BASICVerLDEV;
import sanproject.common.Robj_interface_BASICVerLDEVPerCU;
import sanproject.common.Robj_interface_VerLeaf;

public class LDEVBranchChecker
extends AbstractVersionChecker
implements ResourceGroupInfoVersionChecker.RSGUpdateCallback {
    protected static boolean addAddedDN2List(short cu, short ldev, LinkedList<Short[]> addedDNs) {
        boolean ret = false;
        Short[] modified = new Short[]{cu, ldev};
        ret = addedDNs.offer(modified);
        return ret;
    }

    protected static boolean addModifiedDN2List(short cu, short ldev, LinkedList<Short[]> modifiedDNs) {
        boolean ret = false;
        Short[] modified = new Short[]{cu, ldev};
        ret = modifiedDNs.offer(modified);
        return ret;
    }

    protected static boolean addRemovedDN2List(short cu, short ldev, LinkedList<Short[]> removedDNs) {
        boolean ret = false;
        Short[] modified = new Short[]{cu, ldev};
        ret = removedDNs.offer(modified);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processAddedDN(LinkedList<Short[]> addedDNs, String serialNum) {
        try {
            if (!addedDNs.isEmpty()) {
                Serializable[] dns = DeviceNumber.add2CachedDNs(addedDNs, serialNum);
                CacheUpdater.doCallback((String)serialNum, (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.LDEV, (Serializable[])dns);
            }
        }
        catch (Throwable t) {
            mLogger.log(Level.SEVERE, "Exception occurred trying to add DNs to cache.", t);
        }
        finally {
            if (null != addedDNs) {
                addedDNs.clear();
            }
        }
    }

    protected static void processAffectedDNs(LinkedList<Short[]> addedDNs, LinkedList<Short[]> modifiedDNs, LinkedList<Short[]> removedDNs, String serialNum) {
        if (null != removedDNs && removedDNs.size() > 0) {
            LDEVBranchChecker.processRemovedDN(removedDNs, serialNum);
        }
        if (null != addedDNs && addedDNs.size() > 0) {
            LDEVBranchChecker.processAddedDN(addedDNs, serialNum);
        }
        if (null != modifiedDNs && modifiedDNs.size() > 0) {
            LDEVBranchChecker.processModifiedDN(modifiedDNs, serialNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processModifiedDN(LinkedList<Short[]> modifiedDNs, String serialNum) {
        try {
            if (null != modifiedDNs && !modifiedDNs.isEmpty()) {
                Serializable[] dns = DeviceNumber.modifyCachedDN(modifiedDNs, serialNum);
                CacheUpdater.doCallback((String)serialNum, (CacheUpdateType)CacheUpdateType.MODIFY, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.LDEV, (Serializable[])dns);
            }
        }
        catch (Throwable e) {
            mLogger.log(Level.SEVERE, "Exception occurred trying modify DNs in cache.", e);
        }
        finally {
            if (null != modifiedDNs) {
                modifiedDNs.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processRemovedDN(LinkedList<Short[]> removedDNs, String serialNum) {
        try {
            Serializable[] dns = DeviceNumber.removeDNsFromCache(removedDNs, serialNum);
            CacheUpdater.doCallback((String)serialNum, (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.LDEV, (Serializable[])dns);
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Exception occurred trying remove DNs from cache.", e);
        }
        finally {
            removedDNs.clear();
        }
    }

    public LDEVBranchChecker(String serialNum) {
        super(serialNum);
        CacheUpdater.registerVersionChecker(CacheUpdater.ConfVerID.BASIC, this);
        ResourceGroupInfoVersionChecker.registerForRSGUpdates(ResourceGroupInfo.SearchType.DN, this);
    }

    @Override
    public void checkVersionDetails(Robj_interface_VerLeaf[] currentChildren, Robj_interface_VerLeaf[] prevChildren) {
        this.CompareAllLDEVBranch((Robj_interface_BASICVerAllLDEV)currentChildren[0], (Robj_interface_BASICVerAllLDEV)prevChildren[0]);
    }

    private void CompareAllLDEVBranch(Robj_interface_BASICVerAllLDEV current, Robj_interface_BASICVerAllLDEV prior) {
        boolean oldStyle = false;
        ArrayList<DeviceNumber> addedDNs = new ArrayList<DeviceNumber>();
        ArrayList<DeviceNumber> modifiedDNs = new ArrayList<DeviceNumber>();
        ArrayList<DeviceNumber> removedDNs = new ArrayList<DeviceNumber>();
        HashSet<Short[]> list = new HashSet<Short[]>();
        Robj_interface_BASICVerLDEVPerCU[] currentChildren = (Robj_interface_BASICVerLDEVPerCU[])current.getObjChildren();
        Robj_interface_BASICVerLDEVPerCU[] priorChildren = (Robj_interface_BASICVerLDEVPerCU[])prior.getObjChildren();
        for (short cuIndex = 0; cuIndex < currentChildren.length; cuIndex = (short)((short)(cuIndex + 1))) {
            if (currentChildren[cuIndex] == null && priorChildren[cuIndex] == null) continue;
            if (currentChildren[cuIndex] != null && priorChildren[cuIndex] == null) {
                mLogger.info("CU " + cuIndex + " has had LDEVs added");
                list.add(new Short[]{cuIndex, (short)-1});
                continue;
            }
            if (currentChildren[cuIndex] == null && priorChildren[cuIndex] != null) {
                mLogger.info("CU " + cuIndex + " has had LDEVs removed");
                list.add(new Short[]{cuIndex, (short)-1});
                continue;
            }
            if (currentChildren[cuIndex].getNVer() == priorChildren[cuIndex].getNVer() && currentChildren[cuIndex].getNSummaryVer() == priorChildren[cuIndex].getNSummaryVer()) continue;
            mLogger.info("Detected change in CU - " + cuIndex);
            list.add(new Short[]{cuIndex, (short)-1});
        }
        if (!list.isEmpty()) {
            DeviceNumber.modifyCachedDNs(list, addedDNs, modifiedDNs, removedDNs, this.getSerialNumber());
        }
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Cache update for DeviceNumber{0}Added: {1}\nRemoved: {2}\nModified: {3}", new Object[]{System.lineSeparator(), ((Object)addedDNs).toString(), ((Object)removedDNs).toString(), ((Object)modifiedDNs).toString()});
        } else {
            mLogger.log(Level.INFO, "Added DNs: {0}, Modified DNs: {0}, Removed in DNs: {0}", new Integer[]{addedDNs.size(), modifiedDNs.size(), removedDNs.size()});
        }
        this.notifyCacheListeners(addedDNs, modifiedDNs, removedDNs);
    }

    private void CompareLDEV(short cuIndex, Robj_interface_BASICVerLDEV[] currentLDEVs, Robj_interface_BASICVerLDEV[] priorLDEVs, LinkedList<Short[]> addedDNs, LinkedList<Short[]> modifiedDNs, LinkedList<Short[]> removedDNs) {
        for (short ldevIndex = 0; ldevIndex < currentLDEVs.length; ldevIndex = (short)((short)(ldevIndex + 1))) {
            if (currentLDEVs[ldevIndex] == null && priorLDEVs[ldevIndex] == null) continue;
            if (currentLDEVs[ldevIndex] == null && priorLDEVs[ldevIndex] != null) {
                mLogger.info("Detected removal of CU:LDEV" + cuIndex + ":" + ldevIndex);
                LDEVBranchChecker.addRemovedDN2List(cuIndex, ldevIndex, removedDNs);
                continue;
            }
            if (currentLDEVs[ldevIndex] != null && priorLDEVs[ldevIndex] == null) {
                mLogger.info("Detected addition CU:LDEV" + cuIndex + ":" + ldevIndex);
                LDEVBranchChecker.addAddedDN2List(cuIndex, ldevIndex, addedDNs);
                continue;
            }
            if (currentLDEVs[ldevIndex].getNVer() == priorLDEVs[ldevIndex].getNVer()) continue;
            mLogger.info("Detected possible change in CU:LDEV" + cuIndex + ":" + ldevIndex);
            LDEVBranchChecker.addModifiedDN2List(cuIndex, ldevIndex, modifiedDNs);
        }
    }

    private void CompareLDEVPerCU(short cuIndex, Robj_interface_BASICVerLDEVPerCU currentLDEVPerCU, Robj_interface_BASICVerLDEVPerCU priorLDEVPerCU, LinkedList<Short[]> addedDNs, LinkedList<Short[]> modifiedDNs, LinkedList<Short[]> removedDNs) {
        try {
            if (currentLDEVPerCU != null || priorLDEVPerCU != null) {
                if (currentLDEVPerCU != null && priorLDEVPerCU == null) {
                    mLogger.info("CU " + cuIndex + " has had LDEVs added");
                    LDEVBranchChecker.addAddedDN2List(cuIndex, (short)-1, addedDNs);
                } else if (currentLDEVPerCU == null && priorLDEVPerCU != null) {
                    mLogger.info("CU " + cuIndex + " has had LDEVs removed");
                    LDEVBranchChecker.addRemovedDN2List(cuIndex, (short)-1, removedDNs);
                } else if (currentLDEVPerCU.getNVer() != priorLDEVPerCU.getNVer() || currentLDEVPerCU.getNSummaryVer() != priorLDEVPerCU.getNSummaryVer()) {
                    mLogger.info("Detected change in CU - " + cuIndex);
                    Robj_interface_VerLeaf[] currentChildren = currentLDEVPerCU.getObjChildren();
                    Robj_interface_VerLeaf[] priorChildren = priorLDEVPerCU.getObjChildren();
                    Robj_interface_BASICVerLDEV[] currentLDEVs = (Robj_interface_BASICVerLDEV[])currentChildren;
                    Robj_interface_BASICVerLDEV[] priorLDEVs = (Robj_interface_BASICVerLDEV[])priorChildren;
                    this.CompareLDEV(cuIndex, currentLDEVs, priorLDEVs, addedDNs, modifiedDNs, removedDNs);
                }
            }
        }
        catch (Throwable t) {
            mLogger.log(Level.SEVERE, "Error getting modified LDEVs from device: " + t.toString(), t);
        }
    }

    private void notifyCacheListeners(List<DeviceNumber> addedDNs, List<DeviceNumber> modifiedDNs, List<DeviceNumber> removedDNs) {
        if (!removedDNs.isEmpty()) {
            CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.LDEV, (Serializable[])removedDNs.toArray(new DeviceNumber[removedDNs.size()]));
        }
        if (!modifiedDNs.isEmpty()) {
            CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.MODIFY, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.LDEV, (Serializable[])modifiedDNs.toArray(new DeviceNumber[modifiedDNs.size()]));
        }
        if (!addedDNs.isEmpty()) {
            CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.LDEV, (Serializable[])addedDNs.toArray(new DeviceNumber[addedDNs.size()]));
        }
    }

    @Override
    public void RSGUpdated(ResourceGroupInfo.SearchType type, TreeSet<String> addedDNs, TreeSet<String> removedDNs) {
        if (ResourceGroupInfo.SearchType.DN != type) {
            mLogger.log(Level.WARNING, "Wrong update type, {0} LDEVBranchChecker.RSGUpdated", (Object)type);
            return;
        }
        try {
            if (!addedDNs.isEmpty() || !removedDNs.isEmpty()) {
                LinkedList<Short[]> added = new LinkedList<Short[]>();
                for (String dn : addedDNs) {
                    short[] vals = BaseDeviceNumber.getDevIdStringValues(dn);
                    added.offer(new Short[]{vals[1], vals[2]});
                }
                LinkedList<Short[]> removed = new LinkedList<Short[]>();
                for (String dn : removedDNs) {
                    short[] vals = BaseDeviceNumber.getDevIdStringValues(dn);
                    removed.offer(new Short[]{vals[1], vals[2]});
                }
                LDEVBranchChecker.processAffectedDNs(added, null, removed, this.getSerialNumber());
            }
        }
        catch (Throwable t) {
            mLogger.log(Level.SEVERE, "Unexpected exception updating RSG elements", t);
        }
    }
}

